<?php
function jquery_tools_init()
{
   use_javascript('jquery-1.3.2.min.js', 'first');
   use_javascript('jquery-no-conflict.js', 'first');
}

function st_autocompleter_input_tag($name, $value = null, $options = array())
{
   static $js_included = false;

   if (!$js_included)
   {
      jquery_tools_init();
      
      if (SF_APP != 'backend')
      {
         use_javascript('/jQueryTools/autocompleter/js/jquery.autocomplete.js');      
      }
      else
      {
         use_javascript('/jQueryTools/autocompleter/js/jquery.autocomplete.js?ver=1');
         use_stylesheet('/jQueryTools/autocompleter/css/styles.css?ver=1');
      }
      
      $js_included = true;
   }

   if (!isset($options['autocompleter']))
   {
      throw new sfException('You must set the autocompleter option...');
   }

   if (isset($options['autocompleter']['onSelect']))
   {
      $on_select = $options['autocompleter']['onSelect'];

      unset($options['autocompleter']['onSelect']);
   }
   else
   {
      $on_select = '';
   }

   if (isset($options['autocompleter']['resultFormat']))
   {
      $format_result = $options['autocompleter']['resultFormat'];

      unset($options['autocompleter']['resultFormat']);
   }
   else
   {
      $format_result = '$.fn.autocomplete.fnFormatResult';
   }

   if (isset($options['autocompleter']['indicator']))
   {
      $indicator = $options['autocompleter']['indicator'];
   }
   else
   {
      $indicator = '/jQueryTools/autocompleter/images/indicator.gif';
   }

   $autocompleter = json_encode($options['autocompleter']);

   unset($options['autocompleter']);

   $id = isset($options['id']) ? $options['id'] : get_id_from_name($name);

   $js =<<<JS
<script type="text/javascript">
jQuery(function($) {
   var options = $autocompleter;

   $.extend(options, {
      indicator: $('#$id-indicator'),
      onSelect: function(value, data, el) { $on_select },
      fnFormatResult: function(value, data, current) { return $format_result(value, data, current); }
   });

   $('#$id').autocomplete(options);
});
</script>
JS;

   return input_tag($name, $value, $options).image_tag($indicator, array('alt' => '', 'id' => $id.'-indicator', 'class' => 'autocomplete-indicator')).$js;
}


function st_colorpicker_input_tag($name, $value, $params = array())
{
   static $js_included = false;

   if (!$js_included)
   {
      jquery_tools_init();
      use_javascript('/jQueryTools/colorpicker/js/colorpicker.js?ver=1');
      use_javascript('/jQueryTools/colorpicker/js/st_colorpicker.js?ver=1');
      use_stylesheet('/jQueryTools/colorpicker/css/colorpicker.css');
      use_stylesheet('/jQueryTools/colorpicker/css/layout.css');

      $js_included = true;
   }

   $id = isset($params['id']) ? $params['id'] : get_id_from_name($name);

   $options = array();

   if (isset($params['colorpicker']))
   {
      $options = $params['colorpicker'];

      unset($params['colorpicker']);
   }

   $options['color'] = '#'.$value;

   $options = json_encode($options);

   $params['size'] = $params['maxlength'] = 6;

   $input = input_tag($name, $value, $params);

   $image = image_tag('/jQueryTools/colorpicker/images/select2.png', array('style' => 'background-color: #'.$value, 'id' => $id.'-trigger'));

   $html = <<<HTML
<span class="colorpicker-control">
   <span>#</span>
   $input
   $image
   <script type="text/javascript">
      jQuery(function($) {
         $('#$id').stColorPicker($options);
      });
   </script>
</span>
HTML;

   return $html;
}
