<?php

/**
 * SOTESHOP/stBasket
 *
 * Ten plik należy do aplikacji stBasket opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stBasket
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stBasketListener.class.php 9160 2010-11-10 12:10:16Z marcin $
 */

/**
 * Klasa sluchacza dla stBasket
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 *
 * @package     stBasket
 * @subpackage  libs
 */
class stBasketListener
{

   /**
    * Sluchacz rozszerzający generator.yml stProduct
    *
    * @param       sfEvent     $event
    */
   public static function generateStProduct(sfEvent $event)
   {
      $event->getSubject()->attachAdminGeneratorFile('stBasket', 'stProduct.yml');
   }

   public static function refreshBasketProducts(sfEvent $event)
   {
      $action = $event->getSubject();

      if ($action->getRequest()->getMethod() == sfRequest::POST && $action->hasRequestParameter('user[email]'))
      {
         $basket = stBasket::getInstance($action->getUser());

         if ($basket->hasItems())
         {
            $basket->refresh();

            $basket->save();
         }
      }
   }

}

?>