<?php

/**
 * SOTESHOP/stBasket
 *
 * Ten plik należy do aplikacji stBasket opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stBasket
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: BasketProduct.php 16445 2011-12-12 13:01:54Z marcin $
 */

/**
 * Klasa reprezentujaca wiersz dla tabeli 'st_basket_product'
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 *
 * @package     stBasket
 * @subpackage  libs
 */
class BasketProduct extends BaseBasketProduct
{

   protected static
   $_config = null,
   $globalCurrency = null;

   public function getConfiguration()
   {
      if (null === self::$_config)
      {
         self::$_config = stConfig::getInstance(null, 'stBasket');
      }

      return self::$_config;
   }

   public function getGlobalCurrency()
   {
      if (null === self::$globalCurrency && SF_APP == 'frontend')
      {
         self::$globalCurrency = stCurrency::getInstance(sfContext::getInstance())->get();
      }

      return self::$globalCurrency;
   }

   public function hasLocalCurrency()
   {
      if (SF_APP != 'frontend')
      {
         return false;
      }

      return $this->currency['id'] == $this->getGlobalCurrency()->getId() && $this->currency['exchange'] != 1;
   }

   public function getCurrencyExchange()
   {
      $currency = $this->getCurrency();

      return $currency['exchange'];
   }

   public function getMaxQuantity()
   {
      $max_quantity = parent::getMaxQuantity();

      if (null === $max_quantity || $this->getProduct() && !$this->getProduct()->getIsStockValidated())
      {
         $max_quantity = $this->getConfiguration()->get('max_quantity');
      }

      $max_qty = $this->getProductMaxQty();

      return $max_qty && $max_qty < $max_quantity ? $max_qty : $max_quantity;
   }

   public function getPrice($with_tax = false, $with_currency = false)
   {
      if ($with_tax)
      {
         $price = $this->getPriceBrutto($with_currency);
      }
      else
      {
         $price = $this->getPriceNetto($with_currency);
      }

      return $price;
   }

   public function hasPriceModifiers()
   {
      return (bool) $this->getPriceModifiers();
   }

   public function getPriceBrutto($with_currency = false)
   {
      $price = $this->price_brutto;

      if ($this->wholesale)
      {
         $price = $this->getWholesalePriceBrutto($with_currency);
      }
      elseif ($with_currency)
      {
         $price = $this->hasLocalCurrency() ? $this->currency['price'] : $this->getGlobalCurrency()->exchange($price);
      }

      if ($this->price_modifiers)
      {
         $price = stPrice::computePriceModifiers($this, $price, 'brutto', $with_currency);
      }

      if ($this->discount)
      {
         $price = stPrice::applyDiscount($price, $this->discount['percent']);
      }

      return $price;
   }

   public function getPriceNetto($with_currency = false, $with_discount = true, $with_wholesale = true)
   {
      $price = stPrice::extract($this->getPriceBrutto(false, $with_discount, $with_wholesale), $this->vat);

      if ($with_currency)
      {
         $price = $this->getGlobalCurrency()->exchange($price, false, $this->hasLocalCurrency() ? $this->getCurrencyExchange() : null);
      }

      return $price;
   }

   public function getBasePriceNetto($with_currency = false)
   {
      $price = stPrice::extract($this->getBasePriceBrutto(), $this->vat);

      if ($with_currency)
      {
         $price = $this->getGlobalCurrency()->exchange($price, false, $this->hasLocalCurrency() ? $this->getCurrencyExchange() : null);
      }

      return $price;
   }

   public function getBasePriceBrutto($with_currency = false)
   {
      $price = $this->price_brutto;

      if (true === $with_currency)
      {
         $price = $this->hasLocalCurrency() ? $this->currency['price'] : $this->getGlobalCurrency()->exchange($price);
      }

      return $price;
   }

   public function setBasePriceNetto($v)
   {
      $this->setPrice($v);
   }

   public function setBasePriceBrutto($v)
   {
      $this->setPriceBrutto($v);
   }

   public function getOptImage()
   {
      return $this->getImage();
   }

   public function getWholesalePriceNetto($with_currency = false)
   {
      $price = stPrice::extract($this->getWholesalePriceBrutto(), $this->vat);

      if ($with_currency)
      {
         $price = $this->getGlobalCurrency()->exchange($price, false, $this->hasLocalCurrency() ? $this->getCurrencyExchange() : null);
      }

      return $price;
   }

   public function getWholesalePriceBrutto($with_currency = false)
   {
      $price = $this->wholesale['brutto'];

      if ($with_currency)
      {
         $price = $this->hasLocalCurrency() ? $this->wholesale['currency'] : $this->getGlobalCurrency()->exchange($price);
      }

      return $price;
   }

   public function getOptions()
   {
      $options = parent::getOptions();

      if ($this->hasPriceModifiers())
      {
         $content = '';

         $ids = '';

         foreach ($this->getPriceModifiers() as $price_modifier)
         {
            $content .= '<li>'.$price_modifier['label'].'</li>';

            $ids .= '-'.$price_modifier['custom']['id'];
         }

         $options = '<ul>'.$content.'</ul>'.substr($ids, 1);
      }

      return $options;
   }

   public function getVatValue()
   {
      return $this->getVat();
   }

   public function getPriceModifiers()
   {
      return parent::getPriceModifiers() ? parent::getPriceModifiers() : array();
   }

   public function getCustomItemId()
   {
      return parent::getCustomItemId() ? parent::getCustomItemId() : $this->getProductId();
   }

   public function addPriceModifier($value, $type, $prefix, $level = 1, $custom = array())
   {
      $price_modifiers = $this->getPriceModifiers();

      if (isset($custom['label']))
      {
         $label = $custom['label'];

         unset($custom['label']);
      }
      else
      {
         $label = null;
      }

      $price_modifier = stPrice::createPriceModifier($value, $type, $prefix, $level, $custom);

      $price_modifier['label'] = $label;

      $price_modifiers[] = $price_modifier;

      $this->setPriceModifiers($price_modifiers);
   }

   public function getTotalAmount($with_tax = false, $with_currency = false)
   {
      return $this->getPrice($with_tax, $with_currency) * $this->getQuantity();
   }

   public function getTaxAmount($with_currency = false)
   {
      return $this->getPrice(true, $with_currency) - $this->getPrice(false, $with_currency);
   }

   public function getTotalTaxAmount($with_currency = false)
   {
      return $this->getTaxAmount($with_currency) * $this->getQuantity();
   }

   /**
    * Sprawdza czy produkt istnieje fizycznie w bazie danych
    */
   public function productValidate()
   {
      return $this->product_id !== null && $this->getProduct()->getActive();
   }

   public function getProductStockInDecimals()
   {
      return $this->product_id && $this->getProduct()->getStockInDecimals() ? 2 : 0;
   }
   
   public function getProductStepQty()
   {
      return $this->product_id ? $this->getProduct()->getStepQty() : 0;
   }
   
   public function getProductMinQty()
   {
      return $this->product_id ? $this->getProduct()->getMinQty() : 1;
   }
   
   public function getProductMaxQty()
   {
      return $this->product_id ? $this->getProduct()->getMaxQty() : 0;
   }   
}

?>