<?php

/**
 * SOTESHOP/stOrder
 *
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: Order.php 16070 2011-11-10 14:00:53Z marcin $
 */

/**
 * SOTESHOP/stOrder
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 */
class Order extends BaseOrder
{

   /**
    * Płatność zamówienia
    * @var Payment
    */
   protected $aPayment = null;
   protected $aLanguage = null;
   protected $unpaidAmount = null;
   protected $previousColumnValues = array();

   /**
    * Zwraca użytkownika
    *
    * @return   sfGuardUser
    */
   public function getGuardUser()
   {
      return $this->getSfGuardUser();
   }
   
   

   /**
    * Ustawa użytkownika
    *
    * @param   sfGuardUser $v
    */
   public function setGuardUser($v)
   {
      $this->setSfGuardUser($v);
   }

   /**
    * Ustawia id użytkownika
    *
    * @param       integer     $v
    */
   public function setGuardUserId($v)
   {
      $this->setGuardUser($v);
   }

   /**
    * Zwraca dostawę dla zamówienia
    *
    * @return   OrderDelivery
    */
   public function getOrderDelivery($con = null)
   {
      if (!parent::getOrderDelivery($con))
      {
         $this->setOrderDelivery(new OrderDelivery());
      }

      return $this->aOrderDelivery;
   }
   
   public function setOrderDelivery($v)
   {
      parent::setOrderDelivery($v);
      
      $v->setOrder($this);
   }

   /**
    * Zwraca walute dla zamówienia
    *
    * @return   OrderCurrency
    */
   public function getOrderCurrency($con = null)
   {
      if (!parent::getOrderCurrency($con))
      {
         $this->setOrderCurrency(new OrderCurrency());
      }

      return $this->aOrderCurrency;
   }
      
   public function setOrderStatusId($v)
   {
      $pv = $this->order_status_id;
            
      parent::setOrderStatusId($v);
      
      if ($pv !== $this->order_status_id && !array_key_exists(OrderPeer::ORDER_STATUS_ID, $this->previousColumnValues))
      {
         $this->previousColumnValues[OrderPeer::ORDER_STATUS_ID] = $pv;
      }      
   }
   
   public function getPreviousColumnValue($col)
   {
      if (!array_key_exists($col, $this->previousColumnValues))
      {
         $getter = 'get'.OrderPeer::translateFieldName($col, BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
                  
         return $this->$getter();
      }
      
      return $this->previousColumnValues[$col];
   }

   /**
    * Zwraca dane bilingowe dla zamówienia
    *
    * @return   OrderBilling
    */
   public function getOrderUserDataBilling($con = null)
   {
      if (!parent::getOrderUserDataBilling($con))
      {
         $this->setOrderUserDataBilling(new OrderUserDataBilling());
      }

      return $this->aOrderUserDataBilling;
   }

   /**
    * Zwraca dane dostawy dla zamówienia
    *
    * @return   OrderDelivery
    */
   public function getOrderUserDataDelivery($con = null)
   {
      if (!parent::getOrderUserDataDelivery($con))
      {
         $this->setOrderUserDataDelivery(new OrderUserDataDelivery());
      }

      return $this->aOrderUserDataDelivery;
   }

   /**
    * Zwraca łączną wartość zamówienia
    *
    * @param   bool        $with_vat           Uwzględnij VAT
    * @return   float
    */
   public function getTotalAmount($with_vat = false, $with_currency = false)
   {
      $total_amount = 0;

      $order_products = $this->getOrderProducts();

      foreach ($order_products as $order_product)
      {
         if ($order_product->isDeleted())
            continue;

         $total_amount += $order_product->getTotalAmount($with_vat, $with_currency);
      }

      return $total_amount;
   }

   public function getTotalAmountWithDelivery($with_tax = false, $with_currency = false)
   {
      return $this->getTotalAmount($with_tax, $with_currency) + $this->getOrderDelivery()->getCost($with_tax, $with_currency);
   }

   /**
    * Zwraca łączną ilość produktów w zamówieniu
    *
    * @return   integer
    */
   public function getTotalQuantity()
   {
      $total_quantity = 0;

      $order_products = $this->getOrderProducts();

      foreach ($order_products as $order_product)
      {
         $total_quantity += $order_product->getQuantity();
      }

      return $total_quantity;
   }

   /**
    * Sprawdza czy zamówienie jest opłacone
    *
    * @return   bool
    */
   public function getIsPayed()
   {
      if ($this->getOptIsPayed() === null)
      {
         $this->setOptIsPayed(!stPayment::getUnpayedAmountByOrder($this));
      }

      return $this->getOptIsPayed();
   }

   /**
    * Przeciażenie zapisu - generowaniu ciagu hash używanego podczas dostępu do zamówienia
    *
    * @param         mixed       $con
    */
   public function save($con = null)
   {
      if ($this->isNew())
      {
         $this->setHashCode(md5(serialize($this) . microtime(true)));

         if ($billing = $this->getOrderUserDataBilling())
         {
            $this->setOptClientName($billing->getName() . ' ' . $billing->getSurname());
         }

         if ($user = $this->getsfGuardUser())
         {
            $this->setOptClientEmail($user->getUsername());
         }
         
         $this->setOptTotalAmount($this->getTotalAmountWithDelivery(true, true));
      }
      
      if ($this->isColumnModified(OrderPeer::ORDER_STATUS_ID) && $this->getOrderStatus())
      {
         $this->setOptOrderStatus($this->getOrderStatus()->getName());

         if ($this->getOrderStatus()->getType() == 'ST_COMPLETE')
         {
            $gift_cards = GiftCardPeer::doSelectByOrder($this);

            foreach ($gift_cards as $gift_card)
            {
               $gift_card->setStatus('U');

               $gift_card->save();
            }
         }
      }
      
      parent::save($con);
      
      $this->previousColumnValues = array();
   }

   public function getOrderLanguage()
   {
      if (null === $this->aLanguage)
      {
         $this->aLanguage = LanguagePeer::retrieveByCulture($this->getClientCulture(), null);
      }

      return $this->aLanguage;
   }

   public function getOrderPayment()
   {
      if (null === $this->aPayment)
      {
         $c = new Criteria();

         $c->addJoin(PaymentPeer::ID, OrderHasPaymentPeer::PAYMENT_ID);

         $c->add(OrderHasPaymentPeer::ORDER_ID, $this->getId());

//         $c->add(PaymentPeer::GIFT_CARD_ID, null, Criteria::ISNULL);
         $c->addAscendingOrderByColumn(PaymentPeer::GIFT_CARD_ID);

         $payment = PaymentPeer::doSelectOne($c);

         if ($payment->getGiftCardId())
         {
            $pt = new PaymentType();

            $pt->setName('Bony zakupowe');

            $payment->setPaymentType($pt);
         }

         $this->aPayment = $payment;
      }

      return $this->aPayment;
   }

   public function addOrderPayment(Payment $payment)
   {
      $ohp = new OrderHasPayment();

      $payment->addOrderHasPayment($ohp);

      $this->addOrderHasPayment($ohp);
   }

   public function getOrderProducts($criteria = null, $con = null)
   {
      if (!$criteria)
      {
         $criteria = new Criteria();
      }
      else
      {
         $criteria = clone $criteria;
      }

      $criteria->addAscendingOrderByColumn(OrderProductPeer::ID);

      return parent::getOrderProducts($criteria, $con);
   }

   public function getUnpaidAmount()
   {
      if (null === $this->unpaidAmount)
      {
         $this->unpaidAmount = stPayment::getUnpayedAmountByOrder($this);
      }

      return $this->unpaidAmount;
   }

   public function getPaidAmount()
   {
      return $this->getTotalAmountWithDelivery(true, true) - $this->getUnpaidAmount();
   }

   public function getDescription()
   {
      return stXssSafe::clean($this->description);
   }

}
