<?php

/**
 * SOTESHOP/stOrder
 *
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: OrderDelivery.php 16070 2011-11-10 14:00:53Z marcin $
 */

/**
 * SOTESHOP/stOrder
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 */
class OrderDelivery extends BaseOrderDelivery
{

   protected $currency = null;
   
   protected static $order = array();

   public function __toString()
   {
      return $this->getName();
   }

   public function getCost($with_tax = false, $with_currency = false)
   {
      if ($with_tax)
      {
         return $this->getCostBrutto($with_currency);
      }
      else
      {
         return $this->getCostNetto($with_currency);
      }
   }

   public function getOrder()
   {
      if (!isset(self::$order[$this->getId()]))
      {
         $orders = $this->getOrders();

         self::$order[$this->getId()] = isset($orders[0]) ? $orders[0] : null;
      }

      return self::$order[$this->getId()];
   }
   
   public function setOrder(Order $order)
   {
      self::$order[$this->getId()] = $order;
   }
   
   public function getCostNetto($with_currency = false)
   {
      $cost = stPrice::extract($this->getCostBrutto(), $this->getOptTax());

      if ($with_currency)
      {
         $cost = $this->getOrder()->getOrderCurrency()->exchange($cost);
      }

      return $cost;
   }

   public function getCostBrutto($with_currency = false)
   {
      if ($this->custom_cost_brutto !== null)
      {
         $cost = $this->custom_cost_brutto;

         if ($with_currency)
         {
            $cost = $this->getOrder()->getOrderCurrency()->exchange($cost);
         }

         return $cost;
      }

      $cost = parent::getCostBrutto();

      if (null === $cost)
      {
         $cost = stPrice::calculate($this->cost, $this->getOptTax());
      }

      if ($with_currency)
      {
         $cost = $this->getOrder()->getOrderCurrency()->exchange($cost);
      }

      return $cost + $this->getPaymentCostBrutto($with_currency);
   }

   public function getPaymentCostNetto($with_currency = false)
   {
      $cost = $this->payment_cost;

      if ($with_currency)
      {
         $cost = $this->getOrder()->getOrderCurrency()->exchange($cost);
      }

      return $cost;
   }

   public function getPaymentCostBrutto($with_currency = false)
   {
      $cost = parent::getPaymentCostBrutto();

      if (null === $cost)
      {
         $cost = stPrice::calculate($this->getPaymentCostNetto(), $this->getOptTax());
      }

      if ($with_currency)
      {
         $cost = $this->getOrder()->getOrderCurrency()->exchange($cost);
      }

      return $cost;
   }

   public function getPaymentCost($with_tax = false, $with_currency = false)
   {
      if ($with_tax)
      {
         return $this->getPaymentCostBrutto($with_currency);
      }
      else
      {
         return $this->getPaymentCostNetto($with_currency);
      }
   }

   public function setPaymentCostNetto($v)
   {
      $this->setPaymentCost($v);
   }

   public function setCostNetto($v)
   {
      $this->setCost($v);
   }

}