<?php

/**
 * SOTESHOP/stOrder
 *
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: OrderPeer.php 13691 2011-06-20 07:00:55Z marcin $
 */

/**
 * SOTESHOP/stOrder
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 */
class OrderPeer extends BaseOrderPeer
{

   /**
    * Zwraca zamówienie na podstawie numeru
    *
    * @param   string      $number             Numer zamówienia
    * @return   Order
    */
   public static function retrieveByNumber($number)
   {
      $c = new Criteria();

      $c->add(self::NUMBER, $number);

      return self::doSelectOne($c);
   }

   /**
    * Zwraca zamówienie na podstawie id i ciągu hash
    *
    * @param   string      $id                 Id zamówienia
    * @param   string      $hash_code          Ciągu hash
    */
   public static function retrieveByIdAndHashCode($id, $hash_code)
   {
      $c = new Criteria();

      $c->add(self::ID, $id);

      $c->add(self::HASH_CODE, $hash_code);

      return self::doSelectOne($c);
   }

   /**
    * Zwraca zamówienie na podstawie numeru i ciągu hash
    *
    * @param   string      $number             Numer zamówienia
    * @param   string      $hash_code          Ciągu hash
    */
   public static function retrieveByNumberAndHashCode($number, $hash_code)
   {
      $c = new Criteria();

      $c->add(self::NUMBER, $number);

      $c->add(self::HASH_CODE, $hash_code);

      return self::doSelectOne($c);
   }


   public static function updateOptIsPaid(Order $order)
   {
      $order->setOptIsPayed($order->getUnpaidAmount() == 0);

      $order->save();
   }

}
