<?php

/**
 * SOTESHOP/stOrder
 *
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: OrderProduct.php 16312 2011-12-01 08:41:16Z michal $
 */

/**
 * SOTESHOP/stOrder
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 */
class OrderProduct extends BaseOrderProduct
{

   protected static $order = array();

   /**
    * Zwraca cene produktu
    *
    * @param   bool        $with_vat           Uwzględnij VAT
    * @param   bool        $with_currency      Uwzględnij walutę
    * @return   float
    */
   public function getPrice($with_tax = false, $with_currency = false)
   {
      if ($with_tax)
      {
         $price = $this->getPriceBrutto($with_currency);
      }
      else
      {
         $price = $this->getPriceNetto($with_currency);
      }

      return $price;
   }

   public function getGlobalCurrency()
   {
      return $this->getOrder()->getOrderCurrency();
   }

   public function getCurrencyExchange()
   {
      $currency = $this->getCurrency();

      return $currency['exchange'];
   }

   public function hasLocalCurrency()
   {
      return $this->currency && $this->currency['code'] == $this->getGlobalCurrency()->getShortcut() && $this->currency['exchange'] != 1;
   }

   public function hasPriceModifiers()
   {
      return (bool) $this->getPriceModifiers();
   }

   public function getPriceBrutto($with_currency = false, $with_discount = true, $with_wholesale = true)
   {
      if (null === $this->custom_price_brutto)
      {
         $price = null === $this->price_brutto ? stPrice::calculate($this->price, $this->vat) : $this->price_brutto;

         if ($this->wholesale && $with_wholesale)
         {
            $price = $this->getWholesalePriceBrutto($with_currency);
         }
         elseif ($with_currency)
         {
            $price = $this->hasLocalCurrency() ? $this->currency['price'] : $this->getGlobalCurrency()->exchange($price);
         }
         elseif ($this->hasLocalCurrency())
         {
            $price = $this->getGlobalCurrency()->exchange($this->currency['price'], true);
         }

         if ($this->price_modifiers)
         {
            $price = stPrice::computePriceModifiers($this, $price, 'brutto', $with_currency);
         }
      }
      else
      {
         $price = $this->custom_price_brutto;

         if ($with_currency)
         {
            $price = $this->getGlobalCurrency()->exchange($price);
         }
      }

      if ($this->discount && $with_discount)
      {
         $price = stPrice::applyDiscount($price, $this->discount['percent']);
      }

      return $price;
   }

   public function setCustomPriceNetto($v)
   {
      $this->setCustomPrice($v);
   }

   public function getPriceModifiersIds()
   {
      $arr = array();

      foreach ((array) $this->price_modifiers as $modifier)
      {
         $arr[] = $modifier['custom']['id'];
      }

      return $arr;
   }

   public function getPriceModifierLabels()
   {
      $arr = array();

      foreach ((array) $this->price_modifiers as $modifier)
      {
         $arr[] = $modifier['label'];
      }

      return implode(', ', $arr);
   }

   public function getPriceModifiersSerialized()
   {
      $arr = array();

      foreach ((array) $this->price_modifiers as $modifier)
      {
         $arr[] = array('label' => $modifier['label'], 'type' => null, 'custom' => array('id' => $modifier['custom']['id'], 'type' => 'product_options'));
      }

      return json_encode($arr);
   }

   public function getPriceNetto($with_currency = false, $with_discount = true, $with_wholesale = true)
   {
      $price = stPrice::extract($this->getPriceBrutto(false, $with_discount, $with_wholesale), $this->getVat());

      if ($with_currency)
      {
         $price = $this->getGlobalCurrency()->exchange($price, false, $this->hasLocalCurrency() ? $this->getCurrencyExchange() : null);
      }

      return $price;
   }

   public function getVat()
   {
      $vat = parent::getVat();

      if (null === $vat)
      {
         $this->vat = $this->getTax()->getVat();
      }

      return $this->vat;
   }

   public function getTax($con = null)
   {
      $this->aTax = parent::getTax($con);

      if (null === $this->aTax && null !== $this->vat)
      {
         $this->aTax = TaxPeer::retrieveByTax($this->vat);
      }

      return $this->aTax;
   }

   public function getTaxId()
   {
      $this->tax_id = parent::getTaxId();

      if (null === $this->tax_id && null !== $this->vat)
      {
         $tax = TaxPeer::retrieveByTax($this->vat);

         $this->aTax = $tax;

         $this->tax_id = $tax->getId();
      }

      return $this->tax_id;
   }

   public function getDiscountInPercent()
   {
      $discount = $this->getDiscount();

      return $discount ? $discount['percent'] : 0;
   }

   public function getBasePriceNetto($with_currency = false)
   {
      $price = stPrice::extract($this->getBasePriceBrutto(), $this->vat);

      if ($with_currency)
      {
         $price = $this->getGlobalCurrency()->exchange($price, false, $this->hasLocalCurrency() ? $this->getCurrencyExchange() : null);
      }

      return $price;
   }

   public function getBasePriceBrutto()
   {
      return stPrice::round($this->price_brutto);
   }

   public function setBasePriceNetto($v)
   {
      $this->setPrice($v);
   }

   public function setBasePriceBrutto($v)
   {
      $this->setPriceBrutto($v);
   }

   public function getOptImage()
   {
      return $this->getImage();
   }

   public function getImage()
   {
      $image = parent::getImage();

      if (!$image && $this->getProduct())
      {
         $image = $this->getProduct()->getOptImage();
      }

      return $image;
   }

   public function getWholesalePriceNetto($with_currency = false)
   {
      $price = stPrice::extract($this->getWholesalePriceBrutto(), $this->vat);

      if ($with_currency)
      {
         $price = $this->getGlobalCurrency()->exchange($price, false, $this->hasLocalCurrency() ? $this->getCurrencyExchange() : null);
      }

      return $price;
   }

   public function getWholesalePriceBrutto($with_currency = false)
   {
      $price = $this->wholesale['brutto'];

      if ($with_currency)
      {
         $price = $this->hasLocalCurrency() ? $this->wholesale['currency'] : $this->getGlobalCurrency()->exchange($price);
      }

      return $price;
   }

   /**
    * Zwraca łączną kwotę za produkt (cena x ilosc)
    *
    * @param   bool        $with_vat           Uwzględnij VAT
    * @param   bool        $with_currency      Uwzględnij walutę
    * @return   float
    */
   public function getTotalAmount($with_vat = false, $with_currency = false)
   {
      return stCurrency::formatPrice($this->getQuantity() * $this->getPrice($with_vat, $with_currency));
   }

   public function getTaxAmount($with_currency = false)
   {
      return $this->getPrice(true, $with_currency) - $this->getPrice(false, $with_currency);
   }

   public function getTotalTaxAmount($with_currency = false)
   {
      return $this->getTaxAmount($with_currency) * $this->getQuantity();
   }

   public function getOptions($to_array = false)
   {
      $options = parent::getOptions();

      if ($this->hasPriceModifiers())
      {
         $content = '';

         $ids = '';

         foreach ($this->getPriceModifiers() as $price_modifier)
         {
            $content .= '<li>'.$price_modifier['label'].'</li>';

            $ids .= '-'.$price_modifier['custom']['id'];
         }

         $options = '<ul>'.$content.'</ul>'.substr($ids, 1);
      }
      elseif ($to_array)
      {
         if (preg_match_all('/<li>([^<]+)<\/li>/', $options, $matches))
         {
            return $matches[1];
         }
      }

      return $options;
   }

   public function hasOldOptions()
   {
      return null !== $this->options;
   }

   /**
    * Sprawdza czy produkt istnieje fizycznie w bazie danych
    */
   public function productValidate()
   {
      return $this->getProductId() !== null;
   }

   public function save($con = null)
   {
      $update = !$this->isNew() && $this->isModified();

      if ($this->isColumnModified(OrderProductPeer::TAX_ID) && $this->tax_id)
      {
         $this->setVat($this->getTax()->getVat());
      }

      parent::save($con);
   }

   /**
    *
    * @return Order
    */
   public function getOrder($con = null)
   {
      $id = $this->getOrderId();
      
      if (!isset(self::$order[$id]))
      {
         self::$order[$id] = parent::getOrder();
      }

      return self::$order[$id];
   }

}
