<?php

/** 
 * SOTESHOP/stOrder 
 * 
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stOrder
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: OrderStatusPeer.php 12422 2011-04-21 13:21:05Z bartek $
 */

/** 
 * SOTESHOP/stOrder
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  libs
 */
class OrderStatusPeer extends BaseOrderStatusPeer
{
    const ST_CANCELED = 'anulowane';
    const ST_PENDING = 'oczekuje';
    const ST_COMPLETE = 'zrealizowane';
    /** 
     * Zwraca listę stałych typów statusów
     *
     * @return  array       Lista typów statusów  
     */
    public static function getTypes()
    {
        return array('ST_CANCELED' => self::ST_CANCELED, 'ST_PENDING' => self::ST_PENDING, 'ST_COMPLETE' => self::ST_COMPLETE);
    }
    
    /** 
     * Zwraca nazwę dla danego typu statusu
     *
     * @return   string
     */
    public static function getNameFromType($type)
    {
        $types = self::getTypes();
        
        return isset($types[$type]) ? $types[$type] : '';
    }
    
    /** 
     * Zwraca domyślny stan typu ST_PENDING
     *
     * @return   OrderStatus
     */
    public static function retrieveDefaultPendingStatus()
    {
        $c = new Criteria();
        
        $c->add(self::IS_DEFAULT, true);
        
        $c->add(self::TYPE, 'ST_PENDING');
        
        $status = self::doSelectOne($c);
        
        $status->setCulture(stLanguage::getOptLanguage());

        return $status;
    }
    
    /** 
     * Zwraca domyślny stan systemowy o podanym typie
     *
     * @param   const       $type               Typ stanu
     * @return   OrderStatus
     */
    public static function retrieveSystemStatusByType($type)
    {
        $c = new Criteria();
        
        $c->add(self::IS_SYSTEM_DEFAULT, true);
        
        $c->add(self::TYPE, $type);
        
        return self::doSelectOne($c);
    }
}
