<?php

/**
 * SOTESHOP/stPayment
 *
 * Ten plik należy do aplikacji stPayment opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stPayment
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: Payment.php 15219 2011-09-23 11:29:27Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa Payment
 *
 * @package     stPayment
 * @subpackage  libs
 */
class Payment extends BasePayment
{

	protected $order = null;

	/**
	 * Pobieranie id zamówienia
	 *
	 * @return int
	 */
	public function getOrderId()
	{
		return $this->getOrder() ? $this->getOrder()->getId() : null;
	}

	/**
	 * Pobieranie numeru zamówienia
	 *
	 * @return string
	 */
	public function getOrderNumber()
	{
		return $this->getOrder() ? $this->getOrder()->getNumber() : null;
	}

	public function getOrder()
	{
		if (!$this->order)
		{
			$c = new Criteria();

			$c->addJoin(OrderPeer::ID, OrderHasPaymentPeer::ORDER_ID);

			$c->add(OrderHasPaymentPeer::PAYMENT_ID, $this->getId());

			$this->order = OrderPeer::doSelectOne($c);
		}

		return $this->order;
	}

	/**
	 * @author Marcin Butlak <marcin.butlak@sote.pl>
	 */
	public function save($con = null)
	{
		$is_new = $this->isNew();
		 
		if ($is_new)
		{
			if (null === $this->getHash())
			{
				$hash = md5(serialize($this) . microtime(true));

				$this->setHash($hash);
			}
			 
			$this->setVersion(2);
		}

		$status_modified = $this->isColumnModified(PaymentPeer::STATUS);

		$cancel_modified = $this->isColumnModified(PaymentPeer::CANCEL);

		if ($status_modified && $this->getStatus() && !$this->getPayedAt())
		{
			$this->setPayedAt(time());
		}

		$ret = parent::save($con);

		if (!$is_new && $status_modified)
		{
			if (is_object($this->getOrder())) OrderPeer::updateOptIsPaid($this->getOrder());
		}

		return $ret;
	}
	 
	public function delete($con = null)
	{
		if (is_object($this->getOrder())) OrderPeer::updateOptIsPaid($this->getOrder());

		return parent::delete($con);
	}

	public function setStatus($v)
	{
		if ($this->status != $v || $v === false) {
			$this->status = $v;
			$this->modifiedColumns[] = PaymentPeer::STATUS;
		}
	}
}