<?php
/**
 * SOTESHOP/stPayment
 *
 * Ten plik należy do aplikacji stPayment opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stPayment
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: PaymentTypePeer.php 10425 2011-01-21 13:41:46Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa PaymentTypePeer
 *
 * @package     stPayment
 * @subpackage  libs
 */
class PaymentTypePeer extends BasePaymentTypePeer
{
	protected static $activeModules = array();

	public static function isActive($moduleName)
	{
		if (empty(self::$activeModules)) {
			$stCache = new stFunctionCache('stPayment');
			$cachedActiveModules = $stCache->get('activeModules');

			if ($cachedActiveModules !== null) {
				self::$activeModules = unserialize($cachedActiveModules);
			} else {
				$c = new Criteria();
				$c->add(PaymentTypePeer::ACTIVE, 1);
				$paymentTypes = PaymentTypePeer::doSelect($c);
				foreach ($paymentTypes as $type) self::$activeModules[$type->getModuleName()] = true;

				$stCache->set('activeModules', null, serialize(self::$activeModules));
			}
		}

		if (isset(self::$activeModules[$moduleName])) return self::$activeModules[$moduleName];
		return false;
	}

	public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
	{
		if ($culture === null)
		{
			$culture = stLanguage::getHydrateCulture();
		}

		if ($c->getDbName() == Propel::getDefaultDB())
		{
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentTypePeer::addSelectColumns($c);

		$startcol = (PaymentTypePeer::NUM_COLUMNS - PaymentTypePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		PaymentTypeI18nPeer::addSelectColumns($c);

		$c->addJoin(PaymentTypePeer::ID, sprintf("%s AND %s = '%s'", PaymentTypeI18nPeer::ID, PaymentTypeI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);

		$results = array();

		while($rs->next())
		{

			$omClass = PaymentTypePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
			$obj1->setCulture($culture);

			$omClass = PaymentTypeI18nPeer::getOMClass($rs, $startcol);

			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol);

			$obj1->setPaymentTypeI18nForCulture($obj2, $culture);
			$obj2->setPaymentType($obj1);

			$results[] = $obj1;
		}
		return $results;
	}

	public static function doCountWithI18n(Criteria $c, $con = null)
	{
		$c->addJoin(PaymentTypeI18nPeer::ID, PaymentTypePeer::ID);

		$c->add(PaymentTypeI18nPeer::CULTURE, stLanguage::getHydrateCulture());

		return self::doCount($c, $con);
	}
}