<?php

/**
 * SOTESHOP/stProducer
 *
 * Ten plik należy do aplikacji stProducer opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProducer
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: ProducerPeer.php 850 2009-04-27 11:43:19Z marcin $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa ProducerPeer
 *
 * @package     stProducer
 * @subpackage  libs
 */
class ProducerPeer extends BaseProducerPeer
{

   /**
    * Pobiera nazwe producenta przypisana do produktu, jako parametr podawany
    * obiekt produktu
    *
    * @param        object      $object
    * @return   object
    */
   public static function getProductProducer($object = null)
   {
      return $object->getProducer();
   }

   /**
    * Ustawia dla danego produktu producenta, jezeli producent nie istnieje
    * towrzy go. Jako parametr object
    *
    * @param        object      $object
    * @param        string      $value
    */
   public static function setProductProducer($object = null, $value = '')
   {
      // sprawdzanie czy podany producent juz istnieje
      $c = new Criteria();
      $c2 = $c->getNewCriterion(ProducerPeer::OPT_NAME, $value);
      $c3 = $c->getNewCriterion(ProducerI18nPeer::NAME, $value);
      $c4 = $c->getNewCriterion(ProducerI18nPeer::CULTURE, $object->getCulture());
      $c->addJoin(ProducerI18nPeer::ID, ProducerPeer::ID, Criteria::RIGHT_JOIN);
      $c3->addAnd($c4);
      $c2->addOr($c3);
      $c->add($c2);
      $proudcer = ProducerPeer::doSelectOne($c);

      // jezeli  producent nie istieniej nalezy stworzy nowego
      if (!$proudcer && $value != '')
      {
         $proudcer = new Producer();
         $proudcer->setCulture($object->getCulture());
         $proudcer->setName($value);
         $proudcer->save();
      }

      // zapisz zmiany w produkcie
      if ($proudcer)
      {
         if ($object->getProducerId() != $proudcer->getId())
            $object->setProducerId($proudcer->getId());
         $object->save();
      }
   }

   public static function doSelectActive(Criteria $c = null, $con = null)
   {
      if (is_null($c))
      {
         $c = new Criteria();
      }
      else
      {
         $c = clone $c;
      }

      $product_config = stConfig::getInstance(null, 'stProduct');

      $c->addJoin(ProducerPeer::ID, ProductPeer::PRODUCER_ID, Criteria::LEFT_JOIN);

      $c->addJoin(ProductPeer::ID, ProductHasCategoryPeer::PRODUCT_ID, Criteria::LEFT_JOIN);

      $c->addJoin(ProductHasCategoryPeer::CATEGORY_ID, CategoryPeer::ID, Criteria::LEFT_JOIN);

      $c->add(CategoryPeer::IS_ACTIVE, true);

      $c->add(ProductPeer::ACTIVE, true);

      if ($product_config->get('show_without_price'))
      {
         $c->add(ProductPeer::PRICE, 0, Criteria::GREATER_THAN);
      }

      $c->addAscendingOrderByColumn(ProducerI18nPeer::NAME);
      
      $c->addGroupByColumn(self::ID);

      return self::doSelectWithI18n($c, $con);
   }

   public static function doCountWithI18n(Criteria $c, $con = null)
   {
      $c->addJoin(ProducerI18nPeer::ID, ProducerPeer::ID);

      $c->add(ProducerI18nPeer::CULTURE, stLanguage::getHydrateCulture());

      return self::doCount($c, $con);
   }

   /**
    * Przeciążenie metody pobierającej produkty w odpowiedniej wersji jezykowej
    *
    * @param Criteria $c Kryteria
    * @param mixed $culture Wersja językowa
    * @param CreoleConnection $con Połączenie z bazą danych
    * @return array Produkty
    */
   public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
   {
      if ($culture === null)
      {
         $culture = stLanguage::getHydrateCulture();
      }

      if ($c->getDbName() == Propel::getDefaultDB())
      {
         $c->setDbName(self::DATABASE_NAME);
      }

      ProducerPeer::addSelectColumns($c);

      $startcol = (ProducerPeer::NUM_COLUMNS - ProducerPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

      ProducerI18nPeer::addSelectColumns($c);

      $c->addJoin(ProducerPeer::ID, sprintf("%s AND %s = '%s'", ProducerI18nPeer::ID, ProducerI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

      $rs = BasePeer::doSelect($c, $con);

      $results = array();

      while ($rs->next())
      {

         $omClass = ProducerPeer::getOMClass();

         $cls = Propel::import($omClass);
         $obj1 = new $cls();
         $obj1->hydrate($rs);
         $obj1->setCulture($culture);

         $omClass = ProducerI18nPeer::getOMClass($rs, $startcol);

         $cls = Propel::import($omClass);
         $obj2 = new $cls();
         $obj2->hydrate($rs, $startcol);

         $obj1->setProducerI18nForCulture($obj2, $culture);
         $obj2->setProducer($obj1);

         $results[] = $obj1;
      }
      return $results;
   }

   public static function doSelectProducersForProduct(Criteria $c = null, $con = null)
   {
      if (is_null($c))
      {
         $c = new Criteria();
      }
      else
      {
         $c = clone $c;
      }

      $c->addAscendingOrderByColumn(ProducerI18nPeer::NAME);

      return self::doSelectWithI18n($c, $con);
   }

}

