<?php

/**
 * SOTESHOP/stProductGroup
 *
 * Ten plik należy do aplikacji stProductGroup opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProductGroup
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: ProductGroupPeer.php 10534 2011-01-26 17:22:38Z michal $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl>,
 */

class ProductGroupPeer extends BaseProductGroupPeer
{
	public static function doSelectCached(Criteria $c, $con = null)
	{
		$fc = new stFunctionCache();

		return $fc->callBy('ProductGroupPeer','ProductGroupPeer::doSelect', $c, $con, sfContext::getInstance()->getUser()->getCulture());
	}

	public static function doSelectOneCached(Criteria $c, $con = null)
	{
		$object = self::doSelectCached($c, $con);

		return isset($object[0]) ? $object[0] : null;
	}

	public static function cleanCache()
	{
		$fc = new stFunctionCache();

		$fc->cleanBy('frontend', 'ProductGroupPeer');

		$fc->cleanBy('backend', 'ProductGroupPeer');

		$fc->cleanBy('cache', 'ProductGroupPeer');
	}

	public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
	{
		if ($culture === null)
		{
			$culture = stLanguage::getHydrateCulture();
		}

		if ($c->getDbName() == Propel::getDefaultDB())
		{
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductGroupPeer::addSelectColumns($c);

		$startcol = (ProductGroupPeer::NUM_COLUMNS - ProductGroupPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		ProductGroupI18nPeer::addSelectColumns($c);

		$c->addJoin(ProductGroupPeer::ID, sprintf("%s AND %s = '%s'", ProductGroupI18nPeer::ID, ProductGroupI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);

		$results = array();

		while($rs->next())
		{
			$omClass = ProductGroupPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
			$obj1->setCulture($culture);

			$omClass = ProductGroupI18nPeer::getOMClass($rs, $startcol);

			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol);

			$obj1->setProductGroupI18nForCulture($obj2, $culture);
			$obj2->setProductGroup($obj1);

			$results[] = $obj1;
		}
		return $results;
	}

	public static function doCountWithI18n(Criteria $c, $con = null)
	{
		$c->addJoin(ProductGroupI18nPeer::ID, ProductGroupPeer::ID);

		$c->add(ProductGroupI18nPeer::CULTURE, stLanguage::getHydrateCulture());

		return self::doCount($c, $con);
	}
}