<?php

/**
 * SOTESHOP/stProduct
 *
 * Ten plik należy do aplikacji stProduct opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProduct
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: ProductPeer.php 2641 2009-08-18 12:02:50Z krzysiek $
 */

class ProductPeer extends BaseProductPeer
{
	protected static $showedProduct = null;

        public static function doSelectImages(Product $product, Criteria $c)
        {
            $c = clone $c;

            $c->addJoin(sfAssetPeer::ID, ProductHasSfAssetPeer::SF_ASSET_ID);

            $c->add(ProductHasSfAssetPeer::PRODUCT_ID, $product->getId());

            return sfAssetPeer::doSelectJoinsfAssetFolder($c);
        }


	public static function setShowedProduct($product)
	{
		ProductPeer::$showedProduct = $product;
	}
	
	public static function getShowedProduct()
	{
		return ProductPeer::$showedProduct;
	}	
	
    static public function doCountProduct($c, $distinct = true, $con = null)
    {
        return ProductPeer::doCount($c, $distinct, $con);
    }

    /**
     * Sprawdza czy dany produkt jest nowy
     *
     * @param       Product     $product
     * @return   bool
     */
    static public function isInNewGroup(Product $product)
    {
        $c = new Criteria();
        $c->clearSelectColumns();
        $configProduct = stConfig::getConfig('product');
        $c->add(ProductPeer::CREATED_AT, $configProduct['new_product_date'], Criteria::GREATER_THAN);
        $c->add(ProductPeer::ID, $product->getId());
        self::addTimeOn($c);
        $newProduct = ProductPeer::doSelectOne($c);
        if (empty($newProduct))
            return false;
        return true;
    }

    /**
     * Zwraca true jeżeli produkt jest w danej grupie
     *
     * @param        object      $product
     * @param        object      $group
     * @return   bool
     */
    static public function isInGroup(Product $product, $group)
    {
        $c = new Criteria();
        $c->clearSelectColumns();
        $c->add(ProductPeer::ID, $product->getId());
        self::addTimeOn($c);
        $product = ProductPeer::doSelectOne($c);
        if (!empty($product))
        {
            $groups = $product->getProductGroups();
            foreach ($groups as $singleGroup)
            {
                if ($group == $singleGroup)
                    return true;
            }
        }
        return false;
    }

    /**
     * Dodaje weryfikacje czy produkt powinien się pokazywać
     *
     * @param      Criteria    $c
     * @return   void
     */
    static private function addTimeOn(Criteria $c)
    {
        $date = date(DATE_ATOM);
        $c1 = $c->getNewCriterion(ProductPeer::START_TIME, $date, Criteria::LESS_THAN);
        $c2 = $c->getNewCriterion(ProductPeer::END_TIME, $date, Criteria::GREATER_THAN);
        $c1->addOr($c->getNewCriterion(ProductPeer::START_TIME, null, Criteria::ISNULL));
        $c2->addOr($c->getNewCriterion(ProductPeer::END_TIME, null, Criteria::ISNULL));
        $c1->addAnd($c2);
        $c1->addOr($c->getNewCriterion(ProductPeer::TIME_ON, false));
        $c->add(ProductPeer::ACTIVE, 1);
        $c->add($c1);
    }

    /**
     * pobieranie z dodatkowym cachem
     *
     * @param       integer     $pk
     * @param        object      $con
     * @return   object
     */
    public static function retrieveByPK($pk, $con = null)
    {
        /**
         * @todo przerobić cachowanie danych, tak aby można było odczytać wersje językowe
         */
        //        $stCache = new stFunctionCache('stProduct');
        //        return $stCache->add('retrieve_'.$pk,"BaseProductPeer::retrieveByPK",$pk, $con);
        return parent::retrieveByPK($pk, $con = null);
    }

    public static function setVat(Product $object = null, $value)
    {
        $c = new Criteria();
        $c->add(TaxPeer::VAT,$value);
        $tax = TaxPeer::doSelectOne($c);

        if (!$tax)
        {
            $tax = new Tax();
            $tax->setVat($value);
            $tax->save();
        }
        $object->setVat($tax->getId());
        $object->setOptVat($value);
        $object->setPriceBruttoByNetto($object->getPrice(),$value);
    }

    public static function getProductImages($object = null)
    {
        $c = new Criteria();
        $c->add(ProductHasSfAssetPeer::PRODUCT_ID, $object->getId());
        $c->addDescendingOrderByColumn(ProductHasSfAssetPeer::IS_DEFAULT);
        $images = ProductHasSfAssetPeer::doSelectJoinSfAsset($c);
        $images_array = array();
        foreach ($images as $image)
        {
            $images_array[] = $image->getSfAsset()->getFilename();
        }
        return implode('|', $images_array);
    }

    public static function setProductImages(Product $object = null, $value)
    {
        $images_array = explode('|', $value);
        $default = 1;
        foreach ($images_array as $image)
        {
            $input_file = sfConfig::get('sf_upload_dir') . DIRECTORY_SEPARATOR . 'assets' . DIRECTORY_SEPARATOR . $image;

            $c = new Criteria();
            $c->add(ProductHasSfAssetPeer::PRODUCT_ID, $object->getId());
            $c->addJoin(sfAssetPeer::ID, ProductHasSfAssetPeer::SF_ASSET_ID);
            $c->add(sfAssetPeer::FILENAME, $image);
            $product_has_asset = ProductHasSfAssetPeer::doSelectOne($c);

            if (is_readable($input_file) && strlen($image) > 0 && !$product_has_asset)
            {
                    $product_has_asset = new ProductHasSfAsset();
                    $product_has_asset->setProduct($object);
                    $asset = $product_has_asset->createAsset($image, $input_file, ProductHasSfAssetPeer::IMAGE_FOLDER, pathinfo($image, PATHINFO_FILENAME),null,true,false);
            }

            if (is_object($product_has_asset))
            {
                $product_has_asset->setIsDefault($default);
                $product_has_asset->save();
            }
            $default = 0;
        }
    }

    /**
     * Przeciążenie metody pobierającej produkty w odpowiedniej wersji jezykowej
     *
     * @param Criteria $c Kryteria
     * @param mixed $culture Wersja językowa
     * @param CreoleConnection $con Połączenie z bazą danych
     * @return array Produkty
     */
    public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
    {
        if ($culture === null)
        {
            $culture = stLanguage::getHydrateCulture();
        }

        if ($c->getDbName() == Propel::getDefaultDB())
        {
            $c->setDbName(self::DATABASE_NAME);
        }

        ProductPeer::addSelectColumns($c);

        $startcol = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

        ProductI18nPeer::addSelectColumns($c);

        $c->addJoin(ProductPeer::ID, sprintf("%s AND %s = '%s'", ProductI18nPeer::ID, ProductI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

        //        $criterion = $c->getNewCriterion(ProductI18nPeer::CULTURE, $culture);
        //
        //        $criterion->addOr($c->getNewCriterion(ProductI18nPeer::CULTURE, null, Criteria::ISNULL));
        //
        //        $c->add($criterion);

        $rs = BasePeer::doSelect($c, $con);

        $results = array();

        while($rs->next())
        {

            $omClass = ProductPeer::getOMClass();

            $cls = Propel::import($omClass);
            $obj1 = new $cls();
            $obj1->hydrate($rs);
            $obj1->setCulture($culture);

            $omClass = ProductI18nPeer::getOMClass($rs, $startcol);

            $cls = Propel::import($omClass);
            $obj2 = new $cls();
            $obj2->hydrate($rs, $startcol);

            $obj1->setProductI18nForCulture($obj2, $culture);
            $obj2->setProduct($obj1);

            $results[] = $obj1;
        }
        return $results;
    }

    public static function doCountWithI18n(Criteria $c, $con = null)
    {
        $c->addJoin(ProductI18nPeer::ID, ProductPeer::ID);

        $c->add(ProductI18nPeer::CULTURE, stLanguage::getHydrateCulture());

        return self::doCount($c, $con);
    }

    public static function setOldPrice(Product $object, $value=0.0)
    {
        $object->setOldPriceBruttoByNetto($value,$object->getVat());
        return $object->setOldPrice($value);

    }

    public static function getOldPrice(Product $object)
    {
        return $object->getOldPrice();
    }
}