<?php

/**
 * Subclass for representing a row from the 'st_theme_slot' table.
 *
 * 
 *
 * @package lib.model
 */ 
class ThemeSlot extends BaseThemeSlot
{
   public function getComponents()
   {
      $c = new Criteria();
      
      $c->addJoin(ThemeSlotHasComponentPeer::COMPONENT_ID, ThemeComponentPeer::ID);
      
      $c->add(ThemeSlotHasComponentPeer::SLOT_ID, $this->getId());
      
      ThemeComponentPeer::setHydrateMethod(array($this, 'hydrateComponents'));
      
      $ret = ThemeComponentPeer::doSelect($c);
      
      ThemeComponentPeer::setHydrateMethod(null);
      
      return $ret;
   }
   
   public function deleteComponents()
   {
      $con = Propel::getConnection();
      
      $c = new Criteria();
            
      $c->add(ThemeSlotHasComponentPeer::SLOT_ID, $this->getId());
      
      BasePeer::doDelete($c, $con);
      
      $c = new Criteria();
      
      $c->add(ThemeComponentPeer::THEME_ID, $this->getThemeId());
      
      BasePeer::doDelete($c, $con);
   }
   
   public function delete($con = null)
   {
      $this->deleteComponents();
      
      parent::delete($con);
   }
   
   public function hydrateComponents(ResultSet $rs)
   {
      $components = array();
      
      $rs->setFetchmode(ResultSet::FETCHMODE_ASSOC);
      
      while($rs->next())
      {
         $row = $rs->getRow();
         
         $components[] = array(
             'type' => $row['TYPE'],
             'params' => array(
                 'name' => $row['NAME']
                 ));
      }
      
      return $components;
   }
}
