<?php



class BasketProductMapBuilder {

	
	const CLASS_NAME = 'lib.model.map.BasketProductMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_basket_product');
		$tMap->setPhpName('BasketProduct');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('PRODUCT_ID', 'ProductId', 'string', CreoleTypes::VARCHAR, 'st_product', 'ID', false, 255);

		$tMap->addForeignKey('BASKET_ID', 'BasketId', 'int', CreoleTypes::INTEGER, 'st_basket', 'ID', true, null);

		$tMap->addColumn('QUANTITY', 'Quantity', 'double', CreoleTypes::DECIMAL, false, 8);

		$tMap->addColumn('MAX_QUANTITY', 'MaxQuantity', 'double', CreoleTypes::DECIMAL, false, 8);

		$tMap->addColumn('CODE', 'Code', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('NAME', 'Name', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('IMAGE', 'Image', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('ITEM_ID', 'ItemId', 'string', CreoleTypes::VARCHAR, false, 32);

		$tMap->addColumn('PRICE', 'Price', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('PRICE_BRUTTO', 'PriceBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('VAT', 'Vat', 'double', CreoleTypes::FLOAT, false, null);

		$tMap->addColumn('WEIGHT', 'Weight', 'double', CreoleTypes::FLOAT, false, null);

		$tMap->addColumn('PRICE_MODIFIERS', 'PriceModifiers', 'array', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('DISCOUNT', 'Discount', 'array', CreoleTypes::VARCHAR, false, 1024);

		$tMap->addColumn('CURRENCY', 'Currency', 'array', CreoleTypes::VARCHAR, false, 1024);

		$tMap->addColumn('WHOLESALE', 'Wholesale', 'array', CreoleTypes::VARCHAR, false, 1024);

		$tMap->addColumn('OPTIONS', 'Options', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('NEW_OPTIONS', 'NewOptions', 'array', CreoleTypes::LONGVARCHAR, false, null);

	} 
} 