<?php



class OrderDeliveryMapBuilder {

	
	const CLASS_NAME = 'lib.model.map.OrderDeliveryMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_order_delivery');
		$tMap->setPhpName('OrderDelivery');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('TAX_ID', 'TaxId', 'int', CreoleTypes::INTEGER, 'st_tax', 'ID', false, null);

		$tMap->addForeignKey('DELIVERY_ID', 'DeliveryId', 'int', CreoleTypes::INTEGER, 'st_delivery', 'ID', false, null);

		$tMap->addColumn('NAME', 'Name', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('COST', 'Cost', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('PAYMENT_COST', 'PaymentCost', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('OPT_TAX', 'OptTax', 'double', CreoleTypes::DECIMAL, false, 5);

		$tMap->addColumn('NUMBER', 'Number', 'string', CreoleTypes::VARCHAR, false, 128);

		$tMap->addColumn('COST_BRUTTO', 'CostBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('PAYMENT_COST_BRUTTO', 'PaymentCostBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('CUSTOM_COST_BRUTTO', 'CustomCostBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('DELIVERY_DATE', 'DeliveryDate', 'int', CreoleTypes::TIMESTAMP, false, null);

	} 
} 