<?php



class OrderProductMapBuilder {

	
	const CLASS_NAME = 'lib.model.map.OrderProductMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_order_product');
		$tMap->setPhpName('OrderProduct');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('ORDER_ID', 'OrderId', 'int', CreoleTypes::INTEGER, 'st_order', 'ID', true, null);

		$tMap->addForeignKey('PRODUCT_ID', 'ProductId', 'int', CreoleTypes::INTEGER, 'st_product', 'ID', false, null);

		$tMap->addForeignKey('TAX_ID', 'TaxId', 'int', CreoleTypes::INTEGER, 'st_tax', 'ID', false, null);

		$tMap->addColumn('QUANTITY', 'Quantity', 'double', CreoleTypes::DECIMAL, true, 8);

		$tMap->addColumn('CODE', 'Code', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('NAME', 'Name', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('IMAGE', 'Image', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('PRICE', 'Price', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('PRICE_BRUTTO', 'PriceBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('CUSTOM_PRICE', 'CustomPrice', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('CUSTOM_PRICE_BRUTTO', 'CustomPriceBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('VAT', 'Vat', 'double', CreoleTypes::DECIMAL, false, 5);

		$tMap->addColumn('PRICE_MODIFIERS', 'PriceModifiers', 'array', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('DISCOUNT', 'Discount', 'array', CreoleTypes::VARCHAR, false, 1024);

		$tMap->addColumn('CURRENCY', 'Currency', 'array', CreoleTypes::VARCHAR, false, 1024);

		$tMap->addColumn('WHOLESALE', 'Wholesale', 'array', CreoleTypes::VARCHAR, false, 1024);

		$tMap->addColumn('OPTIONS', 'Options', 'string', CreoleTypes::VARCHAR, false, 255);

	} 
} 