<?php



class PaymentMapBuilder {

	
	const CLASS_NAME = 'lib.model.map.PaymentMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_payment');
		$tMap->setPhpName('Payment');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('SF_GUARD_USER_ID', 'SfGuardUserId', 'int', CreoleTypes::INTEGER, 'sf_guard_user', 'ID', true, null);

		$tMap->addForeignKey('PAYMENT_TYPE_ID', 'PaymentTypeId', 'int', CreoleTypes::INTEGER, 'st_payment_type', 'ID', false, null);

		$tMap->addColumn('AMOUNT', 'Amount', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('STATUS', 'Status', 'boolean', CreoleTypes::BOOLEAN, true, null);

		$tMap->addColumn('CANCEL', 'Cancel', 'boolean', CreoleTypes::BOOLEAN, true, null);

		$tMap->addColumn('HASH', 'Hash', 'string', CreoleTypes::VARCHAR, false, 32);

		$tMap->addColumn('PAYED_AT', 'PayedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('VERSION', 'Version', 'int', CreoleTypes::INTEGER, false, null);

		$tMap->addForeignKey('GIFT_CARD_ID', 'GiftCardId', 'int', CreoleTypes::INTEGER, 'st_gift_card', 'ID', false, null);

	} 
} 