<?php



class ProductMapBuilder {

	
	const CLASS_NAME = 'lib.model.map.ProductMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_product');
		$tMap->setPhpName('Product');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('PARENT_ID', 'ParentId', 'int', CreoleTypes::INTEGER, 'st_product', 'ID', false, null);

		$tMap->addForeignKey('CURRENCY_ID', 'CurrencyId', 'int', CreoleTypes::INTEGER, 'st_currency', 'ID', false, null);

		$tMap->addForeignKey('PRODUCER_ID', 'ProducerId', 'int', CreoleTypes::INTEGER, 'st_producer', 'ID', false, null);

		$tMap->addColumn('CODE', 'Code', 'string', CreoleTypes::VARCHAR, true, 255);

		$tMap->addColumn('PRICE', 'Price', 'double', CreoleTypes::DECIMAL, true, 10);

		$tMap->addColumn('OPT_PRICE_BRUTTO', 'OptPriceBrutto', 'double', CreoleTypes::DECIMAL, true, 10);

		$tMap->addColumn('CURRENCY_PRICE', 'CurrencyPrice', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('OLD_PRICE', 'OldPrice', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('OPT_OLD_PRICE_BRUTTO', 'OptOldPriceBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('CURRENCY_OLD_PRICE', 'CurrencyOldPrice', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('OPT_VAT', 'OptVat', 'double', CreoleTypes::DECIMAL, false, 5);

		$tMap->addColumn('CURRENCY_EXCHANGE', 'CurrencyExchange', 'double', CreoleTypes::DECIMAL, false, 6);

		$tMap->addColumn('ACTIVE', 'Active', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('HIDE_PRICE', 'HidePrice', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('HAS_FIXED_CURRENCY', 'HasFixedCurrency', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('OPT_IMAGE', 'OptImage', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('OPT_NAME', 'OptName', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('OPT_SHORT_DESCRIPTION', 'OptShortDescription', 'string', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('OPT_DESCRIPTION', 'OptDescription', 'string', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('OPT_URL', 'OptUrl', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('OPT_ASSET_FOLDER', 'OptAssetFolder', 'string', CreoleTypes::VARCHAR, false, 32);

		$tMap->addColumn('OPT_UOM', 'OptUom', 'string', CreoleTypes::VARCHAR, false, 10);

		$tMap->addColumn('MIN_QTY', 'MinQty', 'double', CreoleTypes::DECIMAL, false, 8);

		$tMap->addColumn('MAX_QTY', 'MaxQty', 'double', CreoleTypes::DECIMAL, false, 8);

		$tMap->addColumn('STEP_QTY', 'StepQty', 'double', CreoleTypes::DECIMAL, false, 8);

		$tMap->addColumn('IS_STOCK_VALIDATED', 'IsStockValidated', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('STOCK_IN_DECIMALS', 'StockInDecimals', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addForeignKey('AVAILABILITY_ID', 'AvailabilityId', 'int', CreoleTypes::INTEGER, 'st_availability', 'ID', false, null);

		$tMap->addColumn('WEIGHT', 'Weight', 'double', CreoleTypes::FLOAT, false, null);

		$tMap->addColumn('STOCK', 'Stock', 'double', CreoleTypes::DECIMAL, false, 8);

		$tMap->addColumn('MAX_DISCOUNT', 'MaxDiscount', 'double', CreoleTypes::DOUBLE, false, null);

		$tMap->addColumn('OPT_HAS_OPTIONS', 'OptHasOptions', 'int', CreoleTypes::INTEGER, false, null);

		$tMap->addColumn('OPTIONS_COLOR', 'OptionsColor', 'array', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addForeignKey('TAX_ID', 'TaxId', 'int', CreoleTypes::INTEGER, 'st_tax', 'ID', false, null);

		$tMap->addColumn('WHOLESALE_A_NETTO', 'WholesaleANetto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('WHOLESALE_B_NETTO', 'WholesaleBNetto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('WHOLESALE_C_NETTO', 'WholesaleCNetto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('WHOLESALE_A_BRUTTO', 'WholesaleABrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('WHOLESALE_B_BRUTTO', 'WholesaleBBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('WHOLESALE_C_BRUTTO', 'WholesaleCBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('CURRENCY_WHOLESALE_A', 'CurrencyWholesaleA', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('CURRENCY_WHOLESALE_B', 'CurrencyWholesaleB', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('CURRENCY_WHOLESALE_C', 'CurrencyWholesaleC', 'double', CreoleTypes::DECIMAL, false, 10);

	} 
} 