<?php



class ReviewMapBuilder {

	
	const CLASS_NAME = 'lib.model.map.ReviewMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_review');
		$tMap->setPhpName('Review');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('ORDER_ID', 'OrderId', 'int', CreoleTypes::INTEGER, 'st_order', 'ID', true, null);

		$tMap->addForeignKey('SF_GUARD_USER_ID', 'SfGuardUserId', 'int', CreoleTypes::INTEGER, 'sf_guard_user', 'ID', false, null);

		$tMap->addForeignKey('PRODUCT_ID', 'ProductId', 'int', CreoleTypes::INTEGER, 'st_product', 'ID', true, null);

		$tMap->addColumn('ACTIVE', 'Active', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('SCORE', 'Score', 'int', CreoleTypes::INTEGER, false, null);

		$tMap->addColumn('MERCHANT', 'Merchant', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('ADMIN_NAME', 'AdminName', 'string', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('ADMIN_ACTIVE', 'AdminActive', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('ANONYMOUS', 'Anonymous', 'string', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('AGREEMENT', 'Agreement', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('ORDER_NUMBER', 'OrderNumber', 'string', CreoleTypes::VARCHAR, false, 64);

		$tMap->addColumn('DESCRIPTION', 'Description', 'string', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('USER_IP', 'UserIp', 'string', CreoleTypes::VARCHAR, false, 20);

		$tMap->addColumn('USERNAME', 'Username', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('LANGUAGE', 'Language', 'string', CreoleTypes::VARCHAR, false, 255);

	} 
} 