<?php


abstract class BaseBasketProduct extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $product_id;


	
	protected $basket_id;


	
	protected $quantity;


	
	protected $max_quantity;


	
	protected $code;


	
	protected $name;


	
	protected $image;


	
	protected $item_id;


	
	protected $price;


	
	protected $price_brutto;


	
	protected $vat;


	
	protected $weight;


	
	protected $price_modifiers;


	
	protected $discount;


	
	protected $currency;


	
	protected $wholesale;


	
	protected $options;


	
	protected $new_options;

	
	protected $aProduct;

	
	protected $aBasket;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

    
    public function getBasketId()
    {

            return $this->basket_id;
    }

    
    public function getQuantity()
    {

            return null !== $this->quantity ? (string)$this->quantity : null;
    }

    
    public function getMaxQuantity()
    {

            return null !== $this->max_quantity ? (string)$this->max_quantity : null;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getImage()
    {

            return $this->image;
    }

    
    public function getItemId()
    {

            return $this->item_id;
    }

    
    public function getPrice()
    {

            return null !== $this->price ? (string)$this->price : null;
    }

    
    public function getPriceBrutto()
    {

            return null !== $this->price_brutto ? (string)$this->price_brutto : null;
    }

    
    public function getVat()
    {

            return $this->vat;
    }

    
    public function getWeight()
    {

            return $this->weight;
    }

    
    public function getPriceModifiers()
    {

            return $this->price_modifiers;
    }

    
    public function getDiscount()
    {

            return $this->discount;
    }

    
    public function getCurrency()
    {

            return $this->currency;
    }

    
    public function getWholesale()
    {

            return $this->wholesale;
    }

    
    public function getOptions()
    {

            return $this->options;
    }

    
    public function getNewOptions()
    {

            return $this->new_options;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = BasketProductPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = BasketProductPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = BasketProductPeer::ID;
        }

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = BasketProductPeer::PRODUCT_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setBasketId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->basket_id !== $v) {
          $this->basket_id = $v;
          $this->modifiedColumns[] = BasketProductPeer::BASKET_ID;
        }

		if ($this->aBasket !== null && $this->aBasket->getId() !== $v) {
			$this->aBasket = null;
		}

	} 
	
	public function setQuantity($v)
	{

        if ($this->quantity !== $v) {
          $this->quantity = $v;
          $this->modifiedColumns[] = BasketProductPeer::QUANTITY;
        }

	} 
	
	public function setMaxQuantity($v)
	{

        if ($this->max_quantity !== $v) {
          $this->max_quantity = $v;
          $this->modifiedColumns[] = BasketProductPeer::MAX_QUANTITY;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = BasketProductPeer::CODE;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = BasketProductPeer::NAME;
        }

	} 
	
	public function setImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->image !== $v) {
          $this->image = $v;
          $this->modifiedColumns[] = BasketProductPeer::IMAGE;
        }

	} 
	
	public function setItemId($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->item_id !== $v) {
          $this->item_id = $v;
          $this->modifiedColumns[] = BasketProductPeer::ITEM_ID;
        }

	} 
	
	public function setPrice($v)
	{

        if ($this->price !== $v) {
          $this->price = $v;
          $this->modifiedColumns[] = BasketProductPeer::PRICE;
        }

	} 
	
	public function setPriceBrutto($v)
	{

        if ($this->price_brutto !== $v) {
          $this->price_brutto = $v;
          $this->modifiedColumns[] = BasketProductPeer::PRICE_BRUTTO;
        }

	} 
	
	public function setVat($v)
	{

        if ($this->vat !== $v) {
          $this->vat = $v;
          $this->modifiedColumns[] = BasketProductPeer::VAT;
        }

	} 
	
	public function setWeight($v)
	{

        if ($this->weight !== $v) {
          $this->weight = $v;
          $this->modifiedColumns[] = BasketProductPeer::WEIGHT;
        }

	} 
	
	public function setPriceModifiers($v)
	{

        if ($this->price_modifiers !== $v) {
          $this->price_modifiers = $v;
          $this->modifiedColumns[] = BasketProductPeer::PRICE_MODIFIERS;
        }

	} 
	
	public function setDiscount($v)
	{

        if ($this->discount !== $v) {
          $this->discount = $v;
          $this->modifiedColumns[] = BasketProductPeer::DISCOUNT;
        }

	} 
	
	public function setCurrency($v)
	{

        if ($this->currency !== $v) {
          $this->currency = $v;
          $this->modifiedColumns[] = BasketProductPeer::CURRENCY;
        }

	} 
	
	public function setWholesale($v)
	{

        if ($this->wholesale !== $v) {
          $this->wholesale = $v;
          $this->modifiedColumns[] = BasketProductPeer::WHOLESALE;
        }

	} 
	
	public function setOptions($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->options !== $v) {
          $this->options = $v;
          $this->modifiedColumns[] = BasketProductPeer::OPTIONS;
        }

	} 
	
	public function setNewOptions($v)
	{

        if ($this->new_options !== $v) {
          $this->new_options = $v;
          $this->modifiedColumns[] = BasketProductPeer::NEW_OPTIONS;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'BasketProduct.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->product_id = $rs->getString($startcol + 3);

      $this->basket_id = $rs->getInt($startcol + 4);

      $this->quantity = $rs->getString($startcol + 5, null);

      $this->quantity = $rs->getFloat($startcol + 5);

      $this->max_quantity = $rs->getString($startcol + 6, null);

      $this->max_quantity = $rs->getFloat($startcol + 6);

      $this->code = $rs->getString($startcol + 7);

      $this->name = $rs->getString($startcol + 8);

      $this->image = $rs->getString($startcol + 9);

      $this->item_id = $rs->getString($startcol + 10);

      $this->price = $rs->getString($startcol + 11, null);

      $this->price = $rs->getFloat($startcol + 11);

      $this->price_brutto = $rs->getString($startcol + 12, null);

      $this->price_brutto = $rs->getFloat($startcol + 12);

      $this->vat = $rs->getFloat($startcol + 13);

      $this->weight = $rs->getFloat($startcol + 14);

      $this->price_modifiers = $rs->getString($startcol + 15) ? unserialize($rs->getString($startcol + 15)) : null;

      $this->discount = $rs->getString($startcol + 16) ? unserialize($rs->getString($startcol + 16)) : null;

      $this->currency = $rs->getString($startcol + 17) ? unserialize($rs->getString($startcol + 17)) : null;

      $this->wholesale = $rs->getString($startcol + 18) ? unserialize($rs->getString($startcol + 18)) : null;

      $this->options = $rs->getString($startcol + 19);

      $this->new_options = $rs->getString($startcol + 20) ? unserialize($rs->getString($startcol + 20)) : null;

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'BasketProduct.postHydrate', array('resultset' => $rs, 'startcol' => 21)));

            return $startcol + 21; 
    } catch (Exception $e) {
      throw new PropelException("Error populating BasketProduct object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseBasketProduct:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BasketProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			BasketProductPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseBasketProduct:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'BasketProduct.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseBasketProduct:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(BasketProductPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(BasketProductPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BasketProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'BasketProduct.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseBasketProduct:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}

			if ($this->aBasket !== null) {
				if ($this->aBasket->isModified()) {
					$affectedRows += $this->aBasket->save($con);
				}
				$this->setBasket($this->aBasket);
			}


						if ($this->isModified()) {
              $o_price_modifiers = $this->price_modifiers;
              if (null !== $this->price_modifiers && $this->isColumnModified(BasketProductPeer::PRICE_MODIFIERS)) {
                  $this->price_modifiers = serialize($this->price_modifiers);
              }

              $o_discount = $this->discount;
              if (null !== $this->discount && $this->isColumnModified(BasketProductPeer::DISCOUNT)) {
                  $this->discount = serialize($this->discount);
              }

              $o_currency = $this->currency;
              if (null !== $this->currency && $this->isColumnModified(BasketProductPeer::CURRENCY)) {
                  $this->currency = serialize($this->currency);
              }

              $o_wholesale = $this->wholesale;
              if (null !== $this->wholesale && $this->isColumnModified(BasketProductPeer::WHOLESALE)) {
                  $this->wholesale = serialize($this->wholesale);
              }

              $o_new_options = $this->new_options;
              if (null !== $this->new_options && $this->isColumnModified(BasketProductPeer::NEW_OPTIONS)) {
                  $this->new_options = serialize($this->new_options);
              }

				if ($this->isNew()) {
					$pk = BasketProductPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += BasketProductPeer::doUpdate($this, $con);
				}
				$this->resetModified();
             $this->price_modifiers = $o_price_modifiers;

             $this->discount = $o_discount;

             $this->currency = $o_currency;

             $this->wholesale = $o_wholesale;

             $this->new_options = $o_new_options;
 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}

			if ($this->aBasket !== null) {
				if (!$this->aBasket->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aBasket->getValidationFailures());
				}
			}


			if (($retval = BasketProductPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BasketProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getProductId();
				break;
			case 4:
				return $this->getBasketId();
				break;
			case 5:
				return $this->getQuantity();
				break;
			case 6:
				return $this->getMaxQuantity();
				break;
			case 7:
				return $this->getCode();
				break;
			case 8:
				return $this->getName();
				break;
			case 9:
				return $this->getImage();
				break;
			case 10:
				return $this->getItemId();
				break;
			case 11:
				return $this->getPrice();
				break;
			case 12:
				return $this->getPriceBrutto();
				break;
			case 13:
				return $this->getVat();
				break;
			case 14:
				return $this->getWeight();
				break;
			case 15:
				return $this->getPriceModifiers();
				break;
			case 16:
				return $this->getDiscount();
				break;
			case 17:
				return $this->getCurrency();
				break;
			case 18:
				return $this->getWholesale();
				break;
			case 19:
				return $this->getOptions();
				break;
			case 20:
				return $this->getNewOptions();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BasketProductPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getProductId(),
			$keys[4] => $this->getBasketId(),
			$keys[5] => $this->getQuantity(),
			$keys[6] => $this->getMaxQuantity(),
			$keys[7] => $this->getCode(),
			$keys[8] => $this->getName(),
			$keys[9] => $this->getImage(),
			$keys[10] => $this->getItemId(),
			$keys[11] => $this->getPrice(),
			$keys[12] => $this->getPriceBrutto(),
			$keys[13] => $this->getVat(),
			$keys[14] => $this->getWeight(),
			$keys[15] => $this->getPriceModifiers(),
			$keys[16] => $this->getDiscount(),
			$keys[17] => $this->getCurrency(),
			$keys[18] => $this->getWholesale(),
			$keys[19] => $this->getOptions(),
			$keys[20] => $this->getNewOptions(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BasketProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setProductId($value);
				break;
			case 4:
				$this->setBasketId($value);
				break;
			case 5:
				$this->setQuantity($value);
				break;
			case 6:
				$this->setMaxQuantity($value);
				break;
			case 7:
				$this->setCode($value);
				break;
			case 8:
				$this->setName($value);
				break;
			case 9:
				$this->setImage($value);
				break;
			case 10:
				$this->setItemId($value);
				break;
			case 11:
				$this->setPrice($value);
				break;
			case 12:
				$this->setPriceBrutto($value);
				break;
			case 13:
				$this->setVat($value);
				break;
			case 14:
				$this->setWeight($value);
				break;
			case 15:
				$this->setPriceModifiers($value);
				break;
			case 16:
				$this->setDiscount($value);
				break;
			case 17:
				$this->setCurrency($value);
				break;
			case 18:
				$this->setWholesale($value);
				break;
			case 19:
				$this->setOptions($value);
				break;
			case 20:
				$this->setNewOptions($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BasketProductPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setProductId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setBasketId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setQuantity($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setMaxQuantity($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setCode($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setName($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setImage($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setItemId($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setPrice($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setPriceBrutto($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setVat($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setWeight($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setPriceModifiers($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setDiscount($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setCurrency($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setWholesale($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setOptions($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setNewOptions($arr[$keys[20]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(BasketProductPeer::DATABASE_NAME);

		if ($this->isColumnModified(BasketProductPeer::CREATED_AT)) $criteria->add(BasketProductPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(BasketProductPeer::UPDATED_AT)) $criteria->add(BasketProductPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(BasketProductPeer::ID)) $criteria->add(BasketProductPeer::ID, $this->id);
		if ($this->isColumnModified(BasketProductPeer::PRODUCT_ID)) $criteria->add(BasketProductPeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(BasketProductPeer::BASKET_ID)) $criteria->add(BasketProductPeer::BASKET_ID, $this->basket_id);
		if ($this->isColumnModified(BasketProductPeer::QUANTITY)) $criteria->add(BasketProductPeer::QUANTITY, $this->quantity);
		if ($this->isColumnModified(BasketProductPeer::MAX_QUANTITY)) $criteria->add(BasketProductPeer::MAX_QUANTITY, $this->max_quantity);
		if ($this->isColumnModified(BasketProductPeer::CODE)) $criteria->add(BasketProductPeer::CODE, $this->code);
		if ($this->isColumnModified(BasketProductPeer::NAME)) $criteria->add(BasketProductPeer::NAME, $this->name);
		if ($this->isColumnModified(BasketProductPeer::IMAGE)) $criteria->add(BasketProductPeer::IMAGE, $this->image);
		if ($this->isColumnModified(BasketProductPeer::ITEM_ID)) $criteria->add(BasketProductPeer::ITEM_ID, $this->item_id);
		if ($this->isColumnModified(BasketProductPeer::PRICE)) $criteria->add(BasketProductPeer::PRICE, $this->price);
		if ($this->isColumnModified(BasketProductPeer::PRICE_BRUTTO)) $criteria->add(BasketProductPeer::PRICE_BRUTTO, $this->price_brutto);
		if ($this->isColumnModified(BasketProductPeer::VAT)) $criteria->add(BasketProductPeer::VAT, $this->vat);
		if ($this->isColumnModified(BasketProductPeer::WEIGHT)) $criteria->add(BasketProductPeer::WEIGHT, $this->weight);
		if ($this->isColumnModified(BasketProductPeer::PRICE_MODIFIERS)) $criteria->add(BasketProductPeer::PRICE_MODIFIERS, $this->price_modifiers);
		if ($this->isColumnModified(BasketProductPeer::DISCOUNT)) $criteria->add(BasketProductPeer::DISCOUNT, $this->discount);
		if ($this->isColumnModified(BasketProductPeer::CURRENCY)) $criteria->add(BasketProductPeer::CURRENCY, $this->currency);
		if ($this->isColumnModified(BasketProductPeer::WHOLESALE)) $criteria->add(BasketProductPeer::WHOLESALE, $this->wholesale);
		if ($this->isColumnModified(BasketProductPeer::OPTIONS)) $criteria->add(BasketProductPeer::OPTIONS, $this->options);
		if ($this->isColumnModified(BasketProductPeer::NEW_OPTIONS)) $criteria->add(BasketProductPeer::NEW_OPTIONS, $this->new_options);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(BasketProductPeer::DATABASE_NAME);

		$criteria->add(BasketProductPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setProductId($this->product_id);

		$copyObj->setBasketId($this->basket_id);

		$copyObj->setQuantity($this->quantity);

		$copyObj->setMaxQuantity($this->max_quantity);

		$copyObj->setCode($this->code);

		$copyObj->setName($this->name);

		$copyObj->setImage($this->image);

		$copyObj->setItemId($this->item_id);

		$copyObj->setPrice($this->price);

		$copyObj->setPriceBrutto($this->price_brutto);

		$copyObj->setVat($this->vat);

		$copyObj->setWeight($this->weight);

		$copyObj->setPriceModifiers($this->price_modifiers);

		$copyObj->setDiscount($this->discount);

		$copyObj->setCurrency($this->currency);

		$copyObj->setWholesale($this->wholesale);

		$copyObj->setOptions($this->options);

		$copyObj->setNewOptions($this->new_options);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new BasketProductPeer();
		}
		return self::$peer;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && (($this->product_id !== "" && $this->product_id !== null))) {
						$this->aProduct = ProductPeer::retrieveByPK($this->product_id, $con);

			
		}
		return $this->aProduct;
	}

	
	public function setBasket($v)
	{


		if ($v === null) {
			$this->setBasketId(NULL);
		} else {
			$this->setBasketId($v->getId());
		}


		$this->aBasket = $v;
	}


	
	public function getBasket($con = null)
	{
		if ($this->aBasket === null && ($this->basket_id !== null)) {
						$this->aBasket = BasketPeer::retrieveByPK($this->basket_id, $con);

			
		}
		return $this->aBasket;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'BasketProduct.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseBasketProduct:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseBasketProduct::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 