<?php


abstract class BaseCategory extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_image;


	
	protected $lft;


	
	protected $rgt;


	
	protected $scope;


	
	protected $main_page;


	
	protected $parent_id;


	
	protected $sf_asset_id;


	
	protected $opt_name;


	
	protected $opt_description;


	
	protected $depth = 0;


	
	protected $root_position;


	
	protected $is_active = true;


	
	protected $is_hidden = false;


	
	protected $opt_url;

	
	protected $aCategoryRelatedByParentId;

	
	protected $asfAsset;

	
	protected $collCategoryHasPositionings;

	
	protected $lastCategoryHasPositioningCriteria = null;

	
	protected $collCategorysRelatedByParentId;

	
	protected $lastCategoryRelatedByParentIdCriteria = null;

	
	protected $collCategoryI18ns;

	
	protected $lastCategoryI18nCriteria = null;

	
	protected $collProductHasCategorys;

	
	protected $lastProductHasCategoryCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptImage()
    {

            return $this->opt_image;
    }

    
    public function getLft()
    {

            return $this->lft;
    }

    
    public function getRgt()
    {

            return $this->rgt;
    }

    
    public function getScope()
    {

            return $this->scope;
    }

    
    public function getMainPage()
    {

            return $this->main_page;
    }

    
    public function getParentId()
    {

            return $this->parent_id;
    }

    
    public function getSfAssetId()
    {

            return $this->sf_asset_id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getDepth()
    {

            return $this->depth;
    }

    
    public function getRootPosition()
    {

            return $this->root_position;
    }

    
    public function getIsActive()
    {

            return $this->is_active;
    }

    
    public function getIsHidden()
    {

            return $this->is_hidden;
    }

    
    public function getOptUrl()
    {

            return $this->opt_url;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = CategoryPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = CategoryPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = CategoryPeer::ID;
        }

	} 
	
	public function setOptImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_image !== $v) {
          $this->opt_image = $v;
          $this->modifiedColumns[] = CategoryPeer::OPT_IMAGE;
        }

	} 
	
	public function setLft($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->lft !== $v) {
          $this->lft = $v;
          $this->modifiedColumns[] = CategoryPeer::LFT;
        }

	} 
	
	public function setRgt($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->rgt !== $v) {
          $this->rgt = $v;
          $this->modifiedColumns[] = CategoryPeer::RGT;
        }

	} 
	
	public function setScope($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->scope !== $v) {
          $this->scope = $v;
          $this->modifiedColumns[] = CategoryPeer::SCOPE;
        }

	} 
	
	public function setMainPage($v)
	{

        if ($this->main_page !== $v) {
          $this->main_page = $v;
          $this->modifiedColumns[] = CategoryPeer::MAIN_PAGE;
        }

	} 
	
	public function setParentId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->parent_id !== $v) {
          $this->parent_id = $v;
          $this->modifiedColumns[] = CategoryPeer::PARENT_ID;
        }

		if ($this->aCategoryRelatedByParentId !== null && $this->aCategoryRelatedByParentId->getId() !== $v) {
			$this->aCategoryRelatedByParentId = null;
		}

	} 
	
	public function setSfAssetId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_asset_id !== $v) {
          $this->sf_asset_id = $v;
          $this->modifiedColumns[] = CategoryPeer::SF_ASSET_ID;
        }

		if ($this->asfAsset !== null && $this->asfAsset->getId() !== $v) {
			$this->asfAsset = null;
		}

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = CategoryPeer::OPT_NAME;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = CategoryPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setDepth($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->depth !== $v || $v === 0) {
          $this->depth = $v;
          $this->modifiedColumns[] = CategoryPeer::DEPTH;
        }

	} 
	
	public function setRootPosition($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->root_position !== $v) {
          $this->root_position = $v;
          $this->modifiedColumns[] = CategoryPeer::ROOT_POSITION;
        }

	} 
	
	public function setIsActive($v)
	{

        if ($this->is_active !== $v || $v === true) {
          $this->is_active = $v;
          $this->modifiedColumns[] = CategoryPeer::IS_ACTIVE;
        }

	} 
	
	public function setIsHidden($v)
	{

        if ($this->is_hidden !== $v || $v === false) {
          $this->is_hidden = $v;
          $this->modifiedColumns[] = CategoryPeer::IS_HIDDEN;
        }

	} 
	
	public function setOptUrl($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_url !== $v) {
          $this->opt_url = $v;
          $this->modifiedColumns[] = CategoryPeer::OPT_URL;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Category.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_image = $rs->getString($startcol + 3);

      $this->lft = $rs->getInt($startcol + 4);

      $this->rgt = $rs->getInt($startcol + 5);

      $this->scope = $rs->getInt($startcol + 6);

      $this->main_page = $rs->getBoolean($startcol + 7);

      $this->parent_id = $rs->getInt($startcol + 8);

      $this->sf_asset_id = $rs->getInt($startcol + 9);

      $this->opt_name = $rs->getString($startcol + 10);

      $this->opt_description = $rs->getString($startcol + 11);

      $this->depth = $rs->getInt($startcol + 12);

      $this->root_position = $rs->getInt($startcol + 13);

      $this->is_active = $rs->getBoolean($startcol + 14);

      $this->is_hidden = $rs->getBoolean($startcol + 15);

      $this->opt_url = $rs->getString($startcol + 16);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Category.postHydrate', array('resultset' => $rs, 'startcol' => 17)));

            return $startcol + 17; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Category object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseCategory:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CategoryPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			CategoryPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseCategory:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Category.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseCategory:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(CategoryPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(CategoryPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CategoryPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Category.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseCategory:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aCategoryRelatedByParentId !== null) {
				if ($this->aCategoryRelatedByParentId->isModified() || $this->aCategoryRelatedByParentId->getCurrentCategoryI18n()->isModified()) {
					$affectedRows += $this->aCategoryRelatedByParentId->save($con);
				}
				$this->setCategoryRelatedByParentId($this->aCategoryRelatedByParentId);
			}

			if ($this->asfAsset !== null) {
				if ($this->asfAsset->isModified()) {
					$affectedRows += $this->asfAsset->save($con);
				}
				$this->setsfAsset($this->asfAsset);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CategoryPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += CategoryPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collCategoryHasPositionings !== null) {
				foreach($this->collCategoryHasPositionings as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCategorysRelatedByParentId !== null) {
				foreach($this->collCategorysRelatedByParentId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCategoryI18ns !== null) {
				foreach($this->collCategoryI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasCategorys !== null) {
				foreach($this->collProductHasCategorys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aCategoryRelatedByParentId !== null) {
				if (!$this->aCategoryRelatedByParentId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCategoryRelatedByParentId->getValidationFailures());
				}
			}

			if ($this->asfAsset !== null) {
				if (!$this->asfAsset->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfAsset->getValidationFailures());
				}
			}


			if (($retval = CategoryPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collCategoryHasPositionings !== null) {
					foreach($this->collCategoryHasPositionings as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCategoryI18ns !== null) {
					foreach($this->collCategoryI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasCategorys !== null) {
					foreach($this->collProductHasCategorys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CategoryPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptImage();
				break;
			case 4:
				return $this->getLft();
				break;
			case 5:
				return $this->getRgt();
				break;
			case 6:
				return $this->getScope();
				break;
			case 7:
				return $this->getMainPage();
				break;
			case 8:
				return $this->getParentId();
				break;
			case 9:
				return $this->getSfAssetId();
				break;
			case 10:
				return $this->getOptName();
				break;
			case 11:
				return $this->getOptDescription();
				break;
			case 12:
				return $this->getDepth();
				break;
			case 13:
				return $this->getRootPosition();
				break;
			case 14:
				return $this->getIsActive();
				break;
			case 15:
				return $this->getIsHidden();
				break;
			case 16:
				return $this->getOptUrl();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CategoryPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptImage(),
			$keys[4] => $this->getLft(),
			$keys[5] => $this->getRgt(),
			$keys[6] => $this->getScope(),
			$keys[7] => $this->getMainPage(),
			$keys[8] => $this->getParentId(),
			$keys[9] => $this->getSfAssetId(),
			$keys[10] => $this->getOptName(),
			$keys[11] => $this->getOptDescription(),
			$keys[12] => $this->getDepth(),
			$keys[13] => $this->getRootPosition(),
			$keys[14] => $this->getIsActive(),
			$keys[15] => $this->getIsHidden(),
			$keys[16] => $this->getOptUrl(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CategoryPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptImage($value);
				break;
			case 4:
				$this->setLft($value);
				break;
			case 5:
				$this->setRgt($value);
				break;
			case 6:
				$this->setScope($value);
				break;
			case 7:
				$this->setMainPage($value);
				break;
			case 8:
				$this->setParentId($value);
				break;
			case 9:
				$this->setSfAssetId($value);
				break;
			case 10:
				$this->setOptName($value);
				break;
			case 11:
				$this->setOptDescription($value);
				break;
			case 12:
				$this->setDepth($value);
				break;
			case 13:
				$this->setRootPosition($value);
				break;
			case 14:
				$this->setIsActive($value);
				break;
			case 15:
				$this->setIsHidden($value);
				break;
			case 16:
				$this->setOptUrl($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CategoryPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptImage($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setLft($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setRgt($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setScope($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setMainPage($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setParentId($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setSfAssetId($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setOptName($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setOptDescription($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setDepth($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setRootPosition($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setIsActive($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setIsHidden($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setOptUrl($arr[$keys[16]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(CategoryPeer::DATABASE_NAME);

		if ($this->isColumnModified(CategoryPeer::CREATED_AT)) $criteria->add(CategoryPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(CategoryPeer::UPDATED_AT)) $criteria->add(CategoryPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(CategoryPeer::ID)) $criteria->add(CategoryPeer::ID, $this->id);
		if ($this->isColumnModified(CategoryPeer::OPT_IMAGE)) $criteria->add(CategoryPeer::OPT_IMAGE, $this->opt_image);
		if ($this->isColumnModified(CategoryPeer::LFT)) $criteria->add(CategoryPeer::LFT, $this->lft);
		if ($this->isColumnModified(CategoryPeer::RGT)) $criteria->add(CategoryPeer::RGT, $this->rgt);
		if ($this->isColumnModified(CategoryPeer::SCOPE)) $criteria->add(CategoryPeer::SCOPE, $this->scope);
		if ($this->isColumnModified(CategoryPeer::MAIN_PAGE)) $criteria->add(CategoryPeer::MAIN_PAGE, $this->main_page);
		if ($this->isColumnModified(CategoryPeer::PARENT_ID)) $criteria->add(CategoryPeer::PARENT_ID, $this->parent_id);
		if ($this->isColumnModified(CategoryPeer::SF_ASSET_ID)) $criteria->add(CategoryPeer::SF_ASSET_ID, $this->sf_asset_id);
		if ($this->isColumnModified(CategoryPeer::OPT_NAME)) $criteria->add(CategoryPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(CategoryPeer::OPT_DESCRIPTION)) $criteria->add(CategoryPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(CategoryPeer::DEPTH)) $criteria->add(CategoryPeer::DEPTH, $this->depth);
		if ($this->isColumnModified(CategoryPeer::ROOT_POSITION)) $criteria->add(CategoryPeer::ROOT_POSITION, $this->root_position);
		if ($this->isColumnModified(CategoryPeer::IS_ACTIVE)) $criteria->add(CategoryPeer::IS_ACTIVE, $this->is_active);
		if ($this->isColumnModified(CategoryPeer::IS_HIDDEN)) $criteria->add(CategoryPeer::IS_HIDDEN, $this->is_hidden);
		if ($this->isColumnModified(CategoryPeer::OPT_URL)) $criteria->add(CategoryPeer::OPT_URL, $this->opt_url);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CategoryPeer::DATABASE_NAME);

		$criteria->add(CategoryPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptImage($this->opt_image);

		$copyObj->setLft($this->lft);

		$copyObj->setRgt($this->rgt);

		$copyObj->setScope($this->scope);

		$copyObj->setMainPage($this->main_page);

		$copyObj->setParentId($this->parent_id);

		$copyObj->setSfAssetId($this->sf_asset_id);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setDepth($this->depth);

		$copyObj->setRootPosition($this->root_position);

		$copyObj->setIsActive($this->is_active);

		$copyObj->setIsHidden($this->is_hidden);

		$copyObj->setOptUrl($this->opt_url);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getCategoryHasPositionings() as $relObj) {
				$copyObj->addCategoryHasPositioning($relObj->copy($deepCopy));
			}

			foreach($this->getCategorysRelatedByParentId() as $relObj) {
				if($this->getPrimaryKey() === $relObj->getPrimaryKey()) {
						continue;
				}

				$copyObj->addCategoryRelatedByParentId($relObj->copy($deepCopy));
			}

			foreach($this->getCategoryI18ns() as $relObj) {
				$copyObj->addCategoryI18n($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasCategorys() as $relObj) {
				$copyObj->addProductHasCategory($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CategoryPeer();
		}
		return self::$peer;
	}

	
	public function setCategoryRelatedByParentId($v)
	{


		if ($v === null) {
			$this->setParentId(NULL);
		} else {
			$this->setParentId($v->getId());
		}


		$this->aCategoryRelatedByParentId = $v;
	}


	
	public function getCategoryRelatedByParentId($con = null)
	{
		if ($this->aCategoryRelatedByParentId === null && ($this->parent_id !== null)) {
						$this->aCategoryRelatedByParentId = CategoryPeer::retrieveByPK($this->parent_id, $con);

			
		}
		return $this->aCategoryRelatedByParentId;
	}

	
	public function setsfAsset($v)
	{


		if ($v === null) {
			$this->setSfAssetId(NULL);
		} else {
			$this->setSfAssetId($v->getId());
		}


		$this->asfAsset = $v;
	}


	
	public function getsfAsset($con = null)
	{
		if ($this->asfAsset === null && ($this->sf_asset_id !== null)) {
						$this->asfAsset = sfAssetPeer::retrieveByPK($this->sf_asset_id, $con);

			
		}
		return $this->asfAsset;
	}

	
	public function initCategoryHasPositionings()
	{
		if ($this->collCategoryHasPositionings === null) {
			$this->collCategoryHasPositionings = array();
		}
	}

	
	public function getCategoryHasPositionings($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCategoryHasPositionings === null) {
			if ($this->isNew()) {
			   $this->collCategoryHasPositionings = array();
			} else {

				$criteria->add(CategoryHasPositioningPeer::CATEGORY_ID, $this->getId());

				CategoryHasPositioningPeer::addSelectColumns($criteria);
				$this->collCategoryHasPositionings = CategoryHasPositioningPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CategoryHasPositioningPeer::CATEGORY_ID, $this->getId());

				CategoryHasPositioningPeer::addSelectColumns($criteria);
				if (!isset($this->lastCategoryHasPositioningCriteria) || !$this->lastCategoryHasPositioningCriteria->equals($criteria)) {
					$this->collCategoryHasPositionings = CategoryHasPositioningPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCategoryHasPositioningCriteria = $criteria;
		return $this->collCategoryHasPositionings;
	}

	
	public function countCategoryHasPositionings($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CategoryHasPositioningPeer::CATEGORY_ID, $this->getId());

		return CategoryHasPositioningPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCategoryHasPositioning(CategoryHasPositioning $l)
	{
		$this->collCategoryHasPositionings[] = $l;
		$l->setCategory($this);
	}

	
	public function initCategorysRelatedByParentId()
	{
		if ($this->collCategorysRelatedByParentId === null) {
			$this->collCategorysRelatedByParentId = array();
		}
	}

	
	public function getCategorysRelatedByParentId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCategorysRelatedByParentId === null) {
			if ($this->isNew()) {
			   $this->collCategorysRelatedByParentId = array();
			} else {

				$criteria->add(CategoryPeer::PARENT_ID, $this->getId());

				CategoryPeer::addSelectColumns($criteria);
				$this->collCategorysRelatedByParentId = CategoryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CategoryPeer::PARENT_ID, $this->getId());

				CategoryPeer::addSelectColumns($criteria);
				if (!isset($this->lastCategoryRelatedByParentIdCriteria) || !$this->lastCategoryRelatedByParentIdCriteria->equals($criteria)) {
					$this->collCategorysRelatedByParentId = CategoryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCategoryRelatedByParentIdCriteria = $criteria;
		return $this->collCategorysRelatedByParentId;
	}

	
	public function countCategorysRelatedByParentId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CategoryPeer::PARENT_ID, $this->getId());

		return CategoryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCategoryRelatedByParentId(Category $l)
	{
		$this->collCategorysRelatedByParentId[] = $l;
		$l->setCategoryRelatedByParentId($this);
	}


	
	public function getCategorysRelatedByParentIdJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCategorysRelatedByParentId === null) {
			if ($this->isNew()) {
				$this->collCategorysRelatedByParentId = array();
			} else {

				$criteria->add(CategoryPeer::PARENT_ID, $this->getId());

				$this->collCategorysRelatedByParentId = CategoryPeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(CategoryPeer::PARENT_ID, $this->getId());

			if (!isset($this->lastCategoryRelatedByParentIdCriteria) || !$this->lastCategoryRelatedByParentIdCriteria->equals($criteria)) {
				$this->collCategorysRelatedByParentId = CategoryPeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastCategoryRelatedByParentIdCriteria = $criteria;

		return $this->collCategorysRelatedByParentId;
	}

	
	public function initCategoryI18ns()
	{
		if ($this->collCategoryI18ns === null) {
			$this->collCategoryI18ns = array();
		}
	}

	
	public function getCategoryI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCategoryI18ns === null) {
			if ($this->isNew()) {
			   $this->collCategoryI18ns = array();
			} else {

				$criteria->add(CategoryI18nPeer::ID, $this->getId());

				CategoryI18nPeer::addSelectColumns($criteria);
				$this->collCategoryI18ns = CategoryI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CategoryI18nPeer::ID, $this->getId());

				CategoryI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastCategoryI18nCriteria) || !$this->lastCategoryI18nCriteria->equals($criteria)) {
					$this->collCategoryI18ns = CategoryI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCategoryI18nCriteria = $criteria;
		return $this->collCategoryI18ns;
	}

	
	public function countCategoryI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CategoryI18nPeer::ID, $this->getId());

		return CategoryI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCategoryI18n(CategoryI18n $l)
	{
		$this->collCategoryI18ns[] = $l;
		$l->setCategory($this);
	}

	
	public function initProductHasCategorys()
	{
		if ($this->collProductHasCategorys === null) {
			$this->collProductHasCategorys = array();
		}
	}

	
	public function getProductHasCategorys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasCategorys === null) {
			if ($this->isNew()) {
			   $this->collProductHasCategorys = array();
			} else {

				$criteria->add(ProductHasCategoryPeer::CATEGORY_ID, $this->getId());

				ProductHasCategoryPeer::addSelectColumns($criteria);
				$this->collProductHasCategorys = ProductHasCategoryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasCategoryPeer::CATEGORY_ID, $this->getId());

				ProductHasCategoryPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasCategoryCriteria) || !$this->lastProductHasCategoryCriteria->equals($criteria)) {
					$this->collProductHasCategorys = ProductHasCategoryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasCategoryCriteria = $criteria;
		return $this->collProductHasCategorys;
	}

	
	public function countProductHasCategorys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasCategoryPeer::CATEGORY_ID, $this->getId());

		return ProductHasCategoryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasCategory(ProductHasCategory $l)
	{
		$this->collProductHasCategorys[] = $l;
		$l->setCategory($this);
	}


	
	public function getProductHasCategorysJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasCategorys === null) {
			if ($this->isNew()) {
				$this->collProductHasCategorys = array();
			} else {

				$criteria->add(ProductHasCategoryPeer::CATEGORY_ID, $this->getId());

				$this->collProductHasCategorys = ProductHasCategoryPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasCategoryPeer::CATEGORY_ID, $this->getId());

			if (!isset($this->lastProductHasCategoryCriteria) || !$this->lastProductHasCategoryCriteria->equals($criteria)) {
				$this->collProductHasCategorys = ProductHasCategoryPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductHasCategoryCriteria = $criteria;

		return $this->collProductHasCategorys;
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentCategoryI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentCategoryI18n()->setName($value);
  }

  public function getUrl()
  {
    $obj = $this->getCurrentCategoryI18n();

    return ($obj ? $obj->getUrl() : null);
  }

  public function setUrl($value)
  {
    $this->getCurrentCategoryI18n()->setUrl($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentCategoryI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentCategoryI18n()->setDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentCategoryI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = CategoryI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setCategoryI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setCategoryI18nForCulture(new CategoryI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setCategoryI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addCategoryI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Category.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseCategory:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseCategory::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 