<?php


abstract class BaseOrder extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $order_delivery_id;


	
	protected $sf_guard_user_id;


	
	protected $order_user_data_delivery_id;


	
	protected $order_user_data_billing_id;


	
	protected $order_currency_id;


	
	protected $order_status_id;


	
	protected $discount_coupon_code_id;


	
	protected $hash_code;


	
	protected $is_confirmed = false;


	
	protected $number;


	
	protected $description;


	
	protected $order_type;


	
	protected $merchant_notes;


	
	protected $client_culture;


	
	protected $host;


	
	protected $opt_total_amount = 0;


	
	protected $opt_is_payed;


	
	protected $opt_client_name;


	
	protected $opt_client_email;


	
	protected $opt_order_status;


	
	protected $change_stock_on;


	
	protected $ifirma_proforma_id = 0;


	
	protected $ifirma_invoice_id = 0;


	
	protected $partner_id;


	
	protected $provision_value;


	
	protected $provision_payed = false;

	
	protected $aOrderDelivery;

	
	protected $asfGuardUser;

	
	protected $aOrderUserDataDelivery;

	
	protected $aOrderUserDataBilling;

	
	protected $aOrderCurrency;

	
	protected $aOrderStatus;

	
	protected $aDiscountCouponCode;

	
	protected $aPartner;

	
	protected $collTrustedShopsHasOrders;

	
	protected $lastTrustedShopsHasOrderCriteria = null;

	
	protected $collOrderHasPayments;

	
	protected $lastOrderHasPaymentCriteria = null;

	
	protected $collOrderProducts;

	
	protected $lastOrderProductCriteria = null;

	
	protected $collInvoices;

	
	protected $lastInvoiceCriteria = null;

	
	protected $collReviews;

	
	protected $lastReviewCriteria = null;

	
	protected $collReviewOrders;

	
	protected $lastReviewOrderCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOrderDeliveryId()
    {

            return $this->order_delivery_id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getOrderUserDataDeliveryId()
    {

            return $this->order_user_data_delivery_id;
    }

    
    public function getOrderUserDataBillingId()
    {

            return $this->order_user_data_billing_id;
    }

    
    public function getOrderCurrencyId()
    {

            return $this->order_currency_id;
    }

    
    public function getOrderStatusId()
    {

            return $this->order_status_id;
    }

    
    public function getDiscountCouponCodeId()
    {

            return $this->discount_coupon_code_id;
    }

    
    public function getHashCode()
    {

            return $this->hash_code;
    }

    
    public function getIsConfirmed()
    {

            return $this->is_confirmed;
    }

    
    public function getNumber()
    {

            return $this->number;
    }

    
    public function getDescription()
    {

            return $this->description;
    }

    
    public function getOrderType()
    {

            return $this->order_type;
    }

    
    public function getMerchantNotes()
    {

            return $this->merchant_notes;
    }

    
    public function getClientCulture()
    {

            return $this->client_culture;
    }

    
    public function getHost()
    {

            return $this->host;
    }

    
    public function getOptTotalAmount()
    {

            return null !== $this->opt_total_amount ? (string)$this->opt_total_amount : null;
    }

    
    public function getOptIsPayed()
    {

            return $this->opt_is_payed;
    }

    
    public function getOptClientName()
    {

            return $this->opt_client_name;
    }

    
    public function getOptClientEmail()
    {

            return $this->opt_client_email;
    }

    
    public function getOptOrderStatus()
    {

            return $this->opt_order_status;
    }

    
    public function getChangeStockOn()
    {

            return $this->change_stock_on;
    }

    
    public function getIfirmaProformaId()
    {

            return $this->ifirma_proforma_id;
    }

    
    public function getIfirmaInvoiceId()
    {

            return $this->ifirma_invoice_id;
    }

    
    public function getPartnerId()
    {

            return $this->partner_id;
    }

    
    public function getProvisionValue()
    {

            return $this->provision_value;
    }

    
    public function getProvisionPayed()
    {

            return $this->provision_payed;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = OrderPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = OrderPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = OrderPeer::ID;
        }

	} 
	
	public function setOrderDeliveryId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_delivery_id !== $v) {
          $this->order_delivery_id = $v;
          $this->modifiedColumns[] = OrderPeer::ORDER_DELIVERY_ID;
        }

		if ($this->aOrderDelivery !== null && $this->aOrderDelivery->getId() !== $v) {
			$this->aOrderDelivery = null;
		}

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = OrderPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setOrderUserDataDeliveryId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_user_data_delivery_id !== $v) {
          $this->order_user_data_delivery_id = $v;
          $this->modifiedColumns[] = OrderPeer::ORDER_USER_DATA_DELIVERY_ID;
        }

		if ($this->aOrderUserDataDelivery !== null && $this->aOrderUserDataDelivery->getId() !== $v) {
			$this->aOrderUserDataDelivery = null;
		}

	} 
	
	public function setOrderUserDataBillingId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_user_data_billing_id !== $v) {
          $this->order_user_data_billing_id = $v;
          $this->modifiedColumns[] = OrderPeer::ORDER_USER_DATA_BILLING_ID;
        }

		if ($this->aOrderUserDataBilling !== null && $this->aOrderUserDataBilling->getId() !== $v) {
			$this->aOrderUserDataBilling = null;
		}

	} 
	
	public function setOrderCurrencyId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_currency_id !== $v) {
          $this->order_currency_id = $v;
          $this->modifiedColumns[] = OrderPeer::ORDER_CURRENCY_ID;
        }

		if ($this->aOrderCurrency !== null && $this->aOrderCurrency->getId() !== $v) {
			$this->aOrderCurrency = null;
		}

	} 
	
	public function setOrderStatusId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_status_id !== $v) {
          $this->order_status_id = $v;
          $this->modifiedColumns[] = OrderPeer::ORDER_STATUS_ID;
        }

		if ($this->aOrderStatus !== null && $this->aOrderStatus->getId() !== $v) {
			$this->aOrderStatus = null;
		}

	} 
	
	public function setDiscountCouponCodeId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->discount_coupon_code_id !== $v) {
          $this->discount_coupon_code_id = $v;
          $this->modifiedColumns[] = OrderPeer::DISCOUNT_COUPON_CODE_ID;
        }

		if ($this->aDiscountCouponCode !== null && $this->aDiscountCouponCode->getId() !== $v) {
			$this->aDiscountCouponCode = null;
		}

	} 
	
	public function setHashCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->hash_code !== $v) {
          $this->hash_code = $v;
          $this->modifiedColumns[] = OrderPeer::HASH_CODE;
        }

	} 
	
	public function setIsConfirmed($v)
	{

        if ($this->is_confirmed !== $v || $v === false) {
          $this->is_confirmed = $v;
          $this->modifiedColumns[] = OrderPeer::IS_CONFIRMED;
        }

	} 
	
	public function setNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->number !== $v) {
          $this->number = $v;
          $this->modifiedColumns[] = OrderPeer::NUMBER;
        }

	} 
	
	public function setDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->description !== $v) {
          $this->description = $v;
          $this->modifiedColumns[] = OrderPeer::DESCRIPTION;
        }

	} 
	
	public function setOrderType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->order_type !== $v) {
          $this->order_type = $v;
          $this->modifiedColumns[] = OrderPeer::ORDER_TYPE;
        }

	} 
	
	public function setMerchantNotes($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->merchant_notes !== $v) {
          $this->merchant_notes = $v;
          $this->modifiedColumns[] = OrderPeer::MERCHANT_NOTES;
        }

	} 
	
	public function setClientCulture($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->client_culture !== $v) {
          $this->client_culture = $v;
          $this->modifiedColumns[] = OrderPeer::CLIENT_CULTURE;
        }

	} 
	
	public function setHost($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->host !== $v) {
          $this->host = $v;
          $this->modifiedColumns[] = OrderPeer::HOST;
        }

	} 
	
	public function setOptTotalAmount($v)
	{

        if ($this->opt_total_amount !== $v || $v === 0) {
          $this->opt_total_amount = $v;
          $this->modifiedColumns[] = OrderPeer::OPT_TOTAL_AMOUNT;
        }

	} 
	
	public function setOptIsPayed($v)
	{

        if ($this->opt_is_payed !== $v) {
          $this->opt_is_payed = $v;
          $this->modifiedColumns[] = OrderPeer::OPT_IS_PAYED;
        }

	} 
	
	public function setOptClientName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_client_name !== $v) {
          $this->opt_client_name = $v;
          $this->modifiedColumns[] = OrderPeer::OPT_CLIENT_NAME;
        }

	} 
	
	public function setOptClientEmail($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_client_email !== $v) {
          $this->opt_client_email = $v;
          $this->modifiedColumns[] = OrderPeer::OPT_CLIENT_EMAIL;
        }

	} 
	
	public function setOptOrderStatus($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_order_status !== $v) {
          $this->opt_order_status = $v;
          $this->modifiedColumns[] = OrderPeer::OPT_ORDER_STATUS;
        }

	} 
	
	public function setChangeStockOn($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->change_stock_on !== $v) {
          $this->change_stock_on = $v;
          $this->modifiedColumns[] = OrderPeer::CHANGE_STOCK_ON;
        }

	} 
	
	public function setIfirmaProformaId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->ifirma_proforma_id !== $v || $v === 0) {
          $this->ifirma_proforma_id = $v;
          $this->modifiedColumns[] = OrderPeer::IFIRMA_PROFORMA_ID;
        }

	} 
	
	public function setIfirmaInvoiceId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->ifirma_invoice_id !== $v || $v === 0) {
          $this->ifirma_invoice_id = $v;
          $this->modifiedColumns[] = OrderPeer::IFIRMA_INVOICE_ID;
        }

	} 
	
	public function setPartnerId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->partner_id !== $v) {
          $this->partner_id = $v;
          $this->modifiedColumns[] = OrderPeer::PARTNER_ID;
        }

		if ($this->aPartner !== null && $this->aPartner->getId() !== $v) {
			$this->aPartner = null;
		}

	} 
	
	public function setProvisionValue($v)
	{

        if ($this->provision_value !== $v) {
          $this->provision_value = $v;
          $this->modifiedColumns[] = OrderPeer::PROVISION_VALUE;
        }

	} 
	
	public function setProvisionPayed($v)
	{

        if ($this->provision_payed !== $v || $v === false) {
          $this->provision_payed = $v;
          $this->modifiedColumns[] = OrderPeer::PROVISION_PAYED;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Order.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->order_delivery_id = $rs->getInt($startcol + 3);

      $this->sf_guard_user_id = $rs->getInt($startcol + 4);

      $this->order_user_data_delivery_id = $rs->getInt($startcol + 5);

      $this->order_user_data_billing_id = $rs->getInt($startcol + 6);

      $this->order_currency_id = $rs->getInt($startcol + 7);

      $this->order_status_id = $rs->getInt($startcol + 8);

      $this->discount_coupon_code_id = $rs->getInt($startcol + 9);

      $this->hash_code = $rs->getString($startcol + 10);

      $this->is_confirmed = $rs->getBoolean($startcol + 11);

      $this->number = $rs->getString($startcol + 12);

      $this->description = $rs->getString($startcol + 13);

      $this->order_type = $rs->getString($startcol + 14);

      $this->merchant_notes = $rs->getString($startcol + 15);

      $this->client_culture = $rs->getString($startcol + 16);

      $this->host = $rs->getString($startcol + 17);

      $this->opt_total_amount = $rs->getString($startcol + 18, null);

      $this->opt_total_amount = $rs->getFloat($startcol + 18);

      $this->opt_is_payed = $rs->getBoolean($startcol + 19);

      $this->opt_client_name = $rs->getString($startcol + 20);

      $this->opt_client_email = $rs->getString($startcol + 21);

      $this->opt_order_status = $rs->getString($startcol + 22);

      $this->change_stock_on = $rs->getString($startcol + 23);

      $this->ifirma_proforma_id = $rs->getInt($startcol + 24);

      $this->ifirma_invoice_id = $rs->getInt($startcol + 25);

      $this->partner_id = $rs->getInt($startcol + 26);

      $this->provision_value = $rs->getFloat($startcol + 27);

      $this->provision_payed = $rs->getBoolean($startcol + 28);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Order.postHydrate', array('resultset' => $rs, 'startcol' => 29)));

            return $startcol + 29; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Order object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseOrder:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			OrderPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseOrder:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Order.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseOrder:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(OrderPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(OrderPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Order.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseOrder:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aOrderDelivery !== null) {
				if ($this->aOrderDelivery->isModified()) {
					$affectedRows += $this->aOrderDelivery->save($con);
				}
				$this->setOrderDelivery($this->aOrderDelivery);
			}

			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}

			if ($this->aOrderUserDataDelivery !== null) {
				if ($this->aOrderUserDataDelivery->isModified()) {
					$affectedRows += $this->aOrderUserDataDelivery->save($con);
				}
				$this->setOrderUserDataDelivery($this->aOrderUserDataDelivery);
			}

			if ($this->aOrderUserDataBilling !== null) {
				if ($this->aOrderUserDataBilling->isModified()) {
					$affectedRows += $this->aOrderUserDataBilling->save($con);
				}
				$this->setOrderUserDataBilling($this->aOrderUserDataBilling);
			}

			if ($this->aOrderCurrency !== null) {
				if ($this->aOrderCurrency->isModified()) {
					$affectedRows += $this->aOrderCurrency->save($con);
				}
				$this->setOrderCurrency($this->aOrderCurrency);
			}

			if ($this->aOrderStatus !== null) {
				if ($this->aOrderStatus->isModified() || $this->aOrderStatus->getCurrentOrderStatusI18n()->isModified()) {
					$affectedRows += $this->aOrderStatus->save($con);
				}
				$this->setOrderStatus($this->aOrderStatus);
			}

			if ($this->aDiscountCouponCode !== null) {
				if ($this->aDiscountCouponCode->isModified()) {
					$affectedRows += $this->aDiscountCouponCode->save($con);
				}
				$this->setDiscountCouponCode($this->aDiscountCouponCode);
			}

			if ($this->aPartner !== null) {
				if ($this->aPartner->isModified()) {
					$affectedRows += $this->aPartner->save($con);
				}
				$this->setPartner($this->aPartner);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = OrderPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += OrderPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collTrustedShopsHasOrders !== null) {
				foreach($this->collTrustedShopsHasOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderHasPayments !== null) {
				foreach($this->collOrderHasPayments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderProducts !== null) {
				foreach($this->collOrderProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collInvoices !== null) {
				foreach($this->collInvoices as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collReviews !== null) {
				foreach($this->collReviews as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collReviewOrders !== null) {
				foreach($this->collReviewOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aOrderDelivery !== null) {
				if (!$this->aOrderDelivery->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrderDelivery->getValidationFailures());
				}
			}

			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}

			if ($this->aOrderUserDataDelivery !== null) {
				if (!$this->aOrderUserDataDelivery->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrderUserDataDelivery->getValidationFailures());
				}
			}

			if ($this->aOrderUserDataBilling !== null) {
				if (!$this->aOrderUserDataBilling->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrderUserDataBilling->getValidationFailures());
				}
			}

			if ($this->aOrderCurrency !== null) {
				if (!$this->aOrderCurrency->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrderCurrency->getValidationFailures());
				}
			}

			if ($this->aOrderStatus !== null) {
				if (!$this->aOrderStatus->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrderStatus->getValidationFailures());
				}
			}

			if ($this->aDiscountCouponCode !== null) {
				if (!$this->aDiscountCouponCode->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aDiscountCouponCode->getValidationFailures());
				}
			}

			if ($this->aPartner !== null) {
				if (!$this->aPartner->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aPartner->getValidationFailures());
				}
			}


			if (($retval = OrderPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collTrustedShopsHasOrders !== null) {
					foreach($this->collTrustedShopsHasOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderHasPayments !== null) {
					foreach($this->collOrderHasPayments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderProducts !== null) {
					foreach($this->collOrderProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collInvoices !== null) {
					foreach($this->collInvoices as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collReviews !== null) {
					foreach($this->collReviews as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collReviewOrders !== null) {
					foreach($this->collReviewOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOrderDeliveryId();
				break;
			case 4:
				return $this->getSfGuardUserId();
				break;
			case 5:
				return $this->getOrderUserDataDeliveryId();
				break;
			case 6:
				return $this->getOrderUserDataBillingId();
				break;
			case 7:
				return $this->getOrderCurrencyId();
				break;
			case 8:
				return $this->getOrderStatusId();
				break;
			case 9:
				return $this->getDiscountCouponCodeId();
				break;
			case 10:
				return $this->getHashCode();
				break;
			case 11:
				return $this->getIsConfirmed();
				break;
			case 12:
				return $this->getNumber();
				break;
			case 13:
				return $this->getDescription();
				break;
			case 14:
				return $this->getOrderType();
				break;
			case 15:
				return $this->getMerchantNotes();
				break;
			case 16:
				return $this->getClientCulture();
				break;
			case 17:
				return $this->getHost();
				break;
			case 18:
				return $this->getOptTotalAmount();
				break;
			case 19:
				return $this->getOptIsPayed();
				break;
			case 20:
				return $this->getOptClientName();
				break;
			case 21:
				return $this->getOptClientEmail();
				break;
			case 22:
				return $this->getOptOrderStatus();
				break;
			case 23:
				return $this->getChangeStockOn();
				break;
			case 24:
				return $this->getIfirmaProformaId();
				break;
			case 25:
				return $this->getIfirmaInvoiceId();
				break;
			case 26:
				return $this->getPartnerId();
				break;
			case 27:
				return $this->getProvisionValue();
				break;
			case 28:
				return $this->getProvisionPayed();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOrderDeliveryId(),
			$keys[4] => $this->getSfGuardUserId(),
			$keys[5] => $this->getOrderUserDataDeliveryId(),
			$keys[6] => $this->getOrderUserDataBillingId(),
			$keys[7] => $this->getOrderCurrencyId(),
			$keys[8] => $this->getOrderStatusId(),
			$keys[9] => $this->getDiscountCouponCodeId(),
			$keys[10] => $this->getHashCode(),
			$keys[11] => $this->getIsConfirmed(),
			$keys[12] => $this->getNumber(),
			$keys[13] => $this->getDescription(),
			$keys[14] => $this->getOrderType(),
			$keys[15] => $this->getMerchantNotes(),
			$keys[16] => $this->getClientCulture(),
			$keys[17] => $this->getHost(),
			$keys[18] => $this->getOptTotalAmount(),
			$keys[19] => $this->getOptIsPayed(),
			$keys[20] => $this->getOptClientName(),
			$keys[21] => $this->getOptClientEmail(),
			$keys[22] => $this->getOptOrderStatus(),
			$keys[23] => $this->getChangeStockOn(),
			$keys[24] => $this->getIfirmaProformaId(),
			$keys[25] => $this->getIfirmaInvoiceId(),
			$keys[26] => $this->getPartnerId(),
			$keys[27] => $this->getProvisionValue(),
			$keys[28] => $this->getProvisionPayed(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOrderDeliveryId($value);
				break;
			case 4:
				$this->setSfGuardUserId($value);
				break;
			case 5:
				$this->setOrderUserDataDeliveryId($value);
				break;
			case 6:
				$this->setOrderUserDataBillingId($value);
				break;
			case 7:
				$this->setOrderCurrencyId($value);
				break;
			case 8:
				$this->setOrderStatusId($value);
				break;
			case 9:
				$this->setDiscountCouponCodeId($value);
				break;
			case 10:
				$this->setHashCode($value);
				break;
			case 11:
				$this->setIsConfirmed($value);
				break;
			case 12:
				$this->setNumber($value);
				break;
			case 13:
				$this->setDescription($value);
				break;
			case 14:
				$this->setOrderType($value);
				break;
			case 15:
				$this->setMerchantNotes($value);
				break;
			case 16:
				$this->setClientCulture($value);
				break;
			case 17:
				$this->setHost($value);
				break;
			case 18:
				$this->setOptTotalAmount($value);
				break;
			case 19:
				$this->setOptIsPayed($value);
				break;
			case 20:
				$this->setOptClientName($value);
				break;
			case 21:
				$this->setOptClientEmail($value);
				break;
			case 22:
				$this->setOptOrderStatus($value);
				break;
			case 23:
				$this->setChangeStockOn($value);
				break;
			case 24:
				$this->setIfirmaProformaId($value);
				break;
			case 25:
				$this->setIfirmaInvoiceId($value);
				break;
			case 26:
				$this->setPartnerId($value);
				break;
			case 27:
				$this->setProvisionValue($value);
				break;
			case 28:
				$this->setProvisionPayed($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOrderDeliveryId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSfGuardUserId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOrderUserDataDeliveryId($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOrderUserDataBillingId($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOrderCurrencyId($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOrderStatusId($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setDiscountCouponCodeId($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setHashCode($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setIsConfirmed($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setNumber($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setDescription($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setOrderType($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setMerchantNotes($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setClientCulture($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setHost($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setOptTotalAmount($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setOptIsPayed($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setOptClientName($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setOptClientEmail($arr[$keys[21]]);
		if (array_key_exists($keys[22], $arr)) $this->setOptOrderStatus($arr[$keys[22]]);
		if (array_key_exists($keys[23], $arr)) $this->setChangeStockOn($arr[$keys[23]]);
		if (array_key_exists($keys[24], $arr)) $this->setIfirmaProformaId($arr[$keys[24]]);
		if (array_key_exists($keys[25], $arr)) $this->setIfirmaInvoiceId($arr[$keys[25]]);
		if (array_key_exists($keys[26], $arr)) $this->setPartnerId($arr[$keys[26]]);
		if (array_key_exists($keys[27], $arr)) $this->setProvisionValue($arr[$keys[27]]);
		if (array_key_exists($keys[28], $arr)) $this->setProvisionPayed($arr[$keys[28]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(OrderPeer::DATABASE_NAME);

		if ($this->isColumnModified(OrderPeer::CREATED_AT)) $criteria->add(OrderPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(OrderPeer::UPDATED_AT)) $criteria->add(OrderPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(OrderPeer::ID)) $criteria->add(OrderPeer::ID, $this->id);
		if ($this->isColumnModified(OrderPeer::ORDER_DELIVERY_ID)) $criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->order_delivery_id);
		if ($this->isColumnModified(OrderPeer::SF_GUARD_USER_ID)) $criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(OrderPeer::ORDER_USER_DATA_DELIVERY_ID)) $criteria->add(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, $this->order_user_data_delivery_id);
		if ($this->isColumnModified(OrderPeer::ORDER_USER_DATA_BILLING_ID)) $criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->order_user_data_billing_id);
		if ($this->isColumnModified(OrderPeer::ORDER_CURRENCY_ID)) $criteria->add(OrderPeer::ORDER_CURRENCY_ID, $this->order_currency_id);
		if ($this->isColumnModified(OrderPeer::ORDER_STATUS_ID)) $criteria->add(OrderPeer::ORDER_STATUS_ID, $this->order_status_id);
		if ($this->isColumnModified(OrderPeer::DISCOUNT_COUPON_CODE_ID)) $criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->discount_coupon_code_id);
		if ($this->isColumnModified(OrderPeer::HASH_CODE)) $criteria->add(OrderPeer::HASH_CODE, $this->hash_code);
		if ($this->isColumnModified(OrderPeer::IS_CONFIRMED)) $criteria->add(OrderPeer::IS_CONFIRMED, $this->is_confirmed);
		if ($this->isColumnModified(OrderPeer::NUMBER)) $criteria->add(OrderPeer::NUMBER, $this->number);
		if ($this->isColumnModified(OrderPeer::DESCRIPTION)) $criteria->add(OrderPeer::DESCRIPTION, $this->description);
		if ($this->isColumnModified(OrderPeer::ORDER_TYPE)) $criteria->add(OrderPeer::ORDER_TYPE, $this->order_type);
		if ($this->isColumnModified(OrderPeer::MERCHANT_NOTES)) $criteria->add(OrderPeer::MERCHANT_NOTES, $this->merchant_notes);
		if ($this->isColumnModified(OrderPeer::CLIENT_CULTURE)) $criteria->add(OrderPeer::CLIENT_CULTURE, $this->client_culture);
		if ($this->isColumnModified(OrderPeer::HOST)) $criteria->add(OrderPeer::HOST, $this->host);
		if ($this->isColumnModified(OrderPeer::OPT_TOTAL_AMOUNT)) $criteria->add(OrderPeer::OPT_TOTAL_AMOUNT, $this->opt_total_amount);
		if ($this->isColumnModified(OrderPeer::OPT_IS_PAYED)) $criteria->add(OrderPeer::OPT_IS_PAYED, $this->opt_is_payed);
		if ($this->isColumnModified(OrderPeer::OPT_CLIENT_NAME)) $criteria->add(OrderPeer::OPT_CLIENT_NAME, $this->opt_client_name);
		if ($this->isColumnModified(OrderPeer::OPT_CLIENT_EMAIL)) $criteria->add(OrderPeer::OPT_CLIENT_EMAIL, $this->opt_client_email);
		if ($this->isColumnModified(OrderPeer::OPT_ORDER_STATUS)) $criteria->add(OrderPeer::OPT_ORDER_STATUS, $this->opt_order_status);
		if ($this->isColumnModified(OrderPeer::CHANGE_STOCK_ON)) $criteria->add(OrderPeer::CHANGE_STOCK_ON, $this->change_stock_on);
		if ($this->isColumnModified(OrderPeer::IFIRMA_PROFORMA_ID)) $criteria->add(OrderPeer::IFIRMA_PROFORMA_ID, $this->ifirma_proforma_id);
		if ($this->isColumnModified(OrderPeer::IFIRMA_INVOICE_ID)) $criteria->add(OrderPeer::IFIRMA_INVOICE_ID, $this->ifirma_invoice_id);
		if ($this->isColumnModified(OrderPeer::PARTNER_ID)) $criteria->add(OrderPeer::PARTNER_ID, $this->partner_id);
		if ($this->isColumnModified(OrderPeer::PROVISION_VALUE)) $criteria->add(OrderPeer::PROVISION_VALUE, $this->provision_value);
		if ($this->isColumnModified(OrderPeer::PROVISION_PAYED)) $criteria->add(OrderPeer::PROVISION_PAYED, $this->provision_payed);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(OrderPeer::DATABASE_NAME);

		$criteria->add(OrderPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOrderDeliveryId($this->order_delivery_id);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setOrderUserDataDeliveryId($this->order_user_data_delivery_id);

		$copyObj->setOrderUserDataBillingId($this->order_user_data_billing_id);

		$copyObj->setOrderCurrencyId($this->order_currency_id);

		$copyObj->setOrderStatusId($this->order_status_id);

		$copyObj->setDiscountCouponCodeId($this->discount_coupon_code_id);

		$copyObj->setHashCode($this->hash_code);

		$copyObj->setIsConfirmed($this->is_confirmed);

		$copyObj->setNumber($this->number);

		$copyObj->setDescription($this->description);

		$copyObj->setOrderType($this->order_type);

		$copyObj->setMerchantNotes($this->merchant_notes);

		$copyObj->setClientCulture($this->client_culture);

		$copyObj->setHost($this->host);

		$copyObj->setOptTotalAmount($this->opt_total_amount);

		$copyObj->setOptIsPayed($this->opt_is_payed);

		$copyObj->setOptClientName($this->opt_client_name);

		$copyObj->setOptClientEmail($this->opt_client_email);

		$copyObj->setOptOrderStatus($this->opt_order_status);

		$copyObj->setChangeStockOn($this->change_stock_on);

		$copyObj->setIfirmaProformaId($this->ifirma_proforma_id);

		$copyObj->setIfirmaInvoiceId($this->ifirma_invoice_id);

		$copyObj->setPartnerId($this->partner_id);

		$copyObj->setProvisionValue($this->provision_value);

		$copyObj->setProvisionPayed($this->provision_payed);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getTrustedShopsHasOrders() as $relObj) {
				$copyObj->addTrustedShopsHasOrder($relObj->copy($deepCopy));
			}

			foreach($this->getOrderHasPayments() as $relObj) {
				$copyObj->addOrderHasPayment($relObj->copy($deepCopy));
			}

			foreach($this->getOrderProducts() as $relObj) {
				$copyObj->addOrderProduct($relObj->copy($deepCopy));
			}

			foreach($this->getInvoices() as $relObj) {
				$copyObj->addInvoice($relObj->copy($deepCopy));
			}

			foreach($this->getReviews() as $relObj) {
				$copyObj->addReview($relObj->copy($deepCopy));
			}

			foreach($this->getReviewOrders() as $relObj) {
				$copyObj->addReviewOrder($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new OrderPeer();
		}
		return self::$peer;
	}

	
	public function setOrderDelivery($v)
	{


		if ($v === null) {
			$this->setOrderDeliveryId(NULL);
		} else {
			$this->setOrderDeliveryId($v->getId());
		}


		$this->aOrderDelivery = $v;
	}


	
	public function getOrderDelivery($con = null)
	{
		if ($this->aOrderDelivery === null && ($this->order_delivery_id !== null)) {
						$this->aOrderDelivery = OrderDeliveryPeer::retrieveByPK($this->order_delivery_id, $con);

			
		}
		return $this->aOrderDelivery;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function setOrderUserDataDelivery($v)
	{


		if ($v === null) {
			$this->setOrderUserDataDeliveryId(NULL);
		} else {
			$this->setOrderUserDataDeliveryId($v->getId());
		}


		$this->aOrderUserDataDelivery = $v;
	}


	
	public function getOrderUserDataDelivery($con = null)
	{
		if ($this->aOrderUserDataDelivery === null && ($this->order_user_data_delivery_id !== null)) {
						$this->aOrderUserDataDelivery = OrderUserDataDeliveryPeer::retrieveByPK($this->order_user_data_delivery_id, $con);

			
		}
		return $this->aOrderUserDataDelivery;
	}

	
	public function setOrderUserDataBilling($v)
	{


		if ($v === null) {
			$this->setOrderUserDataBillingId(NULL);
		} else {
			$this->setOrderUserDataBillingId($v->getId());
		}


		$this->aOrderUserDataBilling = $v;
	}


	
	public function getOrderUserDataBilling($con = null)
	{
		if ($this->aOrderUserDataBilling === null && ($this->order_user_data_billing_id !== null)) {
						$this->aOrderUserDataBilling = OrderUserDataBillingPeer::retrieveByPK($this->order_user_data_billing_id, $con);

			
		}
		return $this->aOrderUserDataBilling;
	}

	
	public function setOrderCurrency($v)
	{


		if ($v === null) {
			$this->setOrderCurrencyId(NULL);
		} else {
			$this->setOrderCurrencyId($v->getId());
		}


		$this->aOrderCurrency = $v;
	}


	
	public function getOrderCurrency($con = null)
	{
		if ($this->aOrderCurrency === null && ($this->order_currency_id !== null)) {
						$this->aOrderCurrency = OrderCurrencyPeer::retrieveByPK($this->order_currency_id, $con);

			
		}
		return $this->aOrderCurrency;
	}

	
	public function setOrderStatus($v)
	{


		if ($v === null) {
			$this->setOrderStatusId(NULL);
		} else {
			$this->setOrderStatusId($v->getId());
		}


		$this->aOrderStatus = $v;
	}


	
	public function getOrderStatus($con = null)
	{
		if ($this->aOrderStatus === null && ($this->order_status_id !== null)) {
						$this->aOrderStatus = OrderStatusPeer::retrieveByPK($this->order_status_id, $con);

			
		}
		return $this->aOrderStatus;
	}

	
	public function setDiscountCouponCode($v)
	{


		if ($v === null) {
			$this->setDiscountCouponCodeId(NULL);
		} else {
			$this->setDiscountCouponCodeId($v->getId());
		}


		$this->aDiscountCouponCode = $v;
	}


	
	public function getDiscountCouponCode($con = null)
	{
		if ($this->aDiscountCouponCode === null && ($this->discount_coupon_code_id !== null)) {
						$this->aDiscountCouponCode = DiscountCouponCodePeer::retrieveByPK($this->discount_coupon_code_id, $con);

			
		}
		return $this->aDiscountCouponCode;
	}

	
	public function setPartner($v)
	{


		if ($v === null) {
			$this->setPartnerId(NULL);
		} else {
			$this->setPartnerId($v->getId());
		}


		$this->aPartner = $v;
	}


	
	public function getPartner($con = null)
	{
		if ($this->aPartner === null && ($this->partner_id !== null)) {
						$this->aPartner = PartnerPeer::retrieveByPK($this->partner_id, $con);

			
		}
		return $this->aPartner;
	}

	
	public function initTrustedShopsHasOrders()
	{
		if ($this->collTrustedShopsHasOrders === null) {
			$this->collTrustedShopsHasOrders = array();
		}
	}

	
	public function getTrustedShopsHasOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasOrders === null) {
			if ($this->isNew()) {
			   $this->collTrustedShopsHasOrders = array();
			} else {

				$criteria->add(TrustedShopsHasOrderPeer::ORDER_ID, $this->getId());

				TrustedShopsHasOrderPeer::addSelectColumns($criteria);
				$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(TrustedShopsHasOrderPeer::ORDER_ID, $this->getId());

				TrustedShopsHasOrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastTrustedShopsHasOrderCriteria) || !$this->lastTrustedShopsHasOrderCriteria->equals($criteria)) {
					$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTrustedShopsHasOrderCriteria = $criteria;
		return $this->collTrustedShopsHasOrders;
	}

	
	public function countTrustedShopsHasOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TrustedShopsHasOrderPeer::ORDER_ID, $this->getId());

		return TrustedShopsHasOrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addTrustedShopsHasOrder(TrustedShopsHasOrder $l)
	{
		$this->collTrustedShopsHasOrders[] = $l;
		$l->setOrder($this);
	}


	
	public function getTrustedShopsHasOrdersJoinTrustedShops($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasOrders === null) {
			if ($this->isNew()) {
				$this->collTrustedShopsHasOrders = array();
			} else {

				$criteria->add(TrustedShopsHasOrderPeer::ORDER_ID, $this->getId());

				$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelectJoinTrustedShops($criteria, $con);
			}
		} else {
									
			$criteria->add(TrustedShopsHasOrderPeer::ORDER_ID, $this->getId());

			if (!isset($this->lastTrustedShopsHasOrderCriteria) || !$this->lastTrustedShopsHasOrderCriteria->equals($criteria)) {
				$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelectJoinTrustedShops($criteria, $con);
			}
		}
		$this->lastTrustedShopsHasOrderCriteria = $criteria;

		return $this->collTrustedShopsHasOrders;
	}

	
	public function initOrderHasPayments()
	{
		if ($this->collOrderHasPayments === null) {
			$this->collOrderHasPayments = array();
		}
	}

	
	public function getOrderHasPayments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderHasPayments === null) {
			if ($this->isNew()) {
			   $this->collOrderHasPayments = array();
			} else {

				$criteria->add(OrderHasPaymentPeer::ORDER_ID, $this->getId());

				OrderHasPaymentPeer::addSelectColumns($criteria);
				$this->collOrderHasPayments = OrderHasPaymentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderHasPaymentPeer::ORDER_ID, $this->getId());

				OrderHasPaymentPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderHasPaymentCriteria) || !$this->lastOrderHasPaymentCriteria->equals($criteria)) {
					$this->collOrderHasPayments = OrderHasPaymentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderHasPaymentCriteria = $criteria;
		return $this->collOrderHasPayments;
	}

	
	public function countOrderHasPayments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderHasPaymentPeer::ORDER_ID, $this->getId());

		return OrderHasPaymentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderHasPayment(OrderHasPayment $l)
	{
		$this->collOrderHasPayments[] = $l;
		$l->setOrder($this);
	}


	
	public function getOrderHasPaymentsJoinPayment($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderHasPayments === null) {
			if ($this->isNew()) {
				$this->collOrderHasPayments = array();
			} else {

				$criteria->add(OrderHasPaymentPeer::ORDER_ID, $this->getId());

				$this->collOrderHasPayments = OrderHasPaymentPeer::doSelectJoinPayment($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderHasPaymentPeer::ORDER_ID, $this->getId());

			if (!isset($this->lastOrderHasPaymentCriteria) || !$this->lastOrderHasPaymentCriteria->equals($criteria)) {
				$this->collOrderHasPayments = OrderHasPaymentPeer::doSelectJoinPayment($criteria, $con);
			}
		}
		$this->lastOrderHasPaymentCriteria = $criteria;

		return $this->collOrderHasPayments;
	}

	
	public function initOrderProducts()
	{
		if ($this->collOrderProducts === null) {
			$this->collOrderProducts = array();
		}
	}

	
	public function getOrderProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
			   $this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::ORDER_ID, $this->getId());

				OrderProductPeer::addSelectColumns($criteria);
				$this->collOrderProducts = OrderProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderProductPeer::ORDER_ID, $this->getId());

				OrderProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
					$this->collOrderProducts = OrderProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderProductCriteria = $criteria;
		return $this->collOrderProducts;
	}

	
	public function countOrderProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderProductPeer::ORDER_ID, $this->getId());

		return OrderProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderProduct(OrderProduct $l)
	{
		$this->collOrderProducts[] = $l;
		$l->setOrder($this);
	}


	
	public function getOrderProductsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
				$this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::ORDER_ID, $this->getId());

				$this->collOrderProducts = OrderProductPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderProductPeer::ORDER_ID, $this->getId());

			if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
				$this->collOrderProducts = OrderProductPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastOrderProductCriteria = $criteria;

		return $this->collOrderProducts;
	}


	
	public function getOrderProductsJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
				$this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::ORDER_ID, $this->getId());

				$this->collOrderProducts = OrderProductPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderProductPeer::ORDER_ID, $this->getId());

			if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
				$this->collOrderProducts = OrderProductPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastOrderProductCriteria = $criteria;

		return $this->collOrderProducts;
	}

	
	public function initInvoices()
	{
		if ($this->collInvoices === null) {
			$this->collInvoices = array();
		}
	}

	
	public function getInvoices($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
			   $this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

				InvoicePeer::addSelectColumns($criteria);
				$this->collInvoices = InvoicePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

				InvoicePeer::addSelectColumns($criteria);
				if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
					$this->collInvoices = InvoicePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastInvoiceCriteria = $criteria;
		return $this->collInvoices;
	}

	
	public function countInvoices($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

		return InvoicePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addInvoice(Invoice $l)
	{
		$this->collInvoices[] = $l;
		$l->setOrder($this);
	}


	
	public function getInvoicesJoinInvoiceUserSeller($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
				$this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceUserSeller($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

			if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceUserSeller($criteria, $con);
			}
		}
		$this->lastInvoiceCriteria = $criteria;

		return $this->collInvoices;
	}


	
	public function getInvoicesJoinInvoiceUserCustomer($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
				$this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceUserCustomer($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

			if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceUserCustomer($criteria, $con);
			}
		}
		$this->lastInvoiceCriteria = $criteria;

		return $this->collInvoices;
	}


	
	public function getInvoicesJoinInvoiceCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoices === null) {
			if ($this->isNew()) {
				$this->collInvoices = array();
			} else {

				$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoicePeer::ORDER_ID, $this->getId());

			if (!isset($this->lastInvoiceCriteria) || !$this->lastInvoiceCriteria->equals($criteria)) {
				$this->collInvoices = InvoicePeer::doSelectJoinInvoiceCurrency($criteria, $con);
			}
		}
		$this->lastInvoiceCriteria = $criteria;

		return $this->collInvoices;
	}

	
	public function initReviews()
	{
		if ($this->collReviews === null) {
			$this->collReviews = array();
		}
	}

	
	public function getReviews($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
			   $this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::ORDER_ID, $this->getId());

				ReviewPeer::addSelectColumns($criteria);
				$this->collReviews = ReviewPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ReviewPeer::ORDER_ID, $this->getId());

				ReviewPeer::addSelectColumns($criteria);
				if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
					$this->collReviews = ReviewPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastReviewCriteria = $criteria;
		return $this->collReviews;
	}

	
	public function countReviews($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ReviewPeer::ORDER_ID, $this->getId());

		return ReviewPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addReview(Review $l)
	{
		$this->collReviews[] = $l;
		$l->setOrder($this);
	}


	
	public function getReviewsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
				$this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::ORDER_ID, $this->getId());

				$this->collReviews = ReviewPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewPeer::ORDER_ID, $this->getId());

			if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
				$this->collReviews = ReviewPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastReviewCriteria = $criteria;

		return $this->collReviews;
	}


	
	public function getReviewsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
				$this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::ORDER_ID, $this->getId());

				$this->collReviews = ReviewPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewPeer::ORDER_ID, $this->getId());

			if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
				$this->collReviews = ReviewPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastReviewCriteria = $criteria;

		return $this->collReviews;
	}

	
	public function initReviewOrders()
	{
		if ($this->collReviewOrders === null) {
			$this->collReviewOrders = array();
		}
	}

	
	public function getReviewOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviewOrders === null) {
			if ($this->isNew()) {
			   $this->collReviewOrders = array();
			} else {

				$criteria->add(ReviewOrderPeer::ORDER_ID, $this->getId());

				ReviewOrderPeer::addSelectColumns($criteria);
				$this->collReviewOrders = ReviewOrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ReviewOrderPeer::ORDER_ID, $this->getId());

				ReviewOrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastReviewOrderCriteria) || !$this->lastReviewOrderCriteria->equals($criteria)) {
					$this->collReviewOrders = ReviewOrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastReviewOrderCriteria = $criteria;
		return $this->collReviewOrders;
	}

	
	public function countReviewOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ReviewOrderPeer::ORDER_ID, $this->getId());

		return ReviewOrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addReviewOrder(ReviewOrder $l)
	{
		$this->collReviewOrders[] = $l;
		$l->setOrder($this);
	}


	
	public function getReviewOrdersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviewOrders === null) {
			if ($this->isNew()) {
				$this->collReviewOrders = array();
			} else {

				$criteria->add(ReviewOrderPeer::ORDER_ID, $this->getId());

				$this->collReviewOrders = ReviewOrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewOrderPeer::ORDER_ID, $this->getId());

			if (!isset($this->lastReviewOrderCriteria) || !$this->lastReviewOrderCriteria->equals($criteria)) {
				$this->collReviewOrders = ReviewOrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastReviewOrderCriteria = $criteria;

		return $this->collReviewOrders;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Order.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseOrder:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseOrder::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 