<?php


abstract class BaseOrderDelivery extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $tax_id;


	
	protected $delivery_id;


	
	protected $name;


	
	protected $cost;


	
	protected $payment_cost;


	
	protected $opt_tax;


	
	protected $number;


	
	protected $cost_brutto;


	
	protected $payment_cost_brutto;


	
	protected $custom_cost_brutto;


	
	protected $delivery_date;

	
	protected $aTax;

	
	protected $aDelivery;

	
	protected $collOrders;

	
	protected $lastOrderCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getTaxId()
    {

            return $this->tax_id;
    }

    
    public function getDeliveryId()
    {

            return $this->delivery_id;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getCost()
    {

            return null !== $this->cost ? (string)$this->cost : null;
    }

    
    public function getPaymentCost()
    {

            return null !== $this->payment_cost ? (string)$this->payment_cost : null;
    }

    
    public function getOptTax()
    {

            return null !== $this->opt_tax ? (string)$this->opt_tax : null;
    }

    
    public function getNumber()
    {

            return $this->number;
    }

    
    public function getCostBrutto()
    {

            return null !== $this->cost_brutto ? (string)$this->cost_brutto : null;
    }

    
    public function getPaymentCostBrutto()
    {

            return null !== $this->payment_cost_brutto ? (string)$this->payment_cost_brutto : null;
    }

    
    public function getCustomCostBrutto()
    {

            return null !== $this->custom_cost_brutto ? (string)$this->custom_cost_brutto : null;
    }

	
	public function getDeliveryDate($format = 'Y-m-d H:i:s')
	{

		if ($this->delivery_date === null || $this->delivery_date === '') {
			return null;
		} elseif (!is_int($this->delivery_date)) {
						$ts = strtotime($this->delivery_date);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [delivery_date] as date/time value: " . var_export($this->delivery_date, true));
			}
		} else {
			$ts = $this->delivery_date;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = OrderDeliveryPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = OrderDeliveryPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::ID;
        }

	} 
	
	public function setTaxId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->tax_id !== $v) {
          $this->tax_id = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::TAX_ID;
        }

		if ($this->aTax !== null && $this->aTax->getId() !== $v) {
			$this->aTax = null;
		}

	} 
	
	public function setDeliveryId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->delivery_id !== $v) {
          $this->delivery_id = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::DELIVERY_ID;
        }

		if ($this->aDelivery !== null && $this->aDelivery->getId() !== $v) {
			$this->aDelivery = null;
		}

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::NAME;
        }

	} 
	
	public function setCost($v)
	{

        if ($this->cost !== $v) {
          $this->cost = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::COST;
        }

	} 
	
	public function setPaymentCost($v)
	{

        if ($this->payment_cost !== $v) {
          $this->payment_cost = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::PAYMENT_COST;
        }

	} 
	
	public function setOptTax($v)
	{

        if ($this->opt_tax !== $v) {
          $this->opt_tax = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::OPT_TAX;
        }

	} 
	
	public function setNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->number !== $v) {
          $this->number = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::NUMBER;
        }

	} 
	
	public function setCostBrutto($v)
	{

        if ($this->cost_brutto !== $v) {
          $this->cost_brutto = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::COST_BRUTTO;
        }

	} 
	
	public function setPaymentCostBrutto($v)
	{

        if ($this->payment_cost_brutto !== $v) {
          $this->payment_cost_brutto = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::PAYMENT_COST_BRUTTO;
        }

	} 
	
	public function setCustomCostBrutto($v)
	{

        if ($this->custom_cost_brutto !== $v) {
          $this->custom_cost_brutto = $v;
          $this->modifiedColumns[] = OrderDeliveryPeer::CUSTOM_COST_BRUTTO;
        }

	} 
	
	public function setDeliveryDate($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [delivery_date] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->delivery_date !== $ts) {
			$this->delivery_date = $ts;
			$this->modifiedColumns[] = OrderDeliveryPeer::DELIVERY_DATE;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'OrderDelivery.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->tax_id = $rs->getInt($startcol + 3);

      $this->delivery_id = $rs->getInt($startcol + 4);

      $this->name = $rs->getString($startcol + 5);

      $this->cost = $rs->getString($startcol + 6, null);

      $this->cost = $rs->getFloat($startcol + 6);

      $this->payment_cost = $rs->getString($startcol + 7, null);

      $this->payment_cost = $rs->getFloat($startcol + 7);

      $this->opt_tax = $rs->getString($startcol + 8, null);

      $this->opt_tax = $rs->getFloat($startcol + 8);

      $this->number = $rs->getString($startcol + 9);

      $this->cost_brutto = $rs->getString($startcol + 10, null);

      $this->cost_brutto = $rs->getFloat($startcol + 10);

      $this->payment_cost_brutto = $rs->getString($startcol + 11, null);

      $this->payment_cost_brutto = $rs->getFloat($startcol + 11);

      $this->custom_cost_brutto = $rs->getString($startcol + 12, null);

      $this->custom_cost_brutto = $rs->getFloat($startcol + 12);

      $this->delivery_date = $rs->getTimestamp($startcol + 13, null);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'OrderDelivery.postHydrate', array('resultset' => $rs, 'startcol' => 14)));

            return $startcol + 14; 
    } catch (Exception $e) {
      throw new PropelException("Error populating OrderDelivery object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderDelivery:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderDeliveryPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			OrderDeliveryPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseOrderDelivery:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderDelivery.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseOrderDelivery:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(OrderDeliveryPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(OrderDeliveryPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderDeliveryPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderDelivery.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseOrderDelivery:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aTax !== null) {
				if ($this->aTax->isModified()) {
					$affectedRows += $this->aTax->save($con);
				}
				$this->setTax($this->aTax);
			}

			if ($this->aDelivery !== null) {
				if ($this->aDelivery->isModified() || $this->aDelivery->getCurrentDeliveryI18n()->isModified()) {
					$affectedRows += $this->aDelivery->save($con);
				}
				$this->setDelivery($this->aDelivery);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = OrderDeliveryPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += OrderDeliveryPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collOrders !== null) {
				foreach($this->collOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aTax !== null) {
				if (!$this->aTax->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTax->getValidationFailures());
				}
			}

			if ($this->aDelivery !== null) {
				if (!$this->aDelivery->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aDelivery->getValidationFailures());
				}
			}


			if (($retval = OrderDeliveryPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collOrders !== null) {
					foreach($this->collOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderDeliveryPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getTaxId();
				break;
			case 4:
				return $this->getDeliveryId();
				break;
			case 5:
				return $this->getName();
				break;
			case 6:
				return $this->getCost();
				break;
			case 7:
				return $this->getPaymentCost();
				break;
			case 8:
				return $this->getOptTax();
				break;
			case 9:
				return $this->getNumber();
				break;
			case 10:
				return $this->getCostBrutto();
				break;
			case 11:
				return $this->getPaymentCostBrutto();
				break;
			case 12:
				return $this->getCustomCostBrutto();
				break;
			case 13:
				return $this->getDeliveryDate();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderDeliveryPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getTaxId(),
			$keys[4] => $this->getDeliveryId(),
			$keys[5] => $this->getName(),
			$keys[6] => $this->getCost(),
			$keys[7] => $this->getPaymentCost(),
			$keys[8] => $this->getOptTax(),
			$keys[9] => $this->getNumber(),
			$keys[10] => $this->getCostBrutto(),
			$keys[11] => $this->getPaymentCostBrutto(),
			$keys[12] => $this->getCustomCostBrutto(),
			$keys[13] => $this->getDeliveryDate(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderDeliveryPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setTaxId($value);
				break;
			case 4:
				$this->setDeliveryId($value);
				break;
			case 5:
				$this->setName($value);
				break;
			case 6:
				$this->setCost($value);
				break;
			case 7:
				$this->setPaymentCost($value);
				break;
			case 8:
				$this->setOptTax($value);
				break;
			case 9:
				$this->setNumber($value);
				break;
			case 10:
				$this->setCostBrutto($value);
				break;
			case 11:
				$this->setPaymentCostBrutto($value);
				break;
			case 12:
				$this->setCustomCostBrutto($value);
				break;
			case 13:
				$this->setDeliveryDate($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderDeliveryPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setTaxId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setDeliveryId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setName($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setCost($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setPaymentCost($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOptTax($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setNumber($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setCostBrutto($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setPaymentCostBrutto($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setCustomCostBrutto($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setDeliveryDate($arr[$keys[13]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(OrderDeliveryPeer::DATABASE_NAME);

		if ($this->isColumnModified(OrderDeliveryPeer::CREATED_AT)) $criteria->add(OrderDeliveryPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(OrderDeliveryPeer::UPDATED_AT)) $criteria->add(OrderDeliveryPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(OrderDeliveryPeer::ID)) $criteria->add(OrderDeliveryPeer::ID, $this->id);
		if ($this->isColumnModified(OrderDeliveryPeer::TAX_ID)) $criteria->add(OrderDeliveryPeer::TAX_ID, $this->tax_id);
		if ($this->isColumnModified(OrderDeliveryPeer::DELIVERY_ID)) $criteria->add(OrderDeliveryPeer::DELIVERY_ID, $this->delivery_id);
		if ($this->isColumnModified(OrderDeliveryPeer::NAME)) $criteria->add(OrderDeliveryPeer::NAME, $this->name);
		if ($this->isColumnModified(OrderDeliveryPeer::COST)) $criteria->add(OrderDeliveryPeer::COST, $this->cost);
		if ($this->isColumnModified(OrderDeliveryPeer::PAYMENT_COST)) $criteria->add(OrderDeliveryPeer::PAYMENT_COST, $this->payment_cost);
		if ($this->isColumnModified(OrderDeliveryPeer::OPT_TAX)) $criteria->add(OrderDeliveryPeer::OPT_TAX, $this->opt_tax);
		if ($this->isColumnModified(OrderDeliveryPeer::NUMBER)) $criteria->add(OrderDeliveryPeer::NUMBER, $this->number);
		if ($this->isColumnModified(OrderDeliveryPeer::COST_BRUTTO)) $criteria->add(OrderDeliveryPeer::COST_BRUTTO, $this->cost_brutto);
		if ($this->isColumnModified(OrderDeliveryPeer::PAYMENT_COST_BRUTTO)) $criteria->add(OrderDeliveryPeer::PAYMENT_COST_BRUTTO, $this->payment_cost_brutto);
		if ($this->isColumnModified(OrderDeliveryPeer::CUSTOM_COST_BRUTTO)) $criteria->add(OrderDeliveryPeer::CUSTOM_COST_BRUTTO, $this->custom_cost_brutto);
		if ($this->isColumnModified(OrderDeliveryPeer::DELIVERY_DATE)) $criteria->add(OrderDeliveryPeer::DELIVERY_DATE, $this->delivery_date);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(OrderDeliveryPeer::DATABASE_NAME);

		$criteria->add(OrderDeliveryPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setTaxId($this->tax_id);

		$copyObj->setDeliveryId($this->delivery_id);

		$copyObj->setName($this->name);

		$copyObj->setCost($this->cost);

		$copyObj->setPaymentCost($this->payment_cost);

		$copyObj->setOptTax($this->opt_tax);

		$copyObj->setNumber($this->number);

		$copyObj->setCostBrutto($this->cost_brutto);

		$copyObj->setPaymentCostBrutto($this->payment_cost_brutto);

		$copyObj->setCustomCostBrutto($this->custom_cost_brutto);

		$copyObj->setDeliveryDate($this->delivery_date);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getOrders() as $relObj) {
				$copyObj->addOrder($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new OrderDeliveryPeer();
		}
		return self::$peer;
	}

	
	public function setTax($v)
	{


		if ($v === null) {
			$this->setTaxId(NULL);
		} else {
			$this->setTaxId($v->getId());
		}


		$this->aTax = $v;
	}


	
	public function getTax($con = null)
	{
		if ($this->aTax === null && ($this->tax_id !== null)) {
						$this->aTax = TaxPeer::retrieveByPK($this->tax_id, $con);

			
		}
		return $this->aTax;
	}

	
	public function setDelivery($v)
	{


		if ($v === null) {
			$this->setDeliveryId(NULL);
		} else {
			$this->setDeliveryId($v->getId());
		}


		$this->aDelivery = $v;
	}


	
	public function getDelivery($con = null)
	{
		if ($this->aDelivery === null && ($this->delivery_id !== null)) {
						$this->aDelivery = DeliveryPeer::retrieveByPK($this->delivery_id, $con);

			
		}
		return $this->aDelivery;
	}

	
	public function initOrders()
	{
		if ($this->collOrders === null) {
			$this->collOrders = array();
		}
	}

	
	public function getOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
			   $this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				$this->collOrders = OrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
					$this->collOrders = OrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderCriteria = $criteria;
		return $this->collOrders;
	}

	
	public function countOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

		return OrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrder(Order $l)
	{
		$this->collOrders[] = $l;
		$l->setOrderDelivery($this);
	}


	
	public function getOrdersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataBilling($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderStatus($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinDiscountCouponCode($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinPartner($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'OrderDelivery.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseOrderDelivery:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseOrderDelivery::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 