<?php


abstract class BaseOrderPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_order';

	
	const CLASS_DEFAULT = 'lib.model.Order';

	
	const NUM_COLUMNS = 29;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_order.CREATED_AT';

	
	const UPDATED_AT = 'st_order.UPDATED_AT';

	
	const ID = 'st_order.ID';

	
	const ORDER_DELIVERY_ID = 'st_order.ORDER_DELIVERY_ID';

	
	const SF_GUARD_USER_ID = 'st_order.SF_GUARD_USER_ID';

	
	const ORDER_USER_DATA_DELIVERY_ID = 'st_order.ORDER_USER_DATA_DELIVERY_ID';

	
	const ORDER_USER_DATA_BILLING_ID = 'st_order.ORDER_USER_DATA_BILLING_ID';

	
	const ORDER_CURRENCY_ID = 'st_order.ORDER_CURRENCY_ID';

	
	const ORDER_STATUS_ID = 'st_order.ORDER_STATUS_ID';

	
	const DISCOUNT_COUPON_CODE_ID = 'st_order.DISCOUNT_COUPON_CODE_ID';

	
	const HASH_CODE = 'st_order.HASH_CODE';

	
	const IS_CONFIRMED = 'st_order.IS_CONFIRMED';

	
	const NUMBER = 'st_order.NUMBER';

	
	const DESCRIPTION = 'st_order.DESCRIPTION';

	
	const ORDER_TYPE = 'st_order.ORDER_TYPE';

	
	const MERCHANT_NOTES = 'st_order.MERCHANT_NOTES';

	
	const CLIENT_CULTURE = 'st_order.CLIENT_CULTURE';

	
	const HOST = 'st_order.HOST';

	
	const OPT_TOTAL_AMOUNT = 'st_order.OPT_TOTAL_AMOUNT';

	
	const OPT_IS_PAYED = 'st_order.OPT_IS_PAYED';

	
	const OPT_CLIENT_NAME = 'st_order.OPT_CLIENT_NAME';

	
	const OPT_CLIENT_EMAIL = 'st_order.OPT_CLIENT_EMAIL';

	
	const OPT_ORDER_STATUS = 'st_order.OPT_ORDER_STATUS';

	
	const CHANGE_STOCK_ON = 'st_order.CHANGE_STOCK_ON';

	
	const IFIRMA_PROFORMA_ID = 'st_order.IFIRMA_PROFORMA_ID';

	
	const IFIRMA_INVOICE_ID = 'st_order.IFIRMA_INVOICE_ID';

	
	const PARTNER_ID = 'st_order.PARTNER_ID';

	
	const PROVISION_VALUE = 'st_order.PROVISION_VALUE';

	
	const PROVISION_PAYED = 'st_order.PROVISION_PAYED';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'OrderDeliveryId', 'SfGuardUserId', 'OrderUserDataDeliveryId', 'OrderUserDataBillingId', 'OrderCurrencyId', 'OrderStatusId', 'DiscountCouponCodeId', 'HashCode', 'IsConfirmed', 'Number', 'Description', 'OrderType', 'MerchantNotes', 'ClientCulture', 'Host', 'OptTotalAmount', 'OptIsPayed', 'OptClientName', 'OptClientEmail', 'OptOrderStatus', 'ChangeStockOn', 'IfirmaProformaId', 'IfirmaInvoiceId', 'PartnerId', 'ProvisionValue', 'ProvisionPayed', ),
		BasePeer::TYPE_COLNAME => array (OrderPeer::CREATED_AT, OrderPeer::UPDATED_AT, OrderPeer::ID, OrderPeer::ORDER_DELIVERY_ID, OrderPeer::SF_GUARD_USER_ID, OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderPeer::ORDER_CURRENCY_ID, OrderPeer::ORDER_STATUS_ID, OrderPeer::DISCOUNT_COUPON_CODE_ID, OrderPeer::HASH_CODE, OrderPeer::IS_CONFIRMED, OrderPeer::NUMBER, OrderPeer::DESCRIPTION, OrderPeer::ORDER_TYPE, OrderPeer::MERCHANT_NOTES, OrderPeer::CLIENT_CULTURE, OrderPeer::HOST, OrderPeer::OPT_TOTAL_AMOUNT, OrderPeer::OPT_IS_PAYED, OrderPeer::OPT_CLIENT_NAME, OrderPeer::OPT_CLIENT_EMAIL, OrderPeer::OPT_ORDER_STATUS, OrderPeer::CHANGE_STOCK_ON, OrderPeer::IFIRMA_PROFORMA_ID, OrderPeer::IFIRMA_INVOICE_ID, OrderPeer::PARTNER_ID, OrderPeer::PROVISION_VALUE, OrderPeer::PROVISION_PAYED, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'order_delivery_id', 'sf_guard_user_id', 'order_user_data_delivery_id', 'order_user_data_billing_id', 'order_currency_id', 'order_status_id', 'discount_coupon_code_id', 'hash_code', 'is_confirmed', 'number', 'description', 'order_type', 'merchant_notes', 'client_culture', 'host', 'opt_total_amount', 'opt_is_payed', 'opt_client_name', 'opt_client_email', 'opt_order_status', 'change_stock_on', 'ifirma_proforma_id', 'ifirma_invoice_id', 'partner_id', 'provision_value', 'provision_payed', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'OrderDeliveryId' => 3, 'SfGuardUserId' => 4, 'OrderUserDataDeliveryId' => 5, 'OrderUserDataBillingId' => 6, 'OrderCurrencyId' => 7, 'OrderStatusId' => 8, 'DiscountCouponCodeId' => 9, 'HashCode' => 10, 'IsConfirmed' => 11, 'Number' => 12, 'Description' => 13, 'OrderType' => 14, 'MerchantNotes' => 15, 'ClientCulture' => 16, 'Host' => 17, 'OptTotalAmount' => 18, 'OptIsPayed' => 19, 'OptClientName' => 20, 'OptClientEmail' => 21, 'OptOrderStatus' => 22, 'ChangeStockOn' => 23, 'IfirmaProformaId' => 24, 'IfirmaInvoiceId' => 25, 'PartnerId' => 26, 'ProvisionValue' => 27, 'ProvisionPayed' => 28, ),
		BasePeer::TYPE_COLNAME => array (OrderPeer::CREATED_AT => 0, OrderPeer::UPDATED_AT => 1, OrderPeer::ID => 2, OrderPeer::ORDER_DELIVERY_ID => 3, OrderPeer::SF_GUARD_USER_ID => 4, OrderPeer::ORDER_USER_DATA_DELIVERY_ID => 5, OrderPeer::ORDER_USER_DATA_BILLING_ID => 6, OrderPeer::ORDER_CURRENCY_ID => 7, OrderPeer::ORDER_STATUS_ID => 8, OrderPeer::DISCOUNT_COUPON_CODE_ID => 9, OrderPeer::HASH_CODE => 10, OrderPeer::IS_CONFIRMED => 11, OrderPeer::NUMBER => 12, OrderPeer::DESCRIPTION => 13, OrderPeer::ORDER_TYPE => 14, OrderPeer::MERCHANT_NOTES => 15, OrderPeer::CLIENT_CULTURE => 16, OrderPeer::HOST => 17, OrderPeer::OPT_TOTAL_AMOUNT => 18, OrderPeer::OPT_IS_PAYED => 19, OrderPeer::OPT_CLIENT_NAME => 20, OrderPeer::OPT_CLIENT_EMAIL => 21, OrderPeer::OPT_ORDER_STATUS => 22, OrderPeer::CHANGE_STOCK_ON => 23, OrderPeer::IFIRMA_PROFORMA_ID => 24, OrderPeer::IFIRMA_INVOICE_ID => 25, OrderPeer::PARTNER_ID => 26, OrderPeer::PROVISION_VALUE => 27, OrderPeer::PROVISION_PAYED => 28, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'order_delivery_id' => 3, 'sf_guard_user_id' => 4, 'order_user_data_delivery_id' => 5, 'order_user_data_billing_id' => 6, 'order_currency_id' => 7, 'order_status_id' => 8, 'discount_coupon_code_id' => 9, 'hash_code' => 10, 'is_confirmed' => 11, 'number' => 12, 'description' => 13, 'order_type' => 14, 'merchant_notes' => 15, 'client_culture' => 16, 'host' => 17, 'opt_total_amount' => 18, 'opt_is_payed' => 19, 'opt_client_name' => 20, 'opt_client_email' => 21, 'opt_order_status' => 22, 'change_stock_on' => 23, 'ifirma_proforma_id' => 24, 'ifirma_invoice_id' => 25, 'partner_id' => 26, 'provision_value' => 27, 'provision_payed' => 28, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('lib.model.map.OrderMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = OrderPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(OrderPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(OrderPeer::CREATED_AT);

		$criteria->addSelectColumn(OrderPeer::UPDATED_AT);

		$criteria->addSelectColumn(OrderPeer::ID);

		$criteria->addSelectColumn(OrderPeer::ORDER_DELIVERY_ID);

		$criteria->addSelectColumn(OrderPeer::SF_GUARD_USER_ID);

		$criteria->addSelectColumn(OrderPeer::ORDER_USER_DATA_DELIVERY_ID);

		$criteria->addSelectColumn(OrderPeer::ORDER_USER_DATA_BILLING_ID);

		$criteria->addSelectColumn(OrderPeer::ORDER_CURRENCY_ID);

		$criteria->addSelectColumn(OrderPeer::ORDER_STATUS_ID);

		$criteria->addSelectColumn(OrderPeer::DISCOUNT_COUPON_CODE_ID);

		$criteria->addSelectColumn(OrderPeer::HASH_CODE);

		$criteria->addSelectColumn(OrderPeer::IS_CONFIRMED);

		$criteria->addSelectColumn(OrderPeer::NUMBER);

		$criteria->addSelectColumn(OrderPeer::DESCRIPTION);

		$criteria->addSelectColumn(OrderPeer::ORDER_TYPE);

		$criteria->addSelectColumn(OrderPeer::MERCHANT_NOTES);

		$criteria->addSelectColumn(OrderPeer::CLIENT_CULTURE);

		$criteria->addSelectColumn(OrderPeer::HOST);

		$criteria->addSelectColumn(OrderPeer::OPT_TOTAL_AMOUNT);

		$criteria->addSelectColumn(OrderPeer::OPT_IS_PAYED);

		$criteria->addSelectColumn(OrderPeer::OPT_CLIENT_NAME);

		$criteria->addSelectColumn(OrderPeer::OPT_CLIENT_EMAIL);

		$criteria->addSelectColumn(OrderPeer::OPT_ORDER_STATUS);

		$criteria->addSelectColumn(OrderPeer::CHANGE_STOCK_ON);

		$criteria->addSelectColumn(OrderPeer::IFIRMA_PROFORMA_ID);

		$criteria->addSelectColumn(OrderPeer::IFIRMA_INVOICE_ID);

		$criteria->addSelectColumn(OrderPeer::PARTNER_ID);

		$criteria->addSelectColumn(OrderPeer::PROVISION_VALUE);

		$criteria->addSelectColumn(OrderPeer::PROVISION_PAYED);

	}

	const COUNT = 'COUNT(st_order.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_order.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = OrderPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return OrderPeer::populateObjects(OrderPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseOrderPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			OrderPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = OrderPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinOrderDelivery(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinsfGuardUser(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinOrderUserDataDelivery(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinOrderUserDataBilling(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinOrderCurrency(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinOrderStatus(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinDiscountCouponCode(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinPartner(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinOrderDelivery(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		OrderDeliveryPeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getOrderDeliveryId())
                        {

			   $omClass = OrderDeliveryPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinsfGuardUser(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		sfGuardUserPeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getSfGuardUserId())
                        {

			   $omClass = sfGuardUserPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinOrderUserDataDelivery(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		OrderUserDataDeliveryPeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getOrderUserDataDeliveryId())
                        {

			   $omClass = OrderUserDataDeliveryPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinOrderUserDataBilling(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		OrderUserDataBillingPeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getOrderUserDataBillingId())
                        {

			   $omClass = OrderUserDataBillingPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinOrderCurrency(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		OrderCurrencyPeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getOrderCurrencyId())
                        {

			   $omClass = OrderCurrencyPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinOrderStatus(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		OrderStatusPeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getOrderStatusId())
                        {

			   $omClass = OrderStatusPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinDiscountCouponCode(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		DiscountCouponCodePeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getDiscountCouponCodeId())
                        {

			   $omClass = DiscountCouponCodePeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinPartner(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		PartnerPeer::addSelectColumns($c);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getPartnerId())
                        {

			   $omClass = PartnerPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrder($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderCurrencyPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol8 = $startcol7 + OrderStatusPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol9 = $startcol8 + DiscountCouponCodePeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol10 = $startcol9 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}


					
			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3 = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}


					
			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4 = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}


					
			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5 = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}


					
			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6 = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}


					
			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7 = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getOrderStatus(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}


					
			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8 = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}


					
			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj9 = new $cls();
			$obj9->hydrate($rs, $startcol9);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj9 = $temp_obj1->getPartner(); 				if ($temp_obj9->getPrimaryKey() === $obj9->getPrimaryKey()) {
					$newObject = false;
					$temp_obj9->addOrder($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj9->initOrders();
				$obj9->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doCountJoinAllExceptOrderDelivery(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptsfGuardUser(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptOrderUserDataDelivery(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptOrderUserDataBilling(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptOrderCurrency(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptOrderStatus(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptDiscountCouponCode(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptPartner(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$criteria->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$criteria->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAllExceptOrderDelivery(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderCurrencyPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderStatusPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol8 = $startcol7 + DiscountCouponCodePeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol9 = $startcol8 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderStatus(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getPartner(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptsfGuardUser(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderCurrencyPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderStatusPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol8 = $startcol7 + DiscountCouponCodePeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol9 = $startcol8 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderStatus(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getPartner(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptOrderUserDataDelivery(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderCurrencyPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderStatusPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol8 = $startcol7 + DiscountCouponCodePeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol9 = $startcol8 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderStatus(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getPartner(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptOrderUserDataBilling(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderCurrencyPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderStatusPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol8 = $startcol7 + DiscountCouponCodePeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol9 = $startcol8 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderStatus(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getPartner(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptOrderCurrency(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderStatusPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol8 = $startcol7 + DiscountCouponCodePeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol9 = $startcol8 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderStatus(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getPartner(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptOrderStatus(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderCurrencyPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol8 = $startcol7 + DiscountCouponCodePeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol9 = $startcol8 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getPartner(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptDiscountCouponCode(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderCurrencyPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol8 = $startcol7 + OrderStatusPeer::NUM_COLUMNS;

		PartnerPeer::addSelectColumns($c);
		$startcol9 = $startcol8 + PartnerPeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::PARTNER_ID, PartnerPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getOrderStatus(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = PartnerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getPartner(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptPartner(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderPeer::addSelectColumns($c);
		$startcol2 = (OrderPeer::NUM_COLUMNS - OrderPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderDeliveryPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderDeliveryPeer::NUM_COLUMNS;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + sfGuardUserPeer::NUM_COLUMNS;

		OrderUserDataDeliveryPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + OrderUserDataDeliveryPeer::NUM_COLUMNS;

		OrderUserDataBillingPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + OrderUserDataBillingPeer::NUM_COLUMNS;

		OrderCurrencyPeer::addSelectColumns($c);
		$startcol7 = $startcol6 + OrderCurrencyPeer::NUM_COLUMNS;

		OrderStatusPeer::addSelectColumns($c);
		$startcol8 = $startcol7 + OrderStatusPeer::NUM_COLUMNS;

		DiscountCouponCodePeer::addSelectColumns($c);
		$startcol9 = $startcol8 + DiscountCouponCodePeer::NUM_COLUMNS;

		$c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_DELIVERY_ID, OrderUserDataDeliveryPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_USER_DATA_BILLING_ID, OrderUserDataBillingPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderPeer::ORDER_CURRENCY_ID, OrderCurrencyPeer::ID);

		$c->addJoin(OrderPeer::ORDER_STATUS_ID, OrderStatusPeer::ID);

		$c->addJoin(OrderPeer::DISCOUNT_COUPON_CODE_ID, DiscountCouponCodePeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrderDelivery(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrders();
				$obj2->addOrder($obj1);
			}

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrders();
				$obj3->addOrder($obj1);
			}

			$omClass = OrderUserDataDeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getOrderUserDataDelivery(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initOrders();
				$obj4->addOrder($obj1);
			}

			$omClass = OrderUserDataBillingPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getOrderUserDataBilling(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initOrders();
				$obj5->addOrder($obj1);
			}

			$omClass = OrderCurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj6  = new $cls();
			$obj6->hydrate($rs, $startcol6);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj6 = $temp_obj1->getOrderCurrency(); 				if ($temp_obj6->getPrimaryKey() === $obj6->getPrimaryKey()) {
					$newObject = false;
					$temp_obj6->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj6->initOrders();
				$obj6->addOrder($obj1);
			}

			$omClass = OrderStatusPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj7  = new $cls();
			$obj7->hydrate($rs, $startcol7);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj7 = $temp_obj1->getOrderStatus(); 				if ($temp_obj7->getPrimaryKey() === $obj7->getPrimaryKey()) {
					$newObject = false;
					$temp_obj7->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj7->initOrders();
				$obj7->addOrder($obj1);
			}

			$omClass = DiscountCouponCodePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj8  = new $cls();
			$obj8->hydrate($rs, $startcol8);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj8 = $temp_obj1->getDiscountCouponCode(); 				if ($temp_obj8->getPrimaryKey() === $obj8->getPrimaryKey()) {
					$newObject = false;
					$temp_obj8->addOrder($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj8->initOrders();
				$obj8->addOrder($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return OrderPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseOrderPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(OrderPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseOrderPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseOrderPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseOrderPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(OrderPeer::ID);
			$selectCriteria->add(OrderPeer::ID, $criteria->remove(OrderPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseOrderPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseOrderPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += OrderPeer::doOnDeleteCascade(new Criteria(), $con);
			OrderPeer::doOnDeleteSetNull(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(OrderPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(OrderPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof Order) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(OrderPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += OrderPeer::doOnDeleteCascade($criteria, $con);OrderPeer::doOnDeleteSetNull($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = OrderPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(OrderHasPaymentPeer::ORDER_ID, $obj->getId());
			$affectedRows += OrderHasPaymentPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(OrderProductPeer::ORDER_ID, $obj->getId());
			$affectedRows += OrderProductPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ReviewPeer::ORDER_ID, $obj->getId());
			$affectedRows += ReviewPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ReviewOrderPeer::ORDER_ID, $obj->getId());
			$affectedRows += ReviewOrderPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	protected static function doOnDeleteSetNull(Criteria $criteria, Connection $con)
	{

				$objects = OrderPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {

						$selectCriteria = new Criteria(OrderPeer::DATABASE_NAME);
			$updateValues = new Criteria(OrderPeer::DATABASE_NAME);
			$selectCriteria->add(InvoicePeer::ORDER_ID, $obj->getId());
			$updateValues->add(InvoicePeer::ORDER_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
		}
	}

	
	public static function doValidate(Order $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(OrderPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(OrderPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(OrderPeer::DATABASE_NAME, OrderPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = OrderPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(OrderPeer::DATABASE_NAME);

		$criteria->add(OrderPeer::ID, $pk);


		$v = OrderPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(OrderPeer::ID, $pks, Criteria::IN);
			$objs = OrderPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseOrderPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('lib.model.map.OrderMapBuilder');
}
