<?php


abstract class BaseOrderProduct extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $order_id;


	
	protected $product_id;


	
	protected $tax_id;


	
	protected $quantity;


	
	protected $code;


	
	protected $name;


	
	protected $image;


	
	protected $price;


	
	protected $price_brutto;


	
	protected $custom_price;


	
	protected $custom_price_brutto;


	
	protected $vat;


	
	protected $price_modifiers;


	
	protected $discount;


	
	protected $currency;


	
	protected $wholesale;


	
	protected $options;

	
	protected $aOrder;

	
	protected $aProduct;

	
	protected $aTax;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOrderId()
    {

            return $this->order_id;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

    
    public function getTaxId()
    {

            return $this->tax_id;
    }

    
    public function getQuantity()
    {

            return null !== $this->quantity ? (string)$this->quantity : null;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getImage()
    {

            return $this->image;
    }

    
    public function getPrice()
    {

            return null !== $this->price ? (string)$this->price : null;
    }

    
    public function getPriceBrutto()
    {

            return null !== $this->price_brutto ? (string)$this->price_brutto : null;
    }

    
    public function getCustomPrice()
    {

            return null !== $this->custom_price ? (string)$this->custom_price : null;
    }

    
    public function getCustomPriceBrutto()
    {

            return null !== $this->custom_price_brutto ? (string)$this->custom_price_brutto : null;
    }

    
    public function getVat()
    {

            return null !== $this->vat ? (string)$this->vat : null;
    }

    
    public function getPriceModifiers()
    {

            return $this->price_modifiers;
    }

    
    public function getDiscount()
    {

            return $this->discount;
    }

    
    public function getCurrency()
    {

            return $this->currency;
    }

    
    public function getWholesale()
    {

            return $this->wholesale;
    }

    
    public function getOptions()
    {

            return $this->options;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = OrderProductPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = OrderProductPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = OrderProductPeer::ID;
        }

	} 
	
	public function setOrderId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_id !== $v) {
          $this->order_id = $v;
          $this->modifiedColumns[] = OrderProductPeer::ORDER_ID;
        }

		if ($this->aOrder !== null && $this->aOrder->getId() !== $v) {
			$this->aOrder = null;
		}

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = OrderProductPeer::PRODUCT_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setTaxId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->tax_id !== $v) {
          $this->tax_id = $v;
          $this->modifiedColumns[] = OrderProductPeer::TAX_ID;
        }

		if ($this->aTax !== null && $this->aTax->getId() !== $v) {
			$this->aTax = null;
		}

	} 
	
	public function setQuantity($v)
	{

        if ($this->quantity !== $v) {
          $this->quantity = $v;
          $this->modifiedColumns[] = OrderProductPeer::QUANTITY;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = OrderProductPeer::CODE;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = OrderProductPeer::NAME;
        }

	} 
	
	public function setImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->image !== $v) {
          $this->image = $v;
          $this->modifiedColumns[] = OrderProductPeer::IMAGE;
        }

	} 
	
	public function setPrice($v)
	{

        if ($this->price !== $v) {
          $this->price = $v;
          $this->modifiedColumns[] = OrderProductPeer::PRICE;
        }

	} 
	
	public function setPriceBrutto($v)
	{

        if ($this->price_brutto !== $v) {
          $this->price_brutto = $v;
          $this->modifiedColumns[] = OrderProductPeer::PRICE_BRUTTO;
        }

	} 
	
	public function setCustomPrice($v)
	{

        if ($this->custom_price !== $v) {
          $this->custom_price = $v;
          $this->modifiedColumns[] = OrderProductPeer::CUSTOM_PRICE;
        }

	} 
	
	public function setCustomPriceBrutto($v)
	{

        if ($this->custom_price_brutto !== $v) {
          $this->custom_price_brutto = $v;
          $this->modifiedColumns[] = OrderProductPeer::CUSTOM_PRICE_BRUTTO;
        }

	} 
	
	public function setVat($v)
	{

        if ($this->vat !== $v) {
          $this->vat = $v;
          $this->modifiedColumns[] = OrderProductPeer::VAT;
        }

	} 
	
	public function setPriceModifiers($v)
	{

        if ($this->price_modifiers !== $v) {
          $this->price_modifiers = $v;
          $this->modifiedColumns[] = OrderProductPeer::PRICE_MODIFIERS;
        }

	} 
	
	public function setDiscount($v)
	{

        if ($this->discount !== $v) {
          $this->discount = $v;
          $this->modifiedColumns[] = OrderProductPeer::DISCOUNT;
        }

	} 
	
	public function setCurrency($v)
	{

        if ($this->currency !== $v) {
          $this->currency = $v;
          $this->modifiedColumns[] = OrderProductPeer::CURRENCY;
        }

	} 
	
	public function setWholesale($v)
	{

        if ($this->wholesale !== $v) {
          $this->wholesale = $v;
          $this->modifiedColumns[] = OrderProductPeer::WHOLESALE;
        }

	} 
	
	public function setOptions($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->options !== $v) {
          $this->options = $v;
          $this->modifiedColumns[] = OrderProductPeer::OPTIONS;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'OrderProduct.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->order_id = $rs->getInt($startcol + 3);

      $this->product_id = $rs->getInt($startcol + 4);

      $this->tax_id = $rs->getInt($startcol + 5);

      $this->quantity = $rs->getString($startcol + 6, null);

      $this->quantity = $rs->getFloat($startcol + 6);

      $this->code = $rs->getString($startcol + 7);

      $this->name = $rs->getString($startcol + 8);

      $this->image = $rs->getString($startcol + 9);

      $this->price = $rs->getString($startcol + 10, null);

      $this->price = $rs->getFloat($startcol + 10);

      $this->price_brutto = $rs->getString($startcol + 11, null);

      $this->price_brutto = $rs->getFloat($startcol + 11);

      $this->custom_price = $rs->getString($startcol + 12, null);

      $this->custom_price = $rs->getFloat($startcol + 12);

      $this->custom_price_brutto = $rs->getString($startcol + 13, null);

      $this->custom_price_brutto = $rs->getFloat($startcol + 13);

      $this->vat = $rs->getString($startcol + 14, null);

      $this->vat = $rs->getFloat($startcol + 14);

      $this->price_modifiers = $rs->getString($startcol + 15) ? unserialize($rs->getString($startcol + 15)) : null;

      $this->discount = $rs->getString($startcol + 16) ? unserialize($rs->getString($startcol + 16)) : null;

      $this->currency = $rs->getString($startcol + 17) ? unserialize($rs->getString($startcol + 17)) : null;

      $this->wholesale = $rs->getString($startcol + 18) ? unserialize($rs->getString($startcol + 18)) : null;

      $this->options = $rs->getString($startcol + 19);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'OrderProduct.postHydrate', array('resultset' => $rs, 'startcol' => 20)));

            return $startcol + 20; 
    } catch (Exception $e) {
      throw new PropelException("Error populating OrderProduct object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderProduct:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			OrderProductPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseOrderProduct:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderProduct.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseOrderProduct:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(OrderProductPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(OrderProductPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderProduct.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseOrderProduct:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aOrder !== null) {
				if ($this->aOrder->isModified()) {
					$affectedRows += $this->aOrder->save($con);
				}
				$this->setOrder($this->aOrder);
			}

			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}

			if ($this->aTax !== null) {
				if ($this->aTax->isModified()) {
					$affectedRows += $this->aTax->save($con);
				}
				$this->setTax($this->aTax);
			}


						if ($this->isModified()) {
              $o_price_modifiers = $this->price_modifiers;
              if (null !== $this->price_modifiers && $this->isColumnModified(OrderProductPeer::PRICE_MODIFIERS)) {
                  $this->price_modifiers = serialize($this->price_modifiers);
              }

              $o_discount = $this->discount;
              if (null !== $this->discount && $this->isColumnModified(OrderProductPeer::DISCOUNT)) {
                  $this->discount = serialize($this->discount);
              }

              $o_currency = $this->currency;
              if (null !== $this->currency && $this->isColumnModified(OrderProductPeer::CURRENCY)) {
                  $this->currency = serialize($this->currency);
              }

              $o_wholesale = $this->wholesale;
              if (null !== $this->wholesale && $this->isColumnModified(OrderProductPeer::WHOLESALE)) {
                  $this->wholesale = serialize($this->wholesale);
              }

				if ($this->isNew()) {
					$pk = OrderProductPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += OrderProductPeer::doUpdate($this, $con);
				}
				$this->resetModified();
             $this->price_modifiers = $o_price_modifiers;

             $this->discount = $o_discount;

             $this->currency = $o_currency;

             $this->wholesale = $o_wholesale;
 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aOrder !== null) {
				if (!$this->aOrder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrder->getValidationFailures());
				}
			}

			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}

			if ($this->aTax !== null) {
				if (!$this->aTax->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTax->getValidationFailures());
				}
			}


			if (($retval = OrderProductPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOrderId();
				break;
			case 4:
				return $this->getProductId();
				break;
			case 5:
				return $this->getTaxId();
				break;
			case 6:
				return $this->getQuantity();
				break;
			case 7:
				return $this->getCode();
				break;
			case 8:
				return $this->getName();
				break;
			case 9:
				return $this->getImage();
				break;
			case 10:
				return $this->getPrice();
				break;
			case 11:
				return $this->getPriceBrutto();
				break;
			case 12:
				return $this->getCustomPrice();
				break;
			case 13:
				return $this->getCustomPriceBrutto();
				break;
			case 14:
				return $this->getVat();
				break;
			case 15:
				return $this->getPriceModifiers();
				break;
			case 16:
				return $this->getDiscount();
				break;
			case 17:
				return $this->getCurrency();
				break;
			case 18:
				return $this->getWholesale();
				break;
			case 19:
				return $this->getOptions();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderProductPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOrderId(),
			$keys[4] => $this->getProductId(),
			$keys[5] => $this->getTaxId(),
			$keys[6] => $this->getQuantity(),
			$keys[7] => $this->getCode(),
			$keys[8] => $this->getName(),
			$keys[9] => $this->getImage(),
			$keys[10] => $this->getPrice(),
			$keys[11] => $this->getPriceBrutto(),
			$keys[12] => $this->getCustomPrice(),
			$keys[13] => $this->getCustomPriceBrutto(),
			$keys[14] => $this->getVat(),
			$keys[15] => $this->getPriceModifiers(),
			$keys[16] => $this->getDiscount(),
			$keys[17] => $this->getCurrency(),
			$keys[18] => $this->getWholesale(),
			$keys[19] => $this->getOptions(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOrderId($value);
				break;
			case 4:
				$this->setProductId($value);
				break;
			case 5:
				$this->setTaxId($value);
				break;
			case 6:
				$this->setQuantity($value);
				break;
			case 7:
				$this->setCode($value);
				break;
			case 8:
				$this->setName($value);
				break;
			case 9:
				$this->setImage($value);
				break;
			case 10:
				$this->setPrice($value);
				break;
			case 11:
				$this->setPriceBrutto($value);
				break;
			case 12:
				$this->setCustomPrice($value);
				break;
			case 13:
				$this->setCustomPriceBrutto($value);
				break;
			case 14:
				$this->setVat($value);
				break;
			case 15:
				$this->setPriceModifiers($value);
				break;
			case 16:
				$this->setDiscount($value);
				break;
			case 17:
				$this->setCurrency($value);
				break;
			case 18:
				$this->setWholesale($value);
				break;
			case 19:
				$this->setOptions($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderProductPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOrderId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setProductId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setTaxId($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setQuantity($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setCode($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setName($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setImage($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setPrice($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setPriceBrutto($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setCustomPrice($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setCustomPriceBrutto($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setVat($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setPriceModifiers($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setDiscount($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setCurrency($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setWholesale($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setOptions($arr[$keys[19]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(OrderProductPeer::DATABASE_NAME);

		if ($this->isColumnModified(OrderProductPeer::CREATED_AT)) $criteria->add(OrderProductPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(OrderProductPeer::UPDATED_AT)) $criteria->add(OrderProductPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(OrderProductPeer::ID)) $criteria->add(OrderProductPeer::ID, $this->id);
		if ($this->isColumnModified(OrderProductPeer::ORDER_ID)) $criteria->add(OrderProductPeer::ORDER_ID, $this->order_id);
		if ($this->isColumnModified(OrderProductPeer::PRODUCT_ID)) $criteria->add(OrderProductPeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(OrderProductPeer::TAX_ID)) $criteria->add(OrderProductPeer::TAX_ID, $this->tax_id);
		if ($this->isColumnModified(OrderProductPeer::QUANTITY)) $criteria->add(OrderProductPeer::QUANTITY, $this->quantity);
		if ($this->isColumnModified(OrderProductPeer::CODE)) $criteria->add(OrderProductPeer::CODE, $this->code);
		if ($this->isColumnModified(OrderProductPeer::NAME)) $criteria->add(OrderProductPeer::NAME, $this->name);
		if ($this->isColumnModified(OrderProductPeer::IMAGE)) $criteria->add(OrderProductPeer::IMAGE, $this->image);
		if ($this->isColumnModified(OrderProductPeer::PRICE)) $criteria->add(OrderProductPeer::PRICE, $this->price);
		if ($this->isColumnModified(OrderProductPeer::PRICE_BRUTTO)) $criteria->add(OrderProductPeer::PRICE_BRUTTO, $this->price_brutto);
		if ($this->isColumnModified(OrderProductPeer::CUSTOM_PRICE)) $criteria->add(OrderProductPeer::CUSTOM_PRICE, $this->custom_price);
		if ($this->isColumnModified(OrderProductPeer::CUSTOM_PRICE_BRUTTO)) $criteria->add(OrderProductPeer::CUSTOM_PRICE_BRUTTO, $this->custom_price_brutto);
		if ($this->isColumnModified(OrderProductPeer::VAT)) $criteria->add(OrderProductPeer::VAT, $this->vat);
		if ($this->isColumnModified(OrderProductPeer::PRICE_MODIFIERS)) $criteria->add(OrderProductPeer::PRICE_MODIFIERS, $this->price_modifiers);
		if ($this->isColumnModified(OrderProductPeer::DISCOUNT)) $criteria->add(OrderProductPeer::DISCOUNT, $this->discount);
		if ($this->isColumnModified(OrderProductPeer::CURRENCY)) $criteria->add(OrderProductPeer::CURRENCY, $this->currency);
		if ($this->isColumnModified(OrderProductPeer::WHOLESALE)) $criteria->add(OrderProductPeer::WHOLESALE, $this->wholesale);
		if ($this->isColumnModified(OrderProductPeer::OPTIONS)) $criteria->add(OrderProductPeer::OPTIONS, $this->options);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(OrderProductPeer::DATABASE_NAME);

		$criteria->add(OrderProductPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOrderId($this->order_id);

		$copyObj->setProductId($this->product_id);

		$copyObj->setTaxId($this->tax_id);

		$copyObj->setQuantity($this->quantity);

		$copyObj->setCode($this->code);

		$copyObj->setName($this->name);

		$copyObj->setImage($this->image);

		$copyObj->setPrice($this->price);

		$copyObj->setPriceBrutto($this->price_brutto);

		$copyObj->setCustomPrice($this->custom_price);

		$copyObj->setCustomPriceBrutto($this->custom_price_brutto);

		$copyObj->setVat($this->vat);

		$copyObj->setPriceModifiers($this->price_modifiers);

		$copyObj->setDiscount($this->discount);

		$copyObj->setCurrency($this->currency);

		$copyObj->setWholesale($this->wholesale);

		$copyObj->setOptions($this->options);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new OrderProductPeer();
		}
		return self::$peer;
	}

	
	public function setOrder($v)
	{


		if ($v === null) {
			$this->setOrderId(NULL);
		} else {
			$this->setOrderId($v->getId());
		}


		$this->aOrder = $v;
	}


	
	public function getOrder($con = null)
	{
		if ($this->aOrder === null && ($this->order_id !== null)) {
						$this->aOrder = OrderPeer::retrieveByPK($this->order_id, $con);

			
		}
		return $this->aOrder;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->product_id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->product_id, $con);

			
		}
		return $this->aProduct;
	}

	
	public function setTax($v)
	{


		if ($v === null) {
			$this->setTaxId(NULL);
		} else {
			$this->setTaxId($v->getId());
		}


		$this->aTax = $v;
	}


	
	public function getTax($con = null)
	{
		if ($this->aTax === null && ($this->tax_id !== null)) {
						$this->aTax = TaxPeer::retrieveByPK($this->tax_id, $con);

			
		}
		return $this->aTax;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'OrderProduct.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseOrderProduct:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseOrderProduct::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 