<?php


abstract class BaseOrderProductPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_order_product';

	
	const CLASS_DEFAULT = 'lib.model.OrderProduct';

	
	const NUM_COLUMNS = 20;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_order_product.CREATED_AT';

	
	const UPDATED_AT = 'st_order_product.UPDATED_AT';

	
	const ID = 'st_order_product.ID';

	
	const ORDER_ID = 'st_order_product.ORDER_ID';

	
	const PRODUCT_ID = 'st_order_product.PRODUCT_ID';

	
	const TAX_ID = 'st_order_product.TAX_ID';

	
	const QUANTITY = 'st_order_product.QUANTITY';

	
	const CODE = 'st_order_product.CODE';

	
	const NAME = 'st_order_product.NAME';

	
	const IMAGE = 'st_order_product.IMAGE';

	
	const PRICE = 'st_order_product.PRICE';

	
	const PRICE_BRUTTO = 'st_order_product.PRICE_BRUTTO';

	
	const CUSTOM_PRICE = 'st_order_product.CUSTOM_PRICE';

	
	const CUSTOM_PRICE_BRUTTO = 'st_order_product.CUSTOM_PRICE_BRUTTO';

	
	const VAT = 'st_order_product.VAT';

	
	const PRICE_MODIFIERS = 'st_order_product.PRICE_MODIFIERS';

	
	const DISCOUNT = 'st_order_product.DISCOUNT';

	
	const CURRENCY = 'st_order_product.CURRENCY';

	
	const WHOLESALE = 'st_order_product.WHOLESALE';

	
	const OPTIONS = 'st_order_product.OPTIONS';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'OrderId', 'ProductId', 'TaxId', 'Quantity', 'Code', 'Name', 'Image', 'Price', 'PriceBrutto', 'CustomPrice', 'CustomPriceBrutto', 'Vat', 'PriceModifiers', 'Discount', 'Currency', 'Wholesale', 'Options', ),
		BasePeer::TYPE_COLNAME => array (OrderProductPeer::CREATED_AT, OrderProductPeer::UPDATED_AT, OrderProductPeer::ID, OrderProductPeer::ORDER_ID, OrderProductPeer::PRODUCT_ID, OrderProductPeer::TAX_ID, OrderProductPeer::QUANTITY, OrderProductPeer::CODE, OrderProductPeer::NAME, OrderProductPeer::IMAGE, OrderProductPeer::PRICE, OrderProductPeer::PRICE_BRUTTO, OrderProductPeer::CUSTOM_PRICE, OrderProductPeer::CUSTOM_PRICE_BRUTTO, OrderProductPeer::VAT, OrderProductPeer::PRICE_MODIFIERS, OrderProductPeer::DISCOUNT, OrderProductPeer::CURRENCY, OrderProductPeer::WHOLESALE, OrderProductPeer::OPTIONS, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'order_id', 'product_id', 'tax_id', 'quantity', 'code', 'name', 'image', 'price', 'price_brutto', 'custom_price', 'custom_price_brutto', 'vat', 'price_modifiers', 'discount', 'currency', 'wholesale', 'options', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'OrderId' => 3, 'ProductId' => 4, 'TaxId' => 5, 'Quantity' => 6, 'Code' => 7, 'Name' => 8, 'Image' => 9, 'Price' => 10, 'PriceBrutto' => 11, 'CustomPrice' => 12, 'CustomPriceBrutto' => 13, 'Vat' => 14, 'PriceModifiers' => 15, 'Discount' => 16, 'Currency' => 17, 'Wholesale' => 18, 'Options' => 19, ),
		BasePeer::TYPE_COLNAME => array (OrderProductPeer::CREATED_AT => 0, OrderProductPeer::UPDATED_AT => 1, OrderProductPeer::ID => 2, OrderProductPeer::ORDER_ID => 3, OrderProductPeer::PRODUCT_ID => 4, OrderProductPeer::TAX_ID => 5, OrderProductPeer::QUANTITY => 6, OrderProductPeer::CODE => 7, OrderProductPeer::NAME => 8, OrderProductPeer::IMAGE => 9, OrderProductPeer::PRICE => 10, OrderProductPeer::PRICE_BRUTTO => 11, OrderProductPeer::CUSTOM_PRICE => 12, OrderProductPeer::CUSTOM_PRICE_BRUTTO => 13, OrderProductPeer::VAT => 14, OrderProductPeer::PRICE_MODIFIERS => 15, OrderProductPeer::DISCOUNT => 16, OrderProductPeer::CURRENCY => 17, OrderProductPeer::WHOLESALE => 18, OrderProductPeer::OPTIONS => 19, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'order_id' => 3, 'product_id' => 4, 'tax_id' => 5, 'quantity' => 6, 'code' => 7, 'name' => 8, 'image' => 9, 'price' => 10, 'price_brutto' => 11, 'custom_price' => 12, 'custom_price_brutto' => 13, 'vat' => 14, 'price_modifiers' => 15, 'discount' => 16, 'currency' => 17, 'wholesale' => 18, 'options' => 19, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('lib.model.map.OrderProductMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = OrderProductPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(OrderProductPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(OrderProductPeer::CREATED_AT);

		$criteria->addSelectColumn(OrderProductPeer::UPDATED_AT);

		$criteria->addSelectColumn(OrderProductPeer::ID);

		$criteria->addSelectColumn(OrderProductPeer::ORDER_ID);

		$criteria->addSelectColumn(OrderProductPeer::PRODUCT_ID);

		$criteria->addSelectColumn(OrderProductPeer::TAX_ID);

		$criteria->addSelectColumn(OrderProductPeer::QUANTITY);

		$criteria->addSelectColumn(OrderProductPeer::CODE);

		$criteria->addSelectColumn(OrderProductPeer::NAME);

		$criteria->addSelectColumn(OrderProductPeer::IMAGE);

		$criteria->addSelectColumn(OrderProductPeer::PRICE);

		$criteria->addSelectColumn(OrderProductPeer::PRICE_BRUTTO);

		$criteria->addSelectColumn(OrderProductPeer::CUSTOM_PRICE);

		$criteria->addSelectColumn(OrderProductPeer::CUSTOM_PRICE_BRUTTO);

		$criteria->addSelectColumn(OrderProductPeer::VAT);

		$criteria->addSelectColumn(OrderProductPeer::PRICE_MODIFIERS);

		$criteria->addSelectColumn(OrderProductPeer::DISCOUNT);

		$criteria->addSelectColumn(OrderProductPeer::CURRENCY);

		$criteria->addSelectColumn(OrderProductPeer::WHOLESALE);

		$criteria->addSelectColumn(OrderProductPeer::OPTIONS);

	}

	const COUNT = 'COUNT(st_order_product.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_order_product.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = OrderProductPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return OrderProductPeer::populateObjects(OrderProductPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderProductPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseOrderProductPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			OrderProductPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = OrderProductPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinOrder(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinProduct(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinTax(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinOrder(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderProductPeer::addSelectColumns($c);
		$startcol = (OrderProductPeer::NUM_COLUMNS - OrderProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		OrderPeer::addSelectColumns($c);

		$c->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getOrderId())
                        {

			   $omClass = OrderPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrderProduct($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinProduct(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderProductPeer::addSelectColumns($c);
		$startcol = (OrderProductPeer::NUM_COLUMNS - OrderProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		ProductPeer::addSelectColumns($c);

		$c->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getProductId())
                        {

			   $omClass = ProductPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrderProduct($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinTax(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderProductPeer::addSelectColumns($c);
		$startcol = (OrderProductPeer::NUM_COLUMNS - OrderProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		TaxPeer::addSelectColumns($c);

		$c->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = OrderProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getTaxId())
                        {

			   $omClass = TaxPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addOrderProduct($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);

		$criteria->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderProductPeer::addSelectColumns($c);
		$startcol2 = (OrderProductPeer::NUM_COLUMNS - OrderProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderPeer::NUM_COLUMNS;

		ProductPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);

		$c->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrder(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrderProduct($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initOrderProducts();
				$obj2->addOrderProduct($obj1);
			}


					
			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3 = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProduct(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrderProduct($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj3->initOrderProducts();
				$obj3->addOrderProduct($obj1);
			}


					
			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4 = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getTax(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addOrderProduct($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj4->initOrderProducts();
				$obj4->addOrderProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doCountJoinAllExceptOrder(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptProduct(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);

		$criteria->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptTax(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(OrderProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(OrderProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);

		$criteria->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);

		$rs = OrderProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAllExceptOrder(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderProductPeer::addSelectColumns($c);
		$startcol2 = (OrderProductPeer::NUM_COLUMNS - OrderProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		ProductPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + ProductPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getProduct(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrderProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrderProducts();
				$obj2->addOrderProduct($obj1);
			}

			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getTax(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrderProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrderProducts();
				$obj3->addOrderProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptProduct(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderProductPeer::addSelectColumns($c);
		$startcol2 = (OrderProductPeer::NUM_COLUMNS - OrderProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);

		$c->addJoin(OrderProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrder(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrderProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrderProducts();
				$obj2->addOrderProduct($obj1);
			}

			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getTax(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrderProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrderProducts();
				$obj3->addOrderProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptTax(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		OrderProductPeer::addSelectColumns($c);
		$startcol2 = (OrderProductPeer::NUM_COLUMNS - OrderProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		OrderPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + OrderPeer::NUM_COLUMNS;

		ProductPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductPeer::NUM_COLUMNS;

		$c->addJoin(OrderProductPeer::ORDER_ID, OrderPeer::ID);

		$c->addJoin(OrderProductPeer::PRODUCT_ID, ProductPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = OrderProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = OrderPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getOrder(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addOrderProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initOrderProducts();
				$obj2->addOrderProduct($obj1);
			}

			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProduct(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addOrderProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initOrderProducts();
				$obj3->addOrderProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return OrderProductPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderProductPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseOrderProductPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(OrderProductPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseOrderProductPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseOrderProductPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderProductPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseOrderProductPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(OrderProductPeer::ID);
			$selectCriteria->add(OrderProductPeer::ID, $criteria->remove(OrderProductPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseOrderProductPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseOrderProductPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += BasePeer::doDeleteAll(OrderProductPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(OrderProductPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof OrderProduct) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(OrderProductPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	public static function doValidate(OrderProduct $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(OrderProductPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(OrderProductPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(OrderProductPeer::DATABASE_NAME, OrderProductPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = OrderProductPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(OrderProductPeer::DATABASE_NAME);

		$criteria->add(OrderProductPeer::ID, $pk);


		$v = OrderProductPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(OrderProductPeer::ID, $pks, Criteria::IN);
			$objs = OrderProductPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseOrderProductPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('lib.model.map.OrderProductMapBuilder');
}
