<?php


abstract class BaseOrderStatus extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $coupon_code_id;


	
	protected $opt_name;


	
	protected $opt_description;


	
	protected $type;


	
	protected $is_default = false;


	
	protected $is_system_default = false;


	
	protected $has_mail_notification = true;


	
	protected $has_coupon_code = false;


	
	protected $depository_action;

	
	protected $aOrderStatusCouponCode;

	
	protected $collOrders;

	
	protected $lastOrderCriteria = null;

	
	protected $collOrderStatusI18ns;

	
	protected $lastOrderStatusI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCouponCodeId()
    {

            return $this->coupon_code_id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getType()
    {

            return $this->type;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getIsSystemDefault()
    {

            return $this->is_system_default;
    }

    
    public function getHasMailNotification()
    {

            return $this->has_mail_notification;
    }

    
    public function getHasCouponCode()
    {

            return $this->has_coupon_code;
    }

    
    public function getDepositoryAction()
    {

            return $this->depository_action;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = OrderStatusPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = OrderStatusPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = OrderStatusPeer::ID;
        }

	} 
	
	public function setCouponCodeId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->coupon_code_id !== $v) {
          $this->coupon_code_id = $v;
          $this->modifiedColumns[] = OrderStatusPeer::COUPON_CODE_ID;
        }

		if ($this->aOrderStatusCouponCode !== null && $this->aOrderStatusCouponCode->getId() !== $v) {
			$this->aOrderStatusCouponCode = null;
		}

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = OrderStatusPeer::OPT_NAME;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = OrderStatusPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->type !== $v) {
          $this->type = $v;
          $this->modifiedColumns[] = OrderStatusPeer::TYPE;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = OrderStatusPeer::IS_DEFAULT;
        }

	} 
	
	public function setIsSystemDefault($v)
	{

        if ($this->is_system_default !== $v || $v === false) {
          $this->is_system_default = $v;
          $this->modifiedColumns[] = OrderStatusPeer::IS_SYSTEM_DEFAULT;
        }

	} 
	
	public function setHasMailNotification($v)
	{

        if ($this->has_mail_notification !== $v || $v === true) {
          $this->has_mail_notification = $v;
          $this->modifiedColumns[] = OrderStatusPeer::HAS_MAIL_NOTIFICATION;
        }

	} 
	
	public function setHasCouponCode($v)
	{

        if ($this->has_coupon_code !== $v || $v === false) {
          $this->has_coupon_code = $v;
          $this->modifiedColumns[] = OrderStatusPeer::HAS_COUPON_CODE;
        }

	} 
	
	public function setDepositoryAction($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->depository_action !== $v) {
          $this->depository_action = $v;
          $this->modifiedColumns[] = OrderStatusPeer::DEPOSITORY_ACTION;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatus.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->coupon_code_id = $rs->getInt($startcol + 3);

      $this->opt_name = $rs->getString($startcol + 4);

      $this->opt_description = $rs->getString($startcol + 5);

      $this->type = $rs->getString($startcol + 6);

      $this->is_default = $rs->getBoolean($startcol + 7);

      $this->is_system_default = $rs->getBoolean($startcol + 8);

      $this->has_mail_notification = $rs->getBoolean($startcol + 9);

      $this->has_coupon_code = $rs->getBoolean($startcol + 10);

      $this->depository_action = $rs->getString($startcol + 11);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatus.postHydrate', array('resultset' => $rs, 'startcol' => 12)));

            return $startcol + 12; 
    } catch (Exception $e) {
      throw new PropelException("Error populating OrderStatus object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderStatus:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderStatusPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			OrderStatusPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseOrderStatus:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatus.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseOrderStatus:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(OrderStatusPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(OrderStatusPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderStatusPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatus.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseOrderStatus:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aOrderStatusCouponCode !== null) {
				if ($this->aOrderStatusCouponCode->isModified()) {
					$affectedRows += $this->aOrderStatusCouponCode->save($con);
				}
				$this->setOrderStatusCouponCode($this->aOrderStatusCouponCode);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = OrderStatusPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += OrderStatusPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collOrders !== null) {
				foreach($this->collOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderStatusI18ns !== null) {
				foreach($this->collOrderStatusI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aOrderStatusCouponCode !== null) {
				if (!$this->aOrderStatusCouponCode->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrderStatusCouponCode->getValidationFailures());
				}
			}


			if (($retval = OrderStatusPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collOrders !== null) {
					foreach($this->collOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderStatusI18ns !== null) {
					foreach($this->collOrderStatusI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderStatusPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCouponCodeId();
				break;
			case 4:
				return $this->getOptName();
				break;
			case 5:
				return $this->getOptDescription();
				break;
			case 6:
				return $this->getType();
				break;
			case 7:
				return $this->getIsDefault();
				break;
			case 8:
				return $this->getIsSystemDefault();
				break;
			case 9:
				return $this->getHasMailNotification();
				break;
			case 10:
				return $this->getHasCouponCode();
				break;
			case 11:
				return $this->getDepositoryAction();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderStatusPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCouponCodeId(),
			$keys[4] => $this->getOptName(),
			$keys[5] => $this->getOptDescription(),
			$keys[6] => $this->getType(),
			$keys[7] => $this->getIsDefault(),
			$keys[8] => $this->getIsSystemDefault(),
			$keys[9] => $this->getHasMailNotification(),
			$keys[10] => $this->getHasCouponCode(),
			$keys[11] => $this->getDepositoryAction(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderStatusPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCouponCodeId($value);
				break;
			case 4:
				$this->setOptName($value);
				break;
			case 5:
				$this->setOptDescription($value);
				break;
			case 6:
				$this->setType($value);
				break;
			case 7:
				$this->setIsDefault($value);
				break;
			case 8:
				$this->setIsSystemDefault($value);
				break;
			case 9:
				$this->setHasMailNotification($value);
				break;
			case 10:
				$this->setHasCouponCode($value);
				break;
			case 11:
				$this->setDepositoryAction($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderStatusPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCouponCodeId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptName($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOptDescription($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setType($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setIsDefault($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setIsSystemDefault($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setHasMailNotification($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setHasCouponCode($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setDepositoryAction($arr[$keys[11]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(OrderStatusPeer::DATABASE_NAME);

		if ($this->isColumnModified(OrderStatusPeer::CREATED_AT)) $criteria->add(OrderStatusPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(OrderStatusPeer::UPDATED_AT)) $criteria->add(OrderStatusPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(OrderStatusPeer::ID)) $criteria->add(OrderStatusPeer::ID, $this->id);
		if ($this->isColumnModified(OrderStatusPeer::COUPON_CODE_ID)) $criteria->add(OrderStatusPeer::COUPON_CODE_ID, $this->coupon_code_id);
		if ($this->isColumnModified(OrderStatusPeer::OPT_NAME)) $criteria->add(OrderStatusPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(OrderStatusPeer::OPT_DESCRIPTION)) $criteria->add(OrderStatusPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(OrderStatusPeer::TYPE)) $criteria->add(OrderStatusPeer::TYPE, $this->type);
		if ($this->isColumnModified(OrderStatusPeer::IS_DEFAULT)) $criteria->add(OrderStatusPeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(OrderStatusPeer::IS_SYSTEM_DEFAULT)) $criteria->add(OrderStatusPeer::IS_SYSTEM_DEFAULT, $this->is_system_default);
		if ($this->isColumnModified(OrderStatusPeer::HAS_MAIL_NOTIFICATION)) $criteria->add(OrderStatusPeer::HAS_MAIL_NOTIFICATION, $this->has_mail_notification);
		if ($this->isColumnModified(OrderStatusPeer::HAS_COUPON_CODE)) $criteria->add(OrderStatusPeer::HAS_COUPON_CODE, $this->has_coupon_code);
		if ($this->isColumnModified(OrderStatusPeer::DEPOSITORY_ACTION)) $criteria->add(OrderStatusPeer::DEPOSITORY_ACTION, $this->depository_action);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(OrderStatusPeer::DATABASE_NAME);

		$criteria->add(OrderStatusPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCouponCodeId($this->coupon_code_id);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setType($this->type);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setIsSystemDefault($this->is_system_default);

		$copyObj->setHasMailNotification($this->has_mail_notification);

		$copyObj->setHasCouponCode($this->has_coupon_code);

		$copyObj->setDepositoryAction($this->depository_action);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getOrders() as $relObj) {
				$copyObj->addOrder($relObj->copy($deepCopy));
			}

			foreach($this->getOrderStatusI18ns() as $relObj) {
				$copyObj->addOrderStatusI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new OrderStatusPeer();
		}
		return self::$peer;
	}

	
	public function setOrderStatusCouponCode($v)
	{


		if ($v === null) {
			$this->setCouponCodeId(NULL);
		} else {
			$this->setCouponCodeId($v->getId());
		}


		$this->aOrderStatusCouponCode = $v;
	}


	
	public function getOrderStatusCouponCode($con = null)
	{
		if ($this->aOrderStatusCouponCode === null && ($this->coupon_code_id !== null)) {
						$this->aOrderStatusCouponCode = OrderStatusCouponCodePeer::retrieveByPK($this->coupon_code_id, $con);

			
		}
		return $this->aOrderStatusCouponCode;
	}

	
	public function initOrders()
	{
		if ($this->collOrders === null) {
			$this->collOrders = array();
		}
	}

	
	public function getOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
			   $this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				$this->collOrders = OrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
					$this->collOrders = OrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderCriteria = $criteria;
		return $this->collOrders;
	}

	
	public function countOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

		return OrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrder(Order $l)
	{
		$this->collOrders[] = $l;
		$l->setOrderStatus($this);
	}


	
	public function getOrdersJoinOrderDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataBilling($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinDiscountCouponCode($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinPartner($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_STATUS_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}

	
	public function initOrderStatusI18ns()
	{
		if ($this->collOrderStatusI18ns === null) {
			$this->collOrderStatusI18ns = array();
		}
	}

	
	public function getOrderStatusI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderStatusI18ns === null) {
			if ($this->isNew()) {
			   $this->collOrderStatusI18ns = array();
			} else {

				$criteria->add(OrderStatusI18nPeer::ID, $this->getId());

				OrderStatusI18nPeer::addSelectColumns($criteria);
				$this->collOrderStatusI18ns = OrderStatusI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderStatusI18nPeer::ID, $this->getId());

				OrderStatusI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderStatusI18nCriteria) || !$this->lastOrderStatusI18nCriteria->equals($criteria)) {
					$this->collOrderStatusI18ns = OrderStatusI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderStatusI18nCriteria = $criteria;
		return $this->collOrderStatusI18ns;
	}

	
	public function countOrderStatusI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderStatusI18nPeer::ID, $this->getId());

		return OrderStatusI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderStatusI18n(OrderStatusI18n $l)
	{
		$this->collOrderStatusI18ns[] = $l;
		$l->setOrderStatus($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentOrderStatusI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentOrderStatusI18n()->setName($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentOrderStatusI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentOrderStatusI18n()->setDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentOrderStatusI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = OrderStatusI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setOrderStatusI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setOrderStatusI18nForCulture(new OrderStatusI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setOrderStatusI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addOrderStatusI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'OrderStatus.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseOrderStatus:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseOrderStatus::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 