<?php


abstract class BaseOrderStatusCouponCode extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $discount = 0;


	
	protected $valid_for = 0;

	
	protected $collOrderStatuss;

	
	protected $lastOrderStatusCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getDiscount()
    {

            return null !== $this->discount ? (string)$this->discount : null;
    }

    
    public function getValidFor()
    {

            return $this->valid_for;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = OrderStatusCouponCodePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = OrderStatusCouponCodePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = OrderStatusCouponCodePeer::ID;
        }

	} 
	
	public function setDiscount($v)
	{

        if ($this->discount !== $v || $v === 0) {
          $this->discount = $v;
          $this->modifiedColumns[] = OrderStatusCouponCodePeer::DISCOUNT;
        }

	} 
	
	public function setValidFor($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->valid_for !== $v || $v === 0) {
          $this->valid_for = $v;
          $this->modifiedColumns[] = OrderStatusCouponCodePeer::VALID_FOR;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatusCouponCode.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->discount = $rs->getString($startcol + 3, null);

      $this->discount = $rs->getFloat($startcol + 3);

      $this->valid_for = $rs->getInt($startcol + 4);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatusCouponCode.postHydrate', array('resultset' => $rs, 'startcol' => 5)));

            return $startcol + 5; 
    } catch (Exception $e) {
      throw new PropelException("Error populating OrderStatusCouponCode object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderStatusCouponCode:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderStatusCouponCodePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			OrderStatusCouponCodePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseOrderStatusCouponCode:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatusCouponCode.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseOrderStatusCouponCode:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(OrderStatusCouponCodePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(OrderStatusCouponCodePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderStatusCouponCodePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderStatusCouponCode.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseOrderStatusCouponCode:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = OrderStatusCouponCodePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += OrderStatusCouponCodePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collOrderStatuss !== null) {
				foreach($this->collOrderStatuss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = OrderStatusCouponCodePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collOrderStatuss !== null) {
					foreach($this->collOrderStatuss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderStatusCouponCodePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getDiscount();
				break;
			case 4:
				return $this->getValidFor();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderStatusCouponCodePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getDiscount(),
			$keys[4] => $this->getValidFor(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderStatusCouponCodePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setDiscount($value);
				break;
			case 4:
				$this->setValidFor($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderStatusCouponCodePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setDiscount($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setValidFor($arr[$keys[4]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(OrderStatusCouponCodePeer::DATABASE_NAME);

		if ($this->isColumnModified(OrderStatusCouponCodePeer::CREATED_AT)) $criteria->add(OrderStatusCouponCodePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(OrderStatusCouponCodePeer::UPDATED_AT)) $criteria->add(OrderStatusCouponCodePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(OrderStatusCouponCodePeer::ID)) $criteria->add(OrderStatusCouponCodePeer::ID, $this->id);
		if ($this->isColumnModified(OrderStatusCouponCodePeer::DISCOUNT)) $criteria->add(OrderStatusCouponCodePeer::DISCOUNT, $this->discount);
		if ($this->isColumnModified(OrderStatusCouponCodePeer::VALID_FOR)) $criteria->add(OrderStatusCouponCodePeer::VALID_FOR, $this->valid_for);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(OrderStatusCouponCodePeer::DATABASE_NAME);

		$criteria->add(OrderStatusCouponCodePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setDiscount($this->discount);

		$copyObj->setValidFor($this->valid_for);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getOrderStatuss() as $relObj) {
				$copyObj->addOrderStatus($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new OrderStatusCouponCodePeer();
		}
		return self::$peer;
	}

	
	public function initOrderStatuss()
	{
		if ($this->collOrderStatuss === null) {
			$this->collOrderStatuss = array();
		}
	}

	
	public function getOrderStatuss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderStatuss === null) {
			if ($this->isNew()) {
			   $this->collOrderStatuss = array();
			} else {

				$criteria->add(OrderStatusPeer::COUPON_CODE_ID, $this->getId());

				OrderStatusPeer::addSelectColumns($criteria);
				$this->collOrderStatuss = OrderStatusPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderStatusPeer::COUPON_CODE_ID, $this->getId());

				OrderStatusPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderStatusCriteria) || !$this->lastOrderStatusCriteria->equals($criteria)) {
					$this->collOrderStatuss = OrderStatusPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderStatusCriteria = $criteria;
		return $this->collOrderStatuss;
	}

	
	public function countOrderStatuss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderStatusPeer::COUPON_CODE_ID, $this->getId());

		return OrderStatusPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderStatus(OrderStatus $l)
	{
		$this->collOrderStatuss[] = $l;
		$l->setOrderStatusCouponCode($this);
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'OrderStatusCouponCode.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseOrderStatusCouponCode:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseOrderStatusCouponCode::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 