<?php


abstract class BaseOrderUserDataBilling extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $countries_id;


	
	protected $country;


	
	protected $full_name;


	
	protected $address;


	
	protected $address_more;


	
	protected $region;


	
	protected $name;


	
	protected $surname;


	
	protected $street;


	
	protected $house;


	
	protected $flat;


	
	protected $code;


	
	protected $town;


	
	protected $phone;


	
	protected $company;


	
	protected $vat_number;


	
	protected $crypt = false;

	
	protected $aCountries;

	
	protected $collOrders;

	
	protected $lastOrderCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCountriesId()
    {

            return $this->countries_id;
    }

    
    public function getCountry()
    {

            return $this->country;
    }

    
    public function getFullName()
    {

            return $this->full_name;
    }

    
    public function getAddress()
    {

            return $this->address;
    }

    
    public function getAddressMore()
    {

            return $this->address_more;
    }

    
    public function getRegion()
    {

            return $this->region;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getSurname()
    {

            return $this->surname;
    }

    
    public function getStreet()
    {

            return $this->street;
    }

    
    public function getHouse()
    {

            return $this->house;
    }

    
    public function getFlat()
    {

            return $this->flat;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getTown()
    {

            return $this->town;
    }

    
    public function getPhone()
    {

            return $this->phone;
    }

    
    public function getCompany()
    {

            return $this->company;
    }

    
    public function getVatNumber()
    {

            return $this->vat_number;
    }

    
    public function getCrypt()
    {

            return $this->crypt;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = OrderUserDataBillingPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = OrderUserDataBillingPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::ID;
        }

	} 
	
	public function setCountriesId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->countries_id !== $v) {
          $this->countries_id = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::COUNTRIES_ID;
        }

		if ($this->aCountries !== null && $this->aCountries->getId() !== $v) {
			$this->aCountries = null;
		}

	} 
	
	public function setCountry($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->country !== $v) {
          $this->country = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::COUNTRY;
        }

	} 
	
	public function setFullName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->full_name !== $v) {
          $this->full_name = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::FULL_NAME;
        }

	} 
	
	public function setAddress($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->address !== $v) {
          $this->address = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::ADDRESS;
        }

	} 
	
	public function setAddressMore($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->address_more !== $v) {
          $this->address_more = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::ADDRESS_MORE;
        }

	} 
	
	public function setRegion($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->region !== $v) {
          $this->region = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::REGION;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::NAME;
        }

	} 
	
	public function setSurname($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->surname !== $v) {
          $this->surname = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::SURNAME;
        }

	} 
	
	public function setStreet($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->street !== $v) {
          $this->street = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::STREET;
        }

	} 
	
	public function setHouse($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->house !== $v) {
          $this->house = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::HOUSE;
        }

	} 
	
	public function setFlat($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->flat !== $v) {
          $this->flat = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::FLAT;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::CODE;
        }

	} 
	
	public function setTown($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->town !== $v) {
          $this->town = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::TOWN;
        }

	} 
	
	public function setPhone($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->phone !== $v) {
          $this->phone = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::PHONE;
        }

	} 
	
	public function setCompany($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->company !== $v) {
          $this->company = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::COMPANY;
        }

	} 
	
	public function setVatNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->vat_number !== $v) {
          $this->vat_number = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::VAT_NUMBER;
        }

	} 
	
	public function setCrypt($v)
	{

        if ($this->crypt !== $v || $v === false) {
          $this->crypt = $v;
          $this->modifiedColumns[] = OrderUserDataBillingPeer::CRYPT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'OrderUserDataBilling.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->countries_id = $rs->getInt($startcol + 3);

      $this->country = $rs->getString($startcol + 4);

      $this->full_name = $rs->getString($startcol + 5);

      $this->address = $rs->getString($startcol + 6);

      $this->address_more = $rs->getString($startcol + 7);

      $this->region = $rs->getString($startcol + 8);

      $this->name = $rs->getString($startcol + 9);

      $this->surname = $rs->getString($startcol + 10);

      $this->street = $rs->getString($startcol + 11);

      $this->house = $rs->getString($startcol + 12);

      $this->flat = $rs->getString($startcol + 13);

      $this->code = $rs->getString($startcol + 14);

      $this->town = $rs->getString($startcol + 15);

      $this->phone = $rs->getString($startcol + 16);

      $this->company = $rs->getString($startcol + 17);

      $this->vat_number = $rs->getString($startcol + 18);

      $this->crypt = $rs->getBoolean($startcol + 19);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'OrderUserDataBilling.postHydrate', array('resultset' => $rs, 'startcol' => 20)));

            return $startcol + 20; 
    } catch (Exception $e) {
      throw new PropelException("Error populating OrderUserDataBilling object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderUserDataBilling:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderUserDataBillingPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			OrderUserDataBillingPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseOrderUserDataBilling:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderUserDataBilling.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseOrderUserDataBilling:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(OrderUserDataBillingPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(OrderUserDataBillingPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderUserDataBillingPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'OrderUserDataBilling.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseOrderUserDataBilling:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aCountries !== null) {
				if ($this->aCountries->isModified() || $this->aCountries->getCurrentCountriesI18n()->isModified()) {
					$affectedRows += $this->aCountries->save($con);
				}
				$this->setCountries($this->aCountries);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = OrderUserDataBillingPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += OrderUserDataBillingPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collOrders !== null) {
				foreach($this->collOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aCountries !== null) {
				if (!$this->aCountries->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCountries->getValidationFailures());
				}
			}


			if (($retval = OrderUserDataBillingPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collOrders !== null) {
					foreach($this->collOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderUserDataBillingPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCountriesId();
				break;
			case 4:
				return $this->getCountry();
				break;
			case 5:
				return $this->getFullName();
				break;
			case 6:
				return $this->getAddress();
				break;
			case 7:
				return $this->getAddressMore();
				break;
			case 8:
				return $this->getRegion();
				break;
			case 9:
				return $this->getName();
				break;
			case 10:
				return $this->getSurname();
				break;
			case 11:
				return $this->getStreet();
				break;
			case 12:
				return $this->getHouse();
				break;
			case 13:
				return $this->getFlat();
				break;
			case 14:
				return $this->getCode();
				break;
			case 15:
				return $this->getTown();
				break;
			case 16:
				return $this->getPhone();
				break;
			case 17:
				return $this->getCompany();
				break;
			case 18:
				return $this->getVatNumber();
				break;
			case 19:
				return $this->getCrypt();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderUserDataBillingPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCountriesId(),
			$keys[4] => $this->getCountry(),
			$keys[5] => $this->getFullName(),
			$keys[6] => $this->getAddress(),
			$keys[7] => $this->getAddressMore(),
			$keys[8] => $this->getRegion(),
			$keys[9] => $this->getName(),
			$keys[10] => $this->getSurname(),
			$keys[11] => $this->getStreet(),
			$keys[12] => $this->getHouse(),
			$keys[13] => $this->getFlat(),
			$keys[14] => $this->getCode(),
			$keys[15] => $this->getTown(),
			$keys[16] => $this->getPhone(),
			$keys[17] => $this->getCompany(),
			$keys[18] => $this->getVatNumber(),
			$keys[19] => $this->getCrypt(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderUserDataBillingPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCountriesId($value);
				break;
			case 4:
				$this->setCountry($value);
				break;
			case 5:
				$this->setFullName($value);
				break;
			case 6:
				$this->setAddress($value);
				break;
			case 7:
				$this->setAddressMore($value);
				break;
			case 8:
				$this->setRegion($value);
				break;
			case 9:
				$this->setName($value);
				break;
			case 10:
				$this->setSurname($value);
				break;
			case 11:
				$this->setStreet($value);
				break;
			case 12:
				$this->setHouse($value);
				break;
			case 13:
				$this->setFlat($value);
				break;
			case 14:
				$this->setCode($value);
				break;
			case 15:
				$this->setTown($value);
				break;
			case 16:
				$this->setPhone($value);
				break;
			case 17:
				$this->setCompany($value);
				break;
			case 18:
				$this->setVatNumber($value);
				break;
			case 19:
				$this->setCrypt($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderUserDataBillingPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCountriesId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setCountry($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setFullName($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setAddress($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setAddressMore($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setRegion($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setName($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setSurname($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setStreet($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setHouse($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setFlat($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setCode($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setTown($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setPhone($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setCompany($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setVatNumber($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setCrypt($arr[$keys[19]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(OrderUserDataBillingPeer::DATABASE_NAME);

		if ($this->isColumnModified(OrderUserDataBillingPeer::CREATED_AT)) $criteria->add(OrderUserDataBillingPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(OrderUserDataBillingPeer::UPDATED_AT)) $criteria->add(OrderUserDataBillingPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(OrderUserDataBillingPeer::ID)) $criteria->add(OrderUserDataBillingPeer::ID, $this->id);
		if ($this->isColumnModified(OrderUserDataBillingPeer::COUNTRIES_ID)) $criteria->add(OrderUserDataBillingPeer::COUNTRIES_ID, $this->countries_id);
		if ($this->isColumnModified(OrderUserDataBillingPeer::COUNTRY)) $criteria->add(OrderUserDataBillingPeer::COUNTRY, $this->country);
		if ($this->isColumnModified(OrderUserDataBillingPeer::FULL_NAME)) $criteria->add(OrderUserDataBillingPeer::FULL_NAME, $this->full_name);
		if ($this->isColumnModified(OrderUserDataBillingPeer::ADDRESS)) $criteria->add(OrderUserDataBillingPeer::ADDRESS, $this->address);
		if ($this->isColumnModified(OrderUserDataBillingPeer::ADDRESS_MORE)) $criteria->add(OrderUserDataBillingPeer::ADDRESS_MORE, $this->address_more);
		if ($this->isColumnModified(OrderUserDataBillingPeer::REGION)) $criteria->add(OrderUserDataBillingPeer::REGION, $this->region);
		if ($this->isColumnModified(OrderUserDataBillingPeer::NAME)) $criteria->add(OrderUserDataBillingPeer::NAME, $this->name);
		if ($this->isColumnModified(OrderUserDataBillingPeer::SURNAME)) $criteria->add(OrderUserDataBillingPeer::SURNAME, $this->surname);
		if ($this->isColumnModified(OrderUserDataBillingPeer::STREET)) $criteria->add(OrderUserDataBillingPeer::STREET, $this->street);
		if ($this->isColumnModified(OrderUserDataBillingPeer::HOUSE)) $criteria->add(OrderUserDataBillingPeer::HOUSE, $this->house);
		if ($this->isColumnModified(OrderUserDataBillingPeer::FLAT)) $criteria->add(OrderUserDataBillingPeer::FLAT, $this->flat);
		if ($this->isColumnModified(OrderUserDataBillingPeer::CODE)) $criteria->add(OrderUserDataBillingPeer::CODE, $this->code);
		if ($this->isColumnModified(OrderUserDataBillingPeer::TOWN)) $criteria->add(OrderUserDataBillingPeer::TOWN, $this->town);
		if ($this->isColumnModified(OrderUserDataBillingPeer::PHONE)) $criteria->add(OrderUserDataBillingPeer::PHONE, $this->phone);
		if ($this->isColumnModified(OrderUserDataBillingPeer::COMPANY)) $criteria->add(OrderUserDataBillingPeer::COMPANY, $this->company);
		if ($this->isColumnModified(OrderUserDataBillingPeer::VAT_NUMBER)) $criteria->add(OrderUserDataBillingPeer::VAT_NUMBER, $this->vat_number);
		if ($this->isColumnModified(OrderUserDataBillingPeer::CRYPT)) $criteria->add(OrderUserDataBillingPeer::CRYPT, $this->crypt);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(OrderUserDataBillingPeer::DATABASE_NAME);

		$criteria->add(OrderUserDataBillingPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCountriesId($this->countries_id);

		$copyObj->setCountry($this->country);

		$copyObj->setFullName($this->full_name);

		$copyObj->setAddress($this->address);

		$copyObj->setAddressMore($this->address_more);

		$copyObj->setRegion($this->region);

		$copyObj->setName($this->name);

		$copyObj->setSurname($this->surname);

		$copyObj->setStreet($this->street);

		$copyObj->setHouse($this->house);

		$copyObj->setFlat($this->flat);

		$copyObj->setCode($this->code);

		$copyObj->setTown($this->town);

		$copyObj->setPhone($this->phone);

		$copyObj->setCompany($this->company);

		$copyObj->setVatNumber($this->vat_number);

		$copyObj->setCrypt($this->crypt);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getOrders() as $relObj) {
				$copyObj->addOrder($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new OrderUserDataBillingPeer();
		}
		return self::$peer;
	}

	
	public function setCountries($v)
	{


		if ($v === null) {
			$this->setCountriesId(NULL);
		} else {
			$this->setCountriesId($v->getId());
		}


		$this->aCountries = $v;
	}


	
	public function getCountries($con = null)
	{
		if ($this->aCountries === null && ($this->countries_id !== null)) {
						$this->aCountries = CountriesPeer::retrieveByPK($this->countries_id, $con);

			
		}
		return $this->aCountries;
	}

	
	public function initOrders()
	{
		if ($this->collOrders === null) {
			$this->collOrders = array();
		}
	}

	
	public function getOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
			   $this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				$this->collOrders = OrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
					$this->collOrders = OrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderCriteria = $criteria;
		return $this->collOrders;
	}

	
	public function countOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

		return OrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrder(Order $l)
	{
		$this->collOrders[] = $l;
		$l->setOrderUserDataBilling($this);
	}


	
	public function getOrdersJoinOrderDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderStatus($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinDiscountCouponCode($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinPartner($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::ORDER_USER_DATA_BILLING_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'OrderUserDataBilling.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseOrderUserDataBilling:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseOrderUserDataBilling::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 