<?php


abstract class BasePayment extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_guard_user_id;


	
	protected $payment_type_id;


	
	protected $amount;


	
	protected $status = false;


	
	protected $cancel = false;


	
	protected $hash;


	
	protected $payed_at;


	
	protected $version;


	
	protected $gift_card_id;

	
	protected $asfGuardUser;

	
	protected $aPaymentType;

	
	protected $aGiftCard;

	
	protected $collOrderHasPayments;

	
	protected $lastOrderHasPaymentCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getPaymentTypeId()
    {

            return $this->payment_type_id;
    }

    
    public function getAmount()
    {

            return null !== $this->amount ? (string)$this->amount : null;
    }

    
    public function getStatus()
    {

            return $this->status;
    }

    
    public function getCancel()
    {

            return $this->cancel;
    }

    
    public function getHash()
    {

            return $this->hash;
    }

	
	public function getPayedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->payed_at === null || $this->payed_at === '') {
			return null;
		} elseif (!is_int($this->payed_at)) {
						$ts = strtotime($this->payed_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [payed_at] as date/time value: " . var_export($this->payed_at, true));
			}
		} else {
			$ts = $this->payed_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getVersion()
    {

            return $this->version;
    }

    
    public function getGiftCardId()
    {

            return $this->gift_card_id;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = PaymentPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = PaymentPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = PaymentPeer::ID;
        }

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = PaymentPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setPaymentTypeId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->payment_type_id !== $v) {
          $this->payment_type_id = $v;
          $this->modifiedColumns[] = PaymentPeer::PAYMENT_TYPE_ID;
        }

		if ($this->aPaymentType !== null && $this->aPaymentType->getId() !== $v) {
			$this->aPaymentType = null;
		}

	} 
	
	public function setAmount($v)
	{

        if ($this->amount !== $v) {
          $this->amount = $v;
          $this->modifiedColumns[] = PaymentPeer::AMOUNT;
        }

	} 
	
	public function setStatus($v)
	{

        if ($this->status !== $v || $v === false) {
          $this->status = $v;
          $this->modifiedColumns[] = PaymentPeer::STATUS;
        }

	} 
	
	public function setCancel($v)
	{

        if ($this->cancel !== $v || $v === false) {
          $this->cancel = $v;
          $this->modifiedColumns[] = PaymentPeer::CANCEL;
        }

	} 
	
	public function setHash($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->hash !== $v) {
          $this->hash = $v;
          $this->modifiedColumns[] = PaymentPeer::HASH;
        }

	} 
	
	public function setPayedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [payed_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->payed_at !== $ts) {
			$this->payed_at = $ts;
			$this->modifiedColumns[] = PaymentPeer::PAYED_AT;
		}

	} 
	
	public function setVersion($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->version !== $v) {
          $this->version = $v;
          $this->modifiedColumns[] = PaymentPeer::VERSION;
        }

	} 
	
	public function setGiftCardId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->gift_card_id !== $v) {
          $this->gift_card_id = $v;
          $this->modifiedColumns[] = PaymentPeer::GIFT_CARD_ID;
        }

		if ($this->aGiftCard !== null && $this->aGiftCard->getId() !== $v) {
			$this->aGiftCard = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Payment.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_guard_user_id = $rs->getInt($startcol + 3);

      $this->payment_type_id = $rs->getInt($startcol + 4);

      $this->amount = $rs->getString($startcol + 5, null);

      $this->amount = $rs->getFloat($startcol + 5);

      $this->status = $rs->getBoolean($startcol + 6);

      $this->cancel = $rs->getBoolean($startcol + 7);

      $this->hash = $rs->getString($startcol + 8);

      $this->payed_at = $rs->getTimestamp($startcol + 9, null);

      $this->version = $rs->getInt($startcol + 10);

      $this->gift_card_id = $rs->getInt($startcol + 11);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Payment.postHydrate', array('resultset' => $rs, 'startcol' => 12)));

            return $startcol + 12; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Payment object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BasePayment:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PaymentPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			PaymentPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BasePayment:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Payment.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BasePayment:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(PaymentPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(PaymentPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PaymentPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Payment.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BasePayment:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}

			if ($this->aPaymentType !== null) {
				if ($this->aPaymentType->isModified() || $this->aPaymentType->getCurrentPaymentTypeI18n()->isModified()) {
					$affectedRows += $this->aPaymentType->save($con);
				}
				$this->setPaymentType($this->aPaymentType);
			}

			if ($this->aGiftCard !== null) {
				if ($this->aGiftCard->isModified()) {
					$affectedRows += $this->aGiftCard->save($con);
				}
				$this->setGiftCard($this->aGiftCard);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = PaymentPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += PaymentPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collOrderHasPayments !== null) {
				foreach($this->collOrderHasPayments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}

			if ($this->aPaymentType !== null) {
				if (!$this->aPaymentType->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aPaymentType->getValidationFailures());
				}
			}

			if ($this->aGiftCard !== null) {
				if (!$this->aGiftCard->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aGiftCard->getValidationFailures());
				}
			}


			if (($retval = PaymentPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collOrderHasPayments !== null) {
					foreach($this->collOrderHasPayments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PaymentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfGuardUserId();
				break;
			case 4:
				return $this->getPaymentTypeId();
				break;
			case 5:
				return $this->getAmount();
				break;
			case 6:
				return $this->getStatus();
				break;
			case 7:
				return $this->getCancel();
				break;
			case 8:
				return $this->getHash();
				break;
			case 9:
				return $this->getPayedAt();
				break;
			case 10:
				return $this->getVersion();
				break;
			case 11:
				return $this->getGiftCardId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PaymentPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfGuardUserId(),
			$keys[4] => $this->getPaymentTypeId(),
			$keys[5] => $this->getAmount(),
			$keys[6] => $this->getStatus(),
			$keys[7] => $this->getCancel(),
			$keys[8] => $this->getHash(),
			$keys[9] => $this->getPayedAt(),
			$keys[10] => $this->getVersion(),
			$keys[11] => $this->getGiftCardId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PaymentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfGuardUserId($value);
				break;
			case 4:
				$this->setPaymentTypeId($value);
				break;
			case 5:
				$this->setAmount($value);
				break;
			case 6:
				$this->setStatus($value);
				break;
			case 7:
				$this->setCancel($value);
				break;
			case 8:
				$this->setHash($value);
				break;
			case 9:
				$this->setPayedAt($value);
				break;
			case 10:
				$this->setVersion($value);
				break;
			case 11:
				$this->setGiftCardId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PaymentPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfGuardUserId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setPaymentTypeId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setAmount($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setStatus($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setCancel($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setHash($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setPayedAt($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setVersion($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setGiftCardId($arr[$keys[11]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(PaymentPeer::DATABASE_NAME);

		if ($this->isColumnModified(PaymentPeer::CREATED_AT)) $criteria->add(PaymentPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(PaymentPeer::UPDATED_AT)) $criteria->add(PaymentPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(PaymentPeer::ID)) $criteria->add(PaymentPeer::ID, $this->id);
		if ($this->isColumnModified(PaymentPeer::SF_GUARD_USER_ID)) $criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(PaymentPeer::PAYMENT_TYPE_ID)) $criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->payment_type_id);
		if ($this->isColumnModified(PaymentPeer::AMOUNT)) $criteria->add(PaymentPeer::AMOUNT, $this->amount);
		if ($this->isColumnModified(PaymentPeer::STATUS)) $criteria->add(PaymentPeer::STATUS, $this->status);
		if ($this->isColumnModified(PaymentPeer::CANCEL)) $criteria->add(PaymentPeer::CANCEL, $this->cancel);
		if ($this->isColumnModified(PaymentPeer::HASH)) $criteria->add(PaymentPeer::HASH, $this->hash);
		if ($this->isColumnModified(PaymentPeer::PAYED_AT)) $criteria->add(PaymentPeer::PAYED_AT, $this->payed_at);
		if ($this->isColumnModified(PaymentPeer::VERSION)) $criteria->add(PaymentPeer::VERSION, $this->version);
		if ($this->isColumnModified(PaymentPeer::GIFT_CARD_ID)) $criteria->add(PaymentPeer::GIFT_CARD_ID, $this->gift_card_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(PaymentPeer::DATABASE_NAME);

		$criteria->add(PaymentPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setPaymentTypeId($this->payment_type_id);

		$copyObj->setAmount($this->amount);

		$copyObj->setStatus($this->status);

		$copyObj->setCancel($this->cancel);

		$copyObj->setHash($this->hash);

		$copyObj->setPayedAt($this->payed_at);

		$copyObj->setVersion($this->version);

		$copyObj->setGiftCardId($this->gift_card_id);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getOrderHasPayments() as $relObj) {
				$copyObj->addOrderHasPayment($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new PaymentPeer();
		}
		return self::$peer;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function setPaymentType($v)
	{


		if ($v === null) {
			$this->setPaymentTypeId(NULL);
		} else {
			$this->setPaymentTypeId($v->getId());
		}


		$this->aPaymentType = $v;
	}


	
	public function getPaymentType($con = null)
	{
		if ($this->aPaymentType === null && ($this->payment_type_id !== null)) {
						$this->aPaymentType = PaymentTypePeer::retrieveByPK($this->payment_type_id, $con);

			
		}
		return $this->aPaymentType;
	}

	
	public function setGiftCard($v)
	{


		if ($v === null) {
			$this->setGiftCardId(NULL);
		} else {
			$this->setGiftCardId($v->getId());
		}


		$this->aGiftCard = $v;
	}


	
	public function getGiftCard($con = null)
	{
		if ($this->aGiftCard === null && ($this->gift_card_id !== null)) {
						$this->aGiftCard = GiftCardPeer::retrieveByPK($this->gift_card_id, $con);

			
		}
		return $this->aGiftCard;
	}

	
	public function initOrderHasPayments()
	{
		if ($this->collOrderHasPayments === null) {
			$this->collOrderHasPayments = array();
		}
	}

	
	public function getOrderHasPayments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderHasPayments === null) {
			if ($this->isNew()) {
			   $this->collOrderHasPayments = array();
			} else {

				$criteria->add(OrderHasPaymentPeer::PAYMENT_ID, $this->getId());

				OrderHasPaymentPeer::addSelectColumns($criteria);
				$this->collOrderHasPayments = OrderHasPaymentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderHasPaymentPeer::PAYMENT_ID, $this->getId());

				OrderHasPaymentPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderHasPaymentCriteria) || !$this->lastOrderHasPaymentCriteria->equals($criteria)) {
					$this->collOrderHasPayments = OrderHasPaymentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderHasPaymentCriteria = $criteria;
		return $this->collOrderHasPayments;
	}

	
	public function countOrderHasPayments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderHasPaymentPeer::PAYMENT_ID, $this->getId());

		return OrderHasPaymentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderHasPayment(OrderHasPayment $l)
	{
		$this->collOrderHasPayments[] = $l;
		$l->setPayment($this);
	}


	
	public function getOrderHasPaymentsJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderHasPayments === null) {
			if ($this->isNew()) {
				$this->collOrderHasPayments = array();
			} else {

				$criteria->add(OrderHasPaymentPeer::PAYMENT_ID, $this->getId());

				$this->collOrderHasPayments = OrderHasPaymentPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderHasPaymentPeer::PAYMENT_ID, $this->getId());

			if (!isset($this->lastOrderHasPaymentCriteria) || !$this->lastOrderHasPaymentCriteria->equals($criteria)) {
				$this->collOrderHasPayments = OrderHasPaymentPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastOrderHasPaymentCriteria = $criteria;

		return $this->collOrderHasPayments;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Payment.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BasePayment:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BasePayment::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 