<?php


abstract class BasePaymentPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_payment';

	
	const CLASS_DEFAULT = 'lib.model.Payment';

	
	const NUM_COLUMNS = 12;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_payment.CREATED_AT';

	
	const UPDATED_AT = 'st_payment.UPDATED_AT';

	
	const ID = 'st_payment.ID';

	
	const SF_GUARD_USER_ID = 'st_payment.SF_GUARD_USER_ID';

	
	const PAYMENT_TYPE_ID = 'st_payment.PAYMENT_TYPE_ID';

	
	const AMOUNT = 'st_payment.AMOUNT';

	
	const STATUS = 'st_payment.STATUS';

	
	const CANCEL = 'st_payment.CANCEL';

	
	const HASH = 'st_payment.HASH';

	
	const PAYED_AT = 'st_payment.PAYED_AT';

	
	const VERSION = 'st_payment.VERSION';

	
	const GIFT_CARD_ID = 'st_payment.GIFT_CARD_ID';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'SfGuardUserId', 'PaymentTypeId', 'Amount', 'Status', 'Cancel', 'Hash', 'PayedAt', 'Version', 'GiftCardId', ),
		BasePeer::TYPE_COLNAME => array (PaymentPeer::CREATED_AT, PaymentPeer::UPDATED_AT, PaymentPeer::ID, PaymentPeer::SF_GUARD_USER_ID, PaymentPeer::PAYMENT_TYPE_ID, PaymentPeer::AMOUNT, PaymentPeer::STATUS, PaymentPeer::CANCEL, PaymentPeer::HASH, PaymentPeer::PAYED_AT, PaymentPeer::VERSION, PaymentPeer::GIFT_CARD_ID, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'sf_guard_user_id', 'payment_type_id', 'amount', 'status', 'cancel', 'hash', 'payed_at', 'version', 'gift_card_id', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'SfGuardUserId' => 3, 'PaymentTypeId' => 4, 'Amount' => 5, 'Status' => 6, 'Cancel' => 7, 'Hash' => 8, 'PayedAt' => 9, 'Version' => 10, 'GiftCardId' => 11, ),
		BasePeer::TYPE_COLNAME => array (PaymentPeer::CREATED_AT => 0, PaymentPeer::UPDATED_AT => 1, PaymentPeer::ID => 2, PaymentPeer::SF_GUARD_USER_ID => 3, PaymentPeer::PAYMENT_TYPE_ID => 4, PaymentPeer::AMOUNT => 5, PaymentPeer::STATUS => 6, PaymentPeer::CANCEL => 7, PaymentPeer::HASH => 8, PaymentPeer::PAYED_AT => 9, PaymentPeer::VERSION => 10, PaymentPeer::GIFT_CARD_ID => 11, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'sf_guard_user_id' => 3, 'payment_type_id' => 4, 'amount' => 5, 'status' => 6, 'cancel' => 7, 'hash' => 8, 'payed_at' => 9, 'version' => 10, 'gift_card_id' => 11, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('lib.model.map.PaymentMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = PaymentPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(PaymentPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(PaymentPeer::CREATED_AT);

		$criteria->addSelectColumn(PaymentPeer::UPDATED_AT);

		$criteria->addSelectColumn(PaymentPeer::ID);

		$criteria->addSelectColumn(PaymentPeer::SF_GUARD_USER_ID);

		$criteria->addSelectColumn(PaymentPeer::PAYMENT_TYPE_ID);

		$criteria->addSelectColumn(PaymentPeer::AMOUNT);

		$criteria->addSelectColumn(PaymentPeer::STATUS);

		$criteria->addSelectColumn(PaymentPeer::CANCEL);

		$criteria->addSelectColumn(PaymentPeer::HASH);

		$criteria->addSelectColumn(PaymentPeer::PAYED_AT);

		$criteria->addSelectColumn(PaymentPeer::VERSION);

		$criteria->addSelectColumn(PaymentPeer::GIFT_CARD_ID);

	}

	const COUNT = 'COUNT(st_payment.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_payment.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = PaymentPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return PaymentPeer::populateObjects(PaymentPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BasePaymentPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BasePaymentPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			PaymentPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = PaymentPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinsfGuardUser(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinPaymentType(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinGiftCard(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinsfGuardUser(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentPeer::addSelectColumns($c);
		$startcol = (PaymentPeer::NUM_COLUMNS - PaymentPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		sfGuardUserPeer::addSelectColumns($c);

		$c->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = PaymentPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getSfGuardUserId())
                        {

			   $omClass = sfGuardUserPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addPayment($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinPaymentType(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentPeer::addSelectColumns($c);
		$startcol = (PaymentPeer::NUM_COLUMNS - PaymentPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		PaymentTypePeer::addSelectColumns($c);

		$c->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = PaymentPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getPaymentTypeId())
                        {

			   $omClass = PaymentTypePeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addPayment($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinGiftCard(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentPeer::addSelectColumns($c);
		$startcol = (PaymentPeer::NUM_COLUMNS - PaymentPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		GiftCardPeer::addSelectColumns($c);

		$c->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = PaymentPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getGiftCardId())
                        {

			   $omClass = GiftCardPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addPayment($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

		$criteria->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentPeer::addSelectColumns($c);
		$startcol2 = (PaymentPeer::NUM_COLUMNS - PaymentPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfGuardUserPeer::NUM_COLUMNS;

		PaymentTypePeer::addSelectColumns($c);
		$startcol4 = $startcol3 + PaymentTypePeer::NUM_COLUMNS;

		GiftCardPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + GiftCardPeer::NUM_COLUMNS;

		$c->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

		$c->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = PaymentPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addPayment($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initPayments();
				$obj2->addPayment($obj1);
			}


					
			$omClass = PaymentTypePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3 = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getPaymentType(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addPayment($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj3->initPayments();
				$obj3->addPayment($obj1);
			}


					
			$omClass = GiftCardPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4 = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getGiftCard(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addPayment($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj4->initPayments();
				$obj4->addPayment($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doCountJoinAllExceptsfGuardUser(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptPaymentType(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

		$criteria->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptGiftCard(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(PaymentPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(PaymentPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

		$criteria->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);

		$rs = PaymentPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAllExceptsfGuardUser(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentPeer::addSelectColumns($c);
		$startcol2 = (PaymentPeer::NUM_COLUMNS - PaymentPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		PaymentTypePeer::addSelectColumns($c);
		$startcol3 = $startcol2 + PaymentTypePeer::NUM_COLUMNS;

		GiftCardPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + GiftCardPeer::NUM_COLUMNS;

		$c->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = PaymentPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = PaymentTypePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getPaymentType(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addPayment($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initPayments();
				$obj2->addPayment($obj1);
			}

			$omClass = GiftCardPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getGiftCard(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addPayment($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initPayments();
				$obj3->addPayment($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptPaymentType(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentPeer::addSelectColumns($c);
		$startcol2 = (PaymentPeer::NUM_COLUMNS - PaymentPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfGuardUserPeer::NUM_COLUMNS;

		GiftCardPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + GiftCardPeer::NUM_COLUMNS;

		$c->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

		$c->addJoin(PaymentPeer::GIFT_CARD_ID, GiftCardPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = PaymentPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addPayment($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initPayments();
				$obj2->addPayment($obj1);
			}

			$omClass = GiftCardPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getGiftCard(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addPayment($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initPayments();
				$obj3->addPayment($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptGiftCard(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		PaymentPeer::addSelectColumns($c);
		$startcol2 = (PaymentPeer::NUM_COLUMNS - PaymentPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfGuardUserPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfGuardUserPeer::NUM_COLUMNS;

		PaymentTypePeer::addSelectColumns($c);
		$startcol4 = $startcol3 + PaymentTypePeer::NUM_COLUMNS;

		$c->addJoin(PaymentPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID);

		$c->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = PaymentPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = sfGuardUserPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfGuardUser(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addPayment($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initPayments();
				$obj2->addPayment($obj1);
			}

			$omClass = PaymentTypePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getPaymentType(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addPayment($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initPayments();
				$obj3->addPayment($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return PaymentPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BasePaymentPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BasePaymentPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(PaymentPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BasePaymentPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BasePaymentPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BasePaymentPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BasePaymentPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(PaymentPeer::ID);
			$selectCriteria->add(PaymentPeer::ID, $criteria->remove(PaymentPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BasePaymentPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BasePaymentPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += PaymentPeer::doOnDeleteCascade(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(PaymentPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(PaymentPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof Payment) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(PaymentPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += PaymentPeer::doOnDeleteCascade($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = PaymentPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(OrderHasPaymentPeer::PAYMENT_ID, $obj->getId());
			$affectedRows += OrderHasPaymentPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	public static function doValidate(Payment $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(PaymentPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(PaymentPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(PaymentPeer::DATABASE_NAME, PaymentPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = PaymentPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(PaymentPeer::DATABASE_NAME);

		$criteria->add(PaymentPeer::ID, $pk);


		$v = PaymentPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(PaymentPeer::ID, $pks, Criteria::IN);
			$objs = PaymentPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BasePaymentPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('lib.model.map.PaymentMapBuilder');
}
