<?php


abstract class BasePaymentType extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $module_name;


	
	protected $active;


	
	protected $image;


	
	protected $opt_name;


	
	protected $opt_description;

	
	protected $collTrustedShopsHasPaymentTypes;

	
	protected $lastTrustedShopsHasPaymentTypeCriteria = null;

	
	protected $collPayments;

	
	protected $lastPaymentCriteria = null;

	
	protected $collPaymentTypeI18ns;

	
	protected $lastPaymentTypeI18nCriteria = null;

	
	protected $collDeliveryHasPaymentTypes;

	
	protected $lastDeliveryHasPaymentTypeCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getModuleName()
    {

            return $this->module_name;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getImage()
    {

            return $this->image;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = PaymentTypePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = PaymentTypePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = PaymentTypePeer::ID;
        }

	} 
	
	public function setModuleName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->module_name !== $v) {
          $this->module_name = $v;
          $this->modifiedColumns[] = PaymentTypePeer::MODULE_NAME;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v) {
          $this->active = $v;
          $this->modifiedColumns[] = PaymentTypePeer::ACTIVE;
        }

	} 
	
	public function setImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->image !== $v) {
          $this->image = $v;
          $this->modifiedColumns[] = PaymentTypePeer::IMAGE;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = PaymentTypePeer::OPT_NAME;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = PaymentTypePeer::OPT_DESCRIPTION;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'PaymentType.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->module_name = $rs->getString($startcol + 3);

      $this->active = $rs->getBoolean($startcol + 4);

      $this->image = $rs->getString($startcol + 5);

      $this->opt_name = $rs->getString($startcol + 6);

      $this->opt_description = $rs->getString($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'PaymentType.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating PaymentType object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BasePaymentType:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PaymentTypePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			PaymentTypePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BasePaymentType:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'PaymentType.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BasePaymentType:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(PaymentTypePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(PaymentTypePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PaymentTypePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'PaymentType.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BasePaymentType:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = PaymentTypePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += PaymentTypePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collTrustedShopsHasPaymentTypes !== null) {
				foreach($this->collTrustedShopsHasPaymentTypes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPayments !== null) {
				foreach($this->collPayments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPaymentTypeI18ns !== null) {
				foreach($this->collPaymentTypeI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDeliveryHasPaymentTypes !== null) {
				foreach($this->collDeliveryHasPaymentTypes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = PaymentTypePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collTrustedShopsHasPaymentTypes !== null) {
					foreach($this->collTrustedShopsHasPaymentTypes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPayments !== null) {
					foreach($this->collPayments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPaymentTypeI18ns !== null) {
					foreach($this->collPaymentTypeI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDeliveryHasPaymentTypes !== null) {
					foreach($this->collDeliveryHasPaymentTypes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PaymentTypePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getModuleName();
				break;
			case 4:
				return $this->getActive();
				break;
			case 5:
				return $this->getImage();
				break;
			case 6:
				return $this->getOptName();
				break;
			case 7:
				return $this->getOptDescription();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PaymentTypePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getModuleName(),
			$keys[4] => $this->getActive(),
			$keys[5] => $this->getImage(),
			$keys[6] => $this->getOptName(),
			$keys[7] => $this->getOptDescription(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PaymentTypePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setModuleName($value);
				break;
			case 4:
				$this->setActive($value);
				break;
			case 5:
				$this->setImage($value);
				break;
			case 6:
				$this->setOptName($value);
				break;
			case 7:
				$this->setOptDescription($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PaymentTypePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setModuleName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setActive($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setImage($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptName($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptDescription($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(PaymentTypePeer::DATABASE_NAME);

		if ($this->isColumnModified(PaymentTypePeer::CREATED_AT)) $criteria->add(PaymentTypePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(PaymentTypePeer::UPDATED_AT)) $criteria->add(PaymentTypePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(PaymentTypePeer::ID)) $criteria->add(PaymentTypePeer::ID, $this->id);
		if ($this->isColumnModified(PaymentTypePeer::MODULE_NAME)) $criteria->add(PaymentTypePeer::MODULE_NAME, $this->module_name);
		if ($this->isColumnModified(PaymentTypePeer::ACTIVE)) $criteria->add(PaymentTypePeer::ACTIVE, $this->active);
		if ($this->isColumnModified(PaymentTypePeer::IMAGE)) $criteria->add(PaymentTypePeer::IMAGE, $this->image);
		if ($this->isColumnModified(PaymentTypePeer::OPT_NAME)) $criteria->add(PaymentTypePeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(PaymentTypePeer::OPT_DESCRIPTION)) $criteria->add(PaymentTypePeer::OPT_DESCRIPTION, $this->opt_description);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(PaymentTypePeer::DATABASE_NAME);

		$criteria->add(PaymentTypePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setModuleName($this->module_name);

		$copyObj->setActive($this->active);

		$copyObj->setImage($this->image);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptDescription($this->opt_description);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getTrustedShopsHasPaymentTypes() as $relObj) {
				$copyObj->addTrustedShopsHasPaymentType($relObj->copy($deepCopy));
			}

			foreach($this->getPayments() as $relObj) {
				$copyObj->addPayment($relObj->copy($deepCopy));
			}

			foreach($this->getPaymentTypeI18ns() as $relObj) {
				$copyObj->addPaymentTypeI18n($relObj->copy($deepCopy));
			}

			foreach($this->getDeliveryHasPaymentTypes() as $relObj) {
				$copyObj->addDeliveryHasPaymentType($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new PaymentTypePeer();
		}
		return self::$peer;
	}

	
	public function initTrustedShopsHasPaymentTypes()
	{
		if ($this->collTrustedShopsHasPaymentTypes === null) {
			$this->collTrustedShopsHasPaymentTypes = array();
		}
	}

	
	public function getTrustedShopsHasPaymentTypes($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasPaymentTypes === null) {
			if ($this->isNew()) {
			   $this->collTrustedShopsHasPaymentTypes = array();
			} else {

				$criteria->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

				TrustedShopsHasPaymentTypePeer::addSelectColumns($criteria);
				$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

				TrustedShopsHasPaymentTypePeer::addSelectColumns($criteria);
				if (!isset($this->lastTrustedShopsHasPaymentTypeCriteria) || !$this->lastTrustedShopsHasPaymentTypeCriteria->equals($criteria)) {
					$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTrustedShopsHasPaymentTypeCriteria = $criteria;
		return $this->collTrustedShopsHasPaymentTypes;
	}

	
	public function countTrustedShopsHasPaymentTypes($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

		return TrustedShopsHasPaymentTypePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addTrustedShopsHasPaymentType(TrustedShopsHasPaymentType $l)
	{
		$this->collTrustedShopsHasPaymentTypes[] = $l;
		$l->setPaymentType($this);
	}


	
	public function getTrustedShopsHasPaymentTypesJoinTrustedShops($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasPaymentTypes === null) {
			if ($this->isNew()) {
				$this->collTrustedShopsHasPaymentTypes = array();
			} else {

				$criteria->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

				$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelectJoinTrustedShops($criteria, $con);
			}
		} else {
									
			$criteria->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

			if (!isset($this->lastTrustedShopsHasPaymentTypeCriteria) || !$this->lastTrustedShopsHasPaymentTypeCriteria->equals($criteria)) {
				$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelectJoinTrustedShops($criteria, $con);
			}
		}
		$this->lastTrustedShopsHasPaymentTypeCriteria = $criteria;

		return $this->collTrustedShopsHasPaymentTypes;
	}

	
	public function initPayments()
	{
		if ($this->collPayments === null) {
			$this->collPayments = array();
		}
	}

	
	public function getPayments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
			   $this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->getId());

				PaymentPeer::addSelectColumns($criteria);
				$this->collPayments = PaymentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->getId());

				PaymentPeer::addSelectColumns($criteria);
				if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
					$this->collPayments = PaymentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPaymentCriteria = $criteria;
		return $this->collPayments;
	}

	
	public function countPayments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->getId());

		return PaymentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addPayment(Payment $l)
	{
		$this->collPayments[] = $l;
		$l->setPaymentType($this);
	}


	
	public function getPaymentsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->getId());

				$this->collPayments = PaymentPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->getId());

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}


	
	public function getPaymentsJoinGiftCard($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->getId());

				$this->collPayments = PaymentPeer::doSelectJoinGiftCard($criteria, $con);
			}
		} else {
									
			$criteria->add(PaymentPeer::PAYMENT_TYPE_ID, $this->getId());

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinGiftCard($criteria, $con);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}

	
	public function initPaymentTypeI18ns()
	{
		if ($this->collPaymentTypeI18ns === null) {
			$this->collPaymentTypeI18ns = array();
		}
	}

	
	public function getPaymentTypeI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPaymentTypeI18ns === null) {
			if ($this->isNew()) {
			   $this->collPaymentTypeI18ns = array();
			} else {

				$criteria->add(PaymentTypeI18nPeer::ID, $this->getId());

				PaymentTypeI18nPeer::addSelectColumns($criteria);
				$this->collPaymentTypeI18ns = PaymentTypeI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(PaymentTypeI18nPeer::ID, $this->getId());

				PaymentTypeI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastPaymentTypeI18nCriteria) || !$this->lastPaymentTypeI18nCriteria->equals($criteria)) {
					$this->collPaymentTypeI18ns = PaymentTypeI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPaymentTypeI18nCriteria = $criteria;
		return $this->collPaymentTypeI18ns;
	}

	
	public function countPaymentTypeI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(PaymentTypeI18nPeer::ID, $this->getId());

		return PaymentTypeI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addPaymentTypeI18n(PaymentTypeI18n $l)
	{
		$this->collPaymentTypeI18ns[] = $l;
		$l->setPaymentType($this);
	}

	
	public function initDeliveryHasPaymentTypes()
	{
		if ($this->collDeliveryHasPaymentTypes === null) {
			$this->collDeliveryHasPaymentTypes = array();
		}
	}

	
	public function getDeliveryHasPaymentTypes($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliveryHasPaymentTypes === null) {
			if ($this->isNew()) {
			   $this->collDeliveryHasPaymentTypes = array();
			} else {

				$criteria->add(DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

				DeliveryHasPaymentTypePeer::addSelectColumns($criteria);
				$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

				DeliveryHasPaymentTypePeer::addSelectColumns($criteria);
				if (!isset($this->lastDeliveryHasPaymentTypeCriteria) || !$this->lastDeliveryHasPaymentTypeCriteria->equals($criteria)) {
					$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDeliveryHasPaymentTypeCriteria = $criteria;
		return $this->collDeliveryHasPaymentTypes;
	}

	
	public function countDeliveryHasPaymentTypes($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

		return DeliveryHasPaymentTypePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDeliveryHasPaymentType(DeliveryHasPaymentType $l)
	{
		$this->collDeliveryHasPaymentTypes[] = $l;
		$l->setPaymentType($this);
	}


	
	public function getDeliveryHasPaymentTypesJoinDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliveryHasPaymentTypes === null) {
			if ($this->isNew()) {
				$this->collDeliveryHasPaymentTypes = array();
			} else {

				$criteria->add(DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

				$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelectJoinDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->getId());

			if (!isset($this->lastDeliveryHasPaymentTypeCriteria) || !$this->lastDeliveryHasPaymentTypeCriteria->equals($criteria)) {
				$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelectJoinDelivery($criteria, $con);
			}
		}
		$this->lastDeliveryHasPaymentTypeCriteria = $criteria;

		return $this->collDeliveryHasPaymentTypes;
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentPaymentTypeI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentPaymentTypeI18n()->setName($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentPaymentTypeI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentPaymentTypeI18n()->setDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentPaymentTypeI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = PaymentTypeI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setPaymentTypeI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setPaymentTypeI18nForCulture(new PaymentTypeI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setPaymentTypeI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addPaymentTypeI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'PaymentType.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BasePaymentType:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BasePaymentType::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 