<?php


abstract class BaseProducer extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_asset_id;


	
	protected $image;


	
	protected $link;


	
	protected $opt_name;


	
	protected $opt_url;


	
	protected $opt_description;

	
	protected $asfAsset;

	
	protected $collProducerHasPositionings;

	
	protected $lastProducerHasPositioningCriteria = null;

	
	protected $collProducts;

	
	protected $lastProductCriteria = null;

	
	protected $collProducerI18ns;

	
	protected $lastProducerI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfAssetId()
    {

            return $this->sf_asset_id;
    }

    
    public function getImage()
    {

            return $this->image;
    }

    
    public function getLink()
    {

            return $this->link;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptUrl()
    {

            return $this->opt_url;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProducerPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProducerPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProducerPeer::ID;
        }

	} 
	
	public function setSfAssetId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_asset_id !== $v) {
          $this->sf_asset_id = $v;
          $this->modifiedColumns[] = ProducerPeer::SF_ASSET_ID;
        }

		if ($this->asfAsset !== null && $this->asfAsset->getId() !== $v) {
			$this->asfAsset = null;
		}

	} 
	
	public function setImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->image !== $v) {
          $this->image = $v;
          $this->modifiedColumns[] = ProducerPeer::IMAGE;
        }

	} 
	
	public function setLink($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->link !== $v) {
          $this->link = $v;
          $this->modifiedColumns[] = ProducerPeer::LINK;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = ProducerPeer::OPT_NAME;
        }

	} 
	
	public function setOptUrl($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_url !== $v) {
          $this->opt_url = $v;
          $this->modifiedColumns[] = ProducerPeer::OPT_URL;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = ProducerPeer::OPT_DESCRIPTION;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Producer.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_asset_id = $rs->getInt($startcol + 3);

      $this->image = $rs->getString($startcol + 4);

      $this->link = $rs->getString($startcol + 5);

      $this->opt_name = $rs->getString($startcol + 6);

      $this->opt_url = $rs->getString($startcol + 7);

      $this->opt_description = $rs->getString($startcol + 8);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Producer.postHydrate', array('resultset' => $rs, 'startcol' => 9)));

            return $startcol + 9; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Producer object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProducer:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProducerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProducerPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProducer:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Producer.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProducer:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProducerPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProducerPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProducerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Producer.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProducer:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfAsset !== null) {
				if ($this->asfAsset->isModified()) {
					$affectedRows += $this->asfAsset->save($con);
				}
				$this->setsfAsset($this->asfAsset);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProducerPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProducerPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collProducerHasPositionings !== null) {
				foreach($this->collProducerHasPositionings as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProducts !== null) {
				foreach($this->collProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProducerI18ns !== null) {
				foreach($this->collProducerI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfAsset !== null) {
				if (!$this->asfAsset->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfAsset->getValidationFailures());
				}
			}


			if (($retval = ProducerPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collProducerHasPositionings !== null) {
					foreach($this->collProducerHasPositionings as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProducts !== null) {
					foreach($this->collProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProducerI18ns !== null) {
					foreach($this->collProducerI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProducerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfAssetId();
				break;
			case 4:
				return $this->getImage();
				break;
			case 5:
				return $this->getLink();
				break;
			case 6:
				return $this->getOptName();
				break;
			case 7:
				return $this->getOptUrl();
				break;
			case 8:
				return $this->getOptDescription();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProducerPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfAssetId(),
			$keys[4] => $this->getImage(),
			$keys[5] => $this->getLink(),
			$keys[6] => $this->getOptName(),
			$keys[7] => $this->getOptUrl(),
			$keys[8] => $this->getOptDescription(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProducerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfAssetId($value);
				break;
			case 4:
				$this->setImage($value);
				break;
			case 5:
				$this->setLink($value);
				break;
			case 6:
				$this->setOptName($value);
				break;
			case 7:
				$this->setOptUrl($value);
				break;
			case 8:
				$this->setOptDescription($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProducerPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfAssetId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setImage($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setLink($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptName($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptUrl($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOptDescription($arr[$keys[8]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProducerPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProducerPeer::CREATED_AT)) $criteria->add(ProducerPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProducerPeer::UPDATED_AT)) $criteria->add(ProducerPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProducerPeer::ID)) $criteria->add(ProducerPeer::ID, $this->id);
		if ($this->isColumnModified(ProducerPeer::SF_ASSET_ID)) $criteria->add(ProducerPeer::SF_ASSET_ID, $this->sf_asset_id);
		if ($this->isColumnModified(ProducerPeer::IMAGE)) $criteria->add(ProducerPeer::IMAGE, $this->image);
		if ($this->isColumnModified(ProducerPeer::LINK)) $criteria->add(ProducerPeer::LINK, $this->link);
		if ($this->isColumnModified(ProducerPeer::OPT_NAME)) $criteria->add(ProducerPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(ProducerPeer::OPT_URL)) $criteria->add(ProducerPeer::OPT_URL, $this->opt_url);
		if ($this->isColumnModified(ProducerPeer::OPT_DESCRIPTION)) $criteria->add(ProducerPeer::OPT_DESCRIPTION, $this->opt_description);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProducerPeer::DATABASE_NAME);

		$criteria->add(ProducerPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfAssetId($this->sf_asset_id);

		$copyObj->setImage($this->image);

		$copyObj->setLink($this->link);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptUrl($this->opt_url);

		$copyObj->setOptDescription($this->opt_description);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getProducerHasPositionings() as $relObj) {
				$copyObj->addProducerHasPositioning($relObj->copy($deepCopy));
			}

			foreach($this->getProducts() as $relObj) {
				$copyObj->addProduct($relObj->copy($deepCopy));
			}

			foreach($this->getProducerI18ns() as $relObj) {
				$copyObj->addProducerI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProducerPeer();
		}
		return self::$peer;
	}

	
	public function setsfAsset($v)
	{


		if ($v === null) {
			$this->setSfAssetId(NULL);
		} else {
			$this->setSfAssetId($v->getId());
		}


		$this->asfAsset = $v;
	}


	
	public function getsfAsset($con = null)
	{
		if ($this->asfAsset === null && ($this->sf_asset_id !== null)) {
						$this->asfAsset = sfAssetPeer::retrieveByPK($this->sf_asset_id, $con);

			
		}
		return $this->asfAsset;
	}

	
	public function initProducerHasPositionings()
	{
		if ($this->collProducerHasPositionings === null) {
			$this->collProducerHasPositionings = array();
		}
	}

	
	public function getProducerHasPositionings($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducerHasPositionings === null) {
			if ($this->isNew()) {
			   $this->collProducerHasPositionings = array();
			} else {

				$criteria->add(ProducerHasPositioningPeer::PRODUCER_ID, $this->getId());

				ProducerHasPositioningPeer::addSelectColumns($criteria);
				$this->collProducerHasPositionings = ProducerHasPositioningPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProducerHasPositioningPeer::PRODUCER_ID, $this->getId());

				ProducerHasPositioningPeer::addSelectColumns($criteria);
				if (!isset($this->lastProducerHasPositioningCriteria) || !$this->lastProducerHasPositioningCriteria->equals($criteria)) {
					$this->collProducerHasPositionings = ProducerHasPositioningPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProducerHasPositioningCriteria = $criteria;
		return $this->collProducerHasPositionings;
	}

	
	public function countProducerHasPositionings($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProducerHasPositioningPeer::PRODUCER_ID, $this->getId());

		return ProducerHasPositioningPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProducerHasPositioning(ProducerHasPositioning $l)
	{
		$this->collProducerHasPositionings[] = $l;
		$l->setProducer($this);
	}

	
	public function initProducts()
	{
		if ($this->collProducts === null) {
			$this->collProducts = array();
		}
	}

	
	public function getProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
			   $this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				$this->collProducts = ProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
					$this->collProducts = ProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductCriteria = $criteria;
		return $this->collProducts;
	}

	
	public function countProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

		return ProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProduct(Product $l)
	{
		$this->collProducts[] = $l;
		$l->setProducer($this);
	}


	
	public function getProductsJoinProductRelatedByParentId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinAvailability($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PRODUCER_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}

	
	public function initProducerI18ns()
	{
		if ($this->collProducerI18ns === null) {
			$this->collProducerI18ns = array();
		}
	}

	
	public function getProducerI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducerI18ns === null) {
			if ($this->isNew()) {
			   $this->collProducerI18ns = array();
			} else {

				$criteria->add(ProducerI18nPeer::ID, $this->getId());

				ProducerI18nPeer::addSelectColumns($criteria);
				$this->collProducerI18ns = ProducerI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProducerI18nPeer::ID, $this->getId());

				ProducerI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProducerI18nCriteria) || !$this->lastProducerI18nCriteria->equals($criteria)) {
					$this->collProducerI18ns = ProducerI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProducerI18nCriteria = $criteria;
		return $this->collProducerI18ns;
	}

	
	public function countProducerI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProducerI18nPeer::ID, $this->getId());

		return ProducerI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProducerI18n(ProducerI18n $l)
	{
		$this->collProducerI18ns[] = $l;
		$l->setProducer($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentProducerI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentProducerI18n()->setName($value);
  }

  public function getUrl()
  {
    $obj = $this->getCurrentProducerI18n();

    return ($obj ? $obj->getUrl() : null);
  }

  public function setUrl($value)
  {
    $this->getCurrentProducerI18n()->setUrl($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentProducerI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentProducerI18n()->setDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentProducerI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProducerI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProducerI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProducerI18nForCulture(new ProducerI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProducerI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProducerI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Producer.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProducer:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProducer::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 