<?php


abstract class BaseProduct extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $parent_id;


	
	protected $currency_id;


	
	protected $producer_id;


	
	protected $code;


	
	protected $price;


	
	protected $opt_price_brutto;


	
	protected $currency_price;


	
	protected $old_price;


	
	protected $opt_old_price_brutto;


	
	protected $currency_old_price;


	
	protected $opt_vat;


	
	protected $currency_exchange = 1;


	
	protected $active = true;


	
	protected $hide_price = false;


	
	protected $has_fixed_currency = false;


	
	protected $opt_image;


	
	protected $opt_name;


	
	protected $opt_short_description;


	
	protected $opt_description;


	
	protected $opt_url;


	
	protected $opt_asset_folder;


	
	protected $opt_uom;


	
	protected $min_qty = 1;


	
	protected $max_qty = 0;


	
	protected $step_qty = 0;


	
	protected $is_stock_validated;


	
	protected $stock_in_decimals = false;


	
	protected $availability_id;


	
	protected $weight;


	
	protected $stock = 1;


	
	protected $max_discount = 100;


	
	protected $opt_has_options;


	
	protected $options_color;


	
	protected $tax_id;


	
	protected $wholesale_a_netto;


	
	protected $wholesale_b_netto;


	
	protected $wholesale_c_netto;


	
	protected $wholesale_a_brutto;


	
	protected $wholesale_b_brutto;


	
	protected $wholesale_c_brutto;


	
	protected $currency_wholesale_a;


	
	protected $currency_wholesale_b;


	
	protected $currency_wholesale_c;

	
	protected $aProductRelatedByParentId;

	
	protected $aCurrency;

	
	protected $aProducer;

	
	protected $aAvailability;

	
	protected $aTax;

	
	protected $collQuestionss;

	
	protected $lastQuestionsCriteria = null;

	
	protected $collBasketProducts;

	
	protected $lastBasketProductCriteria = null;

	
	protected $collDiscountHasProducts;

	
	protected $lastDiscountHasProductCriteria = null;

	
	protected $collProductHasAccessoriessRelatedByAccessoriesId;

	
	protected $lastProductHasAccessoriesRelatedByAccessoriesIdCriteria = null;

	
	protected $collProductHasAccessoriessRelatedByProductId;

	
	protected $lastProductHasAccessoriesRelatedByProductIdCriteria = null;

	
	protected $collProductGroupHasProducts;

	
	protected $lastProductGroupHasProductCriteria = null;

	
	protected $collProductHasPositionings;

	
	protected $lastProductHasPositioningCriteria = null;

	
	protected $collCrossellingsRelatedByFirstProductId;

	
	protected $lastCrossellingRelatedByFirstProductIdCriteria = null;

	
	protected $collCrossellingsRelatedBySecoundProductId;

	
	protected $lastCrossellingRelatedBySecoundProductIdCriteria = null;

	
	protected $collProductSearchIndexs;

	
	protected $lastProductSearchIndexCriteria = null;

	
	protected $collProductsRelatedByParentId;

	
	protected $lastProductRelatedByParentIdCriteria = null;

	
	protected $collProductHasCategorys;

	
	protected $lastProductHasCategoryCriteria = null;

	
	protected $collProductHasSfAssets;

	
	protected $lastProductHasSfAssetCriteria = null;

	
	protected $collProductHasAttachments;

	
	protected $lastProductHasAttachmentCriteria = null;

	
	protected $collProductI18ns;

	
	protected $lastProductI18nCriteria = null;

	
	protected $collOrderProducts;

	
	protected $lastOrderProductCriteria = null;

	
	protected $collProductOptionsValues;

	
	protected $lastProductOptionsValueCriteria = null;

	
	protected $collInvoiceProducts;

	
	protected $lastInvoiceProductCriteria = null;

	
	protected $collRecommendSends;

	
	protected $lastRecommendSendCriteria = null;

	
	protected $collReviews;

	
	protected $lastReviewCriteria = null;

	
	protected $collProductHasAttributeFields;

	
	protected $lastProductHasAttributeFieldCriteria = null;

	
	protected $collProductHasWholesales;

	
	protected $lastProductHasWholesaleCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getParentId()
    {

            return $this->parent_id;
    }

    
    public function getCurrencyId()
    {

            return $this->currency_id;
    }

    
    public function getProducerId()
    {

            return $this->producer_id;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getPrice()
    {

            return null !== $this->price ? (string)$this->price : null;
    }

    
    public function getOptPriceBrutto()
    {

            return null !== $this->opt_price_brutto ? (string)$this->opt_price_brutto : null;
    }

    
    public function getCurrencyPrice()
    {

            return null !== $this->currency_price ? (string)$this->currency_price : null;
    }

    
    public function getOldPrice()
    {

            return null !== $this->old_price ? (string)$this->old_price : null;
    }

    
    public function getOptOldPriceBrutto()
    {

            return null !== $this->opt_old_price_brutto ? (string)$this->opt_old_price_brutto : null;
    }

    
    public function getCurrencyOldPrice()
    {

            return null !== $this->currency_old_price ? (string)$this->currency_old_price : null;
    }

    
    public function getOptVat()
    {

            return null !== $this->opt_vat ? (string)$this->opt_vat : null;
    }

    
    public function getCurrencyExchange()
    {

            return null !== $this->currency_exchange ? (string)$this->currency_exchange : null;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getHidePrice()
    {

            return $this->hide_price;
    }

    
    public function getHasFixedCurrency()
    {

            return $this->has_fixed_currency;
    }

    
    public function getOptImage()
    {

            return $this->opt_image;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptShortDescription()
    {

            return $this->opt_short_description;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getOptUrl()
    {

            return $this->opt_url;
    }

    
    public function getOptAssetFolder()
    {

            return $this->opt_asset_folder;
    }

    
    public function getOptUom()
    {

            return $this->opt_uom;
    }

    
    public function getMinQty()
    {

            return null !== $this->min_qty ? (string)$this->min_qty : null;
    }

    
    public function getMaxQty()
    {

            return null !== $this->max_qty ? (string)$this->max_qty : null;
    }

    
    public function getStepQty()
    {

            return null !== $this->step_qty ? (string)$this->step_qty : null;
    }

    
    public function getIsStockValidated()
    {

            return $this->is_stock_validated;
    }

    
    public function getStockInDecimals()
    {

            return $this->stock_in_decimals;
    }

    
    public function getAvailabilityId()
    {

            return $this->availability_id;
    }

    
    public function getWeight()
    {

            return $this->weight;
    }

    
    public function getStock()
    {

            return null !== $this->stock ? (string)$this->stock : null;
    }

    
    public function getMaxDiscount()
    {

            return $this->max_discount;
    }

    
    public function getOptHasOptions()
    {

            return $this->opt_has_options;
    }

    
    public function getOptionsColor()
    {

            return $this->options_color;
    }

    
    public function getTaxId()
    {

            return $this->tax_id;
    }

    
    public function getWholesaleANetto()
    {

            return null !== $this->wholesale_a_netto ? (string)$this->wholesale_a_netto : null;
    }

    
    public function getWholesaleBNetto()
    {

            return null !== $this->wholesale_b_netto ? (string)$this->wholesale_b_netto : null;
    }

    
    public function getWholesaleCNetto()
    {

            return null !== $this->wholesale_c_netto ? (string)$this->wholesale_c_netto : null;
    }

    
    public function getWholesaleABrutto()
    {

            return null !== $this->wholesale_a_brutto ? (string)$this->wholesale_a_brutto : null;
    }

    
    public function getWholesaleBBrutto()
    {

            return null !== $this->wholesale_b_brutto ? (string)$this->wholesale_b_brutto : null;
    }

    
    public function getWholesaleCBrutto()
    {

            return null !== $this->wholesale_c_brutto ? (string)$this->wholesale_c_brutto : null;
    }

    
    public function getCurrencyWholesaleA()
    {

            return null !== $this->currency_wholesale_a ? (string)$this->currency_wholesale_a : null;
    }

    
    public function getCurrencyWholesaleB()
    {

            return null !== $this->currency_wholesale_b ? (string)$this->currency_wholesale_b : null;
    }

    
    public function getCurrencyWholesaleC()
    {

            return null !== $this->currency_wholesale_c ? (string)$this->currency_wholesale_c : null;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductPeer::ID;
        }

	} 
	
	public function setParentId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->parent_id !== $v) {
          $this->parent_id = $v;
          $this->modifiedColumns[] = ProductPeer::PARENT_ID;
        }

		if ($this->aProductRelatedByParentId !== null && $this->aProductRelatedByParentId->getId() !== $v) {
			$this->aProductRelatedByParentId = null;
		}

	} 
	
	public function setCurrencyId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->currency_id !== $v) {
          $this->currency_id = $v;
          $this->modifiedColumns[] = ProductPeer::CURRENCY_ID;
        }

		if ($this->aCurrency !== null && $this->aCurrency->getId() !== $v) {
			$this->aCurrency = null;
		}

	} 
	
	public function setProducerId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->producer_id !== $v) {
          $this->producer_id = $v;
          $this->modifiedColumns[] = ProductPeer::PRODUCER_ID;
        }

		if ($this->aProducer !== null && $this->aProducer->getId() !== $v) {
			$this->aProducer = null;
		}

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = ProductPeer::CODE;
        }

	} 
	
	public function setPrice($v)
	{

        if ($this->price !== $v) {
          $this->price = $v;
          $this->modifiedColumns[] = ProductPeer::PRICE;
        }

	} 
	
	public function setOptPriceBrutto($v)
	{

        if ($this->opt_price_brutto !== $v) {
          $this->opt_price_brutto = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_PRICE_BRUTTO;
        }

	} 
	
	public function setCurrencyPrice($v)
	{

        if ($this->currency_price !== $v) {
          $this->currency_price = $v;
          $this->modifiedColumns[] = ProductPeer::CURRENCY_PRICE;
        }

	} 
	
	public function setOldPrice($v)
	{

        if ($this->old_price !== $v) {
          $this->old_price = $v;
          $this->modifiedColumns[] = ProductPeer::OLD_PRICE;
        }

	} 
	
	public function setOptOldPriceBrutto($v)
	{

        if ($this->opt_old_price_brutto !== $v) {
          $this->opt_old_price_brutto = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_OLD_PRICE_BRUTTO;
        }

	} 
	
	public function setCurrencyOldPrice($v)
	{

        if ($this->currency_old_price !== $v) {
          $this->currency_old_price = $v;
          $this->modifiedColumns[] = ProductPeer::CURRENCY_OLD_PRICE;
        }

	} 
	
	public function setOptVat($v)
	{

        if ($this->opt_vat !== $v) {
          $this->opt_vat = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_VAT;
        }

	} 
	
	public function setCurrencyExchange($v)
	{

        if ($this->currency_exchange !== $v || $v === 1) {
          $this->currency_exchange = $v;
          $this->modifiedColumns[] = ProductPeer::CURRENCY_EXCHANGE;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === true) {
          $this->active = $v;
          $this->modifiedColumns[] = ProductPeer::ACTIVE;
        }

	} 
	
	public function setHidePrice($v)
	{

        if ($this->hide_price !== $v || $v === false) {
          $this->hide_price = $v;
          $this->modifiedColumns[] = ProductPeer::HIDE_PRICE;
        }

	} 
	
	public function setHasFixedCurrency($v)
	{

        if ($this->has_fixed_currency !== $v || $v === false) {
          $this->has_fixed_currency = $v;
          $this->modifiedColumns[] = ProductPeer::HAS_FIXED_CURRENCY;
        }

	} 
	
	public function setOptImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_image !== $v) {
          $this->opt_image = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_IMAGE;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_NAME;
        }

	} 
	
	public function setOptShortDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_short_description !== $v) {
          $this->opt_short_description = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_SHORT_DESCRIPTION;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setOptUrl($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_url !== $v) {
          $this->opt_url = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_URL;
        }

	} 
	
	public function setOptAssetFolder($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_asset_folder !== $v) {
          $this->opt_asset_folder = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_ASSET_FOLDER;
        }

	} 
	
	public function setOptUom($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_uom !== $v) {
          $this->opt_uom = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_UOM;
        }

	} 
	
	public function setMinQty($v)
	{

        if ($this->min_qty !== $v || $v === 1) {
          $this->min_qty = $v;
          $this->modifiedColumns[] = ProductPeer::MIN_QTY;
        }

	} 
	
	public function setMaxQty($v)
	{

        if ($this->max_qty !== $v || $v === 0) {
          $this->max_qty = $v;
          $this->modifiedColumns[] = ProductPeer::MAX_QTY;
        }

	} 
	
	public function setStepQty($v)
	{

        if ($this->step_qty !== $v || $v === 0) {
          $this->step_qty = $v;
          $this->modifiedColumns[] = ProductPeer::STEP_QTY;
        }

	} 
	
	public function setIsStockValidated($v)
	{

        if ($this->is_stock_validated !== $v) {
          $this->is_stock_validated = $v;
          $this->modifiedColumns[] = ProductPeer::IS_STOCK_VALIDATED;
        }

	} 
	
	public function setStockInDecimals($v)
	{

        if ($this->stock_in_decimals !== $v || $v === false) {
          $this->stock_in_decimals = $v;
          $this->modifiedColumns[] = ProductPeer::STOCK_IN_DECIMALS;
        }

	} 
	
	public function setAvailabilityId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->availability_id !== $v) {
          $this->availability_id = $v;
          $this->modifiedColumns[] = ProductPeer::AVAILABILITY_ID;
        }

		if ($this->aAvailability !== null && $this->aAvailability->getId() !== $v) {
			$this->aAvailability = null;
		}

	} 
	
	public function setWeight($v)
	{

        if ($this->weight !== $v) {
          $this->weight = $v;
          $this->modifiedColumns[] = ProductPeer::WEIGHT;
        }

	} 
	
	public function setStock($v)
	{

        if ($this->stock !== $v || $v === 1) {
          $this->stock = $v;
          $this->modifiedColumns[] = ProductPeer::STOCK;
        }

	} 
	
	public function setMaxDiscount($v)
	{

        if ($this->max_discount !== $v || $v === 100) {
          $this->max_discount = $v;
          $this->modifiedColumns[] = ProductPeer::MAX_DISCOUNT;
        }

	} 
	
	public function setOptHasOptions($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_has_options !== $v) {
          $this->opt_has_options = $v;
          $this->modifiedColumns[] = ProductPeer::OPT_HAS_OPTIONS;
        }

	} 
	
	public function setOptionsColor($v)
	{

        if ($this->options_color !== $v) {
          $this->options_color = $v;
          $this->modifiedColumns[] = ProductPeer::OPTIONS_COLOR;
        }

	} 
	
	public function setTaxId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->tax_id !== $v) {
          $this->tax_id = $v;
          $this->modifiedColumns[] = ProductPeer::TAX_ID;
        }

		if ($this->aTax !== null && $this->aTax->getId() !== $v) {
			$this->aTax = null;
		}

	} 
	
	public function setWholesaleANetto($v)
	{

        if ($this->wholesale_a_netto !== $v) {
          $this->wholesale_a_netto = $v;
          $this->modifiedColumns[] = ProductPeer::WHOLESALE_A_NETTO;
        }

	} 
	
	public function setWholesaleBNetto($v)
	{

        if ($this->wholesale_b_netto !== $v) {
          $this->wholesale_b_netto = $v;
          $this->modifiedColumns[] = ProductPeer::WHOLESALE_B_NETTO;
        }

	} 
	
	public function setWholesaleCNetto($v)
	{

        if ($this->wholesale_c_netto !== $v) {
          $this->wholesale_c_netto = $v;
          $this->modifiedColumns[] = ProductPeer::WHOLESALE_C_NETTO;
        }

	} 
	
	public function setWholesaleABrutto($v)
	{

        if ($this->wholesale_a_brutto !== $v) {
          $this->wholesale_a_brutto = $v;
          $this->modifiedColumns[] = ProductPeer::WHOLESALE_A_BRUTTO;
        }

	} 
	
	public function setWholesaleBBrutto($v)
	{

        if ($this->wholesale_b_brutto !== $v) {
          $this->wholesale_b_brutto = $v;
          $this->modifiedColumns[] = ProductPeer::WHOLESALE_B_BRUTTO;
        }

	} 
	
	public function setWholesaleCBrutto($v)
	{

        if ($this->wholesale_c_brutto !== $v) {
          $this->wholesale_c_brutto = $v;
          $this->modifiedColumns[] = ProductPeer::WHOLESALE_C_BRUTTO;
        }

	} 
	
	public function setCurrencyWholesaleA($v)
	{

        if ($this->currency_wholesale_a !== $v) {
          $this->currency_wholesale_a = $v;
          $this->modifiedColumns[] = ProductPeer::CURRENCY_WHOLESALE_A;
        }

	} 
	
	public function setCurrencyWholesaleB($v)
	{

        if ($this->currency_wholesale_b !== $v) {
          $this->currency_wholesale_b = $v;
          $this->modifiedColumns[] = ProductPeer::CURRENCY_WHOLESALE_B;
        }

	} 
	
	public function setCurrencyWholesaleC($v)
	{

        if ($this->currency_wholesale_c !== $v) {
          $this->currency_wholesale_c = $v;
          $this->modifiedColumns[] = ProductPeer::CURRENCY_WHOLESALE_C;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Product.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->parent_id = $rs->getInt($startcol + 3);

      $this->currency_id = $rs->getInt($startcol + 4);

      $this->producer_id = $rs->getInt($startcol + 5);

      $this->code = $rs->getString($startcol + 6);

      $this->price = $rs->getString($startcol + 7, null);

      $this->price = $rs->getFloat($startcol + 7);

      $this->opt_price_brutto = $rs->getString($startcol + 8, null);

      $this->opt_price_brutto = $rs->getFloat($startcol + 8);

      $this->currency_price = $rs->getString($startcol + 9, null);

      $this->currency_price = $rs->getFloat($startcol + 9);

      $this->old_price = $rs->getString($startcol + 10, null);

      $this->old_price = $rs->getFloat($startcol + 10);

      $this->opt_old_price_brutto = $rs->getString($startcol + 11, null);

      $this->opt_old_price_brutto = $rs->getFloat($startcol + 11);

      $this->currency_old_price = $rs->getString($startcol + 12, null);

      $this->currency_old_price = $rs->getFloat($startcol + 12);

      $this->opt_vat = $rs->getString($startcol + 13, null);

      $this->opt_vat = $rs->getFloat($startcol + 13);

      $this->currency_exchange = $rs->getString($startcol + 14, null);

      $this->currency_exchange = $rs->getFloat($startcol + 14);

      $this->active = $rs->getBoolean($startcol + 15);

      $this->hide_price = $rs->getBoolean($startcol + 16);

      $this->has_fixed_currency = $rs->getBoolean($startcol + 17);

      $this->opt_image = $rs->getString($startcol + 18);

      $this->opt_name = $rs->getString($startcol + 19);

      $this->opt_short_description = $rs->getString($startcol + 20);

      $this->opt_description = $rs->getString($startcol + 21);

      $this->opt_url = $rs->getString($startcol + 22);

      $this->opt_asset_folder = $rs->getString($startcol + 23);

      $this->opt_uom = $rs->getString($startcol + 24);

      $this->min_qty = $rs->getString($startcol + 25, null);

      $this->min_qty = $rs->getFloat($startcol + 25);

      $this->max_qty = $rs->getString($startcol + 26, null);

      $this->max_qty = $rs->getFloat($startcol + 26);

      $this->step_qty = $rs->getString($startcol + 27, null);

      $this->step_qty = $rs->getFloat($startcol + 27);

      $this->is_stock_validated = $rs->getBoolean($startcol + 28);

      $this->stock_in_decimals = $rs->getBoolean($startcol + 29);

      $this->availability_id = $rs->getInt($startcol + 30);

      $this->weight = $rs->getFloat($startcol + 31);

      $this->stock = $rs->getString($startcol + 32, null);

      $this->stock = $rs->getFloat($startcol + 32);

      $this->max_discount = $rs->getFloat($startcol + 33);

      $this->opt_has_options = $rs->getInt($startcol + 34);

      $this->options_color = $rs->getString($startcol + 35) ? unserialize($rs->getString($startcol + 35)) : null;

      $this->tax_id = $rs->getInt($startcol + 36);

      $this->wholesale_a_netto = $rs->getString($startcol + 37, null);

      $this->wholesale_a_netto = $rs->getFloat($startcol + 37);

      $this->wholesale_b_netto = $rs->getString($startcol + 38, null);

      $this->wholesale_b_netto = $rs->getFloat($startcol + 38);

      $this->wholesale_c_netto = $rs->getString($startcol + 39, null);

      $this->wholesale_c_netto = $rs->getFloat($startcol + 39);

      $this->wholesale_a_brutto = $rs->getString($startcol + 40, null);

      $this->wholesale_a_brutto = $rs->getFloat($startcol + 40);

      $this->wholesale_b_brutto = $rs->getString($startcol + 41, null);

      $this->wholesale_b_brutto = $rs->getFloat($startcol + 41);

      $this->wholesale_c_brutto = $rs->getString($startcol + 42, null);

      $this->wholesale_c_brutto = $rs->getFloat($startcol + 42);

      $this->currency_wholesale_a = $rs->getString($startcol + 43, null);

      $this->currency_wholesale_a = $rs->getFloat($startcol + 43);

      $this->currency_wholesale_b = $rs->getString($startcol + 44, null);

      $this->currency_wholesale_b = $rs->getFloat($startcol + 44);

      $this->currency_wholesale_c = $rs->getString($startcol + 45, null);

      $this->currency_wholesale_c = $rs->getFloat($startcol + 45);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Product.postHydrate', array('resultset' => $rs, 'startcol' => 46)));

            return $startcol + 46; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Product object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProduct:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProduct:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Product.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProduct:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Product.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProduct:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProductRelatedByParentId !== null) {
				if ($this->aProductRelatedByParentId->isModified() || $this->aProductRelatedByParentId->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProductRelatedByParentId->save($con);
				}
				$this->setProductRelatedByParentId($this->aProductRelatedByParentId);
			}

			if ($this->aCurrency !== null) {
				if ($this->aCurrency->isModified() || $this->aCurrency->getCurrentCurrencyI18n()->isModified()) {
					$affectedRows += $this->aCurrency->save($con);
				}
				$this->setCurrency($this->aCurrency);
			}

			if ($this->aProducer !== null) {
				if ($this->aProducer->isModified() || $this->aProducer->getCurrentProducerI18n()->isModified()) {
					$affectedRows += $this->aProducer->save($con);
				}
				$this->setProducer($this->aProducer);
			}

			if ($this->aAvailability !== null) {
				if ($this->aAvailability->isModified() || $this->aAvailability->getCurrentAvailabilityI18n()->isModified()) {
					$affectedRows += $this->aAvailability->save($con);
				}
				$this->setAvailability($this->aAvailability);
			}

			if ($this->aTax !== null) {
				if ($this->aTax->isModified()) {
					$affectedRows += $this->aTax->save($con);
				}
				$this->setTax($this->aTax);
			}


						if ($this->isModified()) {
              $o_options_color = $this->options_color;
              if (null !== $this->options_color && $this->isColumnModified(ProductPeer::OPTIONS_COLOR)) {
                  $this->options_color = serialize($this->options_color);
              }

				if ($this->isNew()) {
					$pk = ProductPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductPeer::doUpdate($this, $con);
				}
				$this->resetModified();
             $this->options_color = $o_options_color;
 			}

			if ($this->collQuestionss !== null) {
				foreach($this->collQuestionss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collBasketProducts !== null) {
				foreach($this->collBasketProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDiscountHasProducts !== null) {
				foreach($this->collDiscountHasProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasAccessoriessRelatedByAccessoriesId !== null) {
				foreach($this->collProductHasAccessoriessRelatedByAccessoriesId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasAccessoriessRelatedByProductId !== null) {
				foreach($this->collProductHasAccessoriessRelatedByProductId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductGroupHasProducts !== null) {
				foreach($this->collProductGroupHasProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasPositionings !== null) {
				foreach($this->collProductHasPositionings as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCrossellingsRelatedByFirstProductId !== null) {
				foreach($this->collCrossellingsRelatedByFirstProductId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCrossellingsRelatedBySecoundProductId !== null) {
				foreach($this->collCrossellingsRelatedBySecoundProductId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductSearchIndexs !== null) {
				foreach($this->collProductSearchIndexs as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductsRelatedByParentId !== null) {
				foreach($this->collProductsRelatedByParentId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasCategorys !== null) {
				foreach($this->collProductHasCategorys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasSfAssets !== null) {
				foreach($this->collProductHasSfAssets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasAttachments !== null) {
				foreach($this->collProductHasAttachments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductI18ns !== null) {
				foreach($this->collProductI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderProducts !== null) {
				foreach($this->collOrderProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsValues !== null) {
				foreach($this->collProductOptionsValues as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collInvoiceProducts !== null) {
				foreach($this->collInvoiceProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collRecommendSends !== null) {
				foreach($this->collRecommendSends as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collReviews !== null) {
				foreach($this->collReviews as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasAttributeFields !== null) {
				foreach($this->collProductHasAttributeFields as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasWholesales !== null) {
				foreach($this->collProductHasWholesales as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProductRelatedByParentId !== null) {
				if (!$this->aProductRelatedByParentId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductRelatedByParentId->getValidationFailures());
				}
			}

			if ($this->aCurrency !== null) {
				if (!$this->aCurrency->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCurrency->getValidationFailures());
				}
			}

			if ($this->aProducer !== null) {
				if (!$this->aProducer->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProducer->getValidationFailures());
				}
			}

			if ($this->aAvailability !== null) {
				if (!$this->aAvailability->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAvailability->getValidationFailures());
				}
			}

			if ($this->aTax !== null) {
				if (!$this->aTax->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTax->getValidationFailures());
				}
			}


			if (($retval = ProductPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collQuestionss !== null) {
					foreach($this->collQuestionss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collBasketProducts !== null) {
					foreach($this->collBasketProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDiscountHasProducts !== null) {
					foreach($this->collDiscountHasProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasAccessoriessRelatedByAccessoriesId !== null) {
					foreach($this->collProductHasAccessoriessRelatedByAccessoriesId as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasAccessoriessRelatedByProductId !== null) {
					foreach($this->collProductHasAccessoriessRelatedByProductId as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductGroupHasProducts !== null) {
					foreach($this->collProductGroupHasProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasPositionings !== null) {
					foreach($this->collProductHasPositionings as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCrossellingsRelatedByFirstProductId !== null) {
					foreach($this->collCrossellingsRelatedByFirstProductId as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCrossellingsRelatedBySecoundProductId !== null) {
					foreach($this->collCrossellingsRelatedBySecoundProductId as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductSearchIndexs !== null) {
					foreach($this->collProductSearchIndexs as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasCategorys !== null) {
					foreach($this->collProductHasCategorys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasSfAssets !== null) {
					foreach($this->collProductHasSfAssets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasAttachments !== null) {
					foreach($this->collProductHasAttachments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductI18ns !== null) {
					foreach($this->collProductI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderProducts !== null) {
					foreach($this->collOrderProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsValues !== null) {
					foreach($this->collProductOptionsValues as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collInvoiceProducts !== null) {
					foreach($this->collInvoiceProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collRecommendSends !== null) {
					foreach($this->collRecommendSends as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collReviews !== null) {
					foreach($this->collReviews as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasAttributeFields !== null) {
					foreach($this->collProductHasAttributeFields as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasWholesales !== null) {
					foreach($this->collProductHasWholesales as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getParentId();
				break;
			case 4:
				return $this->getCurrencyId();
				break;
			case 5:
				return $this->getProducerId();
				break;
			case 6:
				return $this->getCode();
				break;
			case 7:
				return $this->getPrice();
				break;
			case 8:
				return $this->getOptPriceBrutto();
				break;
			case 9:
				return $this->getCurrencyPrice();
				break;
			case 10:
				return $this->getOldPrice();
				break;
			case 11:
				return $this->getOptOldPriceBrutto();
				break;
			case 12:
				return $this->getCurrencyOldPrice();
				break;
			case 13:
				return $this->getOptVat();
				break;
			case 14:
				return $this->getCurrencyExchange();
				break;
			case 15:
				return $this->getActive();
				break;
			case 16:
				return $this->getHidePrice();
				break;
			case 17:
				return $this->getHasFixedCurrency();
				break;
			case 18:
				return $this->getOptImage();
				break;
			case 19:
				return $this->getOptName();
				break;
			case 20:
				return $this->getOptShortDescription();
				break;
			case 21:
				return $this->getOptDescription();
				break;
			case 22:
				return $this->getOptUrl();
				break;
			case 23:
				return $this->getOptAssetFolder();
				break;
			case 24:
				return $this->getOptUom();
				break;
			case 25:
				return $this->getMinQty();
				break;
			case 26:
				return $this->getMaxQty();
				break;
			case 27:
				return $this->getStepQty();
				break;
			case 28:
				return $this->getIsStockValidated();
				break;
			case 29:
				return $this->getStockInDecimals();
				break;
			case 30:
				return $this->getAvailabilityId();
				break;
			case 31:
				return $this->getWeight();
				break;
			case 32:
				return $this->getStock();
				break;
			case 33:
				return $this->getMaxDiscount();
				break;
			case 34:
				return $this->getOptHasOptions();
				break;
			case 35:
				return $this->getOptionsColor();
				break;
			case 36:
				return $this->getTaxId();
				break;
			case 37:
				return $this->getWholesaleANetto();
				break;
			case 38:
				return $this->getWholesaleBNetto();
				break;
			case 39:
				return $this->getWholesaleCNetto();
				break;
			case 40:
				return $this->getWholesaleABrutto();
				break;
			case 41:
				return $this->getWholesaleBBrutto();
				break;
			case 42:
				return $this->getWholesaleCBrutto();
				break;
			case 43:
				return $this->getCurrencyWholesaleA();
				break;
			case 44:
				return $this->getCurrencyWholesaleB();
				break;
			case 45:
				return $this->getCurrencyWholesaleC();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getParentId(),
			$keys[4] => $this->getCurrencyId(),
			$keys[5] => $this->getProducerId(),
			$keys[6] => $this->getCode(),
			$keys[7] => $this->getPrice(),
			$keys[8] => $this->getOptPriceBrutto(),
			$keys[9] => $this->getCurrencyPrice(),
			$keys[10] => $this->getOldPrice(),
			$keys[11] => $this->getOptOldPriceBrutto(),
			$keys[12] => $this->getCurrencyOldPrice(),
			$keys[13] => $this->getOptVat(),
			$keys[14] => $this->getCurrencyExchange(),
			$keys[15] => $this->getActive(),
			$keys[16] => $this->getHidePrice(),
			$keys[17] => $this->getHasFixedCurrency(),
			$keys[18] => $this->getOptImage(),
			$keys[19] => $this->getOptName(),
			$keys[20] => $this->getOptShortDescription(),
			$keys[21] => $this->getOptDescription(),
			$keys[22] => $this->getOptUrl(),
			$keys[23] => $this->getOptAssetFolder(),
			$keys[24] => $this->getOptUom(),
			$keys[25] => $this->getMinQty(),
			$keys[26] => $this->getMaxQty(),
			$keys[27] => $this->getStepQty(),
			$keys[28] => $this->getIsStockValidated(),
			$keys[29] => $this->getStockInDecimals(),
			$keys[30] => $this->getAvailabilityId(),
			$keys[31] => $this->getWeight(),
			$keys[32] => $this->getStock(),
			$keys[33] => $this->getMaxDiscount(),
			$keys[34] => $this->getOptHasOptions(),
			$keys[35] => $this->getOptionsColor(),
			$keys[36] => $this->getTaxId(),
			$keys[37] => $this->getWholesaleANetto(),
			$keys[38] => $this->getWholesaleBNetto(),
			$keys[39] => $this->getWholesaleCNetto(),
			$keys[40] => $this->getWholesaleABrutto(),
			$keys[41] => $this->getWholesaleBBrutto(),
			$keys[42] => $this->getWholesaleCBrutto(),
			$keys[43] => $this->getCurrencyWholesaleA(),
			$keys[44] => $this->getCurrencyWholesaleB(),
			$keys[45] => $this->getCurrencyWholesaleC(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setParentId($value);
				break;
			case 4:
				$this->setCurrencyId($value);
				break;
			case 5:
				$this->setProducerId($value);
				break;
			case 6:
				$this->setCode($value);
				break;
			case 7:
				$this->setPrice($value);
				break;
			case 8:
				$this->setOptPriceBrutto($value);
				break;
			case 9:
				$this->setCurrencyPrice($value);
				break;
			case 10:
				$this->setOldPrice($value);
				break;
			case 11:
				$this->setOptOldPriceBrutto($value);
				break;
			case 12:
				$this->setCurrencyOldPrice($value);
				break;
			case 13:
				$this->setOptVat($value);
				break;
			case 14:
				$this->setCurrencyExchange($value);
				break;
			case 15:
				$this->setActive($value);
				break;
			case 16:
				$this->setHidePrice($value);
				break;
			case 17:
				$this->setHasFixedCurrency($value);
				break;
			case 18:
				$this->setOptImage($value);
				break;
			case 19:
				$this->setOptName($value);
				break;
			case 20:
				$this->setOptShortDescription($value);
				break;
			case 21:
				$this->setOptDescription($value);
				break;
			case 22:
				$this->setOptUrl($value);
				break;
			case 23:
				$this->setOptAssetFolder($value);
				break;
			case 24:
				$this->setOptUom($value);
				break;
			case 25:
				$this->setMinQty($value);
				break;
			case 26:
				$this->setMaxQty($value);
				break;
			case 27:
				$this->setStepQty($value);
				break;
			case 28:
				$this->setIsStockValidated($value);
				break;
			case 29:
				$this->setStockInDecimals($value);
				break;
			case 30:
				$this->setAvailabilityId($value);
				break;
			case 31:
				$this->setWeight($value);
				break;
			case 32:
				$this->setStock($value);
				break;
			case 33:
				$this->setMaxDiscount($value);
				break;
			case 34:
				$this->setOptHasOptions($value);
				break;
			case 35:
				$this->setOptionsColor($value);
				break;
			case 36:
				$this->setTaxId($value);
				break;
			case 37:
				$this->setWholesaleANetto($value);
				break;
			case 38:
				$this->setWholesaleBNetto($value);
				break;
			case 39:
				$this->setWholesaleCNetto($value);
				break;
			case 40:
				$this->setWholesaleABrutto($value);
				break;
			case 41:
				$this->setWholesaleBBrutto($value);
				break;
			case 42:
				$this->setWholesaleCBrutto($value);
				break;
			case 43:
				$this->setCurrencyWholesaleA($value);
				break;
			case 44:
				$this->setCurrencyWholesaleB($value);
				break;
			case 45:
				$this->setCurrencyWholesaleC($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setParentId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setCurrencyId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setProducerId($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setCode($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setPrice($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOptPriceBrutto($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setCurrencyPrice($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setOldPrice($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setOptOldPriceBrutto($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setCurrencyOldPrice($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setOptVat($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setCurrencyExchange($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setActive($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setHidePrice($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setHasFixedCurrency($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setOptImage($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setOptName($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setOptShortDescription($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setOptDescription($arr[$keys[21]]);
		if (array_key_exists($keys[22], $arr)) $this->setOptUrl($arr[$keys[22]]);
		if (array_key_exists($keys[23], $arr)) $this->setOptAssetFolder($arr[$keys[23]]);
		if (array_key_exists($keys[24], $arr)) $this->setOptUom($arr[$keys[24]]);
		if (array_key_exists($keys[25], $arr)) $this->setMinQty($arr[$keys[25]]);
		if (array_key_exists($keys[26], $arr)) $this->setMaxQty($arr[$keys[26]]);
		if (array_key_exists($keys[27], $arr)) $this->setStepQty($arr[$keys[27]]);
		if (array_key_exists($keys[28], $arr)) $this->setIsStockValidated($arr[$keys[28]]);
		if (array_key_exists($keys[29], $arr)) $this->setStockInDecimals($arr[$keys[29]]);
		if (array_key_exists($keys[30], $arr)) $this->setAvailabilityId($arr[$keys[30]]);
		if (array_key_exists($keys[31], $arr)) $this->setWeight($arr[$keys[31]]);
		if (array_key_exists($keys[32], $arr)) $this->setStock($arr[$keys[32]]);
		if (array_key_exists($keys[33], $arr)) $this->setMaxDiscount($arr[$keys[33]]);
		if (array_key_exists($keys[34], $arr)) $this->setOptHasOptions($arr[$keys[34]]);
		if (array_key_exists($keys[35], $arr)) $this->setOptionsColor($arr[$keys[35]]);
		if (array_key_exists($keys[36], $arr)) $this->setTaxId($arr[$keys[36]]);
		if (array_key_exists($keys[37], $arr)) $this->setWholesaleANetto($arr[$keys[37]]);
		if (array_key_exists($keys[38], $arr)) $this->setWholesaleBNetto($arr[$keys[38]]);
		if (array_key_exists($keys[39], $arr)) $this->setWholesaleCNetto($arr[$keys[39]]);
		if (array_key_exists($keys[40], $arr)) $this->setWholesaleABrutto($arr[$keys[40]]);
		if (array_key_exists($keys[41], $arr)) $this->setWholesaleBBrutto($arr[$keys[41]]);
		if (array_key_exists($keys[42], $arr)) $this->setWholesaleCBrutto($arr[$keys[42]]);
		if (array_key_exists($keys[43], $arr)) $this->setCurrencyWholesaleA($arr[$keys[43]]);
		if (array_key_exists($keys[44], $arr)) $this->setCurrencyWholesaleB($arr[$keys[44]]);
		if (array_key_exists($keys[45], $arr)) $this->setCurrencyWholesaleC($arr[$keys[45]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductPeer::CREATED_AT)) $criteria->add(ProductPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductPeer::UPDATED_AT)) $criteria->add(ProductPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductPeer::ID)) $criteria->add(ProductPeer::ID, $this->id);
		if ($this->isColumnModified(ProductPeer::PARENT_ID)) $criteria->add(ProductPeer::PARENT_ID, $this->parent_id);
		if ($this->isColumnModified(ProductPeer::CURRENCY_ID)) $criteria->add(ProductPeer::CURRENCY_ID, $this->currency_id);
		if ($this->isColumnModified(ProductPeer::PRODUCER_ID)) $criteria->add(ProductPeer::PRODUCER_ID, $this->producer_id);
		if ($this->isColumnModified(ProductPeer::CODE)) $criteria->add(ProductPeer::CODE, $this->code);
		if ($this->isColumnModified(ProductPeer::PRICE)) $criteria->add(ProductPeer::PRICE, $this->price);
		if ($this->isColumnModified(ProductPeer::OPT_PRICE_BRUTTO)) $criteria->add(ProductPeer::OPT_PRICE_BRUTTO, $this->opt_price_brutto);
		if ($this->isColumnModified(ProductPeer::CURRENCY_PRICE)) $criteria->add(ProductPeer::CURRENCY_PRICE, $this->currency_price);
		if ($this->isColumnModified(ProductPeer::OLD_PRICE)) $criteria->add(ProductPeer::OLD_PRICE, $this->old_price);
		if ($this->isColumnModified(ProductPeer::OPT_OLD_PRICE_BRUTTO)) $criteria->add(ProductPeer::OPT_OLD_PRICE_BRUTTO, $this->opt_old_price_brutto);
		if ($this->isColumnModified(ProductPeer::CURRENCY_OLD_PRICE)) $criteria->add(ProductPeer::CURRENCY_OLD_PRICE, $this->currency_old_price);
		if ($this->isColumnModified(ProductPeer::OPT_VAT)) $criteria->add(ProductPeer::OPT_VAT, $this->opt_vat);
		if ($this->isColumnModified(ProductPeer::CURRENCY_EXCHANGE)) $criteria->add(ProductPeer::CURRENCY_EXCHANGE, $this->currency_exchange);
		if ($this->isColumnModified(ProductPeer::ACTIVE)) $criteria->add(ProductPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(ProductPeer::HIDE_PRICE)) $criteria->add(ProductPeer::HIDE_PRICE, $this->hide_price);
		if ($this->isColumnModified(ProductPeer::HAS_FIXED_CURRENCY)) $criteria->add(ProductPeer::HAS_FIXED_CURRENCY, $this->has_fixed_currency);
		if ($this->isColumnModified(ProductPeer::OPT_IMAGE)) $criteria->add(ProductPeer::OPT_IMAGE, $this->opt_image);
		if ($this->isColumnModified(ProductPeer::OPT_NAME)) $criteria->add(ProductPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(ProductPeer::OPT_SHORT_DESCRIPTION)) $criteria->add(ProductPeer::OPT_SHORT_DESCRIPTION, $this->opt_short_description);
		if ($this->isColumnModified(ProductPeer::OPT_DESCRIPTION)) $criteria->add(ProductPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(ProductPeer::OPT_URL)) $criteria->add(ProductPeer::OPT_URL, $this->opt_url);
		if ($this->isColumnModified(ProductPeer::OPT_ASSET_FOLDER)) $criteria->add(ProductPeer::OPT_ASSET_FOLDER, $this->opt_asset_folder);
		if ($this->isColumnModified(ProductPeer::OPT_UOM)) $criteria->add(ProductPeer::OPT_UOM, $this->opt_uom);
		if ($this->isColumnModified(ProductPeer::MIN_QTY)) $criteria->add(ProductPeer::MIN_QTY, $this->min_qty);
		if ($this->isColumnModified(ProductPeer::MAX_QTY)) $criteria->add(ProductPeer::MAX_QTY, $this->max_qty);
		if ($this->isColumnModified(ProductPeer::STEP_QTY)) $criteria->add(ProductPeer::STEP_QTY, $this->step_qty);
		if ($this->isColumnModified(ProductPeer::IS_STOCK_VALIDATED)) $criteria->add(ProductPeer::IS_STOCK_VALIDATED, $this->is_stock_validated);
		if ($this->isColumnModified(ProductPeer::STOCK_IN_DECIMALS)) $criteria->add(ProductPeer::STOCK_IN_DECIMALS, $this->stock_in_decimals);
		if ($this->isColumnModified(ProductPeer::AVAILABILITY_ID)) $criteria->add(ProductPeer::AVAILABILITY_ID, $this->availability_id);
		if ($this->isColumnModified(ProductPeer::WEIGHT)) $criteria->add(ProductPeer::WEIGHT, $this->weight);
		if ($this->isColumnModified(ProductPeer::STOCK)) $criteria->add(ProductPeer::STOCK, $this->stock);
		if ($this->isColumnModified(ProductPeer::MAX_DISCOUNT)) $criteria->add(ProductPeer::MAX_DISCOUNT, $this->max_discount);
		if ($this->isColumnModified(ProductPeer::OPT_HAS_OPTIONS)) $criteria->add(ProductPeer::OPT_HAS_OPTIONS, $this->opt_has_options);
		if ($this->isColumnModified(ProductPeer::OPTIONS_COLOR)) $criteria->add(ProductPeer::OPTIONS_COLOR, $this->options_color);
		if ($this->isColumnModified(ProductPeer::TAX_ID)) $criteria->add(ProductPeer::TAX_ID, $this->tax_id);
		if ($this->isColumnModified(ProductPeer::WHOLESALE_A_NETTO)) $criteria->add(ProductPeer::WHOLESALE_A_NETTO, $this->wholesale_a_netto);
		if ($this->isColumnModified(ProductPeer::WHOLESALE_B_NETTO)) $criteria->add(ProductPeer::WHOLESALE_B_NETTO, $this->wholesale_b_netto);
		if ($this->isColumnModified(ProductPeer::WHOLESALE_C_NETTO)) $criteria->add(ProductPeer::WHOLESALE_C_NETTO, $this->wholesale_c_netto);
		if ($this->isColumnModified(ProductPeer::WHOLESALE_A_BRUTTO)) $criteria->add(ProductPeer::WHOLESALE_A_BRUTTO, $this->wholesale_a_brutto);
		if ($this->isColumnModified(ProductPeer::WHOLESALE_B_BRUTTO)) $criteria->add(ProductPeer::WHOLESALE_B_BRUTTO, $this->wholesale_b_brutto);
		if ($this->isColumnModified(ProductPeer::WHOLESALE_C_BRUTTO)) $criteria->add(ProductPeer::WHOLESALE_C_BRUTTO, $this->wholesale_c_brutto);
		if ($this->isColumnModified(ProductPeer::CURRENCY_WHOLESALE_A)) $criteria->add(ProductPeer::CURRENCY_WHOLESALE_A, $this->currency_wholesale_a);
		if ($this->isColumnModified(ProductPeer::CURRENCY_WHOLESALE_B)) $criteria->add(ProductPeer::CURRENCY_WHOLESALE_B, $this->currency_wholesale_b);
		if ($this->isColumnModified(ProductPeer::CURRENCY_WHOLESALE_C)) $criteria->add(ProductPeer::CURRENCY_WHOLESALE_C, $this->currency_wholesale_c);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductPeer::DATABASE_NAME);

		$criteria->add(ProductPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setParentId($this->parent_id);

		$copyObj->setCurrencyId($this->currency_id);

		$copyObj->setProducerId($this->producer_id);

		$copyObj->setCode($this->code);

		$copyObj->setPrice($this->price);

		$copyObj->setOptPriceBrutto($this->opt_price_brutto);

		$copyObj->setCurrencyPrice($this->currency_price);

		$copyObj->setOldPrice($this->old_price);

		$copyObj->setOptOldPriceBrutto($this->opt_old_price_brutto);

		$copyObj->setCurrencyOldPrice($this->currency_old_price);

		$copyObj->setOptVat($this->opt_vat);

		$copyObj->setCurrencyExchange($this->currency_exchange);

		$copyObj->setActive($this->active);

		$copyObj->setHidePrice($this->hide_price);

		$copyObj->setHasFixedCurrency($this->has_fixed_currency);

		$copyObj->setOptImage($this->opt_image);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptShortDescription($this->opt_short_description);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setOptUrl($this->opt_url);

		$copyObj->setOptAssetFolder($this->opt_asset_folder);

		$copyObj->setOptUom($this->opt_uom);

		$copyObj->setMinQty($this->min_qty);

		$copyObj->setMaxQty($this->max_qty);

		$copyObj->setStepQty($this->step_qty);

		$copyObj->setIsStockValidated($this->is_stock_validated);

		$copyObj->setStockInDecimals($this->stock_in_decimals);

		$copyObj->setAvailabilityId($this->availability_id);

		$copyObj->setWeight($this->weight);

		$copyObj->setStock($this->stock);

		$copyObj->setMaxDiscount($this->max_discount);

		$copyObj->setOptHasOptions($this->opt_has_options);

		$copyObj->setOptionsColor($this->options_color);

		$copyObj->setTaxId($this->tax_id);

		$copyObj->setWholesaleANetto($this->wholesale_a_netto);

		$copyObj->setWholesaleBNetto($this->wholesale_b_netto);

		$copyObj->setWholesaleCNetto($this->wholesale_c_netto);

		$copyObj->setWholesaleABrutto($this->wholesale_a_brutto);

		$copyObj->setWholesaleBBrutto($this->wholesale_b_brutto);

		$copyObj->setWholesaleCBrutto($this->wholesale_c_brutto);

		$copyObj->setCurrencyWholesaleA($this->currency_wholesale_a);

		$copyObj->setCurrencyWholesaleB($this->currency_wholesale_b);

		$copyObj->setCurrencyWholesaleC($this->currency_wholesale_c);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getQuestionss() as $relObj) {
				$copyObj->addQuestions($relObj->copy($deepCopy));
			}

			foreach($this->getBasketProducts() as $relObj) {
				$copyObj->addBasketProduct($relObj->copy($deepCopy));
			}

			foreach($this->getDiscountHasProducts() as $relObj) {
				$copyObj->addDiscountHasProduct($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasAccessoriessRelatedByAccessoriesId() as $relObj) {
				$copyObj->addProductHasAccessoriesRelatedByAccessoriesId($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasAccessoriessRelatedByProductId() as $relObj) {
				$copyObj->addProductHasAccessoriesRelatedByProductId($relObj->copy($deepCopy));
			}

			foreach($this->getProductGroupHasProducts() as $relObj) {
				$copyObj->addProductGroupHasProduct($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasPositionings() as $relObj) {
				$copyObj->addProductHasPositioning($relObj->copy($deepCopy));
			}

			foreach($this->getCrossellingsRelatedByFirstProductId() as $relObj) {
				$copyObj->addCrossellingRelatedByFirstProductId($relObj->copy($deepCopy));
			}

			foreach($this->getCrossellingsRelatedBySecoundProductId() as $relObj) {
				$copyObj->addCrossellingRelatedBySecoundProductId($relObj->copy($deepCopy));
			}

			foreach($this->getProductSearchIndexs() as $relObj) {
				$copyObj->addProductSearchIndex($relObj->copy($deepCopy));
			}

			foreach($this->getProductsRelatedByParentId() as $relObj) {
				if($this->getPrimaryKey() === $relObj->getPrimaryKey()) {
						continue;
				}

				$copyObj->addProductRelatedByParentId($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasCategorys() as $relObj) {
				$copyObj->addProductHasCategory($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasSfAssets() as $relObj) {
				$copyObj->addProductHasSfAsset($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasAttachments() as $relObj) {
				$copyObj->addProductHasAttachment($relObj->copy($deepCopy));
			}

			foreach($this->getProductI18ns() as $relObj) {
				$copyObj->addProductI18n($relObj->copy($deepCopy));
			}

			foreach($this->getOrderProducts() as $relObj) {
				$copyObj->addOrderProduct($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsValues() as $relObj) {
				$copyObj->addProductOptionsValue($relObj->copy($deepCopy));
			}

			foreach($this->getInvoiceProducts() as $relObj) {
				$copyObj->addInvoiceProduct($relObj->copy($deepCopy));
			}

			foreach($this->getRecommendSends() as $relObj) {
				$copyObj->addRecommendSend($relObj->copy($deepCopy));
			}

			foreach($this->getReviews() as $relObj) {
				$copyObj->addReview($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasAttributeFields() as $relObj) {
				$copyObj->addProductHasAttributeField($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasWholesales() as $relObj) {
				$copyObj->addProductHasWholesale($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductPeer();
		}
		return self::$peer;
	}

	
	public function setProductRelatedByParentId($v)
	{


		if ($v === null) {
			$this->setParentId(NULL);
		} else {
			$this->setParentId($v->getId());
		}


		$this->aProductRelatedByParentId = $v;
	}


	
	public function getProductRelatedByParentId($con = null)
	{
		if ($this->aProductRelatedByParentId === null && ($this->parent_id !== null)) {
						$this->aProductRelatedByParentId = ProductPeer::retrieveByPK($this->parent_id, $con);

			
		}
		return $this->aProductRelatedByParentId;
	}

	
	public function setCurrency($v)
	{


		if ($v === null) {
			$this->setCurrencyId(NULL);
		} else {
			$this->setCurrencyId($v->getId());
		}


		$this->aCurrency = $v;
	}


	
	public function getCurrency($con = null)
	{
		if ($this->aCurrency === null && ($this->currency_id !== null)) {
						$this->aCurrency = CurrencyPeer::retrieveByPK($this->currency_id, $con);

			
		}
		return $this->aCurrency;
	}

	
	public function setProducer($v)
	{


		if ($v === null) {
			$this->setProducerId(NULL);
		} else {
			$this->setProducerId($v->getId());
		}


		$this->aProducer = $v;
	}


	
	public function getProducer($con = null)
	{
		if ($this->aProducer === null && ($this->producer_id !== null)) {
						$this->aProducer = ProducerPeer::retrieveByPK($this->producer_id, $con);

			
		}
		return $this->aProducer;
	}

	
	public function setAvailability($v)
	{


		if ($v === null) {
			$this->setAvailabilityId(NULL);
		} else {
			$this->setAvailabilityId($v->getId());
		}


		$this->aAvailability = $v;
	}


	
	public function getAvailability($con = null)
	{
		if ($this->aAvailability === null && ($this->availability_id !== null)) {
						$this->aAvailability = AvailabilityPeer::retrieveByPK($this->availability_id, $con);

			
		}
		return $this->aAvailability;
	}

	
	public function setTax($v)
	{


		if ($v === null) {
			$this->setTaxId(NULL);
		} else {
			$this->setTaxId($v->getId());
		}


		$this->aTax = $v;
	}


	
	public function getTax($con = null)
	{
		if ($this->aTax === null && ($this->tax_id !== null)) {
						$this->aTax = TaxPeer::retrieveByPK($this->tax_id, $con);

			
		}
		return $this->aTax;
	}

	
	public function initQuestionss()
	{
		if ($this->collQuestionss === null) {
			$this->collQuestionss = array();
		}
	}

	
	public function getQuestionss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collQuestionss === null) {
			if ($this->isNew()) {
			   $this->collQuestionss = array();
			} else {

				$criteria->add(QuestionsPeer::ITEM_ID, $this->getId());

				QuestionsPeer::addSelectColumns($criteria);
				$this->collQuestionss = QuestionsPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(QuestionsPeer::ITEM_ID, $this->getId());

				QuestionsPeer::addSelectColumns($criteria);
				if (!isset($this->lastQuestionsCriteria) || !$this->lastQuestionsCriteria->equals($criteria)) {
					$this->collQuestionss = QuestionsPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastQuestionsCriteria = $criteria;
		return $this->collQuestionss;
	}

	
	public function countQuestionss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(QuestionsPeer::ITEM_ID, $this->getId());

		return QuestionsPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addQuestions(Questions $l)
	{
		$this->collQuestionss[] = $l;
		$l->setProduct($this);
	}


	
	public function getQuestionssJoinQuestionStatus($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collQuestionss === null) {
			if ($this->isNew()) {
				$this->collQuestionss = array();
			} else {

				$criteria->add(QuestionsPeer::ITEM_ID, $this->getId());

				$this->collQuestionss = QuestionsPeer::doSelectJoinQuestionStatus($criteria, $con);
			}
		} else {
									
			$criteria->add(QuestionsPeer::ITEM_ID, $this->getId());

			if (!isset($this->lastQuestionsCriteria) || !$this->lastQuestionsCriteria->equals($criteria)) {
				$this->collQuestionss = QuestionsPeer::doSelectJoinQuestionStatus($criteria, $con);
			}
		}
		$this->lastQuestionsCriteria = $criteria;

		return $this->collQuestionss;
	}

	
	public function initBasketProducts()
	{
		if ($this->collBasketProducts === null) {
			$this->collBasketProducts = array();
		}
	}

	
	public function getBasketProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBasketProducts === null) {
			if ($this->isNew()) {
			   $this->collBasketProducts = array();
			} else {

				$criteria->add(BasketProductPeer::PRODUCT_ID, $this->getId());

				BasketProductPeer::addSelectColumns($criteria);
				$this->collBasketProducts = BasketProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(BasketProductPeer::PRODUCT_ID, $this->getId());

				BasketProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastBasketProductCriteria) || !$this->lastBasketProductCriteria->equals($criteria)) {
					$this->collBasketProducts = BasketProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBasketProductCriteria = $criteria;
		return $this->collBasketProducts;
	}

	
	public function countBasketProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(BasketProductPeer::PRODUCT_ID, $this->getId());

		return BasketProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addBasketProduct(BasketProduct $l)
	{
		$this->collBasketProducts[] = $l;
		$l->setProduct($this);
	}


	
	public function getBasketProductsJoinBasket($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBasketProducts === null) {
			if ($this->isNew()) {
				$this->collBasketProducts = array();
			} else {

				$criteria->add(BasketProductPeer::PRODUCT_ID, $this->getId());

				$this->collBasketProducts = BasketProductPeer::doSelectJoinBasket($criteria, $con);
			}
		} else {
									
			$criteria->add(BasketProductPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastBasketProductCriteria) || !$this->lastBasketProductCriteria->equals($criteria)) {
				$this->collBasketProducts = BasketProductPeer::doSelectJoinBasket($criteria, $con);
			}
		}
		$this->lastBasketProductCriteria = $criteria;

		return $this->collBasketProducts;
	}

	
	public function initDiscountHasProducts()
	{
		if ($this->collDiscountHasProducts === null) {
			$this->collDiscountHasProducts = array();
		}
	}

	
	public function getDiscountHasProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDiscountHasProducts === null) {
			if ($this->isNew()) {
			   $this->collDiscountHasProducts = array();
			} else {

				$criteria->add(DiscountHasProductPeer::PRODUCT_ID, $this->getId());

				DiscountHasProductPeer::addSelectColumns($criteria);
				$this->collDiscountHasProducts = DiscountHasProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DiscountHasProductPeer::PRODUCT_ID, $this->getId());

				DiscountHasProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastDiscountHasProductCriteria) || !$this->lastDiscountHasProductCriteria->equals($criteria)) {
					$this->collDiscountHasProducts = DiscountHasProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDiscountHasProductCriteria = $criteria;
		return $this->collDiscountHasProducts;
	}

	
	public function countDiscountHasProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DiscountHasProductPeer::PRODUCT_ID, $this->getId());

		return DiscountHasProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDiscountHasProduct(DiscountHasProduct $l)
	{
		$this->collDiscountHasProducts[] = $l;
		$l->setProduct($this);
	}


	
	public function getDiscountHasProductsJoinDiscount($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDiscountHasProducts === null) {
			if ($this->isNew()) {
				$this->collDiscountHasProducts = array();
			} else {

				$criteria->add(DiscountHasProductPeer::PRODUCT_ID, $this->getId());

				$this->collDiscountHasProducts = DiscountHasProductPeer::doSelectJoinDiscount($criteria, $con);
			}
		} else {
									
			$criteria->add(DiscountHasProductPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastDiscountHasProductCriteria) || !$this->lastDiscountHasProductCriteria->equals($criteria)) {
				$this->collDiscountHasProducts = DiscountHasProductPeer::doSelectJoinDiscount($criteria, $con);
			}
		}
		$this->lastDiscountHasProductCriteria = $criteria;

		return $this->collDiscountHasProducts;
	}

	
	public function initProductHasAccessoriessRelatedByAccessoriesId()
	{
		if ($this->collProductHasAccessoriessRelatedByAccessoriesId === null) {
			$this->collProductHasAccessoriessRelatedByAccessoriesId = array();
		}
	}

	
	public function getProductHasAccessoriessRelatedByAccessoriesId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAccessoriessRelatedByAccessoriesId === null) {
			if ($this->isNew()) {
			   $this->collProductHasAccessoriessRelatedByAccessoriesId = array();
			} else {

				$criteria->add(ProductHasAccessoriesPeer::ACCESSORIES_ID, $this->getId());

				ProductHasAccessoriesPeer::addSelectColumns($criteria);
				$this->collProductHasAccessoriessRelatedByAccessoriesId = ProductHasAccessoriesPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasAccessoriesPeer::ACCESSORIES_ID, $this->getId());

				ProductHasAccessoriesPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasAccessoriesRelatedByAccessoriesIdCriteria) || !$this->lastProductHasAccessoriesRelatedByAccessoriesIdCriteria->equals($criteria)) {
					$this->collProductHasAccessoriessRelatedByAccessoriesId = ProductHasAccessoriesPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasAccessoriesRelatedByAccessoriesIdCriteria = $criteria;
		return $this->collProductHasAccessoriessRelatedByAccessoriesId;
	}

	
	public function countProductHasAccessoriessRelatedByAccessoriesId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasAccessoriesPeer::ACCESSORIES_ID, $this->getId());

		return ProductHasAccessoriesPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasAccessoriesRelatedByAccessoriesId(ProductHasAccessories $l)
	{
		$this->collProductHasAccessoriessRelatedByAccessoriesId[] = $l;
		$l->setProductRelatedByAccessoriesId($this);
	}

	
	public function initProductHasAccessoriessRelatedByProductId()
	{
		if ($this->collProductHasAccessoriessRelatedByProductId === null) {
			$this->collProductHasAccessoriessRelatedByProductId = array();
		}
	}

	
	public function getProductHasAccessoriessRelatedByProductId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAccessoriessRelatedByProductId === null) {
			if ($this->isNew()) {
			   $this->collProductHasAccessoriessRelatedByProductId = array();
			} else {

				$criteria->add(ProductHasAccessoriesPeer::PRODUCT_ID, $this->getId());

				ProductHasAccessoriesPeer::addSelectColumns($criteria);
				$this->collProductHasAccessoriessRelatedByProductId = ProductHasAccessoriesPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasAccessoriesPeer::PRODUCT_ID, $this->getId());

				ProductHasAccessoriesPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasAccessoriesRelatedByProductIdCriteria) || !$this->lastProductHasAccessoriesRelatedByProductIdCriteria->equals($criteria)) {
					$this->collProductHasAccessoriessRelatedByProductId = ProductHasAccessoriesPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasAccessoriesRelatedByProductIdCriteria = $criteria;
		return $this->collProductHasAccessoriessRelatedByProductId;
	}

	
	public function countProductHasAccessoriessRelatedByProductId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasAccessoriesPeer::PRODUCT_ID, $this->getId());

		return ProductHasAccessoriesPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasAccessoriesRelatedByProductId(ProductHasAccessories $l)
	{
		$this->collProductHasAccessoriessRelatedByProductId[] = $l;
		$l->setProductRelatedByProductId($this);
	}

	
	public function initProductGroupHasProducts()
	{
		if ($this->collProductGroupHasProducts === null) {
			$this->collProductGroupHasProducts = array();
		}
	}

	
	public function getProductGroupHasProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductGroupHasProducts === null) {
			if ($this->isNew()) {
			   $this->collProductGroupHasProducts = array();
			} else {

				$criteria->add(ProductGroupHasProductPeer::PRODUCT_ID, $this->getId());

				ProductGroupHasProductPeer::addSelectColumns($criteria);
				$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductGroupHasProductPeer::PRODUCT_ID, $this->getId());

				ProductGroupHasProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductGroupHasProductCriteria) || !$this->lastProductGroupHasProductCriteria->equals($criteria)) {
					$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductGroupHasProductCriteria = $criteria;
		return $this->collProductGroupHasProducts;
	}

	
	public function countProductGroupHasProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductGroupHasProductPeer::PRODUCT_ID, $this->getId());

		return ProductGroupHasProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductGroupHasProduct(ProductGroupHasProduct $l)
	{
		$this->collProductGroupHasProducts[] = $l;
		$l->setProduct($this);
	}


	
	public function getProductGroupHasProductsJoinProductGroup($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductGroupHasProducts === null) {
			if ($this->isNew()) {
				$this->collProductGroupHasProducts = array();
			} else {

				$criteria->add(ProductGroupHasProductPeer::PRODUCT_ID, $this->getId());

				$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelectJoinProductGroup($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductGroupHasProductPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductGroupHasProductCriteria) || !$this->lastProductGroupHasProductCriteria->equals($criteria)) {
				$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelectJoinProductGroup($criteria, $con);
			}
		}
		$this->lastProductGroupHasProductCriteria = $criteria;

		return $this->collProductGroupHasProducts;
	}

	
	public function initProductHasPositionings()
	{
		if ($this->collProductHasPositionings === null) {
			$this->collProductHasPositionings = array();
		}
	}

	
	public function getProductHasPositionings($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasPositionings === null) {
			if ($this->isNew()) {
			   $this->collProductHasPositionings = array();
			} else {

				$criteria->add(ProductHasPositioningPeer::PRODUCT_ID, $this->getId());

				ProductHasPositioningPeer::addSelectColumns($criteria);
				$this->collProductHasPositionings = ProductHasPositioningPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasPositioningPeer::PRODUCT_ID, $this->getId());

				ProductHasPositioningPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasPositioningCriteria) || !$this->lastProductHasPositioningCriteria->equals($criteria)) {
					$this->collProductHasPositionings = ProductHasPositioningPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasPositioningCriteria = $criteria;
		return $this->collProductHasPositionings;
	}

	
	public function countProductHasPositionings($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasPositioningPeer::PRODUCT_ID, $this->getId());

		return ProductHasPositioningPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasPositioning(ProductHasPositioning $l)
	{
		$this->collProductHasPositionings[] = $l;
		$l->setProduct($this);
	}

	
	public function initCrossellingsRelatedByFirstProductId()
	{
		if ($this->collCrossellingsRelatedByFirstProductId === null) {
			$this->collCrossellingsRelatedByFirstProductId = array();
		}
	}

	
	public function getCrossellingsRelatedByFirstProductId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCrossellingsRelatedByFirstProductId === null) {
			if ($this->isNew()) {
			   $this->collCrossellingsRelatedByFirstProductId = array();
			} else {

				$criteria->add(CrossellingPeer::FIRST_PRODUCT_ID, $this->getId());

				CrossellingPeer::addSelectColumns($criteria);
				$this->collCrossellingsRelatedByFirstProductId = CrossellingPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CrossellingPeer::FIRST_PRODUCT_ID, $this->getId());

				CrossellingPeer::addSelectColumns($criteria);
				if (!isset($this->lastCrossellingRelatedByFirstProductIdCriteria) || !$this->lastCrossellingRelatedByFirstProductIdCriteria->equals($criteria)) {
					$this->collCrossellingsRelatedByFirstProductId = CrossellingPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCrossellingRelatedByFirstProductIdCriteria = $criteria;
		return $this->collCrossellingsRelatedByFirstProductId;
	}

	
	public function countCrossellingsRelatedByFirstProductId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CrossellingPeer::FIRST_PRODUCT_ID, $this->getId());

		return CrossellingPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCrossellingRelatedByFirstProductId(Crosselling $l)
	{
		$this->collCrossellingsRelatedByFirstProductId[] = $l;
		$l->setProductRelatedByFirstProductId($this);
	}

	
	public function initCrossellingsRelatedBySecoundProductId()
	{
		if ($this->collCrossellingsRelatedBySecoundProductId === null) {
			$this->collCrossellingsRelatedBySecoundProductId = array();
		}
	}

	
	public function getCrossellingsRelatedBySecoundProductId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCrossellingsRelatedBySecoundProductId === null) {
			if ($this->isNew()) {
			   $this->collCrossellingsRelatedBySecoundProductId = array();
			} else {

				$criteria->add(CrossellingPeer::SECOUND_PRODUCT_ID, $this->getId());

				CrossellingPeer::addSelectColumns($criteria);
				$this->collCrossellingsRelatedBySecoundProductId = CrossellingPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CrossellingPeer::SECOUND_PRODUCT_ID, $this->getId());

				CrossellingPeer::addSelectColumns($criteria);
				if (!isset($this->lastCrossellingRelatedBySecoundProductIdCriteria) || !$this->lastCrossellingRelatedBySecoundProductIdCriteria->equals($criteria)) {
					$this->collCrossellingsRelatedBySecoundProductId = CrossellingPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCrossellingRelatedBySecoundProductIdCriteria = $criteria;
		return $this->collCrossellingsRelatedBySecoundProductId;
	}

	
	public function countCrossellingsRelatedBySecoundProductId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CrossellingPeer::SECOUND_PRODUCT_ID, $this->getId());

		return CrossellingPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCrossellingRelatedBySecoundProductId(Crosselling $l)
	{
		$this->collCrossellingsRelatedBySecoundProductId[] = $l;
		$l->setProductRelatedBySecoundProductId($this);
	}

	
	public function initProductSearchIndexs()
	{
		if ($this->collProductSearchIndexs === null) {
			$this->collProductSearchIndexs = array();
		}
	}

	
	public function getProductSearchIndexs($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductSearchIndexs === null) {
			if ($this->isNew()) {
			   $this->collProductSearchIndexs = array();
			} else {

				$criteria->add(ProductSearchIndexPeer::ID, $this->getId());

				ProductSearchIndexPeer::addSelectColumns($criteria);
				$this->collProductSearchIndexs = ProductSearchIndexPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductSearchIndexPeer::ID, $this->getId());

				ProductSearchIndexPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductSearchIndexCriteria) || !$this->lastProductSearchIndexCriteria->equals($criteria)) {
					$this->collProductSearchIndexs = ProductSearchIndexPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductSearchIndexCriteria = $criteria;
		return $this->collProductSearchIndexs;
	}

	
	public function countProductSearchIndexs($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductSearchIndexPeer::ID, $this->getId());

		return ProductSearchIndexPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductSearchIndex(ProductSearchIndex $l)
	{
		$this->collProductSearchIndexs[] = $l;
		$l->setProduct($this);
	}

	
	public function initProductsRelatedByParentId()
	{
		if ($this->collProductsRelatedByParentId === null) {
			$this->collProductsRelatedByParentId = array();
		}
	}

	
	public function getProductsRelatedByParentId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductsRelatedByParentId === null) {
			if ($this->isNew()) {
			   $this->collProductsRelatedByParentId = array();
			} else {

				$criteria->add(ProductPeer::PARENT_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				$this->collProductsRelatedByParentId = ProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductPeer::PARENT_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductRelatedByParentIdCriteria) || !$this->lastProductRelatedByParentIdCriteria->equals($criteria)) {
					$this->collProductsRelatedByParentId = ProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductRelatedByParentIdCriteria = $criteria;
		return $this->collProductsRelatedByParentId;
	}

	
	public function countProductsRelatedByParentId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductPeer::PARENT_ID, $this->getId());

		return ProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductRelatedByParentId(Product $l)
	{
		$this->collProductsRelatedByParentId[] = $l;
		$l->setProductRelatedByParentId($this);
	}


	
	public function getProductsRelatedByParentIdJoinCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductsRelatedByParentId === null) {
			if ($this->isNew()) {
				$this->collProductsRelatedByParentId = array();
			} else {

				$criteria->add(ProductPeer::PARENT_ID, $this->getId());

				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PARENT_ID, $this->getId());

			if (!isset($this->lastProductRelatedByParentIdCriteria) || !$this->lastProductRelatedByParentIdCriteria->equals($criteria)) {
				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		}
		$this->lastProductRelatedByParentIdCriteria = $criteria;

		return $this->collProductsRelatedByParentId;
	}


	
	public function getProductsRelatedByParentIdJoinProducer($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductsRelatedByParentId === null) {
			if ($this->isNew()) {
				$this->collProductsRelatedByParentId = array();
			} else {

				$criteria->add(ProductPeer::PARENT_ID, $this->getId());

				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PARENT_ID, $this->getId());

			if (!isset($this->lastProductRelatedByParentIdCriteria) || !$this->lastProductRelatedByParentIdCriteria->equals($criteria)) {
				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		}
		$this->lastProductRelatedByParentIdCriteria = $criteria;

		return $this->collProductsRelatedByParentId;
	}


	
	public function getProductsRelatedByParentIdJoinAvailability($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductsRelatedByParentId === null) {
			if ($this->isNew()) {
				$this->collProductsRelatedByParentId = array();
			} else {

				$criteria->add(ProductPeer::PARENT_ID, $this->getId());

				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PARENT_ID, $this->getId());

			if (!isset($this->lastProductRelatedByParentIdCriteria) || !$this->lastProductRelatedByParentIdCriteria->equals($criteria)) {
				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		}
		$this->lastProductRelatedByParentIdCriteria = $criteria;

		return $this->collProductsRelatedByParentId;
	}


	
	public function getProductsRelatedByParentIdJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductsRelatedByParentId === null) {
			if ($this->isNew()) {
				$this->collProductsRelatedByParentId = array();
			} else {

				$criteria->add(ProductPeer::PARENT_ID, $this->getId());

				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::PARENT_ID, $this->getId());

			if (!isset($this->lastProductRelatedByParentIdCriteria) || !$this->lastProductRelatedByParentIdCriteria->equals($criteria)) {
				$this->collProductsRelatedByParentId = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastProductRelatedByParentIdCriteria = $criteria;

		return $this->collProductsRelatedByParentId;
	}

	
	public function initProductHasCategorys()
	{
		if ($this->collProductHasCategorys === null) {
			$this->collProductHasCategorys = array();
		}
	}

	
	public function getProductHasCategorys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasCategorys === null) {
			if ($this->isNew()) {
			   $this->collProductHasCategorys = array();
			} else {

				$criteria->add(ProductHasCategoryPeer::PRODUCT_ID, $this->getId());

				ProductHasCategoryPeer::addSelectColumns($criteria);
				$this->collProductHasCategorys = ProductHasCategoryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasCategoryPeer::PRODUCT_ID, $this->getId());

				ProductHasCategoryPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasCategoryCriteria) || !$this->lastProductHasCategoryCriteria->equals($criteria)) {
					$this->collProductHasCategorys = ProductHasCategoryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasCategoryCriteria = $criteria;
		return $this->collProductHasCategorys;
	}

	
	public function countProductHasCategorys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasCategoryPeer::PRODUCT_ID, $this->getId());

		return ProductHasCategoryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasCategory(ProductHasCategory $l)
	{
		$this->collProductHasCategorys[] = $l;
		$l->setProduct($this);
	}


	
	public function getProductHasCategorysJoinCategory($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasCategorys === null) {
			if ($this->isNew()) {
				$this->collProductHasCategorys = array();
			} else {

				$criteria->add(ProductHasCategoryPeer::PRODUCT_ID, $this->getId());

				$this->collProductHasCategorys = ProductHasCategoryPeer::doSelectJoinCategory($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasCategoryPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductHasCategoryCriteria) || !$this->lastProductHasCategoryCriteria->equals($criteria)) {
				$this->collProductHasCategorys = ProductHasCategoryPeer::doSelectJoinCategory($criteria, $con);
			}
		}
		$this->lastProductHasCategoryCriteria = $criteria;

		return $this->collProductHasCategorys;
	}

	
	public function initProductHasSfAssets()
	{
		if ($this->collProductHasSfAssets === null) {
			$this->collProductHasSfAssets = array();
		}
	}

	
	public function getProductHasSfAssets($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasSfAssets === null) {
			if ($this->isNew()) {
			   $this->collProductHasSfAssets = array();
			} else {

				$criteria->add(ProductHasSfAssetPeer::PRODUCT_ID, $this->getId());

				ProductHasSfAssetPeer::addSelectColumns($criteria);
				$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasSfAssetPeer::PRODUCT_ID, $this->getId());

				ProductHasSfAssetPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasSfAssetCriteria) || !$this->lastProductHasSfAssetCriteria->equals($criteria)) {
					$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasSfAssetCriteria = $criteria;
		return $this->collProductHasSfAssets;
	}

	
	public function countProductHasSfAssets($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasSfAssetPeer::PRODUCT_ID, $this->getId());

		return ProductHasSfAssetPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasSfAsset(ProductHasSfAsset $l)
	{
		$this->collProductHasSfAssets[] = $l;
		$l->setProduct($this);
	}


	
	public function getProductHasSfAssetsJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasSfAssets === null) {
			if ($this->isNew()) {
				$this->collProductHasSfAssets = array();
			} else {

				$criteria->add(ProductHasSfAssetPeer::PRODUCT_ID, $this->getId());

				$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasSfAssetPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductHasSfAssetCriteria) || !$this->lastProductHasSfAssetCriteria->equals($criteria)) {
				$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastProductHasSfAssetCriteria = $criteria;

		return $this->collProductHasSfAssets;
	}

	
	public function initProductHasAttachments()
	{
		if ($this->collProductHasAttachments === null) {
			$this->collProductHasAttachments = array();
		}
	}

	
	public function getProductHasAttachments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
			   $this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->getId());

				ProductHasAttachmentPeer::addSelectColumns($criteria);
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->getId());

				ProductHasAttachmentPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
					$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;
		return $this->collProductHasAttachments;
	}

	
	public function countProductHasAttachments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->getId());

		return ProductHasAttachmentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasAttachment(ProductHasAttachment $l)
	{
		$this->collProductHasAttachments[] = $l;
		$l->setProduct($this);
	}


	
	public function getProductHasAttachmentsJoinLanguage($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
				$this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->getId());

				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinLanguage($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinLanguage($criteria, $con);
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;

		return $this->collProductHasAttachments;
	}


	
	public function getProductHasAttachmentsJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
				$this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->getId());

				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;

		return $this->collProductHasAttachments;
	}

	
	public function initProductI18ns()
	{
		if ($this->collProductI18ns === null) {
			$this->collProductI18ns = array();
		}
	}

	
	public function getProductI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductI18ns === null) {
			if ($this->isNew()) {
			   $this->collProductI18ns = array();
			} else {

				$criteria->add(ProductI18nPeer::ID, $this->getId());

				ProductI18nPeer::addSelectColumns($criteria);
				$this->collProductI18ns = ProductI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductI18nPeer::ID, $this->getId());

				ProductI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductI18nCriteria) || !$this->lastProductI18nCriteria->equals($criteria)) {
					$this->collProductI18ns = ProductI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductI18nCriteria = $criteria;
		return $this->collProductI18ns;
	}

	
	public function countProductI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductI18nPeer::ID, $this->getId());

		return ProductI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductI18n(ProductI18n $l)
	{
		$this->collProductI18ns[] = $l;
		$l->setProduct($this);
	}

	
	public function initOrderProducts()
	{
		if ($this->collOrderProducts === null) {
			$this->collOrderProducts = array();
		}
	}

	
	public function getOrderProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
			   $this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::PRODUCT_ID, $this->getId());

				OrderProductPeer::addSelectColumns($criteria);
				$this->collOrderProducts = OrderProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderProductPeer::PRODUCT_ID, $this->getId());

				OrderProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
					$this->collOrderProducts = OrderProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderProductCriteria = $criteria;
		return $this->collOrderProducts;
	}

	
	public function countOrderProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderProductPeer::PRODUCT_ID, $this->getId());

		return OrderProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderProduct(OrderProduct $l)
	{
		$this->collOrderProducts[] = $l;
		$l->setProduct($this);
	}


	
	public function getOrderProductsJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
				$this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::PRODUCT_ID, $this->getId());

				$this->collOrderProducts = OrderProductPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderProductPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
				$this->collOrderProducts = OrderProductPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastOrderProductCriteria = $criteria;

		return $this->collOrderProducts;
	}


	
	public function getOrderProductsJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
				$this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::PRODUCT_ID, $this->getId());

				$this->collOrderProducts = OrderProductPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderProductPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
				$this->collOrderProducts = OrderProductPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastOrderProductCriteria = $criteria;

		return $this->collOrderProducts;
	}

	
	public function initProductOptionsValues()
	{
		if ($this->collProductOptionsValues === null) {
			$this->collProductOptionsValues = array();
		}
	}

	
	public function getProductOptionsValues($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
					$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;
		return $this->collProductOptionsValues;
	}

	
	public function countProductOptionsValues($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

		return ProductOptionsValuePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsValue(ProductOptionsValue $l)
	{
		$this->collProductOptionsValues[] = $l;
		$l->setProduct($this);
	}


	
	public function getProductOptionsValuesJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsTemplate($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsValueRelatedByProductOptionsValueId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsField($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}

	
	public function initInvoiceProducts()
	{
		if ($this->collInvoiceProducts === null) {
			$this->collInvoiceProducts = array();
		}
	}

	
	public function getInvoiceProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoiceProducts === null) {
			if ($this->isNew()) {
			   $this->collInvoiceProducts = array();
			} else {

				$criteria->add(InvoiceProductPeer::PRODUCT_ID, $this->getId());

				InvoiceProductPeer::addSelectColumns($criteria);
				$this->collInvoiceProducts = InvoiceProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(InvoiceProductPeer::PRODUCT_ID, $this->getId());

				InvoiceProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastInvoiceProductCriteria) || !$this->lastInvoiceProductCriteria->equals($criteria)) {
					$this->collInvoiceProducts = InvoiceProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastInvoiceProductCriteria = $criteria;
		return $this->collInvoiceProducts;
	}

	
	public function countInvoiceProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(InvoiceProductPeer::PRODUCT_ID, $this->getId());

		return InvoiceProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addInvoiceProduct(InvoiceProduct $l)
	{
		$this->collInvoiceProducts[] = $l;
		$l->setProduct($this);
	}


	
	public function getInvoiceProductsJoinInvoice($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collInvoiceProducts === null) {
			if ($this->isNew()) {
				$this->collInvoiceProducts = array();
			} else {

				$criteria->add(InvoiceProductPeer::PRODUCT_ID, $this->getId());

				$this->collInvoiceProducts = InvoiceProductPeer::doSelectJoinInvoice($criteria, $con);
			}
		} else {
									
			$criteria->add(InvoiceProductPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastInvoiceProductCriteria) || !$this->lastInvoiceProductCriteria->equals($criteria)) {
				$this->collInvoiceProducts = InvoiceProductPeer::doSelectJoinInvoice($criteria, $con);
			}
		}
		$this->lastInvoiceProductCriteria = $criteria;

		return $this->collInvoiceProducts;
	}

	
	public function initRecommendSends()
	{
		if ($this->collRecommendSends === null) {
			$this->collRecommendSends = array();
		}
	}

	
	public function getRecommendSends($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collRecommendSends === null) {
			if ($this->isNew()) {
			   $this->collRecommendSends = array();
			} else {

				$criteria->add(RecommendSendPeer::PRODUCT_ID, $this->getId());

				RecommendSendPeer::addSelectColumns($criteria);
				$this->collRecommendSends = RecommendSendPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(RecommendSendPeer::PRODUCT_ID, $this->getId());

				RecommendSendPeer::addSelectColumns($criteria);
				if (!isset($this->lastRecommendSendCriteria) || !$this->lastRecommendSendCriteria->equals($criteria)) {
					$this->collRecommendSends = RecommendSendPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastRecommendSendCriteria = $criteria;
		return $this->collRecommendSends;
	}

	
	public function countRecommendSends($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(RecommendSendPeer::PRODUCT_ID, $this->getId());

		return RecommendSendPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addRecommendSend(RecommendSend $l)
	{
		$this->collRecommendSends[] = $l;
		$l->setProduct($this);
	}


	
	public function getRecommendSendsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collRecommendSends === null) {
			if ($this->isNew()) {
				$this->collRecommendSends = array();
			} else {

				$criteria->add(RecommendSendPeer::PRODUCT_ID, $this->getId());

				$this->collRecommendSends = RecommendSendPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(RecommendSendPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastRecommendSendCriteria) || !$this->lastRecommendSendCriteria->equals($criteria)) {
				$this->collRecommendSends = RecommendSendPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastRecommendSendCriteria = $criteria;

		return $this->collRecommendSends;
	}

	
	public function initReviews()
	{
		if ($this->collReviews === null) {
			$this->collReviews = array();
		}
	}

	
	public function getReviews($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
			   $this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::PRODUCT_ID, $this->getId());

				ReviewPeer::addSelectColumns($criteria);
				$this->collReviews = ReviewPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ReviewPeer::PRODUCT_ID, $this->getId());

				ReviewPeer::addSelectColumns($criteria);
				if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
					$this->collReviews = ReviewPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastReviewCriteria = $criteria;
		return $this->collReviews;
	}

	
	public function countReviews($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ReviewPeer::PRODUCT_ID, $this->getId());

		return ReviewPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addReview(Review $l)
	{
		$this->collReviews[] = $l;
		$l->setProduct($this);
	}


	
	public function getReviewsJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
				$this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::PRODUCT_ID, $this->getId());

				$this->collReviews = ReviewPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
				$this->collReviews = ReviewPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastReviewCriteria = $criteria;

		return $this->collReviews;
	}


	
	public function getReviewsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
				$this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::PRODUCT_ID, $this->getId());

				$this->collReviews = ReviewPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
				$this->collReviews = ReviewPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastReviewCriteria = $criteria;

		return $this->collReviews;
	}

	
	public function initProductHasAttributeFields()
	{
		if ($this->collProductHasAttributeFields === null) {
			$this->collProductHasAttributeFields = array();
		}
	}

	
	public function getProductHasAttributeFields($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttributeFields === null) {
			if ($this->isNew()) {
			   $this->collProductHasAttributeFields = array();
			} else {

				$criteria->add(ProductHasAttributeFieldPeer::PRODUCT_ID, $this->getId());

				ProductHasAttributeFieldPeer::addSelectColumns($criteria);
				$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasAttributeFieldPeer::PRODUCT_ID, $this->getId());

				ProductHasAttributeFieldPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasAttributeFieldCriteria) || !$this->lastProductHasAttributeFieldCriteria->equals($criteria)) {
					$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasAttributeFieldCriteria = $criteria;
		return $this->collProductHasAttributeFields;
	}

	
	public function countProductHasAttributeFields($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasAttributeFieldPeer::PRODUCT_ID, $this->getId());

		return ProductHasAttributeFieldPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasAttributeField(ProductHasAttributeField $l)
	{
		$this->collProductHasAttributeFields[] = $l;
		$l->setProduct($this);
	}


	
	public function getProductHasAttributeFieldsJoinAttributeField($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttributeFields === null) {
			if ($this->isNew()) {
				$this->collProductHasAttributeFields = array();
			} else {

				$criteria->add(ProductHasAttributeFieldPeer::PRODUCT_ID, $this->getId());

				$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelectJoinAttributeField($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttributeFieldPeer::PRODUCT_ID, $this->getId());

			if (!isset($this->lastProductHasAttributeFieldCriteria) || !$this->lastProductHasAttributeFieldCriteria->equals($criteria)) {
				$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelectJoinAttributeField($criteria, $con);
			}
		}
		$this->lastProductHasAttributeFieldCriteria = $criteria;

		return $this->collProductHasAttributeFields;
	}

	
	public function initProductHasWholesales()
	{
		if ($this->collProductHasWholesales === null) {
			$this->collProductHasWholesales = array();
		}
	}

	
	public function getProductHasWholesales($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasWholesales === null) {
			if ($this->isNew()) {
			   $this->collProductHasWholesales = array();
			} else {

				$criteria->add(ProductHasWholesalePeer::PRODUCT_ID, $this->getId());

				ProductHasWholesalePeer::addSelectColumns($criteria);
				$this->collProductHasWholesales = ProductHasWholesalePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasWholesalePeer::PRODUCT_ID, $this->getId());

				ProductHasWholesalePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasWholesaleCriteria) || !$this->lastProductHasWholesaleCriteria->equals($criteria)) {
					$this->collProductHasWholesales = ProductHasWholesalePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasWholesaleCriteria = $criteria;
		return $this->collProductHasWholesales;
	}

	
	public function countProductHasWholesales($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasWholesalePeer::PRODUCT_ID, $this->getId());

		return ProductHasWholesalePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasWholesale(ProductHasWholesale $l)
	{
		$this->collProductHasWholesales[] = $l;
		$l->setProduct($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentProductI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentProductI18n()->setName($value);
  }

  public function getShortDescription()
  {
    $obj = $this->getCurrentProductI18n();

    return ($obj ? $obj->getShortDescription() : null);
  }

  public function setShortDescription($value)
  {
    $this->getCurrentProductI18n()->setShortDescription($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentProductI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentProductI18n()->setDescription($value);
  }

  public function getUrl()
  {
    $obj = $this->getCurrentProductI18n();

    return ($obj ? $obj->getUrl() : null);
  }

  public function setUrl($value)
  {
    $this->getCurrentProductI18n()->setUrl($value);
  }

  public function getUom()
  {
    $obj = $this->getCurrentProductI18n();

    return ($obj ? $obj->getUom() : null);
  }

  public function setUom($value)
  {
    $this->getCurrentProductI18n()->setUom($value);
  }

  protected $current_i18n = array();

  public function getCurrentProductI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProductI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProductI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProductI18nForCulture(new ProductI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProductI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProductI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Product.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProduct:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProduct::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 