<?php


abstract class BaseProductGroup extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $product_group;


	
	protected $opt_name;


	
	protected $product_limit;


	
	protected $opt_url;

	
	protected $collProductGroupHasProducts;

	
	protected $lastProductGroupHasProductCriteria = null;

	
	protected $collProductGroupI18ns;

	
	protected $lastProductGroupI18nCriteria = null;

	
	protected $collProductGroupHasPositionings;

	
	protected $lastProductGroupHasPositioningCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getProductGroup()
    {

            return $this->product_group;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getProductLimit()
    {

            return $this->product_limit;
    }

    
    public function getOptUrl()
    {

            return $this->opt_url;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductGroupPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductGroupPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductGroupPeer::ID;
        }

	} 
	
	public function setProductGroup($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->product_group !== $v) {
          $this->product_group = $v;
          $this->modifiedColumns[] = ProductGroupPeer::PRODUCT_GROUP;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = ProductGroupPeer::OPT_NAME;
        }

	} 
	
	public function setProductLimit($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_limit !== $v) {
          $this->product_limit = $v;
          $this->modifiedColumns[] = ProductGroupPeer::PRODUCT_LIMIT;
        }

	} 
	
	public function setOptUrl($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_url !== $v) {
          $this->opt_url = $v;
          $this->modifiedColumns[] = ProductGroupPeer::OPT_URL;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroup.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->product_group = $rs->getString($startcol + 3);

      $this->opt_name = $rs->getString($startcol + 4);

      $this->product_limit = $rs->getInt($startcol + 5);

      $this->opt_url = $rs->getString($startcol + 6);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroup.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductGroup object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductGroup:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductGroup:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroup.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductGroup:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductGroupPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductGroupPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroup.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductGroup:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductGroupPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collProductGroupHasProducts !== null) {
				foreach($this->collProductGroupHasProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductGroupI18ns !== null) {
				foreach($this->collProductGroupI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductGroupHasPositionings !== null) {
				foreach($this->collProductGroupHasPositionings as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = ProductGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collProductGroupHasProducts !== null) {
					foreach($this->collProductGroupHasProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductGroupI18ns !== null) {
					foreach($this->collProductGroupI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductGroupHasPositionings !== null) {
					foreach($this->collProductGroupHasPositionings as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getProductGroup();
				break;
			case 4:
				return $this->getOptName();
				break;
			case 5:
				return $this->getProductLimit();
				break;
			case 6:
				return $this->getOptUrl();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductGroupPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getProductGroup(),
			$keys[4] => $this->getOptName(),
			$keys[5] => $this->getProductLimit(),
			$keys[6] => $this->getOptUrl(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setProductGroup($value);
				break;
			case 4:
				$this->setOptName($value);
				break;
			case 5:
				$this->setProductLimit($value);
				break;
			case 6:
				$this->setOptUrl($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductGroupPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setProductGroup($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptName($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setProductLimit($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptUrl($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductGroupPeer::CREATED_AT)) $criteria->add(ProductGroupPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductGroupPeer::UPDATED_AT)) $criteria->add(ProductGroupPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductGroupPeer::ID)) $criteria->add(ProductGroupPeer::ID, $this->id);
		if ($this->isColumnModified(ProductGroupPeer::PRODUCT_GROUP)) $criteria->add(ProductGroupPeer::PRODUCT_GROUP, $this->product_group);
		if ($this->isColumnModified(ProductGroupPeer::OPT_NAME)) $criteria->add(ProductGroupPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(ProductGroupPeer::PRODUCT_LIMIT)) $criteria->add(ProductGroupPeer::PRODUCT_LIMIT, $this->product_limit);
		if ($this->isColumnModified(ProductGroupPeer::OPT_URL)) $criteria->add(ProductGroupPeer::OPT_URL, $this->opt_url);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductGroupPeer::DATABASE_NAME);

		$criteria->add(ProductGroupPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setProductGroup($this->product_group);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setProductLimit($this->product_limit);

		$copyObj->setOptUrl($this->opt_url);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getProductGroupHasProducts() as $relObj) {
				$copyObj->addProductGroupHasProduct($relObj->copy($deepCopy));
			}

			foreach($this->getProductGroupI18ns() as $relObj) {
				$copyObj->addProductGroupI18n($relObj->copy($deepCopy));
			}

			foreach($this->getProductGroupHasPositionings() as $relObj) {
				$copyObj->addProductGroupHasPositioning($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductGroupPeer();
		}
		return self::$peer;
	}

	
	public function initProductGroupHasProducts()
	{
		if ($this->collProductGroupHasProducts === null) {
			$this->collProductGroupHasProducts = array();
		}
	}

	
	public function getProductGroupHasProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductGroupHasProducts === null) {
			if ($this->isNew()) {
			   $this->collProductGroupHasProducts = array();
			} else {

				$criteria->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $this->getId());

				ProductGroupHasProductPeer::addSelectColumns($criteria);
				$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $this->getId());

				ProductGroupHasProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductGroupHasProductCriteria) || !$this->lastProductGroupHasProductCriteria->equals($criteria)) {
					$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductGroupHasProductCriteria = $criteria;
		return $this->collProductGroupHasProducts;
	}

	
	public function countProductGroupHasProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $this->getId());

		return ProductGroupHasProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductGroupHasProduct(ProductGroupHasProduct $l)
	{
		$this->collProductGroupHasProducts[] = $l;
		$l->setProductGroup($this);
	}


	
	public function getProductGroupHasProductsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductGroupHasProducts === null) {
			if ($this->isNew()) {
				$this->collProductGroupHasProducts = array();
			} else {

				$criteria->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $this->getId());

				$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $this->getId());

			if (!isset($this->lastProductGroupHasProductCriteria) || !$this->lastProductGroupHasProductCriteria->equals($criteria)) {
				$this->collProductGroupHasProducts = ProductGroupHasProductPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductGroupHasProductCriteria = $criteria;

		return $this->collProductGroupHasProducts;
	}

	
	public function initProductGroupI18ns()
	{
		if ($this->collProductGroupI18ns === null) {
			$this->collProductGroupI18ns = array();
		}
	}

	
	public function getProductGroupI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductGroupI18ns === null) {
			if ($this->isNew()) {
			   $this->collProductGroupI18ns = array();
			} else {

				$criteria->add(ProductGroupI18nPeer::ID, $this->getId());

				ProductGroupI18nPeer::addSelectColumns($criteria);
				$this->collProductGroupI18ns = ProductGroupI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductGroupI18nPeer::ID, $this->getId());

				ProductGroupI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductGroupI18nCriteria) || !$this->lastProductGroupI18nCriteria->equals($criteria)) {
					$this->collProductGroupI18ns = ProductGroupI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductGroupI18nCriteria = $criteria;
		return $this->collProductGroupI18ns;
	}

	
	public function countProductGroupI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductGroupI18nPeer::ID, $this->getId());

		return ProductGroupI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductGroupI18n(ProductGroupI18n $l)
	{
		$this->collProductGroupI18ns[] = $l;
		$l->setProductGroup($this);
	}

	
	public function initProductGroupHasPositionings()
	{
		if ($this->collProductGroupHasPositionings === null) {
			$this->collProductGroupHasPositionings = array();
		}
	}

	
	public function getProductGroupHasPositionings($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductGroupHasPositionings === null) {
			if ($this->isNew()) {
			   $this->collProductGroupHasPositionings = array();
			} else {

				$criteria->add(ProductGroupHasPositioningPeer::PRODUCT_GROUP_ID, $this->getId());

				ProductGroupHasPositioningPeer::addSelectColumns($criteria);
				$this->collProductGroupHasPositionings = ProductGroupHasPositioningPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductGroupHasPositioningPeer::PRODUCT_GROUP_ID, $this->getId());

				ProductGroupHasPositioningPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductGroupHasPositioningCriteria) || !$this->lastProductGroupHasPositioningCriteria->equals($criteria)) {
					$this->collProductGroupHasPositionings = ProductGroupHasPositioningPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductGroupHasPositioningCriteria = $criteria;
		return $this->collProductGroupHasPositionings;
	}

	
	public function countProductGroupHasPositionings($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductGroupHasPositioningPeer::PRODUCT_GROUP_ID, $this->getId());

		return ProductGroupHasPositioningPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductGroupHasPositioning(ProductGroupHasPositioning $l)
	{
		$this->collProductGroupHasPositionings[] = $l;
		$l->setProductGroup($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentProductGroupI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentProductGroupI18n()->setName($value);
  }

  public function getUrl()
  {
    $obj = $this->getCurrentProductGroupI18n();

    return ($obj ? $obj->getUrl() : null);
  }

  public function setUrl($value)
  {
    $this->getCurrentProductGroupI18n()->setUrl($value);
  }

  protected $current_i18n = array();

  public function getCurrentProductGroupI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProductGroupI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProductGroupI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProductGroupI18nForCulture(new ProductGroupI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProductGroupI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProductGroupI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductGroup.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductGroup:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductGroup::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 