<?php


abstract class BaseProductGroupPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_product_group';

	
	const CLASS_DEFAULT = 'lib.model.ProductGroup';

	
	const NUM_COLUMNS = 7;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_product_group.CREATED_AT';

	
	const UPDATED_AT = 'st_product_group.UPDATED_AT';

	
	const ID = 'st_product_group.ID';

	
	const PRODUCT_GROUP = 'st_product_group.PRODUCT_GROUP';

	
	const OPT_NAME = 'st_product_group.OPT_NAME';

	
	const PRODUCT_LIMIT = 'st_product_group.PRODUCT_LIMIT';

	
	const OPT_URL = 'st_product_group.OPT_URL';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'ProductGroup', 'OptName', 'ProductLimit', 'OptUrl', ),
		BasePeer::TYPE_COLNAME => array (ProductGroupPeer::CREATED_AT, ProductGroupPeer::UPDATED_AT, ProductGroupPeer::ID, ProductGroupPeer::PRODUCT_GROUP, ProductGroupPeer::OPT_NAME, ProductGroupPeer::PRODUCT_LIMIT, ProductGroupPeer::OPT_URL, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'product_group', 'opt_name', 'product_limit', 'opt_url', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'ProductGroup' => 3, 'OptName' => 4, 'ProductLimit' => 5, 'OptUrl' => 6, ),
		BasePeer::TYPE_COLNAME => array (ProductGroupPeer::CREATED_AT => 0, ProductGroupPeer::UPDATED_AT => 1, ProductGroupPeer::ID => 2, ProductGroupPeer::PRODUCT_GROUP => 3, ProductGroupPeer::OPT_NAME => 4, ProductGroupPeer::PRODUCT_LIMIT => 5, ProductGroupPeer::OPT_URL => 6, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'product_group' => 3, 'opt_name' => 4, 'product_limit' => 5, 'opt_url' => 6, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('lib.model.map.ProductGroupMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = ProductGroupPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(ProductGroupPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(ProductGroupPeer::CREATED_AT);

		$criteria->addSelectColumn(ProductGroupPeer::UPDATED_AT);

		$criteria->addSelectColumn(ProductGroupPeer::ID);

		$criteria->addSelectColumn(ProductGroupPeer::PRODUCT_GROUP);

		$criteria->addSelectColumn(ProductGroupPeer::OPT_NAME);

		$criteria->addSelectColumn(ProductGroupPeer::PRODUCT_LIMIT);

		$criteria->addSelectColumn(ProductGroupPeer::OPT_URL);

	}

	const COUNT = 'COUNT(st_product_group.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_product_group.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductGroupPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductGroupPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = ProductGroupPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = ProductGroupPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return ProductGroupPeer::populateObjects(ProductGroupPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductGroupPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseProductGroupPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			ProductGroupPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = ProductGroupPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

     
     public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
     {
       if ($culture === null)
       {
         $culture = sfContext::getInstance()->getUser()->getCulture();
       }

              if ($c->getDbName() == Propel::getDefaultDB())
       {
         $c->setDbName(self::DATABASE_NAME);
       }

      ProductGroupPeer::addSelectColumns($c);
      $startcol = (ProductGroupPeer::NUM_COLUMNS - ProductGroupPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

      ProductGroupI18nPeer::addSelectColumns($c);

      $c->addJoin(ProductGroupPeer::ID, sprintf('%s AND %s = \'%s\'', ProductGroupI18nPeer::ID, ProductGroupI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

      $rs = BasePeer::doSelect($c, $con);

      if (self::$hydrateMethod)
      {
         return call_user_func(self::$hydrateMethod, $rs);
      }

      $results = array();

      while($rs->next()) {

         $omClass = ProductGroupPeer::getOMClass();

         $cls = Propel::import($omClass);
         $obj1 = new $cls();
         $obj1->hydrate($rs);
         $obj1->setCulture($culture);

         $omClass = ProductGroupI18nPeer::getOMClass($rs, $startcol);

         $cls = Propel::import($omClass);
         $obj2 = new $cls();
         $obj2->hydrate($rs, $startcol);

         $obj1->setProductGroupI18nForCulture($obj2, $culture);
         $obj2->setProductGroup($obj1);

         $results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
       }
       return $results;
     }

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return ProductGroupPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductGroupPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseProductGroupPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(ProductGroupPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseProductGroupPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseProductGroupPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductGroupPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseProductGroupPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(ProductGroupPeer::ID);
			$selectCriteria->add(ProductGroupPeer::ID, $criteria->remove(ProductGroupPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseProductGroupPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseProductGroupPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += ProductGroupPeer::doOnDeleteCascade(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(ProductGroupPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(ProductGroupPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof ProductGroup) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(ProductGroupPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += ProductGroupPeer::doOnDeleteCascade($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = ProductGroupPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $obj->getId());
			$affectedRows += ProductGroupHasProductPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductGroupI18nPeer::ID, $obj->getId());
			$affectedRows += ProductGroupI18nPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductGroupHasPositioningPeer::PRODUCT_GROUP_ID, $obj->getId());
			$affectedRows += ProductGroupHasPositioningPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	public static function doValidate(ProductGroup $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(ProductGroupPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(ProductGroupPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(ProductGroupPeer::DATABASE_NAME, ProductGroupPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = ProductGroupPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(ProductGroupPeer::DATABASE_NAME);

		$criteria->add(ProductGroupPeer::ID, $pk);


		$v = ProductGroupPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(ProductGroupPeer::ID, $pks, Criteria::IN);
			$objs = ProductGroupPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseProductGroupPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('lib.model.map.ProductGroupMapBuilder');
}
