<?php


abstract class BaseProductPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_product';

	
	const CLASS_DEFAULT = 'lib.model.Product';

	
	const NUM_COLUMNS = 46;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_product.CREATED_AT';

	
	const UPDATED_AT = 'st_product.UPDATED_AT';

	
	const ID = 'st_product.ID';

	
	const PARENT_ID = 'st_product.PARENT_ID';

	
	const CURRENCY_ID = 'st_product.CURRENCY_ID';

	
	const PRODUCER_ID = 'st_product.PRODUCER_ID';

	
	const CODE = 'st_product.CODE';

	
	const PRICE = 'st_product.PRICE';

	
	const OPT_PRICE_BRUTTO = 'st_product.OPT_PRICE_BRUTTO';

	
	const CURRENCY_PRICE = 'st_product.CURRENCY_PRICE';

	
	const OLD_PRICE = 'st_product.OLD_PRICE';

	
	const OPT_OLD_PRICE_BRUTTO = 'st_product.OPT_OLD_PRICE_BRUTTO';

	
	const CURRENCY_OLD_PRICE = 'st_product.CURRENCY_OLD_PRICE';

	
	const OPT_VAT = 'st_product.OPT_VAT';

	
	const CURRENCY_EXCHANGE = 'st_product.CURRENCY_EXCHANGE';

	
	const ACTIVE = 'st_product.ACTIVE';

	
	const HIDE_PRICE = 'st_product.HIDE_PRICE';

	
	const HAS_FIXED_CURRENCY = 'st_product.HAS_FIXED_CURRENCY';

	
	const OPT_IMAGE = 'st_product.OPT_IMAGE';

	
	const OPT_NAME = 'st_product.OPT_NAME';

	
	const OPT_SHORT_DESCRIPTION = 'st_product.OPT_SHORT_DESCRIPTION';

	
	const OPT_DESCRIPTION = 'st_product.OPT_DESCRIPTION';

	
	const OPT_URL = 'st_product.OPT_URL';

	
	const OPT_ASSET_FOLDER = 'st_product.OPT_ASSET_FOLDER';

	
	const OPT_UOM = 'st_product.OPT_UOM';

	
	const MIN_QTY = 'st_product.MIN_QTY';

	
	const MAX_QTY = 'st_product.MAX_QTY';

	
	const STEP_QTY = 'st_product.STEP_QTY';

	
	const IS_STOCK_VALIDATED = 'st_product.IS_STOCK_VALIDATED';

	
	const STOCK_IN_DECIMALS = 'st_product.STOCK_IN_DECIMALS';

	
	const AVAILABILITY_ID = 'st_product.AVAILABILITY_ID';

	
	const WEIGHT = 'st_product.WEIGHT';

	
	const STOCK = 'st_product.STOCK';

	
	const MAX_DISCOUNT = 'st_product.MAX_DISCOUNT';

	
	const OPT_HAS_OPTIONS = 'st_product.OPT_HAS_OPTIONS';

	
	const OPTIONS_COLOR = 'st_product.OPTIONS_COLOR';

	
	const TAX_ID = 'st_product.TAX_ID';

	
	const WHOLESALE_A_NETTO = 'st_product.WHOLESALE_A_NETTO';

	
	const WHOLESALE_B_NETTO = 'st_product.WHOLESALE_B_NETTO';

	
	const WHOLESALE_C_NETTO = 'st_product.WHOLESALE_C_NETTO';

	
	const WHOLESALE_A_BRUTTO = 'st_product.WHOLESALE_A_BRUTTO';

	
	const WHOLESALE_B_BRUTTO = 'st_product.WHOLESALE_B_BRUTTO';

	
	const WHOLESALE_C_BRUTTO = 'st_product.WHOLESALE_C_BRUTTO';

	
	const CURRENCY_WHOLESALE_A = 'st_product.CURRENCY_WHOLESALE_A';

	
	const CURRENCY_WHOLESALE_B = 'st_product.CURRENCY_WHOLESALE_B';

	
	const CURRENCY_WHOLESALE_C = 'st_product.CURRENCY_WHOLESALE_C';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'ParentId', 'CurrencyId', 'ProducerId', 'Code', 'Price', 'OptPriceBrutto', 'CurrencyPrice', 'OldPrice', 'OptOldPriceBrutto', 'CurrencyOldPrice', 'OptVat', 'CurrencyExchange', 'Active', 'HidePrice', 'HasFixedCurrency', 'OptImage', 'OptName', 'OptShortDescription', 'OptDescription', 'OptUrl', 'OptAssetFolder', 'OptUom', 'MinQty', 'MaxQty', 'StepQty', 'IsStockValidated', 'StockInDecimals', 'AvailabilityId', 'Weight', 'Stock', 'MaxDiscount', 'OptHasOptions', 'OptionsColor', 'TaxId', 'WholesaleANetto', 'WholesaleBNetto', 'WholesaleCNetto', 'WholesaleABrutto', 'WholesaleBBrutto', 'WholesaleCBrutto', 'CurrencyWholesaleA', 'CurrencyWholesaleB', 'CurrencyWholesaleC', ),
		BasePeer::TYPE_COLNAME => array (ProductPeer::CREATED_AT, ProductPeer::UPDATED_AT, ProductPeer::ID, ProductPeer::PARENT_ID, ProductPeer::CURRENCY_ID, ProductPeer::PRODUCER_ID, ProductPeer::CODE, ProductPeer::PRICE, ProductPeer::OPT_PRICE_BRUTTO, ProductPeer::CURRENCY_PRICE, ProductPeer::OLD_PRICE, ProductPeer::OPT_OLD_PRICE_BRUTTO, ProductPeer::CURRENCY_OLD_PRICE, ProductPeer::OPT_VAT, ProductPeer::CURRENCY_EXCHANGE, ProductPeer::ACTIVE, ProductPeer::HIDE_PRICE, ProductPeer::HAS_FIXED_CURRENCY, ProductPeer::OPT_IMAGE, ProductPeer::OPT_NAME, ProductPeer::OPT_SHORT_DESCRIPTION, ProductPeer::OPT_DESCRIPTION, ProductPeer::OPT_URL, ProductPeer::OPT_ASSET_FOLDER, ProductPeer::OPT_UOM, ProductPeer::MIN_QTY, ProductPeer::MAX_QTY, ProductPeer::STEP_QTY, ProductPeer::IS_STOCK_VALIDATED, ProductPeer::STOCK_IN_DECIMALS, ProductPeer::AVAILABILITY_ID, ProductPeer::WEIGHT, ProductPeer::STOCK, ProductPeer::MAX_DISCOUNT, ProductPeer::OPT_HAS_OPTIONS, ProductPeer::OPTIONS_COLOR, ProductPeer::TAX_ID, ProductPeer::WHOLESALE_A_NETTO, ProductPeer::WHOLESALE_B_NETTO, ProductPeer::WHOLESALE_C_NETTO, ProductPeer::WHOLESALE_A_BRUTTO, ProductPeer::WHOLESALE_B_BRUTTO, ProductPeer::WHOLESALE_C_BRUTTO, ProductPeer::CURRENCY_WHOLESALE_A, ProductPeer::CURRENCY_WHOLESALE_B, ProductPeer::CURRENCY_WHOLESALE_C, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'parent_id', 'currency_id', 'producer_id', 'code', 'price', 'opt_price_brutto', 'currency_price', 'old_price', 'opt_old_price_brutto', 'currency_old_price', 'opt_vat', 'currency_exchange', 'active', 'hide_price', 'has_fixed_currency', 'opt_image', 'opt_name', 'opt_short_description', 'opt_description', 'opt_url', 'opt_asset_folder', 'opt_uom', 'min_qty', 'max_qty', 'step_qty', 'is_stock_validated', 'stock_in_decimals', 'availability_id', 'weight', 'stock', 'max_discount', 'opt_has_options', 'options_color', 'tax_id', 'wholesale_a_netto', 'wholesale_b_netto', 'wholesale_c_netto', 'wholesale_a_brutto', 'wholesale_b_brutto', 'wholesale_c_brutto', 'currency_wholesale_a', 'currency_wholesale_b', 'currency_wholesale_c', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'ParentId' => 3, 'CurrencyId' => 4, 'ProducerId' => 5, 'Code' => 6, 'Price' => 7, 'OptPriceBrutto' => 8, 'CurrencyPrice' => 9, 'OldPrice' => 10, 'OptOldPriceBrutto' => 11, 'CurrencyOldPrice' => 12, 'OptVat' => 13, 'CurrencyExchange' => 14, 'Active' => 15, 'HidePrice' => 16, 'HasFixedCurrency' => 17, 'OptImage' => 18, 'OptName' => 19, 'OptShortDescription' => 20, 'OptDescription' => 21, 'OptUrl' => 22, 'OptAssetFolder' => 23, 'OptUom' => 24, 'MinQty' => 25, 'MaxQty' => 26, 'StepQty' => 27, 'IsStockValidated' => 28, 'StockInDecimals' => 29, 'AvailabilityId' => 30, 'Weight' => 31, 'Stock' => 32, 'MaxDiscount' => 33, 'OptHasOptions' => 34, 'OptionsColor' => 35, 'TaxId' => 36, 'WholesaleANetto' => 37, 'WholesaleBNetto' => 38, 'WholesaleCNetto' => 39, 'WholesaleABrutto' => 40, 'WholesaleBBrutto' => 41, 'WholesaleCBrutto' => 42, 'CurrencyWholesaleA' => 43, 'CurrencyWholesaleB' => 44, 'CurrencyWholesaleC' => 45, ),
		BasePeer::TYPE_COLNAME => array (ProductPeer::CREATED_AT => 0, ProductPeer::UPDATED_AT => 1, ProductPeer::ID => 2, ProductPeer::PARENT_ID => 3, ProductPeer::CURRENCY_ID => 4, ProductPeer::PRODUCER_ID => 5, ProductPeer::CODE => 6, ProductPeer::PRICE => 7, ProductPeer::OPT_PRICE_BRUTTO => 8, ProductPeer::CURRENCY_PRICE => 9, ProductPeer::OLD_PRICE => 10, ProductPeer::OPT_OLD_PRICE_BRUTTO => 11, ProductPeer::CURRENCY_OLD_PRICE => 12, ProductPeer::OPT_VAT => 13, ProductPeer::CURRENCY_EXCHANGE => 14, ProductPeer::ACTIVE => 15, ProductPeer::HIDE_PRICE => 16, ProductPeer::HAS_FIXED_CURRENCY => 17, ProductPeer::OPT_IMAGE => 18, ProductPeer::OPT_NAME => 19, ProductPeer::OPT_SHORT_DESCRIPTION => 20, ProductPeer::OPT_DESCRIPTION => 21, ProductPeer::OPT_URL => 22, ProductPeer::OPT_ASSET_FOLDER => 23, ProductPeer::OPT_UOM => 24, ProductPeer::MIN_QTY => 25, ProductPeer::MAX_QTY => 26, ProductPeer::STEP_QTY => 27, ProductPeer::IS_STOCK_VALIDATED => 28, ProductPeer::STOCK_IN_DECIMALS => 29, ProductPeer::AVAILABILITY_ID => 30, ProductPeer::WEIGHT => 31, ProductPeer::STOCK => 32, ProductPeer::MAX_DISCOUNT => 33, ProductPeer::OPT_HAS_OPTIONS => 34, ProductPeer::OPTIONS_COLOR => 35, ProductPeer::TAX_ID => 36, ProductPeer::WHOLESALE_A_NETTO => 37, ProductPeer::WHOLESALE_B_NETTO => 38, ProductPeer::WHOLESALE_C_NETTO => 39, ProductPeer::WHOLESALE_A_BRUTTO => 40, ProductPeer::WHOLESALE_B_BRUTTO => 41, ProductPeer::WHOLESALE_C_BRUTTO => 42, ProductPeer::CURRENCY_WHOLESALE_A => 43, ProductPeer::CURRENCY_WHOLESALE_B => 44, ProductPeer::CURRENCY_WHOLESALE_C => 45, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'parent_id' => 3, 'currency_id' => 4, 'producer_id' => 5, 'code' => 6, 'price' => 7, 'opt_price_brutto' => 8, 'currency_price' => 9, 'old_price' => 10, 'opt_old_price_brutto' => 11, 'currency_old_price' => 12, 'opt_vat' => 13, 'currency_exchange' => 14, 'active' => 15, 'hide_price' => 16, 'has_fixed_currency' => 17, 'opt_image' => 18, 'opt_name' => 19, 'opt_short_description' => 20, 'opt_description' => 21, 'opt_url' => 22, 'opt_asset_folder' => 23, 'opt_uom' => 24, 'min_qty' => 25, 'max_qty' => 26, 'step_qty' => 27, 'is_stock_validated' => 28, 'stock_in_decimals' => 29, 'availability_id' => 30, 'weight' => 31, 'stock' => 32, 'max_discount' => 33, 'opt_has_options' => 34, 'options_color' => 35, 'tax_id' => 36, 'wholesale_a_netto' => 37, 'wholesale_b_netto' => 38, 'wholesale_c_netto' => 39, 'wholesale_a_brutto' => 40, 'wholesale_b_brutto' => 41, 'wholesale_c_brutto' => 42, 'currency_wholesale_a' => 43, 'currency_wholesale_b' => 44, 'currency_wholesale_c' => 45, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('lib.model.map.ProductMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = ProductPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(ProductPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(ProductPeer::CREATED_AT);

		$criteria->addSelectColumn(ProductPeer::UPDATED_AT);

		$criteria->addSelectColumn(ProductPeer::ID);

		$criteria->addSelectColumn(ProductPeer::PARENT_ID);

		$criteria->addSelectColumn(ProductPeer::CURRENCY_ID);

		$criteria->addSelectColumn(ProductPeer::PRODUCER_ID);

		$criteria->addSelectColumn(ProductPeer::CODE);

		$criteria->addSelectColumn(ProductPeer::PRICE);

		$criteria->addSelectColumn(ProductPeer::OPT_PRICE_BRUTTO);

		$criteria->addSelectColumn(ProductPeer::CURRENCY_PRICE);

		$criteria->addSelectColumn(ProductPeer::OLD_PRICE);

		$criteria->addSelectColumn(ProductPeer::OPT_OLD_PRICE_BRUTTO);

		$criteria->addSelectColumn(ProductPeer::CURRENCY_OLD_PRICE);

		$criteria->addSelectColumn(ProductPeer::OPT_VAT);

		$criteria->addSelectColumn(ProductPeer::CURRENCY_EXCHANGE);

		$criteria->addSelectColumn(ProductPeer::ACTIVE);

		$criteria->addSelectColumn(ProductPeer::HIDE_PRICE);

		$criteria->addSelectColumn(ProductPeer::HAS_FIXED_CURRENCY);

		$criteria->addSelectColumn(ProductPeer::OPT_IMAGE);

		$criteria->addSelectColumn(ProductPeer::OPT_NAME);

		$criteria->addSelectColumn(ProductPeer::OPT_SHORT_DESCRIPTION);

		$criteria->addSelectColumn(ProductPeer::OPT_DESCRIPTION);

		$criteria->addSelectColumn(ProductPeer::OPT_URL);

		$criteria->addSelectColumn(ProductPeer::OPT_ASSET_FOLDER);

		$criteria->addSelectColumn(ProductPeer::OPT_UOM);

		$criteria->addSelectColumn(ProductPeer::MIN_QTY);

		$criteria->addSelectColumn(ProductPeer::MAX_QTY);

		$criteria->addSelectColumn(ProductPeer::STEP_QTY);

		$criteria->addSelectColumn(ProductPeer::IS_STOCK_VALIDATED);

		$criteria->addSelectColumn(ProductPeer::STOCK_IN_DECIMALS);

		$criteria->addSelectColumn(ProductPeer::AVAILABILITY_ID);

		$criteria->addSelectColumn(ProductPeer::WEIGHT);

		$criteria->addSelectColumn(ProductPeer::STOCK);

		$criteria->addSelectColumn(ProductPeer::MAX_DISCOUNT);

		$criteria->addSelectColumn(ProductPeer::OPT_HAS_OPTIONS);

		$criteria->addSelectColumn(ProductPeer::OPTIONS_COLOR);

		$criteria->addSelectColumn(ProductPeer::TAX_ID);

		$criteria->addSelectColumn(ProductPeer::WHOLESALE_A_NETTO);

		$criteria->addSelectColumn(ProductPeer::WHOLESALE_B_NETTO);

		$criteria->addSelectColumn(ProductPeer::WHOLESALE_C_NETTO);

		$criteria->addSelectColumn(ProductPeer::WHOLESALE_A_BRUTTO);

		$criteria->addSelectColumn(ProductPeer::WHOLESALE_B_BRUTTO);

		$criteria->addSelectColumn(ProductPeer::WHOLESALE_C_BRUTTO);

		$criteria->addSelectColumn(ProductPeer::CURRENCY_WHOLESALE_A);

		$criteria->addSelectColumn(ProductPeer::CURRENCY_WHOLESALE_B);

		$criteria->addSelectColumn(ProductPeer::CURRENCY_WHOLESALE_C);

	}

	const COUNT = 'COUNT(st_product.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_product.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = ProductPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return ProductPeer::populateObjects(ProductPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseProductPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			ProductPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = ProductPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinCurrency(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinProducer(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAvailability(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinTax(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinCurrency(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		CurrencyPeer::addSelectColumns($c);

		$c->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getCurrencyId())
                        {

			   $omClass = CurrencyPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProduct($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinProducer(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		ProducerPeer::addSelectColumns($c);

		$c->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getProducerId())
                        {

			   $omClass = ProducerPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProduct($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinAvailability(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		AvailabilityPeer::addSelectColumns($c);

		$c->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getAvailabilityId())
                        {

			   $omClass = AvailabilityPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProduct($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinTax(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		TaxPeer::addSelectColumns($c);

		$c->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getTaxId())
                        {

			   $omClass = TaxPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProduct($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol2 = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CurrencyPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CurrencyPeer::NUM_COLUMNS;

		ProducerPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProducerPeer::NUM_COLUMNS;

		AvailabilityPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + AvailabilityPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = CurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCurrency(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProduct($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initProducts();
				$obj2->addProduct($obj1);
			}


					
			$omClass = ProducerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3 = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProducer(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProduct($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj3->initProducts();
				$obj3->addProduct($obj1);
			}


					
			$omClass = AvailabilityPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4 = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getAvailability(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProduct($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj4->initProducts();
				$obj4->addProduct($obj1);
			}


					
			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5 = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getTax(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addProduct($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj5->initProducts();
				$obj5->addProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doCountJoinAllExceptProductRelatedByParentId(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptCurrency(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptProducer(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptAvailability(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptTax(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAllExceptProductRelatedByParentId(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol2 = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CurrencyPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CurrencyPeer::NUM_COLUMNS;

		ProducerPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProducerPeer::NUM_COLUMNS;

		AvailabilityPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + AvailabilityPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = CurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCurrency(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProducts();
				$obj2->addProduct($obj1);
			}

			$omClass = ProducerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProducer(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProducts();
				$obj3->addProduct($obj1);
			}

			$omClass = AvailabilityPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getAvailability(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProducts();
				$obj4->addProduct($obj1);
			}

			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getTax(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initProducts();
				$obj5->addProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptCurrency(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol2 = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		ProducerPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + ProducerPeer::NUM_COLUMNS;

		AvailabilityPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + AvailabilityPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = ProducerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getProducer(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProducts();
				$obj2->addProduct($obj1);
			}

			$omClass = AvailabilityPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getAvailability(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProducts();
				$obj3->addProduct($obj1);
			}

			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getTax(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProducts();
				$obj4->addProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptProducer(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol2 = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CurrencyPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CurrencyPeer::NUM_COLUMNS;

		AvailabilityPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + AvailabilityPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = CurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCurrency(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProducts();
				$obj2->addProduct($obj1);
			}

			$omClass = AvailabilityPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getAvailability(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProducts();
				$obj3->addProduct($obj1);
			}

			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getTax(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProducts();
				$obj4->addProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptAvailability(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol2 = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CurrencyPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CurrencyPeer::NUM_COLUMNS;

		ProducerPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProducerPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = CurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCurrency(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProducts();
				$obj2->addProduct($obj1);
			}

			$omClass = ProducerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProducer(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProducts();
				$obj3->addProduct($obj1);
			}

			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getTax(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProducts();
				$obj4->addProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptTax(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductPeer::addSelectColumns($c);
		$startcol2 = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CurrencyPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CurrencyPeer::NUM_COLUMNS;

		ProducerPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProducerPeer::NUM_COLUMNS;

		AvailabilityPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + AvailabilityPeer::NUM_COLUMNS;

		$c->addJoin(ProductPeer::CURRENCY_ID, CurrencyPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::PRODUCER_ID, ProducerPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductPeer::AVAILABILITY_ID, AvailabilityPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = CurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCurrency(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProducts();
				$obj2->addProduct($obj1);
			}

			$omClass = ProducerPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProducer(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProducts();
				$obj3->addProduct($obj1);
			}

			$omClass = AvailabilityPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getAvailability(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProduct($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProducts();
				$obj4->addProduct($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


     
     public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
     {
       if ($culture === null)
       {
         $culture = sfContext::getInstance()->getUser()->getCulture();
       }

              if ($c->getDbName() == Propel::getDefaultDB())
       {
         $c->setDbName(self::DATABASE_NAME);
       }

      ProductPeer::addSelectColumns($c);
      $startcol = (ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

      ProductI18nPeer::addSelectColumns($c);

      $c->addJoin(ProductPeer::ID, sprintf('%s AND %s = \'%s\'', ProductI18nPeer::ID, ProductI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

      $rs = BasePeer::doSelect($c, $con);

      if (self::$hydrateMethod)
      {
         return call_user_func(self::$hydrateMethod, $rs);
      }

      $results = array();

      while($rs->next()) {

         $omClass = ProductPeer::getOMClass();

         $cls = Propel::import($omClass);
         $obj1 = new $cls();
         $obj1->hydrate($rs);
         $obj1->setCulture($culture);

         $omClass = ProductI18nPeer::getOMClass($rs, $startcol);

         $cls = Propel::import($omClass);
         $obj2 = new $cls();
         $obj2->hydrate($rs, $startcol);

         $obj1->setProductI18nForCulture($obj2, $culture);
         $obj2->setProduct($obj1);

         $results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
       }
       return $results;
     }

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return ProductPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseProductPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(ProductPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseProductPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseProductPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseProductPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(ProductPeer::ID);
			$selectCriteria->add(ProductPeer::ID, $criteria->remove(ProductPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseProductPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseProductPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += ProductPeer::doOnDeleteCascade(new Criteria(), $con);
			ProductPeer::doOnDeleteSetNull(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(ProductPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(ProductPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof Product) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(ProductPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += ProductPeer::doOnDeleteCascade($criteria, $con);ProductPeer::doOnDeleteSetNull($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = ProductPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(ProductHasAccessoriesPeer::ACCESSORIES_ID, $obj->getId());
			$affectedRows += ProductHasAccessoriesPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductHasAccessoriesPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ProductHasAccessoriesPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductGroupHasProductPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ProductGroupHasProductPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductHasPositioningPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ProductHasPositioningPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(CrossellingPeer::FIRST_PRODUCT_ID, $obj->getId());
			$affectedRows += CrossellingPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(CrossellingPeer::SECOUND_PRODUCT_ID, $obj->getId());
			$affectedRows += CrossellingPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductHasCategoryPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ProductHasCategoryPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductHasSfAssetPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ProductHasSfAssetPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductHasAttachmentPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ProductHasAttachmentPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductI18nPeer::ID, $obj->getId());
			$affectedRows += ProductI18nPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ProductOptionsValuePeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ProductOptionsValuePeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(RecommendSendPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += RecommendSendPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(ReviewPeer::PRODUCT_ID, $obj->getId());
			$affectedRows += ReviewPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	protected static function doOnDeleteSetNull(Criteria $criteria, Connection $con)
	{

				$objects = ProductPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {

						$selectCriteria = new Criteria(ProductPeer::DATABASE_NAME);
			$updateValues = new Criteria(ProductPeer::DATABASE_NAME);
			$selectCriteria->add(QuestionsPeer::ITEM_ID, $obj->getId());
			$updateValues->add(QuestionsPeer::ITEM_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
						$selectCriteria = new Criteria(ProductPeer::DATABASE_NAME);
			$updateValues = new Criteria(ProductPeer::DATABASE_NAME);
			$selectCriteria->add(BasketProductPeer::PRODUCT_ID, $obj->getId());
			$updateValues->add(BasketProductPeer::PRODUCT_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
						$selectCriteria = new Criteria(ProductPeer::DATABASE_NAME);
			$updateValues = new Criteria(ProductPeer::DATABASE_NAME);
			$selectCriteria->add(OrderProductPeer::PRODUCT_ID, $obj->getId());
			$updateValues->add(OrderProductPeer::PRODUCT_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
						$selectCriteria = new Criteria(ProductPeer::DATABASE_NAME);
			$updateValues = new Criteria(ProductPeer::DATABASE_NAME);
			$selectCriteria->add(InvoiceProductPeer::PRODUCT_ID, $obj->getId());
			$updateValues->add(InvoiceProductPeer::PRODUCT_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
		}
	}

	
	public static function doValidate(Product $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(ProductPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(ProductPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(ProductPeer::DATABASE_NAME, ProductPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = ProductPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(ProductPeer::DATABASE_NAME);

		$criteria->add(ProductPeer::ID, $pk);


		$v = ProductPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(ProductPeer::ID, $pks, Criteria::IN);
			$objs = ProductPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseProductPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('lib.model.map.ProductMapBuilder');
}
