<?php


abstract class BaseReview extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $order_id;


	
	protected $sf_guard_user_id;


	
	protected $product_id;


	
	protected $active = false;


	
	protected $score;


	
	protected $merchant;


	
	protected $admin_name;


	
	protected $admin_active;


	
	protected $anonymous;


	
	protected $agreement = false;


	
	protected $order_number;


	
	protected $description;


	
	protected $user_ip;


	
	protected $username;


	
	protected $language;

	
	protected $aOrder;

	
	protected $asfGuardUser;

	
	protected $aProduct;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOrderId()
    {

            return $this->order_id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getScore()
    {

            return $this->score;
    }

    
    public function getMerchant()
    {

            return $this->merchant;
    }

    
    public function getAdminName()
    {

            return $this->admin_name;
    }

    
    public function getAdminActive()
    {

            return $this->admin_active;
    }

    
    public function getAnonymous()
    {

            return $this->anonymous;
    }

    
    public function getAgreement()
    {

            return $this->agreement;
    }

    
    public function getOrderNumber()
    {

            return $this->order_number;
    }

    
    public function getDescription()
    {

            return $this->description;
    }

    
    public function getUserIp()
    {

            return $this->user_ip;
    }

    
    public function getUsername()
    {

            return $this->username;
    }

    
    public function getLanguage()
    {

            return $this->language;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ReviewPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ReviewPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ReviewPeer::ID;
        }

	} 
	
	public function setOrderId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_id !== $v) {
          $this->order_id = $v;
          $this->modifiedColumns[] = ReviewPeer::ORDER_ID;
        }

		if ($this->aOrder !== null && $this->aOrder->getId() !== $v) {
			$this->aOrder = null;
		}

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = ReviewPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = ReviewPeer::PRODUCT_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === false) {
          $this->active = $v;
          $this->modifiedColumns[] = ReviewPeer::ACTIVE;
        }

	} 
	
	public function setScore($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->score !== $v) {
          $this->score = $v;
          $this->modifiedColumns[] = ReviewPeer::SCORE;
        }

	} 
	
	public function setMerchant($v)
	{

        if ($this->merchant !== $v) {
          $this->merchant = $v;
          $this->modifiedColumns[] = ReviewPeer::MERCHANT;
        }

	} 
	
	public function setAdminName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->admin_name !== $v) {
          $this->admin_name = $v;
          $this->modifiedColumns[] = ReviewPeer::ADMIN_NAME;
        }

	} 
	
	public function setAdminActive($v)
	{

        if ($this->admin_active !== $v) {
          $this->admin_active = $v;
          $this->modifiedColumns[] = ReviewPeer::ADMIN_ACTIVE;
        }

	} 
	
	public function setAnonymous($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->anonymous !== $v) {
          $this->anonymous = $v;
          $this->modifiedColumns[] = ReviewPeer::ANONYMOUS;
        }

	} 
	
	public function setAgreement($v)
	{

        if ($this->agreement !== $v || $v === false) {
          $this->agreement = $v;
          $this->modifiedColumns[] = ReviewPeer::AGREEMENT;
        }

	} 
	
	public function setOrderNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->order_number !== $v) {
          $this->order_number = $v;
          $this->modifiedColumns[] = ReviewPeer::ORDER_NUMBER;
        }

	} 
	
	public function setDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->description !== $v) {
          $this->description = $v;
          $this->modifiedColumns[] = ReviewPeer::DESCRIPTION;
        }

	} 
	
	public function setUserIp($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->user_ip !== $v) {
          $this->user_ip = $v;
          $this->modifiedColumns[] = ReviewPeer::USER_IP;
        }

	} 
	
	public function setUsername($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->username !== $v) {
          $this->username = $v;
          $this->modifiedColumns[] = ReviewPeer::USERNAME;
        }

	} 
	
	public function setLanguage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->language !== $v) {
          $this->language = $v;
          $this->modifiedColumns[] = ReviewPeer::LANGUAGE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Review.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->order_id = $rs->getInt($startcol + 3);

      $this->sf_guard_user_id = $rs->getInt($startcol + 4);

      $this->product_id = $rs->getInt($startcol + 5);

      $this->active = $rs->getBoolean($startcol + 6);

      $this->score = $rs->getInt($startcol + 7);

      $this->merchant = $rs->getBoolean($startcol + 8);

      $this->admin_name = $rs->getString($startcol + 9);

      $this->admin_active = $rs->getBoolean($startcol + 10);

      $this->anonymous = $rs->getString($startcol + 11);

      $this->agreement = $rs->getBoolean($startcol + 12);

      $this->order_number = $rs->getString($startcol + 13);

      $this->description = $rs->getString($startcol + 14);

      $this->user_ip = $rs->getString($startcol + 15);

      $this->username = $rs->getString($startcol + 16);

      $this->language = $rs->getString($startcol + 17);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Review.postHydrate', array('resultset' => $rs, 'startcol' => 18)));

            return $startcol + 18; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Review object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseReview:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ReviewPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ReviewPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseReview:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Review.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseReview:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ReviewPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ReviewPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ReviewPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Review.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseReview:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aOrder !== null) {
				if ($this->aOrder->isModified()) {
					$affectedRows += $this->aOrder->save($con);
				}
				$this->setOrder($this->aOrder);
			}

			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}

			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ReviewPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ReviewPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aOrder !== null) {
				if (!$this->aOrder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrder->getValidationFailures());
				}
			}

			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}

			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}


			if (($retval = ReviewPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ReviewPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOrderId();
				break;
			case 4:
				return $this->getSfGuardUserId();
				break;
			case 5:
				return $this->getProductId();
				break;
			case 6:
				return $this->getActive();
				break;
			case 7:
				return $this->getScore();
				break;
			case 8:
				return $this->getMerchant();
				break;
			case 9:
				return $this->getAdminName();
				break;
			case 10:
				return $this->getAdminActive();
				break;
			case 11:
				return $this->getAnonymous();
				break;
			case 12:
				return $this->getAgreement();
				break;
			case 13:
				return $this->getOrderNumber();
				break;
			case 14:
				return $this->getDescription();
				break;
			case 15:
				return $this->getUserIp();
				break;
			case 16:
				return $this->getUsername();
				break;
			case 17:
				return $this->getLanguage();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ReviewPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOrderId(),
			$keys[4] => $this->getSfGuardUserId(),
			$keys[5] => $this->getProductId(),
			$keys[6] => $this->getActive(),
			$keys[7] => $this->getScore(),
			$keys[8] => $this->getMerchant(),
			$keys[9] => $this->getAdminName(),
			$keys[10] => $this->getAdminActive(),
			$keys[11] => $this->getAnonymous(),
			$keys[12] => $this->getAgreement(),
			$keys[13] => $this->getOrderNumber(),
			$keys[14] => $this->getDescription(),
			$keys[15] => $this->getUserIp(),
			$keys[16] => $this->getUsername(),
			$keys[17] => $this->getLanguage(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ReviewPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOrderId($value);
				break;
			case 4:
				$this->setSfGuardUserId($value);
				break;
			case 5:
				$this->setProductId($value);
				break;
			case 6:
				$this->setActive($value);
				break;
			case 7:
				$this->setScore($value);
				break;
			case 8:
				$this->setMerchant($value);
				break;
			case 9:
				$this->setAdminName($value);
				break;
			case 10:
				$this->setAdminActive($value);
				break;
			case 11:
				$this->setAnonymous($value);
				break;
			case 12:
				$this->setAgreement($value);
				break;
			case 13:
				$this->setOrderNumber($value);
				break;
			case 14:
				$this->setDescription($value);
				break;
			case 15:
				$this->setUserIp($value);
				break;
			case 16:
				$this->setUsername($value);
				break;
			case 17:
				$this->setLanguage($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ReviewPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOrderId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSfGuardUserId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setProductId($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setActive($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setScore($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setMerchant($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setAdminName($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setAdminActive($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setAnonymous($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setAgreement($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setOrderNumber($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setDescription($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setUserIp($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setUsername($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setLanguage($arr[$keys[17]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ReviewPeer::DATABASE_NAME);

		if ($this->isColumnModified(ReviewPeer::CREATED_AT)) $criteria->add(ReviewPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ReviewPeer::UPDATED_AT)) $criteria->add(ReviewPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ReviewPeer::ID)) $criteria->add(ReviewPeer::ID, $this->id);
		if ($this->isColumnModified(ReviewPeer::ORDER_ID)) $criteria->add(ReviewPeer::ORDER_ID, $this->order_id);
		if ($this->isColumnModified(ReviewPeer::SF_GUARD_USER_ID)) $criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(ReviewPeer::PRODUCT_ID)) $criteria->add(ReviewPeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(ReviewPeer::ACTIVE)) $criteria->add(ReviewPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(ReviewPeer::SCORE)) $criteria->add(ReviewPeer::SCORE, $this->score);
		if ($this->isColumnModified(ReviewPeer::MERCHANT)) $criteria->add(ReviewPeer::MERCHANT, $this->merchant);
		if ($this->isColumnModified(ReviewPeer::ADMIN_NAME)) $criteria->add(ReviewPeer::ADMIN_NAME, $this->admin_name);
		if ($this->isColumnModified(ReviewPeer::ADMIN_ACTIVE)) $criteria->add(ReviewPeer::ADMIN_ACTIVE, $this->admin_active);
		if ($this->isColumnModified(ReviewPeer::ANONYMOUS)) $criteria->add(ReviewPeer::ANONYMOUS, $this->anonymous);
		if ($this->isColumnModified(ReviewPeer::AGREEMENT)) $criteria->add(ReviewPeer::AGREEMENT, $this->agreement);
		if ($this->isColumnModified(ReviewPeer::ORDER_NUMBER)) $criteria->add(ReviewPeer::ORDER_NUMBER, $this->order_number);
		if ($this->isColumnModified(ReviewPeer::DESCRIPTION)) $criteria->add(ReviewPeer::DESCRIPTION, $this->description);
		if ($this->isColumnModified(ReviewPeer::USER_IP)) $criteria->add(ReviewPeer::USER_IP, $this->user_ip);
		if ($this->isColumnModified(ReviewPeer::USERNAME)) $criteria->add(ReviewPeer::USERNAME, $this->username);
		if ($this->isColumnModified(ReviewPeer::LANGUAGE)) $criteria->add(ReviewPeer::LANGUAGE, $this->language);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ReviewPeer::DATABASE_NAME);

		$criteria->add(ReviewPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOrderId($this->order_id);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setProductId($this->product_id);

		$copyObj->setActive($this->active);

		$copyObj->setScore($this->score);

		$copyObj->setMerchant($this->merchant);

		$copyObj->setAdminName($this->admin_name);

		$copyObj->setAdminActive($this->admin_active);

		$copyObj->setAnonymous($this->anonymous);

		$copyObj->setAgreement($this->agreement);

		$copyObj->setOrderNumber($this->order_number);

		$copyObj->setDescription($this->description);

		$copyObj->setUserIp($this->user_ip);

		$copyObj->setUsername($this->username);

		$copyObj->setLanguage($this->language);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ReviewPeer();
		}
		return self::$peer;
	}

	
	public function setOrder($v)
	{


		if ($v === null) {
			$this->setOrderId(NULL);
		} else {
			$this->setOrderId($v->getId());
		}


		$this->aOrder = $v;
	}


	
	public function getOrder($con = null)
	{
		if ($this->aOrder === null && ($this->order_id !== null)) {
						$this->aOrder = OrderPeer::retrieveByPK($this->order_id, $con);

			
		}
		return $this->aOrder;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->product_id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->product_id, $con);

			
		}
		return $this->aProduct;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Review.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseReview:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseReview::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 