<?php


abstract class BaseReviewOrder extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $order_id;


	
	protected $order_number;


	
	protected $sf_guard_user_id;


	
	protected $agreement;


	
	protected $mark;


	
	protected $active = false;


	
	protected $description;

	
	protected $aOrder;

	
	protected $asfGuardUser;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOrderId()
    {

            return $this->order_id;
    }

    
    public function getOrderNumber()
    {

            return $this->order_number;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getAgreement()
    {

            return $this->agreement;
    }

    
    public function getMark()
    {

            return $this->mark;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getDescription()
    {

            return $this->description;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ReviewOrderPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ReviewOrderPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::ID;
        }

	} 
	
	public function setOrderId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_id !== $v) {
          $this->order_id = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::ORDER_ID;
        }

		if ($this->aOrder !== null && $this->aOrder->getId() !== $v) {
			$this->aOrder = null;
		}

	} 
	
	public function setOrderNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->order_number !== $v) {
          $this->order_number = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::ORDER_NUMBER;
        }

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setAgreement($v)
	{

        if ($this->agreement !== $v) {
          $this->agreement = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::AGREEMENT;
        }

	} 
	
	public function setMark($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->mark !== $v) {
          $this->mark = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::MARK;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === false) {
          $this->active = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::ACTIVE;
        }

	} 
	
	public function setDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->description !== $v) {
          $this->description = $v;
          $this->modifiedColumns[] = ReviewOrderPeer::DESCRIPTION;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ReviewOrder.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->order_id = $rs->getInt($startcol + 3);

      $this->order_number = $rs->getString($startcol + 4);

      $this->sf_guard_user_id = $rs->getInt($startcol + 5);

      $this->agreement = $rs->getBoolean($startcol + 6);

      $this->mark = $rs->getInt($startcol + 7);

      $this->active = $rs->getBoolean($startcol + 8);

      $this->description = $rs->getString($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ReviewOrder.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ReviewOrder object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseReviewOrder:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ReviewOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ReviewOrderPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseReviewOrder:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ReviewOrder.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseReviewOrder:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ReviewOrderPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ReviewOrderPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ReviewOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ReviewOrder.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseReviewOrder:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aOrder !== null) {
				if ($this->aOrder->isModified()) {
					$affectedRows += $this->aOrder->save($con);
				}
				$this->setOrder($this->aOrder);
			}

			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ReviewOrderPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ReviewOrderPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aOrder !== null) {
				if (!$this->aOrder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrder->getValidationFailures());
				}
			}

			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}


			if (($retval = ReviewOrderPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ReviewOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOrderId();
				break;
			case 4:
				return $this->getOrderNumber();
				break;
			case 5:
				return $this->getSfGuardUserId();
				break;
			case 6:
				return $this->getAgreement();
				break;
			case 7:
				return $this->getMark();
				break;
			case 8:
				return $this->getActive();
				break;
			case 9:
				return $this->getDescription();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ReviewOrderPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOrderId(),
			$keys[4] => $this->getOrderNumber(),
			$keys[5] => $this->getSfGuardUserId(),
			$keys[6] => $this->getAgreement(),
			$keys[7] => $this->getMark(),
			$keys[8] => $this->getActive(),
			$keys[9] => $this->getDescription(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ReviewOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOrderId($value);
				break;
			case 4:
				$this->setOrderNumber($value);
				break;
			case 5:
				$this->setSfGuardUserId($value);
				break;
			case 6:
				$this->setAgreement($value);
				break;
			case 7:
				$this->setMark($value);
				break;
			case 8:
				$this->setActive($value);
				break;
			case 9:
				$this->setDescription($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ReviewOrderPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOrderId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOrderNumber($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setSfGuardUserId($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setAgreement($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setMark($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setActive($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setDescription($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ReviewOrderPeer::DATABASE_NAME);

		if ($this->isColumnModified(ReviewOrderPeer::CREATED_AT)) $criteria->add(ReviewOrderPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ReviewOrderPeer::UPDATED_AT)) $criteria->add(ReviewOrderPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ReviewOrderPeer::ID)) $criteria->add(ReviewOrderPeer::ID, $this->id);
		if ($this->isColumnModified(ReviewOrderPeer::ORDER_ID)) $criteria->add(ReviewOrderPeer::ORDER_ID, $this->order_id);
		if ($this->isColumnModified(ReviewOrderPeer::ORDER_NUMBER)) $criteria->add(ReviewOrderPeer::ORDER_NUMBER, $this->order_number);
		if ($this->isColumnModified(ReviewOrderPeer::SF_GUARD_USER_ID)) $criteria->add(ReviewOrderPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(ReviewOrderPeer::AGREEMENT)) $criteria->add(ReviewOrderPeer::AGREEMENT, $this->agreement);
		if ($this->isColumnModified(ReviewOrderPeer::MARK)) $criteria->add(ReviewOrderPeer::MARK, $this->mark);
		if ($this->isColumnModified(ReviewOrderPeer::ACTIVE)) $criteria->add(ReviewOrderPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(ReviewOrderPeer::DESCRIPTION)) $criteria->add(ReviewOrderPeer::DESCRIPTION, $this->description);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ReviewOrderPeer::DATABASE_NAME);

		$criteria->add(ReviewOrderPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOrderId($this->order_id);

		$copyObj->setOrderNumber($this->order_number);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setAgreement($this->agreement);

		$copyObj->setMark($this->mark);

		$copyObj->setActive($this->active);

		$copyObj->setDescription($this->description);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ReviewOrderPeer();
		}
		return self::$peer;
	}

	
	public function setOrder($v)
	{


		if ($v === null) {
			$this->setOrderId(NULL);
		} else {
			$this->setOrderId($v->getId());
		}


		$this->aOrder = $v;
	}


	
	public function getOrder($con = null)
	{
		if ($this->aOrder === null && ($this->order_id !== null)) {
						$this->aOrder = OrderPeer::retrieveByPK($this->order_id, $con);

			
		}
		return $this->aOrder;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ReviewOrder.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseReviewOrder:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseReviewOrder::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 