<?php


abstract class BaseThemeComponent extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $is_shared = false;


	
	protected $type;


	
	protected $name;


	
	protected $label;


	
	protected $theme_id;

	
	protected $aTheme;

	
	protected $collThemeSlotHasComponents;

	
	protected $lastThemeSlotHasComponentCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getIsShared()
    {

            return $this->is_shared;
    }

    
    public function getType()
    {

            return $this->type;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getLabel()
    {

            return $this->label;
    }

    
    public function getThemeId()
    {

            return $this->theme_id;
    }

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ThemeComponentPeer::ID;
        }

	} 
	
	public function setIsShared($v)
	{

        if ($this->is_shared !== $v || $v === false) {
          $this->is_shared = $v;
          $this->modifiedColumns[] = ThemeComponentPeer::IS_SHARED;
        }

	} 
	
	public function setType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->type !== $v) {
          $this->type = $v;
          $this->modifiedColumns[] = ThemeComponentPeer::TYPE;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = ThemeComponentPeer::NAME;
        }

	} 
	
	public function setLabel($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->label !== $v) {
          $this->label = $v;
          $this->modifiedColumns[] = ThemeComponentPeer::LABEL;
        }

	} 
	
	public function setThemeId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->theme_id !== $v) {
          $this->theme_id = $v;
          $this->modifiedColumns[] = ThemeComponentPeer::THEME_ID;
        }

		if ($this->aTheme !== null && $this->aTheme->getId() !== $v) {
			$this->aTheme = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ThemeComponent.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->is_shared = $rs->getBoolean($startcol + 1);

      $this->type = $rs->getString($startcol + 2);

      $this->name = $rs->getString($startcol + 3);

      $this->label = $rs->getString($startcol + 4);

      $this->theme_id = $rs->getInt($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ThemeComponent.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ThemeComponent object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseThemeComponent:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ThemeComponentPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ThemeComponentPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseThemeComponent:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ThemeComponent.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseThemeComponent:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ThemeComponentPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ThemeComponent.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseThemeComponent:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aTheme !== null) {
				if ($this->aTheme->isModified()) {
					$affectedRows += $this->aTheme->save($con);
				}
				$this->setTheme($this->aTheme);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ThemeComponentPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ThemeComponentPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collThemeSlotHasComponents !== null) {
				foreach($this->collThemeSlotHasComponents as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aTheme !== null) {
				if (!$this->aTheme->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTheme->getValidationFailures());
				}
			}


			if (($retval = ThemeComponentPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collThemeSlotHasComponents !== null) {
					foreach($this->collThemeSlotHasComponents as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ThemeComponentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getIsShared();
				break;
			case 2:
				return $this->getType();
				break;
			case 3:
				return $this->getName();
				break;
			case 4:
				return $this->getLabel();
				break;
			case 5:
				return $this->getThemeId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ThemeComponentPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getIsShared(),
			$keys[2] => $this->getType(),
			$keys[3] => $this->getName(),
			$keys[4] => $this->getLabel(),
			$keys[5] => $this->getThemeId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ThemeComponentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setIsShared($value);
				break;
			case 2:
				$this->setType($value);
				break;
			case 3:
				$this->setName($value);
				break;
			case 4:
				$this->setLabel($value);
				break;
			case 5:
				$this->setThemeId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ThemeComponentPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setIsShared($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setType($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setLabel($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setThemeId($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ThemeComponentPeer::DATABASE_NAME);

		if ($this->isColumnModified(ThemeComponentPeer::ID)) $criteria->add(ThemeComponentPeer::ID, $this->id);
		if ($this->isColumnModified(ThemeComponentPeer::IS_SHARED)) $criteria->add(ThemeComponentPeer::IS_SHARED, $this->is_shared);
		if ($this->isColumnModified(ThemeComponentPeer::TYPE)) $criteria->add(ThemeComponentPeer::TYPE, $this->type);
		if ($this->isColumnModified(ThemeComponentPeer::NAME)) $criteria->add(ThemeComponentPeer::NAME, $this->name);
		if ($this->isColumnModified(ThemeComponentPeer::LABEL)) $criteria->add(ThemeComponentPeer::LABEL, $this->label);
		if ($this->isColumnModified(ThemeComponentPeer::THEME_ID)) $criteria->add(ThemeComponentPeer::THEME_ID, $this->theme_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ThemeComponentPeer::DATABASE_NAME);

		$criteria->add(ThemeComponentPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setIsShared($this->is_shared);

		$copyObj->setType($this->type);

		$copyObj->setName($this->name);

		$copyObj->setLabel($this->label);

		$copyObj->setThemeId($this->theme_id);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getThemeSlotHasComponents() as $relObj) {
				$copyObj->addThemeSlotHasComponent($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ThemeComponentPeer();
		}
		return self::$peer;
	}

	
	public function setTheme($v)
	{


		if ($v === null) {
			$this->setThemeId(NULL);
		} else {
			$this->setThemeId($v->getId());
		}


		$this->aTheme = $v;
	}


	
	public function getTheme($con = null)
	{
		if ($this->aTheme === null && ($this->theme_id !== null)) {
						$this->aTheme = ThemePeer::retrieveByPK($this->theme_id, $con);

			
		}
		return $this->aTheme;
	}

	
	public function initThemeSlotHasComponents()
	{
		if ($this->collThemeSlotHasComponents === null) {
			$this->collThemeSlotHasComponents = array();
		}
	}

	
	public function getThemeSlotHasComponents($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeSlotHasComponents === null) {
			if ($this->isNew()) {
			   $this->collThemeSlotHasComponents = array();
			} else {

				$criteria->add(ThemeSlotHasComponentPeer::COMPONENT_ID, $this->getId());

				ThemeSlotHasComponentPeer::addSelectColumns($criteria);
				$this->collThemeSlotHasComponents = ThemeSlotHasComponentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeSlotHasComponentPeer::COMPONENT_ID, $this->getId());

				ThemeSlotHasComponentPeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeSlotHasComponentCriteria) || !$this->lastThemeSlotHasComponentCriteria->equals($criteria)) {
					$this->collThemeSlotHasComponents = ThemeSlotHasComponentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeSlotHasComponentCriteria = $criteria;
		return $this->collThemeSlotHasComponents;
	}

	
	public function countThemeSlotHasComponents($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeSlotHasComponentPeer::COMPONENT_ID, $this->getId());

		return ThemeSlotHasComponentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeSlotHasComponent(ThemeSlotHasComponent $l)
	{
		$this->collThemeSlotHasComponents[] = $l;
		$l->setThemeComponent($this);
	}


	
	public function getThemeSlotHasComponentsJoinThemeSlot($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeSlotHasComponents === null) {
			if ($this->isNew()) {
				$this->collThemeSlotHasComponents = array();
			} else {

				$criteria->add(ThemeSlotHasComponentPeer::COMPONENT_ID, $this->getId());

				$this->collThemeSlotHasComponents = ThemeSlotHasComponentPeer::doSelectJoinThemeSlot($criteria, $con);
			}
		} else {
									
			$criteria->add(ThemeSlotHasComponentPeer::COMPONENT_ID, $this->getId());

			if (!isset($this->lastThemeSlotHasComponentCriteria) || !$this->lastThemeSlotHasComponentCriteria->equals($criteria)) {
				$this->collThemeSlotHasComponents = ThemeSlotHasComponentPeer::doSelectJoinThemeSlot($criteria, $con);
			}
		}
		$this->lastThemeSlotHasComponentCriteria = $criteria;

		return $this->collThemeSlotHasComponents;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ThemeComponent.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseThemeComponent:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseThemeComponent::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 