<?php


abstract class BaseThemeSlotHasComponent extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $slot_id;


	
	protected $component_id;

	
	protected $aThemeSlot;

	
	protected $aThemeComponent;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getSlotId()
    {

            return $this->slot_id;
    }

    
    public function getComponentId()
    {

            return $this->component_id;
    }

	
	public function setSlotId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->slot_id !== $v) {
          $this->slot_id = $v;
          $this->modifiedColumns[] = ThemeSlotHasComponentPeer::SLOT_ID;
        }

		if ($this->aThemeSlot !== null && $this->aThemeSlot->getId() !== $v) {
			$this->aThemeSlot = null;
		}

	} 
	
	public function setComponentId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->component_id !== $v) {
          $this->component_id = $v;
          $this->modifiedColumns[] = ThemeSlotHasComponentPeer::COMPONENT_ID;
        }

		if ($this->aThemeComponent !== null && $this->aThemeComponent->getId() !== $v) {
			$this->aThemeComponent = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ThemeSlotHasComponent.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->slot_id = $rs->getInt($startcol + 0);

      $this->component_id = $rs->getInt($startcol + 1);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ThemeSlotHasComponent.postHydrate', array('resultset' => $rs, 'startcol' => 2)));

            return $startcol + 2; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ThemeSlotHasComponent object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseThemeSlotHasComponent:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ThemeSlotHasComponentPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ThemeSlotHasComponentPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseThemeSlotHasComponent:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ThemeSlotHasComponent.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseThemeSlotHasComponent:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ThemeSlotHasComponentPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ThemeSlotHasComponent.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseThemeSlotHasComponent:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aThemeSlot !== null) {
				if ($this->aThemeSlot->isModified()) {
					$affectedRows += $this->aThemeSlot->save($con);
				}
				$this->setThemeSlot($this->aThemeSlot);
			}

			if ($this->aThemeComponent !== null) {
				if ($this->aThemeComponent->isModified()) {
					$affectedRows += $this->aThemeComponent->save($con);
				}
				$this->setThemeComponent($this->aThemeComponent);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ThemeSlotHasComponentPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setNew(false);
				} else {
					$affectedRows += ThemeSlotHasComponentPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aThemeSlot !== null) {
				if (!$this->aThemeSlot->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aThemeSlot->getValidationFailures());
				}
			}

			if ($this->aThemeComponent !== null) {
				if (!$this->aThemeComponent->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aThemeComponent->getValidationFailures());
				}
			}


			if (($retval = ThemeSlotHasComponentPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ThemeSlotHasComponentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getSlotId();
				break;
			case 1:
				return $this->getComponentId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ThemeSlotHasComponentPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getSlotId(),
			$keys[1] => $this->getComponentId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ThemeSlotHasComponentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setSlotId($value);
				break;
			case 1:
				$this->setComponentId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ThemeSlotHasComponentPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setSlotId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setComponentId($arr[$keys[1]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ThemeSlotHasComponentPeer::DATABASE_NAME);

		if ($this->isColumnModified(ThemeSlotHasComponentPeer::SLOT_ID)) $criteria->add(ThemeSlotHasComponentPeer::SLOT_ID, $this->slot_id);
		if ($this->isColumnModified(ThemeSlotHasComponentPeer::COMPONENT_ID)) $criteria->add(ThemeSlotHasComponentPeer::COMPONENT_ID, $this->component_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ThemeSlotHasComponentPeer::DATABASE_NAME);

		$criteria->add(ThemeSlotHasComponentPeer::SLOT_ID, $this->slot_id);
		$criteria->add(ThemeSlotHasComponentPeer::COMPONENT_ID, $this->component_id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getSlotId();

		$pks[1] = $this->getComponentId();

		return $pks;
	}

	
	public function setPrimaryKey($keys)
	{

		$this->setSlotId($keys[0]);

		$this->setComponentId($keys[1]);

	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{


		$copyObj->setNew(true);

		$copyObj->setSlotId(NULL); 
		$copyObj->setComponentId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ThemeSlotHasComponentPeer();
		}
		return self::$peer;
	}

	
	public function setThemeSlot($v)
	{


		if ($v === null) {
			$this->setSlotId(NULL);
		} else {
			$this->setSlotId($v->getId());
		}


		$this->aThemeSlot = $v;
	}


	
	public function getThemeSlot($con = null)
	{
		if ($this->aThemeSlot === null && ($this->slot_id !== null)) {
						$this->aThemeSlot = ThemeSlotPeer::retrieveByPK($this->slot_id, $con);

			
		}
		return $this->aThemeSlot;
	}

	
	public function setThemeComponent($v)
	{


		if ($v === null) {
			$this->setComponentId(NULL);
		} else {
			$this->setComponentId($v->getId());
		}


		$this->aThemeComponent = $v;
	}


	
	public function getThemeComponent($con = null)
	{
		if ($this->aThemeComponent === null && ($this->component_id !== null)) {
						$this->aThemeComponent = ThemeComponentPeer::retrieveByPK($this->component_id, $con);

			
		}
		return $this->aThemeComponent;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ThemeSlotHasComponent.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseThemeSlotHasComponent:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseThemeSlotHasComponent::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 