<?php


abstract class BaseUserData extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_guard_user_id;


	
	protected $countries_id;


	
	protected $is_billing;


	
	protected $is_default = false;


	
	protected $name;


	
	protected $surname;


	
	protected $full_name;


	
	protected $address;


	
	protected $address_more;


	
	protected $region;


	
	protected $street;


	
	protected $house;


	
	protected $flat;


	
	protected $code;


	
	protected $town;


	
	protected $phone;


	
	protected $company;


	
	protected $vat_number;


	
	protected $crypt = false;

	
	protected $asfGuardUser;

	
	protected $aCountries;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getCountriesId()
    {

            return $this->countries_id;
    }

    
    public function getIsBilling()
    {

            return $this->is_billing;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getSurname()
    {

            return $this->surname;
    }

    
    public function getFullName()
    {

            return $this->full_name;
    }

    
    public function getAddress()
    {

            return $this->address;
    }

    
    public function getAddressMore()
    {

            return $this->address_more;
    }

    
    public function getRegion()
    {

            return $this->region;
    }

    
    public function getStreet()
    {

            return $this->street;
    }

    
    public function getHouse()
    {

            return $this->house;
    }

    
    public function getFlat()
    {

            return $this->flat;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getTown()
    {

            return $this->town;
    }

    
    public function getPhone()
    {

            return $this->phone;
    }

    
    public function getCompany()
    {

            return $this->company;
    }

    
    public function getVatNumber()
    {

            return $this->vat_number;
    }

    
    public function getCrypt()
    {

            return $this->crypt;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = UserDataPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = UserDataPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = UserDataPeer::ID;
        }

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = UserDataPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setCountriesId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->countries_id !== $v) {
          $this->countries_id = $v;
          $this->modifiedColumns[] = UserDataPeer::COUNTRIES_ID;
        }

		if ($this->aCountries !== null && $this->aCountries->getId() !== $v) {
			$this->aCountries = null;
		}

	} 
	
	public function setIsBilling($v)
	{

        if ($this->is_billing !== $v) {
          $this->is_billing = $v;
          $this->modifiedColumns[] = UserDataPeer::IS_BILLING;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = UserDataPeer::IS_DEFAULT;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = UserDataPeer::NAME;
        }

	} 
	
	public function setSurname($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->surname !== $v) {
          $this->surname = $v;
          $this->modifiedColumns[] = UserDataPeer::SURNAME;
        }

	} 
	
	public function setFullName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->full_name !== $v) {
          $this->full_name = $v;
          $this->modifiedColumns[] = UserDataPeer::FULL_NAME;
        }

	} 
	
	public function setAddress($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->address !== $v) {
          $this->address = $v;
          $this->modifiedColumns[] = UserDataPeer::ADDRESS;
        }

	} 
	
	public function setAddressMore($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->address_more !== $v) {
          $this->address_more = $v;
          $this->modifiedColumns[] = UserDataPeer::ADDRESS_MORE;
        }

	} 
	
	public function setRegion($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->region !== $v) {
          $this->region = $v;
          $this->modifiedColumns[] = UserDataPeer::REGION;
        }

	} 
	
	public function setStreet($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->street !== $v) {
          $this->street = $v;
          $this->modifiedColumns[] = UserDataPeer::STREET;
        }

	} 
	
	public function setHouse($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->house !== $v) {
          $this->house = $v;
          $this->modifiedColumns[] = UserDataPeer::HOUSE;
        }

	} 
	
	public function setFlat($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->flat !== $v) {
          $this->flat = $v;
          $this->modifiedColumns[] = UserDataPeer::FLAT;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = UserDataPeer::CODE;
        }

	} 
	
	public function setTown($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->town !== $v) {
          $this->town = $v;
          $this->modifiedColumns[] = UserDataPeer::TOWN;
        }

	} 
	
	public function setPhone($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->phone !== $v) {
          $this->phone = $v;
          $this->modifiedColumns[] = UserDataPeer::PHONE;
        }

	} 
	
	public function setCompany($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->company !== $v) {
          $this->company = $v;
          $this->modifiedColumns[] = UserDataPeer::COMPANY;
        }

	} 
	
	public function setVatNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->vat_number !== $v) {
          $this->vat_number = $v;
          $this->modifiedColumns[] = UserDataPeer::VAT_NUMBER;
        }

	} 
	
	public function setCrypt($v)
	{

        if ($this->crypt !== $v || $v === false) {
          $this->crypt = $v;
          $this->modifiedColumns[] = UserDataPeer::CRYPT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'UserData.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_guard_user_id = $rs->getInt($startcol + 3);

      $this->countries_id = $rs->getInt($startcol + 4);

      $this->is_billing = $rs->getBoolean($startcol + 5);

      $this->is_default = $rs->getBoolean($startcol + 6);

      $this->name = $rs->getString($startcol + 7);

      $this->surname = $rs->getString($startcol + 8);

      $this->full_name = $rs->getString($startcol + 9);

      $this->address = $rs->getString($startcol + 10);

      $this->address_more = $rs->getString($startcol + 11);

      $this->region = $rs->getString($startcol + 12);

      $this->street = $rs->getString($startcol + 13);

      $this->house = $rs->getString($startcol + 14);

      $this->flat = $rs->getString($startcol + 15);

      $this->code = $rs->getString($startcol + 16);

      $this->town = $rs->getString($startcol + 17);

      $this->phone = $rs->getString($startcol + 18);

      $this->company = $rs->getString($startcol + 19);

      $this->vat_number = $rs->getString($startcol + 20);

      $this->crypt = $rs->getBoolean($startcol + 21);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'UserData.postHydrate', array('resultset' => $rs, 'startcol' => 22)));

            return $startcol + 22; 
    } catch (Exception $e) {
      throw new PropelException("Error populating UserData object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseUserData:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(UserDataPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			UserDataPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseUserData:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'UserData.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseUserData:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(UserDataPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(UserDataPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(UserDataPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'UserData.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseUserData:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}

			if ($this->aCountries !== null) {
				if ($this->aCountries->isModified() || $this->aCountries->getCurrentCountriesI18n()->isModified()) {
					$affectedRows += $this->aCountries->save($con);
				}
				$this->setCountries($this->aCountries);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = UserDataPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += UserDataPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}

			if ($this->aCountries !== null) {
				if (!$this->aCountries->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCountries->getValidationFailures());
				}
			}


			if (($retval = UserDataPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = UserDataPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfGuardUserId();
				break;
			case 4:
				return $this->getCountriesId();
				break;
			case 5:
				return $this->getIsBilling();
				break;
			case 6:
				return $this->getIsDefault();
				break;
			case 7:
				return $this->getName();
				break;
			case 8:
				return $this->getSurname();
				break;
			case 9:
				return $this->getFullName();
				break;
			case 10:
				return $this->getAddress();
				break;
			case 11:
				return $this->getAddressMore();
				break;
			case 12:
				return $this->getRegion();
				break;
			case 13:
				return $this->getStreet();
				break;
			case 14:
				return $this->getHouse();
				break;
			case 15:
				return $this->getFlat();
				break;
			case 16:
				return $this->getCode();
				break;
			case 17:
				return $this->getTown();
				break;
			case 18:
				return $this->getPhone();
				break;
			case 19:
				return $this->getCompany();
				break;
			case 20:
				return $this->getVatNumber();
				break;
			case 21:
				return $this->getCrypt();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = UserDataPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfGuardUserId(),
			$keys[4] => $this->getCountriesId(),
			$keys[5] => $this->getIsBilling(),
			$keys[6] => $this->getIsDefault(),
			$keys[7] => $this->getName(),
			$keys[8] => $this->getSurname(),
			$keys[9] => $this->getFullName(),
			$keys[10] => $this->getAddress(),
			$keys[11] => $this->getAddressMore(),
			$keys[12] => $this->getRegion(),
			$keys[13] => $this->getStreet(),
			$keys[14] => $this->getHouse(),
			$keys[15] => $this->getFlat(),
			$keys[16] => $this->getCode(),
			$keys[17] => $this->getTown(),
			$keys[18] => $this->getPhone(),
			$keys[19] => $this->getCompany(),
			$keys[20] => $this->getVatNumber(),
			$keys[21] => $this->getCrypt(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = UserDataPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfGuardUserId($value);
				break;
			case 4:
				$this->setCountriesId($value);
				break;
			case 5:
				$this->setIsBilling($value);
				break;
			case 6:
				$this->setIsDefault($value);
				break;
			case 7:
				$this->setName($value);
				break;
			case 8:
				$this->setSurname($value);
				break;
			case 9:
				$this->setFullName($value);
				break;
			case 10:
				$this->setAddress($value);
				break;
			case 11:
				$this->setAddressMore($value);
				break;
			case 12:
				$this->setRegion($value);
				break;
			case 13:
				$this->setStreet($value);
				break;
			case 14:
				$this->setHouse($value);
				break;
			case 15:
				$this->setFlat($value);
				break;
			case 16:
				$this->setCode($value);
				break;
			case 17:
				$this->setTown($value);
				break;
			case 18:
				$this->setPhone($value);
				break;
			case 19:
				$this->setCompany($value);
				break;
			case 20:
				$this->setVatNumber($value);
				break;
			case 21:
				$this->setCrypt($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = UserDataPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfGuardUserId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setCountriesId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setIsBilling($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setIsDefault($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setName($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setSurname($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setFullName($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setAddress($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setAddressMore($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setRegion($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setStreet($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setHouse($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setFlat($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setCode($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setTown($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setPhone($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setCompany($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setVatNumber($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setCrypt($arr[$keys[21]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(UserDataPeer::DATABASE_NAME);

		if ($this->isColumnModified(UserDataPeer::CREATED_AT)) $criteria->add(UserDataPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(UserDataPeer::UPDATED_AT)) $criteria->add(UserDataPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(UserDataPeer::ID)) $criteria->add(UserDataPeer::ID, $this->id);
		if ($this->isColumnModified(UserDataPeer::SF_GUARD_USER_ID)) $criteria->add(UserDataPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(UserDataPeer::COUNTRIES_ID)) $criteria->add(UserDataPeer::COUNTRIES_ID, $this->countries_id);
		if ($this->isColumnModified(UserDataPeer::IS_BILLING)) $criteria->add(UserDataPeer::IS_BILLING, $this->is_billing);
		if ($this->isColumnModified(UserDataPeer::IS_DEFAULT)) $criteria->add(UserDataPeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(UserDataPeer::NAME)) $criteria->add(UserDataPeer::NAME, $this->name);
		if ($this->isColumnModified(UserDataPeer::SURNAME)) $criteria->add(UserDataPeer::SURNAME, $this->surname);
		if ($this->isColumnModified(UserDataPeer::FULL_NAME)) $criteria->add(UserDataPeer::FULL_NAME, $this->full_name);
		if ($this->isColumnModified(UserDataPeer::ADDRESS)) $criteria->add(UserDataPeer::ADDRESS, $this->address);
		if ($this->isColumnModified(UserDataPeer::ADDRESS_MORE)) $criteria->add(UserDataPeer::ADDRESS_MORE, $this->address_more);
		if ($this->isColumnModified(UserDataPeer::REGION)) $criteria->add(UserDataPeer::REGION, $this->region);
		if ($this->isColumnModified(UserDataPeer::STREET)) $criteria->add(UserDataPeer::STREET, $this->street);
		if ($this->isColumnModified(UserDataPeer::HOUSE)) $criteria->add(UserDataPeer::HOUSE, $this->house);
		if ($this->isColumnModified(UserDataPeer::FLAT)) $criteria->add(UserDataPeer::FLAT, $this->flat);
		if ($this->isColumnModified(UserDataPeer::CODE)) $criteria->add(UserDataPeer::CODE, $this->code);
		if ($this->isColumnModified(UserDataPeer::TOWN)) $criteria->add(UserDataPeer::TOWN, $this->town);
		if ($this->isColumnModified(UserDataPeer::PHONE)) $criteria->add(UserDataPeer::PHONE, $this->phone);
		if ($this->isColumnModified(UserDataPeer::COMPANY)) $criteria->add(UserDataPeer::COMPANY, $this->company);
		if ($this->isColumnModified(UserDataPeer::VAT_NUMBER)) $criteria->add(UserDataPeer::VAT_NUMBER, $this->vat_number);
		if ($this->isColumnModified(UserDataPeer::CRYPT)) $criteria->add(UserDataPeer::CRYPT, $this->crypt);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(UserDataPeer::DATABASE_NAME);

		$criteria->add(UserDataPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setCountriesId($this->countries_id);

		$copyObj->setIsBilling($this->is_billing);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setName($this->name);

		$copyObj->setSurname($this->surname);

		$copyObj->setFullName($this->full_name);

		$copyObj->setAddress($this->address);

		$copyObj->setAddressMore($this->address_more);

		$copyObj->setRegion($this->region);

		$copyObj->setStreet($this->street);

		$copyObj->setHouse($this->house);

		$copyObj->setFlat($this->flat);

		$copyObj->setCode($this->code);

		$copyObj->setTown($this->town);

		$copyObj->setPhone($this->phone);

		$copyObj->setCompany($this->company);

		$copyObj->setVatNumber($this->vat_number);

		$copyObj->setCrypt($this->crypt);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new UserDataPeer();
		}
		return self::$peer;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function setCountries($v)
	{


		if ($v === null) {
			$this->setCountriesId(NULL);
		} else {
			$this->setCountriesId($v->getId());
		}


		$this->aCountries = $v;
	}


	
	public function getCountries($con = null)
	{
		if ($this->aCountries === null && ($this->countries_id !== null)) {
						$this->aCountries = CountriesPeer::retrieveByPK($this->countries_id, $con);

			
		}
		return $this->aCountries;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'UserData.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseUserData:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseUserData::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 