<?php
/**
 * SOTESHOP/stBase
 *
 * Ten plik należy do aplikacji stBase opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stBase
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stActions.class.php 10277 2011-01-14 13:51:05Z marcin $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/**
 * Klasa Akcji. Zastępienie akcji sfActions w modułach.
 *
 * @package     stBase
 * @subpackage  libs
 */
class stActions extends sfActions
{
    /**
     *
     * Lista aktualizacji elementów DOM HTML
     * 
     * @var array
     */
    protected $responseCalls = array();

    /**
     * Instancja obiektu event dispatcher
     * @var sfEventDispatcher
     */
    protected $dispatcher = null;

    /**
     * Przekazanie instancji obiektu sfEventDispatcher do stActions
     *
     * @param        string      $context
     */
    public function initialize($context)
    {
        $this->dispatcher = $context->getController()->getDispatcher();

        return parent::initialize($context);
    }

    /**
     * Zwraca instancje obiektu sfEventDispatcher
     *
     * @return   sfEventDispatcher
     */
    public function getDispatcher()
    {
        return $this->dispatcher;
    }

    /**
     * Zadanie wykonywane przed akcją.
     */
    public function preExecute()
    {
        $this->getContext()->getI18N()->setCurrentCatalogue($this->getModuleName());

        $this->dispatcher->notify(new sfEvent($this, 'stActions.preExecute'), array('moduleName' => $this->getModuleName()));
        $this->dispatcher->notify(new sfEvent($this, 'stActions.preExecute' . ucfirst($this->getActionName()), array('moduleName' => $this->getModuleName())));
        $this->dispatcher->notify(new sfEvent($this, $this->getActionClassName() . '.preExecute' . ucfirst($this->getActionName())));
        parent::preExecute();
    }

    /**
     *  Zadanie wykonywane po akcji.
     */
    public function postExecute()
    {
    	$this->dispatcher->notify(new sfEvent($this, 'stActions.postExecute'), array('moduleName' => $this->getModuleName()));
        $this->dispatcher->notify(new sfEvent($this, 'stActions.postExecute' . ucfirst($this->getActionName()), array('moduleName' => $this->getModuleName())));
        $this->dispatcher->notify(new sfEvent($this, $this->getActionClassName() . '.postExecute' . ucfirst($this->getActionName())));
        parent::postExecute();
    }

    /**
     * Zwraca nazwe klasy dla aplikacji
     *
     * @return   string
     */
    protected function getActionClassName()
    {
        return (SF_APP == 'backend' ? 'auto' : '') . get_class($this);
    }

    /**
     *
     * Metoda pomocniczna dla ajaxUpdateElement
     *
     * @param <type> $html
     * @return <type>
     */
    protected function responseEscapeHtml($html)
    {
        return preg_replace('/\r\n|\n|\r/', '', addslashes($html));
    }

    /**
     *
     * Aktualizuje dowolny element DOM HTML o $element_id na stronie
     *
     * @param string $element_id Id elementu DOM HTML
     * @param mixed $content Zawartośc jaka ma zostać wstawiona do elementu DOM HTML
     *
     * przykład:
     *
     * // Aktualizacja elementu o id 'st_basket_list' komponentem 'list' z modulu 'stBasket' z parametrem 'basket_id'
     * $this->updateElement('st_basket_list', array('module' => 'stBasket', 'component' => 'list', 'params' => array('basket_id' => 1)));
     *
     * // Aktualizacja elementu o id 'st_basket_list' partialem 'list' z modulu 'stBasket' z parametrem 'basket_id'
     * $this->updateElement('st_basket_list', array('module' => 'stBasket', 'partial' => 'list', 'params' => array('basket_id' => 1)));
     *
     * // Aktualizacja elementu o id 'st_basket_list' dowolna zawartością
     * $this->updateElement('st_basket_list', '<div>Dowolna zawartość</div>');
     *
     */
    public function responseUpdateElement($element_id, $content, $highlight_change = true)
    {
        sfLoader::loadHelpers(array('Helper','Javascript', 'Partial','stPartial'));

        if (is_array($content))
        {
            $params = isset($content['params']) ? $content['params'] : array();

            if (isset($content['partial']))
            {
                $content = st_get_partial($content['module'] . '/' . $content['partial'], $params);
            }
            elseif (isset($content['component']))
            {
                $content = st_get_component($content['module'], $content['component'], $params);
            }
            else
            {
                throw new sfException('Wrong syntax see ' . __FILE__ . ' for examples of updateElement() calls');
            }
        }

        if ($highlight_change)
        {
            $highlight = visual_effect('highlight', $element_id, array('duration' => 0.5));
        }
        else
        {
            $highlight = '';
        }
        
        $this->responseCalls[] = sprintf('if ($(\'%1$s\')) { $(\'%1$s\').update("%2$s"); %3$s; }', $element_id, $this->responseEscapeHtml($content), $highlight);
    }

    public function responseEvalJs($javascript)
    {
        $this->responseCalls[] = $javascript;
    }
    
    /**
     *
     * Zwraca aktualizacje elementów DOM HTML do odpowiedzi Ajax
     *
     * @return sfView::NONE
     */
    public function renderResponse()
    {
        $this->postExecute();

        if (!empty($this->responseCalls) && $this->getRequest()->isXmlHttpRequest())
        {
            $this->getResponse()->setContentType('application/javascript');

            return $this->renderText(implode(";\n", $this->responseCalls));
        }
    }

    /**
     *
     * Appends json to the response content
     *
     * This method accept the same parameters as json_encode
     *
     * @param mixed $value The value to be encoded to json response
     * @return sfView::NONE
     */
    public function renderJSON($value)
    {
       $this->getResponse()->setContentType('application/json');

       return $this->renderText(json_encode($value));
    }
}