<?php
/**
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */

/**
 * Fast cache code generator. Elements which replace smarty assign elements. Elements are replaced by php code.
 */
class stFastCacheCode
{
    /**
     * Get source php code from file.
     * 
     * @param string $file    File in soteshop/fastcache/lib.php/$file
     * @param string $default If file doesn't exists get default file
     * @param mixed  $data    Parameters
     * @return string Source of the provided file
     */
    static public function code($file,$default=null,$data=null)
    {        
        $path=sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'php'.DIRECTORY_SEPARATOR;
        $path_file=$path.$file.'.php';
        $path_default_file=$path.$default.'.php';
        if (file_exists($path_file)) return trim(file_get_contents($path_file));
        if (file_exists($path_default_file)) 
        {
            $data=trim(file_get_contents($path_default_file));
            $data=str_replace('__FC_ASSIGN__',$file,$data);
            return $data;
        }
        return NULL;
    }
    
    /**
     * Execute PHP or create PHP Fast Cache code.
     * 
     * @param string $file    File in soteshop/fastcache/lib/php/execute/$file
     * @param mixed  $data    Parameters for included file
     * @return string Generated php code
     */
    static public function prepareCode($file,$data=null)
    {
        $path=sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'php'.DIRECTORY_SEPARATOR.'prepare'.DIRECTORY_SEPARATOR;
        $path_file=$path.$file.'.php';
        if (file_exists($path_file)) 
        {
             ob_start();
             include($path_file);
             $code=ob_get_clean();
             return $code;
        }        
        return null;
    }
    
    /**
     * Save default value for $key. Eg. Save default element for empty basket etc.
     *
     * @param string $key
     * @param string $value
     * @param string $lang   
     * @return null
     */
    static public function save($key,$value,$lang)
    {
       $path=sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'default';
       if (! is_dir($path)) 
       {
           if (! mkdir($path)) throw Exception("Unable mkdir $path");
       }
       
       if (! is_dir($path.DIRECTORY_SEPARATOR.$lang)) 
       {
           if (! mkdir($path.DIRECTORY_SEPARATOR.$lang)) throw Exception("Unable mkdir ".$path.DIRECTORY_SEPARATOR.$lang);
       }
              
       if (empty($value)) $value='<!-- '.$key.' -->'; // if value is empty file_put_contents return false value and method throw excpetion
       if (! file_put_contents($path.DIRECTORY_SEPARATOR.$lang.DIRECTORY_SEPARATOR.$key.'.html',$value))
       {
           throw new Exception ("Unable save cache in ".$path.DIRECTORY_SEPARATOR.$lang.DIRECTORY_SEPARATOR.$key);
       }
       
       return null;
    }
}