<?php
/**
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */

/**
 * stFastCache Manager.
 * Manage fast cache files.
 */
class stFastCacheManager
{
	static public function clearCache($model=null, $con=null)
	{
		foreach (glob(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'cache*') as $cache_file)
		{
			unlink($cache_file);
		}

		foreach (glob(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'default'.DIRECTORY_SEPARATOR.'*'.DIRECTORY_SEPARATOR.'*') as $cache_file)
		{
			if (is_file($cache_file)) unlink($cache_file);
			elseif (is_dir($cache_file))
			{
                foreach (glob($cache_file.DIRECTORY_SEPARATOR.'*') as $file)
                {
                    unlink ($file);
                }                
                rmdir($cache_file);
			}			
		}
	}

	static public function productConfigClearCache($event)
	{
		if (sfContext::getInstance()->getRequest()->getMethod() == sfRequest::POST)
		{
			self::clearCache();
		}
	}

}