<?php
/**
 * 
 */

class stOrderPrintPdf {
    
    protected $pdf = null;
    
    protected $orderId = null;
        
    protected $showBorder = 0;
    
    public static $PDF_MARGIN_TOP = 5;
    
    public static $PDF_MARGIN_LEFT = 5;
    
    public static $PDF_MARGIN_RIGHT = 5;
    
    protected $download = "D";
    
    public function __construct($orderId) {
        /**
         * inicjalizacja klasy stInvoicePdf
         */
        $this->pdf = new stCustomTCPDF();
        $this->orderId = $orderId;

        //tryb developerski
        if (SF_DEBUG) $this->showBorder=1;
        
        $this->configure();
    }
    
    protected function configure() {
        $this->pdf->SetFont("dejavusans", "", 11);
        $this->pdf->SetMargins(stOrderPrintPdf::$PDF_MARGIN_LEFT, stOrderPrintPdf::$PDF_MARGIN_TOP, stOrderPrintPdf::$PDF_MARGIN_RIGHT);
        $this->pdf->AddPage();
    }
    
    public function forceDownload($download = false) {
        $this->download = $download?"D":"I";
    }
    
    public function renderOrder() {
        
        $this->pdf->startPageGroup(); 
              
        $c = new Criteria();
        $c->add(OrderPeer::ID, $this->orderId);        
        $order = OrderPeer::doSelectOne($c);

        $user = sfContext::getInstance()->getUser();

        $culture = $user->getCulture();

        $user->setCulture($order->getClientCulture());
          
        $orderInfoHTML = st_get_partial('stOrderPrintPdf/order_info', array('order' => $order));
        $orderItemsHTML = st_get_partial('stOrderPrintPdf/order_items', array('order' => $order));
        $billingAddressHTML = st_get_partial('stOrderPrintPdf/user_data', array('user_data' => $order->getOrderUserDataBilling()));
        $deliveryAddressHTML = st_get_partial('stOrderPrintPdf/user_data', array('user_data' => $order->getOrderUserDataDelivery()));
        $deliveryHTML = st_get_partial('stOrderPrintPdf/order_delivery', array('order' => $order));
        $paymentHTML = st_get_partial('stOrderPrintPdf/order_payment', array('order' => $order));
        $orderDataHTML = st_get_partial('stOrderPrintPdf/order_data', array('order' => $order));
        $orderDescriptionHTML = st_get_partial('stOrderPrintPdf/order_description', array('order' => $order));
        
        
        //$this->pdf->SetDrawColor(255, 255, 255);
        $this->pdf->SetDrawColor(120, 120, 120);
        $this->pdf->SetLineWidth(0.2); 

        $current_y_pos = stInvoicePdf::$PDF_MARGIN_TOP;
        
                
        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $orderDataHTML,$this->showBorder,1,0);
        $new_y_pos = $this->pdf->getY();
       
        $current_y_pos = $this->pdf->getY();
        $this->pdf->writeHTMLCell(100,0,0,$current_y_pos, $billingAddressHTML,$this->showBorder,1,0); 
        $new_y_pos = $this->pdf->getY();

        $this->pdf->writeHTMLCell(0,0,105,$current_y_pos, $deliveryAddressHTML,$this->showBorder,1,0); 
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;
                       
        $this->pdf->writeHTMLCell(200,0,0,$current_y_pos, $orderItemsHTML,$this->showBorder,1,0);
        
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;
        
        $this->pdf->writeHTMLCell(200,0,0,$current_y_pos, $deliveryHTML, $this->showBorder,1,0);
        
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;
        
        $this->pdf->writeHTMLCell(200,0,0,$current_y_pos, $paymentHTML, $this->showBorder,1,0);
        
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;
        
        $this->pdf->writeHTMLCell(200,0,0,$current_y_pos, $orderDescriptionHTML, $this->showBorder,1,0);
        
        if ($new_y_pos < $this->pdf->getY()) $new_y_pos = $this->pdf->getY();
        $current_y_pos = $new_y_pos;
        
        $this->pdf->writeHTMLCell(200,0,0,$current_y_pos, $orderInfoHTML, $this->showBorder,1,0);
        
        if (SF_APP == 'backend')
        {       
            $this->pdf->Output('order-'.$order->getNumber().'.pdf',$this->download);
        }

        $user->setCulture($culture);
    }
}