<?php

class stOrderProgressBar
{
   protected static $dbm = null;
   /**
    *
    * @return Criteria 
    */
   public static function getCriteria()
   {
      $c = new Criteria();
      
      return $c;
   }
   
   public static function initDatabase()
   {
      self::$dbm = new sfDatabaseManager();

      self::$dbm->initialize();      
   }
   
   public static function shutdownDatabase()
   {
      self::$dbm->shutdown();
   }
   
   public static function countRepairTotalAmount()
   {
      self::initDatabase();
      
      $count = OrderPeer::doCount(self::getCriteria());
      
      self::shutdownDatabase();
      
      return $count;
   }
   
   public function close()
   {
      $this->setMessage('Naprawa zamówień zakończona pomyślnie');
   }
   
   public function repairTotalAmount($offset = 0)
   {      
      self::initDatabase();
      
      $c = self::getCriteria();
      
      $c->setOffset($offset);
      
      $c->setLimit(100);

      $orders = OrderPeer::doSelect($c);   
      
      foreach ($orders as $order)
      {
         $order->setOptTotalAmount($order->getTotalAmountWithDelivery(true, true));
         
         $order->save();
         
         $offset++;
         
         usleep(200000);
      }
      
      $this->setMessage('Zamówienia - Naprawa sortowania i filtrowania po cenie');
      
      self::shutdownDatabase();
      
      sleep(2);
      
      return $offset;
   }
   
   protected function setMessage($message)
   {
     $user = sfContext::getInstance()->getUser();

     $user->setAttribute('stProgressBar-stOrderRepair', $message, 'symfony/flash');
   }   
}
