<?php
/**
 * SOTESHOP/stPriceCompare
 *
 * Ten plik należy do aplikacji stPriceCompare opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stPriceCompare
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stPriceCompareListener.class.php 8244 2010-09-09 14:32:00Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa słuchacza stPriceCompareListener
 *
 * @package     stPriceCompare
 * @subpackage  libs
 */
class stPriceCompareListener
{
	/**
	 * Funkcja generate przeciążająca generator modułu stProduct
	 *
	 * @param sfEvent $event
	 */
	public static function generate(sfEvent $event)
	{
		$event->getSubject()->attachAdminGeneratorFile('stPriceCompare', 'stPriceComparePluginInProduct.yml');
	}

	/**
	 * Funkcja blokuje dostęp do aplikacji
	 *
	 * @param sfEvent $event
	 */
	public static function blockCommercial(sfEvent $event)
	{
		if (stLicense::isOpen()) $event->getSubject()->forward('stBackendMain','Open');
	}

	/**
	 * Funkcja przeciaża zapisywania zamówienia
	 *
	 * @param sfEvent $event
	 */
	public static function filterOrderSave(sfEvent $event)
	{
		if ($event->getSubject()->getUser()->hasAttribute('name', stPriceCompare::SESSION_NAMESPACE))
		{
			$event['order']->setOrderType($event->getSubject()->getUser()->getAttribute('name', null, stPriceCompare::SESSION_NAMESPACE));
		}
	}
}