<?php
/**
 * SOTESHOP/stUpdate
 *
 * Ten plik należy do aplikacji stUpdate opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stUpdate
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id:  $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa stWebStore
 * Zarządzanie instalacją pakietów z WebStore
 *
 * @package     stUpdate
 * @subpackage  libs
 */
class stWebStore
{
	private static $soteUrl = 'http://sote.pl/smWebStoreFrontend/soap';

	public static function checkPackage($name, $code = null) {
		try {
			$soapClient = new SoapClient(null, array('location' => self::$soteUrl, 'uri' => self::$soteUrl));
			$response = $soapClient->checkPackage($name, $code);
		} catch (SoapFault $e) {
			$response = false;
		}

		return $response;
	}

	public static function activatePackage($name, $code = null) {
		try {
			$soapClient = new SoapClient(null, array('location' => self::$soteUrl, 'uri' => self::$soteUrl));
			$register = stConfig::getInstance(sfContext::getInstance(), 'stRegister');
			$response = $soapClient->activatePackage($register->get('license'), $name, $code);
		} catch (SoapFault $e) {
			$response = false;
		}

		return $response;
	}
}